/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.harvester.I18NConstants;
import weblogic.diagnostics.harvester.I18NSupport;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;

public final class LogSupport
implements I18NConstants {
    private static final DebugLogger DBG = DebugLogger.getDebugLogger((String)"DebugDiagnosticsHarvester");
    private static final String GENERIC_PROBLEM_TEXT = I18NSupport.formatter().getGenericHarvesterProblemMessage();

    public static void logUnexpectedProblem(String string) {
        DiagnosticsLogger.logGenericHarvesterProblem((String)LogSupport.getGenericHarvesterProblemText(string));
    }

    public static void logExpectedProblem(String string) {
        DiagnosticsLogger.logGenericHarvesterProblem((String)string);
    }

    public static String getGenericHarvesterProblemText(String string) {
        if (DBG.isDebugEnabled()) {
            DBG.debug("*** ERROR *** " + string);
        }
        return GENERIC_PROBLEM_TEXT;
    }

    public static void logUnexpectedException(String string, Throwable throwable) {
        UnexpectedExceptionHandler.handle(LogSupport.getGenericHarvesterProblemText(string), throwable);
    }

    public static void assertCondition(boolean bl, String string) {
        if (!bl) {
            throw new AssertionError((Object)LogSupport.getGenericHarvesterProblemText(string));
        }
    }
}

