/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import weblogic.diagnostics.descriptor.WLDFHarvestedTypeBean;
import weblogic.diagnostics.harvester.LogSupport;
import weblogic.kernel.KernelStatus;
import weblogic.utils.AssertionError;

public class Validators {
    private static final String validatorClassName = "weblogic.diagnostics.harvester.internal.Validators";
    private static final Class validatorClass = Validators.getClass("weblogic.diagnostics.harvester.internal.Validators");
    private static Method beanValidator = Validators.getDeclaredMethod("validateHarvestedTypeBean", new Class[]{WLDFHarvestedTypeBean.class});
    private static Method typeValidator = Validators.getDeclaredMethod("validateConfiguredType", new Class[]{String.class});
    private static Method attributeValidator = Validators.getDeclaredMethod("validateConfiguredAttributes", new Class[]{String.class, String[].class});
    private static Method instanceValidator = Validators.getDeclaredMethod("validateConfiguredInstances", new Class[]{String[].class});

    private static Class getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Throwable)classNotFoundException);
        }
    }

    private static Method getDeclaredMethod(String string, Class[] classArray) {
        try {
            return validatorClass.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Throwable)noSuchMethodException);
        }
    }

    public static void validateConfiguredType(String string) throws IllegalArgumentException {
        if (!KernelStatus.isServer()) {
            return;
        }
        try {
            typeValidator.invoke(null, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)invocationTargetException.getTargetException();
            }
            LogSupport.logUnexpectedException("Unable to validate type name: " + string, invocationTargetException);
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new AssertionError((Throwable)invocationTargetException);
        }
        catch (RuntimeException runtimeException) {
            LogSupport.logUnexpectedException("Unable to validate type name: " + string, runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            LogSupport.logUnexpectedException("Unable to validate type name: " + string, exception);
            throw (RuntimeException)exception;
        }
    }

    public static void validateConfiguredAttribute(String string, String string2) throws IllegalArgumentException {
        if (!KernelStatus.isServer()) {
            return;
        }
        try {
            attributeValidator.invoke(null, string, new String[]{string2});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)invocationTargetException.getTargetException();
            }
            LogSupport.logUnexpectedException("Unable to validate attribute: " + string2 + " for type: " + string, invocationTargetException);
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new AssertionError((Throwable)invocationTargetException);
        }
        catch (RuntimeException runtimeException) {
            LogSupport.logUnexpectedException("Unable to validate attribute: " + string2 + " for type: " + string, runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            LogSupport.logUnexpectedException("Unable to validate attribute: " + string2 + " for type: " + string, exception);
            throw (RuntimeException)exception;
        }
    }

    public static void validateConfiguredAttributes(WLDFHarvestedTypeBean wLDFHarvestedTypeBean) throws IllegalArgumentException {
        String string = wLDFHarvestedTypeBean.getName();
        String[] stringArray = wLDFHarvestedTypeBean.getHarvestedAttributes();
        Validators.validateConfiguredAttributes(string, stringArray);
    }

    public static void validateConfiguredAttributes(String string, String[] stringArray) throws IllegalArgumentException {
        if (!KernelStatus.isServer()) {
            return;
        }
        try {
            attributeValidator.invoke(null, string, stringArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)invocationTargetException.getTargetException();
            }
            LogSupport.logUnexpectedException("Unable to validate attribute list for bean: " + string, invocationTargetException);
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new AssertionError((Throwable)invocationTargetException);
        }
        catch (RuntimeException runtimeException) {
            LogSupport.logUnexpectedException("Unable to validate attribute list for bean: " + string, runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            LogSupport.logUnexpectedException("Unable to validate attribute list for bean: " + string, exception);
            throw (RuntimeException)exception;
        }
    }

    public static void validateConfiguredInstances(String[] stringArray) throws IllegalArgumentException {
        if (!KernelStatus.isServer()) {
            return;
        }
        try {
            instanceValidator.invoke(null, new Object[]{stringArray});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)invocationTargetException.getTargetException();
            }
            LogSupport.logUnexpectedException("Unable to validate instance list for bean: ", invocationTargetException);
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new AssertionError((Throwable)invocationTargetException);
        }
        catch (RuntimeException runtimeException) {
            LogSupport.logUnexpectedException("Unable to validate instance list for bean: ", runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            LogSupport.logUnexpectedException("Unable to validate instance list for bean: ", exception);
            throw (RuntimeException)exception;
        }
    }

    public static void validateHarvestedTypeBean(WLDFHarvestedTypeBean wLDFHarvestedTypeBean) throws IllegalArgumentException {
        if (!KernelStatus.isServer()) {
            return;
        }
        try {
            beanValidator.invoke(null, wLDFHarvestedTypeBean);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)invocationTargetException.getTargetException();
            }
            LogSupport.logUnexpectedException("Unable to validate bean: " + wLDFHarvestedTypeBean.getName(), invocationTargetException);
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new AssertionError((Throwable)invocationTargetException);
        }
        catch (RuntimeException runtimeException) {
            LogSupport.logUnexpectedException("Unable to validate bean: " + wLDFHarvestedTypeBean.getName(), runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            LogSupport.logUnexpectedException("Unable to validate bean: " + wLDFHarvestedTypeBean.getName(), exception);
            throw (RuntimeException)exception;
        }
    }
}

