/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester;

import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.harvester.WLDFHarvester;
import weblogic.diagnostics.harvester.WLDFHarvesterLauncher;
import weblogic.diagnostics.harvester.internal.WLDFHarvesterImpl;
import weblogic.diagnostics.utils.SecurityHelper;

public class WLDFHarvesterManager
implements WLDFHarvesterLauncher {
    private static final DebugLogger DBG = DebugLogger.getDebugLogger((String)"DebugDiagnosticsHarvester");
    private static WLDFHarvesterImpl wldfHarvesterSingleton;
    private static WLDFHarvesterManager mgr;
    LifecycleState state = LifecycleState.UNPREPARED;

    private WLDFHarvesterManager() {
    }

    public static WLDFHarvesterLauncher getInstance() {
        SecurityHelper.checkForAdminRole();
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WLDFHarvester getHarvesterSingleton() {
        SecurityHelper.checkForAdminRole();
        WLDFHarvesterManager wLDFHarvesterManager = this;
        synchronized (wLDFHarvesterManager) {
            if (wldfHarvesterSingleton == null) {
                wldfHarvesterSingleton = WLDFHarvesterImpl.getInstance();
                wldfHarvesterSingleton.prepare();
                wldfHarvesterSingleton.activate();
            }
        }
        return wldfHarvesterSingleton;
    }

    public void prepare() {
        if (DBG.isDebugEnabled()) {
            DBG.debug("In WLDFHarvesterManager.prepare");
        }
        this.state = LifecycleState.PREPARED;
    }

    public void activate() {
        if (this.state.compareTo(LifecycleState.ACTIVATED) < 0) {
            if (DBG.isDebugEnabled()) {
                DBG.debug("In WLDFHarvesterManager.activate()");
            }
            this.state = LifecycleState.ACTIVATED;
        }
    }

    public void deactivate() {
        if (this.state.compareTo(LifecycleState.PREPARED) > 0) {
            if (DBG.isDebugEnabled()) {
                DBG.debug("In WLDFHarvesterManager.deactivate()");
            }
            this.state = LifecycleState.PREPARED;
        }
    }

    public void unprepare() {
        if (this.state.compareTo(LifecycleState.UNPREPARED) > 0) {
            if (DBG.isDebugEnabled()) {
                DBG.debug("In WLDFHarvesterManager.unprepare");
            }
            this.state = LifecycleState.UNPREPARED;
        }
    }

    static {
        mgr = new WLDFHarvesterManager();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LifecycleState {
        UNPREPARED,
        PREPARED,
        ACTIVATED;

    }
}

