/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester;

import com.bea.adaptive.harvester.Harvester;
import com.bea.adaptive.harvester.WatchedValues;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.ObjectName;
import weblogic.diagnostics.harvester.HarvesterRuntimeException;
import weblogic.diagnostics.harvester.InstanceNameNormalizer;
import weblogic.diagnostics.harvester.InvalidHarvesterInstanceNameException;
import weblogic.diagnostics.harvester.InvalidHarvesterNamespaceException;
import weblogic.diagnostics.harvester.WLDFHarvester;
import weblogic.diagnostics.harvester.WLDFHarvesterManager;
import weblogic.diagnostics.harvester.internal.AttributeNormalizerUtil;
import weblogic.diagnostics.harvester.internal.BeanTreeHarvesterImpl;
import weblogic.diagnostics.harvester.internal.MetricArchiver;
import weblogic.diagnostics.harvester.internal.Validators;
import weblogic.diagnostics.i18n.DiagnosticsHarvesterLogger;
import weblogic.diagnostics.i18n.DiagnosticsTextTextFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WLDFHarvesterUtils {
    private static WLDFHarvester harvesterInstance;

    private WLDFHarvesterUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WLDFHarvester getHarvesterInstance() {
        Class<WLDFHarvesterUtils> clazz = WLDFHarvesterUtils.class;
        synchronized (WLDFHarvesterUtils.class) {
            if (harvesterInstance == null) {
                harvesterInstance = WLDFHarvesterManager.getInstance().getHarvesterSingleton();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return harvesterInstance;
        }
    }

    public static Object getValue(String string, String string2, String string3, String string4) throws JMException, InvalidHarvesterInstanceNameException {
        WLDFHarvester wLDFHarvester = WLDFHarvesterUtils.getHarvesterInstance();
        int n = 1;
        WatchedValues watchedValues = MetricArchiver.getInstance().createWatchedValues("HarvesterUtils_getValue()");
        InstanceNameNormalizer instanceNameNormalizer = new InstanceNameNormalizer(string3);
        watchedValues.addMetric(string, string2, instanceNameNormalizer.translateHarvesterSpec(), string4, false, instanceNameNormalizer.isPattern(), false, true, n);
        int n2 = -1;
        try {
            n2 = wLDFHarvester.addWatchedValues(watchedValues.getName(), watchedValues, null);
        }
        catch (IOException iOException) {
            throw new HarvesterRuntimeException(iOException);
        }
        HashMap hashMap = new HashMap(1);
        HashSet<Integer> hashSet = new HashSet<Integer>(1);
        hashSet.add(n);
        hashMap.put(n2, hashSet);
        wLDFHarvester.harvest(hashMap);
        ArrayList<Object> arrayList = null;
        WatchedValues.Values values = watchedValues.getMetric(n);
        List list = values.getValues().getRawValues();
        if (list.size() == 1) {
            arrayList = ((WatchedValues.Values.RawValueData)list.get(0)).getValue();
        } else {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (WatchedValues.Values.RawValueData rawValueData : list) {
                arrayList2.add(rawValueData.getValue());
            }
            arrayList = arrayList2;
        }
        wLDFHarvester.deleteWatchedValues(watchedValues);
        return arrayList;
    }

    public static ArrayList<String> validateWatchedValues(Harvester harvester, WatchedValues watchedValues) {
        Collection collection = harvester.validateWatchedValues(watchedValues);
        ArrayList<String> arrayList = new ArrayList<String>();
        WLDFHarvesterUtils.processValidationResults(watchedValues.getName(), collection, arrayList);
        return arrayList;
    }

    public static void processValidationResults(String string, Collection<WatchedValues.Validation> collection) {
        WLDFHarvesterUtils.processValidationResults(string, collection, null);
    }

    public static void processValidationResults(String string, Collection<WatchedValues.Validation> collection, ArrayList<String> arrayList) {
        boolean bl = false;
        String string2 = "";
        int n = 0;
        for (WatchedValues.Validation validation : collection) {
            Set set;
            if (validation.getStatus() != -1) continue;
            if (arrayList != null) {
                arrayList.add(validation.getMetric().getInstanceName());
            }
            if ((set = validation.getIssues()).size() <= 0) continue;
            if (!bl) {
                bl = true;
            }
            for (String string3 : set) {
                string2 = string2 + string3;
                ++n;
            }
        }
        if (bl) {
            string2 = DiagnosticsTextTextFormatter.getInstance().getErrorsOccurredValidatingWatchedValues(string2, n);
            DiagnosticsHarvesterLogger.logValidationErrors((String)string, (String)string2);
        }
    }

    public static ArrayList<String> validateWatchedValues(WatchedValues watchedValues) {
        return WLDFHarvesterUtils.validateWatchedValues(WLDFHarvesterUtils.getHarvesterInstance(), watchedValues);
    }

    public static void validateNamespace(String string) throws InvalidHarvesterNamespaceException {
        Validators.validateNamespace(string);
    }

    public static String normalizeInstanceName(String string) throws InvalidHarvesterInstanceNameException {
        InstanceNameNormalizer instanceNameNormalizer = new InstanceNameNormalizer(string);
        return instanceNameNormalizer.translateHarvesterSpec();
    }

    public static String normalizeAttributeSpecification(String string, String string2) {
        return AttributeNormalizerUtil.getNormalizedAttributeName(string, string2);
    }

    public static String[] normalizeAttributeSpecs(String string, String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = WLDFHarvesterUtils.normalizeAttributeSpecification(string, stringArray[i]);
        }
        return stringArray2;
    }

    public static String normalizeAttributeForInstance(String string, String string2) {
        String string3 = WLDFHarvesterUtils.getTypeForObjectName(string);
        if (string3 != null) {
            return WLDFHarvesterUtils.normalizeAttributeSpecification(string3, string2);
        }
        return string2;
    }

    public static String getTypeForInstance(String string) {
        String string2;
        BeanTreeHarvesterImpl beanTreeHarvesterImpl = BeanTreeHarvesterImpl.getInstance();
        String string3 = beanTreeHarvesterImpl.getTypeForInstance(string);
        if (string3 == null && (string2 = WLDFHarvesterUtils.getTypeForObjectName(string)) != null && beanTreeHarvesterImpl.isTypeHandled(string2) == 2) {
            string3 = string2;
        }
        return string3;
    }

    private static String getTypeForObjectName(String string) {
        String string2 = null;
        try {
            ObjectName objectName = new ObjectName(string);
            String string3 = objectName.getKeyProperty("Type");
            if (string3 != null && string3.indexOf(42) < 0 && string3.indexOf(63) < 0) {
                string2 = "weblogic.management.runtime." + string3 + "MBean";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String buildDataContextString(List<WatchedValues.ContextItem> list) {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        for (WatchedValues.ContextItem contextItem : list) {
            WatchedValues.ContextItem.AttributeTermType attributeTermType = contextItem.getAttributeTermType();
            if (attributeTermType == WatchedValues.ContextItem.AttributeTermType.ARRAY_OR_LIST) {
                stringBuilder.append('[');
            } else if (attributeTermType == WatchedValues.ContextItem.AttributeTermType.MAP) {
                stringBuilder.append('(');
            } else if (attributeTermType == WatchedValues.ContextItem.AttributeTermType.SIMPLE) {
                stringBuilder.append('.');
            }
            stringBuilder.append(contextItem.getContext().toString());
            if (attributeTermType == WatchedValues.ContextItem.AttributeTermType.ARRAY_OR_LIST) {
                stringBuilder.append(']');
                continue;
            }
            if (attributeTermType != WatchedValues.ContextItem.AttributeTermType.MAP) continue;
            stringBuilder.append(')');
        }
        int n = stringBuilder.length();
        if (n > 0 && (c = stringBuilder.charAt(0)) == '.') {
            stringBuilder.deleteCharAt(0);
        }
        return stringBuilder.toString();
    }

    public static Object[] getLeafValues(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            WLDFHarvesterUtils.addItems(arrayList, objectArray);
        }
        return arrayList.toArray();
    }

    private static void addItems(List<Object> list, Object[] objectArray) {
        for (Object object : objectArray) {
            if (object == null || object instanceof WatchedValues.AttributeTrackedDataItem && (object = ((WatchedValues.AttributeTrackedDataItem)object).getData()) == null) continue;
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                WLDFHarvesterUtils.addItems(list, (Object[])object);
                continue;
            }
            list.add(object);
        }
    }
}

