/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import com.bea.adaptive.harvester.WatchedValues;
import com.bea.adaptive.harvester.jmx.BaseHarvesterImpl;
import com.bea.adaptive.harvester.jmx.MetricInfoManager;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import weblogic.diagnostics.harvester.HarvesterException;
import weblogic.diagnostics.harvester.I18NConstants;
import weblogic.diagnostics.harvester.internal.BeanTreeRegistrationManager;
import weblogic.diagnostics.harvester.internal.TreeBeanHarvestableDataProviderHelper;
import weblogic.management.mbeanservers.Service;
import weblogic.management.runtime.RuntimeMBean;

public class BeanTreeHarvesterImpl
extends BaseHarvesterImpl {
    public static BeanTreeHarvesterImpl getInstance() {
        return BeanTreeHarvesterImplFactory.getInstance();
    }

    private BeanTreeHarvesterImpl(String string) throws Exception {
        this.setUpDebugFlags("LocJMXHarvester");
        this.setName(string);
        this.regMan = new BeanTreeRegistrationManager(this);
        this.metricMan = new MetricInfoManager((BaseHarvesterImpl)this);
        this.useCount = 1;
        this.setNamespace("ServerRuntime");
        harvestersByName.put(string, this);
    }

    public void deallocate() {
    }

    public String findTypeName(String string) throws Exception {
        if (string == null) {
            throw new HarvesterException.NullName(I18NConstants.TYPE_I18N);
        }
        return TreeBeanHarvestableDataProviderHelper.getTypeNameForInstance(string);
    }

    protected Object getAttribute(Object object, String string) throws Exception {
        String string2;
        if (object instanceof ObjectName) {
            string2 = ((ObjectName)object).getCanonicalName();
            object = TreeBeanHarvestableDataProviderHelper.getInstanceForObjectIdentifier(string2);
        } else {
            string2 = TreeBeanHarvestableDataProviderHelper.getObjectNameForBean(object);
        }
        String string3 = TreeBeanHarvestableDataProviderHelper.getTypeNameForInstance(string2);
        Method method = ((BeanTreeRegistrationManager)this.regMan).getReadMethod(string3, string);
        if (method != null) {
            Object object2 = method.invoke(object, new Object[0]);
            if (object2 != null) {
                Class<?> clazz;
                if (object2 instanceof RuntimeMBean || object2 instanceof Service) {
                    String string4 = TreeBeanHarvestableDataProviderHelper.getObjectNameForBean(object);
                    try {
                        object2 = new ObjectName(string4);
                    }
                    catch (MalformedObjectNameException malformedObjectNameException) {
                        return string4;
                    }
                } else if (object2.getClass().isArray() && (RuntimeMBean.class.isAssignableFrom(clazz = object2.getClass().getComponentType()) || Service.class.isAssignableFrom(clazz))) {
                    object2 = this.normalizeArrayResult((Object[])object2);
                }
            }
            return object2;
        }
        return null;
    }

    private Object normalizeArrayResult(Object[] objectArray) {
        ObjectName[] objectNameArray = new ObjectName[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null || !(object instanceof RuntimeMBean) && !(object instanceof Service)) continue;
            String string = TreeBeanHarvestableDataProviderHelper.getObjectNameForBean(object);
            try {
                objectNameArray[i] = new ObjectName(string);
                continue;
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                objectNameArray[i] = null;
            }
        }
        return objectNameArray;
    }

    protected boolean instanceNameIsValid(String string) {
        return true;
    }

    protected void validateInstanceName(String string) throws IllegalArgumentException {
    }

    protected int resolveByType(WatchedValues.Values values) {
        if (values.getTypeName() == null) {
            return -1;
        }
        return super.resolveByType(values);
    }

    public int isTypeHandled(String string) {
        String[][] stringArray;
        if (string == null) {
            throw new HarvesterException.NullName(I18NConstants.TYPE_I18N);
        }
        int n = -1;
        try {
            stringArray = this.regMan.getKnownHarvestableTypes(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (stringArray != null && stringArray.length > 0) {
            for (String[] stringArray2 : stringArray) {
                Class clazz;
                String string2 = stringArray2[0];
                if (string2 == null || (clazz = BeanTreeHarvesterImpl.getTypeClass(string2)) == null) continue;
                n = 2;
                break;
            }
        }
        return n;
    }

    private static Class getTypeClass(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        if (!RuntimeMBean.class.isAssignableFrom(clazz) && !Service.class.isAssignableFrom(clazz)) {
            return null;
        }
        return clazz;
    }

    protected Object getInstance(String string) {
        return TreeBeanHarvestableDataProviderHelper.getInstanceForObjectIdentifier(string);
    }

    private static class BeanTreeHarvesterImplFactory {
        private static BeanTreeHarvesterImpl SINGLETON;

        private BeanTreeHarvesterImplFactory() {
        }

        private static BeanTreeHarvesterImpl createBeanTreeHarvesterImpl() {
            try {
                return new BeanTreeHarvesterImpl("WLSBeanTreeHarvester");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        static synchronized BeanTreeHarvesterImpl getInstance() {
            if (SINGLETON == null) {
                SINGLETON = BeanTreeHarvesterImplFactory.createBeanTreeHarvesterImpl();
            }
            return SINGLETON;
        }
    }
}

