/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import com.bea.adaptive.harvester.jmx.AttributeSpec;
import com.bea.adaptive.harvester.jmx.AttributeTerm;
import com.bea.adaptive.harvester.jmx.BaseHarvesterImpl;
import com.bea.adaptive.harvester.jmx.RegistrationManager;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.ObjectName;
import weblogic.descriptor.DescriptorBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.harvester.internal.TreeBeanHarvestableDataProviderHelper;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RegistrationHandler;
import weblogic.management.provider.Service;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanTreeRegistrationManager
extends RegistrationManager
implements RegistrationHandler {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final DebugLogger DEBUG = DebugLogger.getDebugLogger((String)"DebugDiagnosticsHarvesterTreeBeanPlugin");
    public static final String CATEGORY_NAME = "WLS-MBean";
    private ConcurrentHashMap<String, Class> classByTypes = new ConcurrentHashMap();
    private ConcurrentHashMap typeAttrMetaData = new ConcurrentHashMap();

    static BeanInfo getBeanInfoForInterface(String string) {
        return TreeBeanHarvestableDataProviderHelper.getBeanInfo(string);
    }

    public BeanTreeRegistrationManager(BaseHarvesterImpl baseHarvesterImpl) throws IOException, JMException {
        super(baseHarvesterImpl);
        this.initKnownTypes();
        ManagementService.getRuntimeAccess(KERNEL_ID).initiateRegistrationHandler(this);
    }

    private void addInstances(Object object, String string) throws Exception {
        Class<?> clazz = object.getClass();
        for (String string2 : this.classByTypes.keySet()) {
            Class clazz2 = this.classByTypes.get(string2);
            if (!clazz2.isAssignableFrom(clazz)) continue;
            this.newInstance(string2, string, CATEGORY_NAME);
        }
    }

    private void cacheClassNames(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                Class<?> clazz = Class.forName(string);
                this.classByTypes.put(string, clazz);
                this.addKnownTypeToCache(string);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public String getDescriptionForType(String string) {
        BeanDescriptor beanDescriptor;
        BeanInfo beanInfo = BeanTreeRegistrationManager.getBeanInfoForInterface(string);
        if (beanInfo != null && (beanDescriptor = beanInfo.getBeanDescriptor()) != null) {
            return beanDescriptor.getDisplayName();
        }
        return mtf_base.getUnknownLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String[][] getHarvestableAttributes(String string, String string2) {
        BeanInfo beanInfo;
        Pattern pattern;
        block15: {
            String[][] stringArray;
            try {
                if (this.dbg.isDebugTEnabled() || this.dbg.isDebugCEnabled()) {
                    this.harvester.beforeSync((Object)"getHarvestableAttributes(BeanTreeRegistrationManager)", (Object)this, (Object)("   typeName=" + string + "   attrNameRegex=" + string2));
                }
                BeanTreeRegistrationManager beanTreeRegistrationManager = this;
                // MONITORENTER : beanTreeRegistrationManager
                this.harvester.afterSync((Object)"getHarvestableAttributes(BeanTreeRegistrationManager)");
                pattern = string2 != null ? Pattern.compile(string2) : null;
                beanInfo = BeanTreeRegistrationManager.getBeanInfoForInterface(string);
                if (beanInfo != null) break block15;
                stringArray = null;
                // MONITOREXIT : beanTreeRegistrationManager
            }
            catch (Throwable throwable) {
                this.harvester.unsynced((Object)"getHarvestableAttributes(BeanTreeRegistrationManager)");
                throw throwable;
            }
            this.harvester.unsynced((Object)"getHarvestableAttributes(BeanTreeRegistrationManager)");
            return stringArray;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n = propertyDescriptorArray != null ? propertyDescriptorArray.length : 0;
        String[][] stringArray = new String[n][3];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            String string3 = propertyDescriptor.getName();
            if (!this.isUnharvestable(string3, propertyDescriptor) && (pattern == null || pattern.matcher(string3).matches())) {
                String string4 = propertyDescriptor.getPropertyType().getName();
                String string5 = propertyDescriptor.getShortDescription();
                stringArray[i][0] = string3;
                stringArray[i][1] = string4;
                stringArray[i][2] = string5;
                ConcurrentHashMap<String, Method> concurrentHashMap = (ConcurrentHashMap<String, Method>)this.typeAttrMetaData.get(string);
                if (concurrentHashMap == null) {
                    concurrentHashMap = new ConcurrentHashMap<String, Method>();
                    this.typeAttrMetaData.put(string, concurrentHashMap);
                }
                if (concurrentHashMap.containsKey(string3)) continue;
                concurrentHashMap.put(string3, propertyDescriptor.getReadMethod());
                continue;
            }
            ++n2;
            stringArray[i] = null;
        }
        if (n2 <= 0) {
            String[][] stringArray2 = stringArray;
            // MONITOREXIT : beanTreeRegistrationManager
            this.harvester.unsynced((Object)"getHarvestableAttributes(BeanTreeRegistrationManager)");
            return stringArray2;
        }
        String[][] stringArray3 = new String[n - n2][3];
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n4 >= n) {
                String[][] stringArray4 = stringArray3;
                // MONITOREXIT : beanTreeRegistrationManager
                this.harvester.unsynced((Object)"getHarvestableAttributes(BeanTreeRegistrationManager)");
                return stringArray4;
            }
            if (stringArray[n4] != null) {
                stringArray3[n3] = stringArray[n4];
                ++n3;
            }
            ++n4;
        }
    }

    private boolean isUnharvestable(String string, PropertyDescriptor propertyDescriptor) {
        for (int i = 0; i < UNHARVESTABLE_ATTRIBUTE_DESCRIPTORS.length; ++i) {
            String string2 = UNHARVESTABLE_ATTRIBUTE_DESCRIPTORS[i];
            Boolean bl = (Boolean)propertyDescriptor.getValue(string2);
            if (bl == null || !string2.equals("unharvestable") && !bl.booleanValue()) continue;
            if (DEBUG.isDebugEnabled()) {
                DEBUG.debug("Attribute " + string + " is unharvestable, tagged with @" + string2);
            }
            return true;
        }
        return false;
    }

    public List<AttributeSpec> getHarvestableAttributesForInstance(String string, String string2) {
        ArrayList<AttributeSpec> arrayList = new ArrayList<AttributeSpec>();
        String[][] stringArray = this.getHarvestableAttributes(string2, null);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i];
                AttributeSpec attributeSpec = new AttributeSpec(stringArray2[0], stringArray2[1], string2, (AttributeTerm)new AttributeTerm.SimpleTerm(stringArray2[0], null));
                arrayList.add(attributeSpec);
            }
        }
        return arrayList;
    }

    private void initKnownTypes() throws IOException {
        String[] stringArray = ManagementService.getBeanInfoAccess().getSubtypes(RuntimeMBean.class.getName());
        this.cacheClassNames(stringArray);
        String[] stringArray2 = ManagementService.getBeanInfoAccess().getSubtypes(Service.class.getName());
        this.cacheClassNames(stringArray2);
    }

    private void processRegistration(Object object) throws Exception {
        String string = TreeBeanHarvestableDataProviderHelper.getObjectNameForBean(object);
        String string2 = TreeBeanHarvestableDataProviderHelper.getTypeNameForInstance(string);
        this.newInstance(string2, string, CATEGORY_NAME);
    }

    private void processUnregistration(Object object) {
        block5: {
            try {
                String string = TreeBeanHarvestableDataProviderHelper.getRegisteredObjectNameForBean(object);
                if (string != null) {
                    this.instanceDeleted(string);
                } else if (DEBUG.isDebugEnabled()) {
                    DEBUG.debug("No ObjectName found for bean " + object.toString());
                }
            }
            catch (Exception exception) {
                if (!DEBUG.isDebugEnabled()) break block5;
                DEBUG.debug("Exception deleting instance", (Throwable)exception);
            }
        }
    }

    public void registered(RuntimeMBean runtimeMBean, DescriptorBean descriptorBean) {
        block2: {
            try {
                this.processRegistration(runtimeMBean);
            }
            catch (Exception exception) {
                if (!DEBUG.isDebugEnabled()) break block2;
                DEBUG.debug("Exception while registering bean", (Throwable)exception);
            }
        }
    }

    public void registered(Service service2) {
        block2: {
            try {
                this.processRegistration(service2);
            }
            catch (Exception exception) {
                if (!DEBUG.isDebugEnabled()) break block2;
                DEBUG.debug("Exception while registering bean", (Throwable)exception);
            }
        }
    }

    public void registeredCustom(ObjectName objectName, Object object) {
    }

    public void shutdown() {
        this.classByTypes = new ConcurrentHashMap();
        ManagementService.getRuntimeAccess(KERNEL_ID).removeRegistrationHandler(this);
    }

    public void unregistered(RuntimeMBean runtimeMBean) {
        if (DEBUG.isDebugEnabled()) {
            DEBUG.debug("Processing unregistration for " + runtimeMBean.getName());
        }
        this.processUnregistration(runtimeMBean);
    }

    public void unregistered(Service service2) {
        this.processUnregistration(service2);
    }

    public void unregisteredCustom(ObjectName objectName) {
    }

    Method getReadMethod(String string, String string2) {
        Method method = null;
        Map map = (Map)this.typeAttrMetaData.get(string);
        if (map != null) {
            method = (Method)map.get(string2);
        }
        return method;
    }
}

