/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import com.bea.adaptive.harvester.Harvester;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.harvester.internal.DebugSupport;
import weblogic.diagnostics.harvester.internal.DelegateHarvesterControl;
import weblogic.diagnostics.harvester.internal.DelegateHarvesterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DelegateHarvesterManagerImpl
extends ArrayList<DelegateHarvesterControl>
implements DelegateHarvesterManager {
    private static DebugLogger debugLogger = DebugSupport.getDebugLogger();
    private HashMap<String, DelegateHarvesterControl> delegatesByName = new HashMap();
    private int modifiedCount;

    private DelegateHarvesterManagerImpl() {
    }

    static DelegateHarvesterManager createDelegateHarvesterManager() {
        return new DelegateHarvesterManagerImpl();
    }

    @Override
    public void addDelegateHarvester(DelegateHarvesterControl delegateHarvesterControl) {
        this.add(delegateHarvesterControl);
        ++this.modifiedCount;
        this.delegatesByName.put(delegateHarvesterControl.getName(), delegateHarvesterControl);
        if (delegateHarvesterControl.getActivationPolicy() == DelegateHarvesterControl.ActivationPolicy.IMMEDIATE) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Activating delegate: " + delegateHarvesterControl.getName());
            }
            delegateHarvesterControl.activate();
        }
    }

    @Override
    public void removeDelegateHarvesterByName(String string) {
        DelegateHarvesterControl delegateHarvesterControl = this.delegatesByName.remove(string);
        if (delegateHarvesterControl != null || string.equals(delegateHarvesterControl.getName())) {
            this.remove(delegateHarvesterControl);
            ++this.modifiedCount;
            delegateHarvesterControl.deactivate();
        }
    }

    @Override
    public void removeAll() {
        for (String string : this.delegatesByName.keySet()) {
            this.removeDelegateHarvesterByName(string);
        }
    }

    @Override
    public Harvester getDefaultDelegate() {
        Harvester harvester = null;
        for (DelegateHarvesterControl delegateHarvesterControl : this) {
            if (!delegateHarvesterControl.isDefaultDelegate()) continue;
            harvester = delegateHarvesterControl.getDelegate();
        }
        return harvester;
    }

    @Override
    public Iterator<Harvester> harvesterIterator() {
        return new ActivatingIterator(DelegateHarvesterControl.ActivationPolicy.ON_REGISTRATION);
    }

    @Override
    public Iterator<Harvester> activeOnlyIterator() {
        return new ActiveControlIterator();
    }

    @Override
    public Iterator<Harvester> activatingIterator() {
        return new ActivatingIterator(DelegateHarvesterControl.ActivationPolicy.ON_REGISTRATION);
    }

    @Override
    public Iterator<Harvester> activatingIterator(DelegateHarvesterControl.ActivationPolicy activationPolicy) {
        return new ActivatingIterator(activationPolicy);
    }

    @Override
    public int getConfiguredHarvestersCount() {
        return this.size();
    }

    @Override
    public int getActiveHarvestersCount() {
        int n = 0;
        for (DelegateHarvesterControl delegateHarvesterControl : this) {
            if (!delegateHarvesterControl.isActive()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Harvester getHarvesterByName(String string) {
        DelegateHarvesterControl delegateHarvesterControl = this.delegatesByName.get(string);
        if (delegateHarvesterControl != null) {
            return delegateHarvesterControl.getDelegate();
        }
        return null;
    }

    protected int getModifiedCount() {
        return this.modifiedCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class ControlIterator
    implements Iterator<Harvester> {
        protected DelegateHarvesterControl next;
        protected DelegateHarvesterControl current;
        protected int currentIndex = -1;
        protected int modcount;

        public ControlIterator() {
            this.modcount = DelegateHarvesterManagerImpl.this.getModifiedCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            ControlIterator controlIterator = this;
            synchronized (controlIterator) {
                this.checkModification();
                if (this.next == null) {
                    this.next = this.findNextNode();
                }
            }
            return this.next != null;
        }

        @Override
        public Harvester next() {
            this.nextControl();
            return this.current.getDelegate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void nextControl() {
            ControlIterator controlIterator = this;
            synchronized (controlIterator) {
                this.checkModification();
                this.current = this.next;
                this.currentIndex = DelegateHarvesterManagerImpl.this.indexOf(this.current);
                this.next = this.findNextNode();
            }
        }

        protected abstract DelegateHarvesterControl findNextNode();

        private final void checkModification() {
            if (DelegateHarvesterManagerImpl.this.getModifiedCount() != this.modcount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ActiveControlIterator
    extends ControlIterator {
        protected DelegateHarvesterControl findNextNode() {
            DelegateHarvesterControl delegateHarvesterControl = null;
            for (int i = this.currentIndex + 1; i < DelegateHarvesterManagerImpl.this.size(); ++i) {
                DelegateHarvesterControl delegateHarvesterControl2 = (DelegateHarvesterControl)DelegateHarvesterManagerImpl.this.get(i);
                if (!delegateHarvesterControl2.isActive()) continue;
                delegateHarvesterControl = delegateHarvesterControl2;
                break;
            }
            return delegateHarvesterControl;
        }
    }

    class ActivatingIterator
    extends ControlIterator {
        private DelegateHarvesterControl.ActivationPolicy threshold;

        public ActivatingIterator(DelegateHarvesterControl.ActivationPolicy activationPolicy) {
            this.threshold = activationPolicy;
        }

        protected DelegateHarvesterControl findNextNode() {
            DelegateHarvesterControl delegateHarvesterControl = null;
            int n = this.currentIndex + 1;
            if (n < DelegateHarvesterManagerImpl.this.size()) {
                delegateHarvesterControl = (DelegateHarvesterControl)DelegateHarvesterManagerImpl.this.get(n);
            }
            return delegateHarvesterControl;
        }

        public Harvester next() {
            super.nextControl();
            if (this.current != null) {
                if (!this.current.isActive() && this.threshold.compareTo(this.current.getActivationPolicy()) >= 0) {
                    if (debugLogger.isDebugEnabled()) {
                        debugLogger.debug("Activating delegate: " + this.current.getName());
                    }
                    this.current.activate();
                }
                return this.current.getDelegate();
            }
            return null;
        }
    }
}

