/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import weblogic.diagnostics.harvester.internal.HarvesterDefaultAttributeNormalizerLexer;
import weblogic.diagnostics.harvester.internal.HarvesterDefaultAttributeNormalizerParserTokenTypes;

public class HarvesterDefaultAttributeNormalizerParser
extends LLkParser
implements HarvesterDefaultAttributeNormalizerParserTokenTypes {
    private static final String REGEX_METACHARS = ".#^$\\?+*|[]()";
    private static final String INVALID_IDENT_CHARS = ".#^$\\?+*|[]()%";
    private static final char WILD_CARD_CHAR = '%';
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "WS", "LSQPAREN", "RSQPAREN", "COMMA", "PERIOD", "SEMICOLON", "DIGIT", "LETTER", "INTEGER", "IDENTIFIER", "STAR_WILDCARD", "KEYSPEC"};

    private static void validateCharacters(String string) throws RecognitionException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (INVALID_IDENT_CHARS.indexOf(c) < 0) continue;
            throw new RecognitionException("Unexpected character '" + c + "' in IDENTIFIER " + string);
        }
    }

    private static String normalizeKey(String string) {
        int n = string.length();
        ArrayList arrayList = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (++i >= n) continue;
                c = string.charAt(i);
                if (c == '%') {
                    stringBuilder.append('%');
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == ',') {
                bl2 |= HarvesterDefaultAttributeNormalizerParser.addKeySpec(arrayList, stringBuilder);
                stringBuilder = new StringBuilder();
                continue;
            }
            if (c == '%') {
                bl = true;
            }
            stringBuilder.append(c);
        }
        if (bl2 |= HarvesterDefaultAttributeNormalizerParser.addKeySpec(arrayList, stringBuilder)) {
            return "(*)";
        }
        return HarvesterDefaultAttributeNormalizerParser.normalizeKey(arrayList, bl);
    }

    private static boolean addKeySpec(List list, StringBuilder stringBuilder) {
        boolean bl = false;
        if (stringBuilder.length() > 0) {
            String string = stringBuilder.toString().trim();
            list.add(string);
            if ("*".equals(string)) {
                bl = true;
            }
        }
        return bl;
    }

    private static String normalizeKey(List list, boolean bl) {
        int n = list.size();
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("{");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append("|");
                }
                String string = (String)list.get(i);
                HarvesterDefaultAttributeNormalizerParser.escapeRegexMetaChars(string, stringBuilder);
            }
            stringBuilder.append("}");
        } else {
            stringBuilder.append("(");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                HarvesterDefaultAttributeNormalizerParser.unescapeWildcard((String)list.get(i), stringBuilder);
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    private static void unescapeWildcard(String string, StringBuilder stringBuilder) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                char c2;
                char c3 = c2 = i < n - 1 ? string.charAt(i + 1) : (char)'\u0000';
                if (c2 == '%') {
                    ++i;
                }
            } else if (c == ',') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
    }

    private static void escapeRegexMetaChars(String string, StringBuilder stringBuilder) {
        boolean bl;
        int n = string.length();
        boolean bl2 = n > 0 && string.charAt(0) == '%';
        boolean bl3 = bl = n > 0 && string.charAt(n - 1) == '%';
        if (!bl2) {
            stringBuilder.append("^");
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                char c2;
                char c3 = c2 = i < n - 1 ? string.charAt(i + 1) : (char)'\u0000';
                if (c2 == '%') {
                    stringBuilder.append('%');
                    ++i;
                    continue;
                }
                stringBuilder.append(".*?");
                continue;
            }
            if (REGEX_METACHARS.indexOf(c) >= 0) {
                stringBuilder.append("\\");
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        if (!bl) {
            stringBuilder.append("$");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Invalid number of arguments");
            System.exit(1);
        }
        System.out.println("Normalizing: " + stringArray[0]);
        HarvesterDefaultAttributeNormalizerLexer harvesterDefaultAttributeNormalizerLexer = new HarvesterDefaultAttributeNormalizerLexer(new StringReader(stringArray[0]));
        HarvesterDefaultAttributeNormalizerParser harvesterDefaultAttributeNormalizerParser = new HarvesterDefaultAttributeNormalizerParser(harvesterDefaultAttributeNormalizerLexer);
        String string = harvesterDefaultAttributeNormalizerParser.normalizeAttributeSpec();
        System.out.println("Normalized attribute spec: " + string);
    }

    protected HarvesterDefaultAttributeNormalizerParser(TokenBuffer tokenBuffer, int n) {
        super(tokenBuffer, n);
        this.tokenNames = _tokenNames;
    }

    public HarvesterDefaultAttributeNormalizerParser(TokenBuffer tokenBuffer) {
        this(tokenBuffer, 1);
    }

    protected HarvesterDefaultAttributeNormalizerParser(TokenStream tokenStream, int n) {
        super(tokenStream, n);
        this.tokenNames = _tokenNames;
    }

    public HarvesterDefaultAttributeNormalizerParser(TokenStream tokenStream) {
        this(tokenStream, 1);
    }

    public HarvesterDefaultAttributeNormalizerParser(ParserSharedInputState parserSharedInputState) {
        super(parserSharedInputState, 1);
        this.tokenNames = _tokenNames;
    }

    public final String normalizeAttributeSpec() throws RecognitionException, TokenStreamException {
        String string = null;
        String string2 = this.attributeNameSpec();
        String string3 = this.remainderSpec();
        string = string2 + string3;
        return string;
    }

    public final String attributeNameSpec() throws RecognitionException, TokenStreamException {
        String string = null;
        Token token = null;
        token = this.LT(1);
        this.match(13);
        string = token.getText();
        HarvesterDefaultAttributeNormalizerParser.validateCharacters(string);
        return string;
    }

    public final String remainderSpec() throws RecognitionException, TokenStreamException {
        Token token = null;
        String string = null;
        String string2 = null;
        Object var5_4 = null;
        ArrayList arrayList = new ArrayList();
        String string3 = "";
        switch (this.LA(1)) {
            case 8: {
                this.match(8);
                string3 = this.normalizeAttributeSpec();
                string3 = "." + string3;
                break;
            }
            case 5: {
                this.match(5);
                string = this.indexSpec();
                this.match(6);
                string2 = this.remainderSpec();
                string3 = "[" + string + "]" + string2;
                break;
            }
            case 15: {
                token = this.LT(1);
                this.match(15);
                string2 = this.remainderSpec();
                string3 = HarvesterDefaultAttributeNormalizerParser.normalizeKey(token.getText()) + string2;
                break;
            }
            case 1: {
                this.match(1);
                string3 = "";
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return string3;
    }

    public final String indexSpec() throws RecognitionException, TokenStreamException {
        String string;
        Token token = null;
        switch (this.LA(1)) {
            case 12: {
                token = this.LT(1);
                this.match(12);
                string = token.getText();
                break;
            }
            case 14: {
                this.match(14);
                string = "*";
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return string;
    }
}

