/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import java.io.OutputStream;
import java.util.Collection;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.diagnostics.harvester.HarvesterDataSample;
import weblogic.diagnostics.harvester.LogSupport;
import weblogic.diagnostics.harvester.internal.HarvesterSnapshot;
import weblogic.diagnostics.harvester.internal.MetricArchiver;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.diagnostics.image.descriptor.HarvesterImageSourceBean;
import weblogic.diagnostics.utils.DateUtils;

class HarvesterImageSource
implements ImageSource {
    private HarvesterImageSourceBean root;
    private boolean timeoutRequested;
    private static final long NANOS_PER_MILLI = 1000000L;

    HarvesterImageSource() {
    }

    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        DescriptorManager descriptorManager = new DescriptorManager();
        Descriptor descriptor = descriptorManager.createDescriptorRoot(HarvesterImageSourceBean.class);
        this.root = (HarvesterImageSourceBean)descriptor.getRootBean();
        this.writeHarvesterSamples();
        try {
            descriptorManager.writeDescriptorBeanAsXML((DescriptorBean)this.root, outputStream);
        }
        catch (Exception exception) {
            throw new ImageSourceCreationException((Throwable)exception);
        }
    }

    public void timeoutImageCreation() {
        this.timeoutRequested = true;
    }

    private void writeHarvesterSamples() {
        try {
            MetricArchiver metricArchiver = MetricArchiver.getInstance();
            HarvesterSnapshot harvesterSnapshot = metricArchiver.getCurrentSnapshot();
            if (harvesterSnapshot == null) {
                return;
            }
            long l = harvesterSnapshot.getSnapshotStartTimeMillis();
            this.root.setHarvesterCycleStartTime(DateUtils.nanoDateToString(l *= 1000000L));
            long l2 = harvesterSnapshot.getSnapshotElapsedTimeNanos();
            this.root.setHarvesterCycleDurationNanos(l2);
            Collection<HarvesterDataSample> collection = harvesterSnapshot.getHarvesterDataSamples();
            for (HarvesterDataSample harvesterDataSample : collection) {
                this.root.addHarvesterSample(harvesterDataSample.toStringLong());
            }
        }
        catch (Exception exception) {
            LogSupport.logUnexpectedException("Error in HarvesterImageSource.", exception);
        }
    }
}

