/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import java.io.IOException;
import java.security.AccessController;
import javax.management.MBeanException;
import javax.management.Notification;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.harvester.HarvesterException;
import weblogic.diagnostics.harvester.HarvesterRuntimeException;
import weblogic.diagnostics.harvester.LogSupport;
import weblogic.diagnostics.harvester.internal.DebugSupport;
import weblogic.diagnostics.harvester.internal.MetricArchiver;
import weblogic.management.ManagementException;
import weblogic.management.jmx.modelmbean.NotificationGenerator;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.WLDFHarvesterRuntimeMBean;
import weblogic.management.runtime.WLDFRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class HarvesterRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements WLDFHarvesterRuntimeMBean {
    private final DebugLogger dbg = DebugSupport.getDebugLogger();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static HarvesterRuntimeMBeanImpl singleton = null;
    private MetricArchiver archiver;
    int notificationSequence = 0;
    NotificationGenerator notificationGenerator;

    static final HarvesterRuntimeMBeanImpl getInstance(MetricArchiver metricArchiver) throws ManagementException {
        if (singleton == null) {
            WLDFRuntimeMBean wLDFRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getWLDFRuntime();
            singleton = new HarvesterRuntimeMBeanImpl(metricArchiver, wLDFRuntimeMBean);
        }
        return singleton;
    }

    private HarvesterRuntimeMBeanImpl(MetricArchiver metricArchiver, WLDFRuntimeMBean wLDFRuntimeMBean) throws ManagementException {
        super("WLDFHarvesterRuntime", (RuntimeMBean)wLDFRuntimeMBean);
        wLDFRuntimeMBean.setWLDFHarvesterRuntime(this);
    }

    public long getTotalSamplingCycles() {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return metricArchiver.getTotalSamplingCycles();
        }
        return 0L;
    }

    public long getMinimumSamplingTime() {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return metricArchiver.getMinimumSamplingTime();
        }
        return 0L;
    }

    public long getMaximumSamplingTime() {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return metricArchiver.getMaximumSamplingTime();
        }
        return 0L;
    }

    public long getTotalSamplingTime() {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return metricArchiver.getTotalSamplingTime();
        }
        return 0L;
    }

    public long getAverageSamplingTime() {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return this.getArchiver().getAverageSamplingTime();
        }
        return 0L;
    }

    public long getTotalDataSampleCount() throws HarvesterException.HarvestingNotEnabled {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return this.getArchiver().getTotalConfiguredDataSampleCount();
        }
        return 0L;
    }

    public long getTotalImplicitDataSampleCount() throws HarvesterException.HarvestingNotEnabled {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return metricArchiver.getTotalImplicitDataSampleCount();
        }
        return 0L;
    }

    public String[] getConfiguredNamespaces() throws HarvesterException.HarvestingNotEnabled {
        String[] stringArray = this.getArchiver().getConfiguredNamespaces();
        return stringArray;
    }

    public String getDefaultNamespace() throws HarvesterException.HarvestingNotEnabled {
        String string = this.getArchiver().getDefaultNamespace();
        return string;
    }

    public long getCurrentDataSampleCount() throws HarvesterException.HarvestingNotEnabled {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return metricArchiver.getCurrentConfiguredDataSampleCount();
        }
        return 0L;
    }

    public long getCurrentImplicitDataSampleCount() throws HarvesterException.HarvestingNotEnabled {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return metricArchiver.getCurrentImplicitDataSampleCount();
        }
        return 0L;
    }

    public long getCurrentSnapshotStartTime() throws HarvesterException.HarvestingNotEnabled {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return metricArchiver.getCurrentSnapshotStartTime();
        }
        return -1L;
    }

    public long getCurrentSnapshotElapsedTime() throws HarvesterException.HarvestingNotEnabled {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return metricArchiver.getCurrentSnapshotElapsedTime();
        }
        return 0L;
    }

    public long getSamplePeriod() throws HarvesterException.HarvestingNotEnabled {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return metricArchiver.getSamplePeriod();
        }
        return 0L;
    }

    public String getHarvestableType(String string) throws HarvesterException.HarvestableInstancesNotFoundException, HarvesterException.AmbiguousInstanceName {
        String string2 = this.getArchiver().getHarvestableType(string);
        return string2;
    }

    public String[] getCurrentlyHarvestedAttributes(String string) throws HarvesterException.AmbiguousTypeName, HarvesterException.HarvestingNotEnabled, HarvesterException.MissingConfigurationType {
        String[] stringArray = new String[]{};
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            stringArray = metricArchiver.getCurrentlyHarvestedAttributes(string);
        }
        return stringArray;
    }

    public String[] getCurrentlyHarvestedInstances(String string) throws HarvesterException.MissingConfigurationType, HarvesterException.HarvestingNotEnabled {
        String[] stringArray = new String[]{};
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            stringArray = metricArchiver.getCurrentlyHarvestedInstances(string);
        }
        return stringArray;
    }

    public String[][] getHarvestableAttributes(String string) throws HarvesterException.AmbiguousTypeName, HarvesterException.HarvestableTypesNotFoundException, HarvesterException.TypeNotHarvestable {
        String[][] stringArray = new String[][]{};
        try {
            stringArray = this.getArchiver().getHarvestableAttributes(string);
        }
        catch (IOException iOException) {
            throw new HarvesterRuntimeException(iOException);
        }
        return stringArray;
    }

    public String[][] getHarvestableAttributesForInstance(String string) throws HarvesterException.AmbiguousTypeName, HarvesterException.HarvestableTypesNotFoundException, HarvesterException.TypeNotHarvestable {
        String[][] stringArray;
        block5: {
            stringArray = null;
            String string2 = null;
            try {
                string2 = this.getArchiver().getHarvestableType(string);
                if (string2 != null) {
                    stringArray = this.getHarvestableAttributes(string2);
                }
            }
            catch (HarvesterException.HarvestableInstancesNotFoundException harvestableInstancesNotFoundException) {
                if (this.dbg.isDebugEnabled()) {
                    this.dbg.debug("No harvestable instances found for derived type name " + string2, (Throwable)((Object)harvestableInstancesNotFoundException));
                }
            }
            catch (HarvesterException.AmbiguousInstanceName ambiguousInstanceName) {
                if (!this.dbg.isDebugEnabled()) break block5;
                this.dbg.debug("Ambiguous instance name: " + string, (Throwable)((Object)ambiguousInstanceName));
            }
        }
        return stringArray;
    }

    public String[] getKnownHarvestableTypes() {
        String[] stringArray = this.getArchiver().getKnownHarvestableTypes();
        return stringArray;
    }

    public String[] getKnownHarvestableTypes(String string) {
        String[] stringArray = this.getArchiver().getKnownHarvestableTypes(string);
        return stringArray;
    }

    public String[] getKnownHarvestableInstances(String string) throws HarvesterException.AmbiguousTypeName, HarvesterException.HarvestableTypesNotFoundException, HarvesterException.TypeNotHarvestable {
        String[] stringArray = this.getArchiver().getKnownHarvestableInstances(string);
        return stringArray;
    }

    public String[] getKnownHarvestableInstances(String string, String string2) throws HarvesterException.HarvestableTypesNotFoundException, HarvesterException.AmbiguousTypeName, HarvesterException.TypeNotHarvestable {
        String[] stringArray = this.getArchiver().getKnownHarvestableInstances(string, string2);
        return stringArray;
    }

    public long getTotalSamplingTimeOutlierCount() {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return metricArchiver.getTotalSamplingTimeOutlierCount();
        }
        return 0L;
    }

    public boolean isCurrentSampleTimeAnOutlier() {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver.isEnabled()) {
            return metricArchiver.isCurrentSampleTimeAnOutlier();
        }
        return false;
    }

    public float getOutlierDetectionFactor() {
        MetricArchiver metricArchiver = this.getArchiver();
        if (metricArchiver != null) {
            return metricArchiver.getOutlierDetectionFactor();
        }
        return 0.0f;
    }

    private MetricArchiver getArchiver() {
        if (this.archiver == null) {
            this.archiver = MetricArchiver.getInstance();
        }
        return this.archiver;
    }

    void harvestCycleOccurred(long l) {
        ++this.notificationSequence;
        try {
            if (this.notificationGenerator != null) {
                if (this.dbg.isDebugEnabled()) {
                    this.dbg.debug("Harvester runtime MBean is sending notification. ");
                }
                this.notificationGenerator.sendNotification(new Notification("weblogic.diagnostics.harvester.cycleCompleted", (Object)this.notificationGenerator.getObjectName(), (long)this.notificationSequence, l));
            }
        }
        catch (MBeanException mBeanException) {
            LogSupport.logUnexpectedException("Harvest cycle notification failed with exception.", mBeanException);
        }
    }

    void setNotificationGenerator(NotificationGenerator notificationGenerator) {
        this.notificationGenerator = notificationGenerator;
    }
}

