/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.diagnostics.harvester.internal.HarvesterRuntimeMBeanImpl;
import weblogic.management.WebLogicMBeanImplBeanInfo;
import weblogic.management.internal.mbean.BeanInfoHelper;
import weblogic.management.runtime.WLDFHarvesterRuntimeMBean;

public class HarvesterRuntimeMBeanImplBeanInfo
extends WebLogicMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = WLDFHarvesterRuntimeMBean.class;

    public HarvesterRuntimeMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public HarvesterRuntimeMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = HarvesterRuntimeMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("since", "9.0.0.0");
        beanDescriptor.setValue("notificationTranslator", "weblogic.diagnostics.harvester.internal.RuntimeMBeanNotificationTranslator");
        beanDescriptor.setValue("package", "weblogic.diagnostics.harvester.internal");
        String string = new String("<p>Provides information about harvestable and harvested attributes, types, and instances. Harvestable means potentially available for harvesting; harvested means explicitly designated for harvesting. These terms apply to types, instances, and the attributes within those types. In addition, the interface provides access to sampling and snapshot statistics. All statistics are base on data collected during the current server session.</p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.runtime.WLDFHarvesterRuntimeMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("AverageSamplingTime")) {
            string2 = "getAverageSamplingTime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AverageSamplingTime", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("AverageSamplingTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The average amount of time, in nanoseconds, spent in sampling cycles.</p> ");
        }
        if (!map.containsKey("ConfiguredNamespaces")) {
            string2 = "getConfiguredNamespaces";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ConfiguredNamespaces", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("ConfiguredNamespaces", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the set of MBean namespaces currently configured within the WLDF Harvester.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("CurrentDataSampleCount")) {
            string2 = "getCurrentDataSampleCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CurrentDataSampleCount", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("CurrentDataSampleCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of collected data samples in the current snapshot.</p> ");
        }
        if (!map.containsKey("CurrentImplicitDataSampleCount")) {
            string2 = "getCurrentImplicitDataSampleCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CurrentImplicitDataSampleCount", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("CurrentImplicitDataSampleCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of implicit data samples gathered in the last sample.</p> ");
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("CurrentSnapshotElapsedTime")) {
            string2 = "getCurrentSnapshotElapsedTime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CurrentSnapshotElapsedTime", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("CurrentSnapshotElapsedTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The elapsed time, in nanoseconds, of a snapshot.</p> ");
        }
        if (!map.containsKey("CurrentSnapshotStartTime")) {
            string2 = "getCurrentSnapshotStartTime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CurrentSnapshotStartTime", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("CurrentSnapshotStartTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The start time, in nanoseconds, of a snapshot.</p> ");
        }
        if (!map.containsKey("DefaultNamespace")) {
            string2 = "getDefaultNamespace";
            string = null;
            propertyDescriptor = new PropertyDescriptor("DefaultNamespace", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("DefaultNamespace", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p> Returns the default MBean namespace within the WLDF Harvester.  This is the namespace used if none is provided for a configured MBean metric. </p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("KnownHarvestableTypes")) {
            string2 = "getKnownHarvestableTypes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("KnownHarvestableTypes", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("KnownHarvestableTypes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The set of all known types, regardless of whether the types are currently configured for harvesting. The set includes the WebLogic Server MBeans, which are always present, plus any other types that can be discovered. MBeans that are not WebLogic Server MBeans will require instances to exist in order to discover the type.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("MaximumSamplingTime")) {
            string2 = "getMaximumSamplingTime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MaximumSamplingTime", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("MaximumSamplingTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The maximum sampling time, in nanoseconds.</p> ");
        }
        if (!map.containsKey("MinimumSamplingTime")) {
            string2 = "getMinimumSamplingTime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MinimumSamplingTime", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("MinimumSamplingTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The minimum sampling time, in nanoseconds.</p> ");
        }
        if (!map.containsKey("OutlierDetectionFactor")) {
            string2 = "getOutlierDetectionFactor";
            string = null;
            propertyDescriptor = new PropertyDescriptor("OutlierDetectionFactor", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("OutlierDetectionFactor", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The multiplicative factor used to determine a statistical outlier. If the actual sampling time exceeds this the session average multiplied by the outlier detection factor, then the sampling time is considered to be a statistical outlier.</p> ");
        }
        if (!map.containsKey("SamplePeriod")) {
            string2 = "getSamplePeriod";
            string = null;
            propertyDescriptor = new PropertyDescriptor("SamplePeriod", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("SamplePeriod", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The current global sample period, in nanoseconds.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("TotalDataSampleCount")) {
            string2 = "getTotalDataSampleCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("TotalDataSampleCount", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("TotalDataSampleCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of configured data samples that have been collected so far in this server session.</p> ");
        }
        if (!map.containsKey("TotalImplicitDataSampleCount")) {
            string2 = "getTotalImplicitDataSampleCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("TotalImplicitDataSampleCount", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("TotalImplicitDataSampleCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of implicit data samples that have been collected in this server session.</p> ");
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
        }
        if (!map.containsKey("TotalSamplingCycles")) {
            string2 = "getTotalSamplingCycles";
            string = null;
            propertyDescriptor = new PropertyDescriptor("TotalSamplingCycles", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("TotalSamplingCycles", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The total number of sampling cycles taken thus far.</p> ");
        }
        if (!map.containsKey("TotalSamplingTime")) {
            string2 = "getTotalSamplingTime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("TotalSamplingTime", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("TotalSamplingTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The total amount of time, in nanoseconds, spent in sampling cycles.</p> ");
        }
        if (!map.containsKey("TotalSamplingTimeOutlierCount")) {
            string2 = "getTotalSamplingTimeOutlierCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("TotalSamplingTimeOutlierCount", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("TotalSamplingTimeOutlierCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of times within this server session that the sampling time differed significantly enough from the average to be considered a statistical outlier.  The Harvester removes these values form the ongoing averages.</p> ");
        }
        if (!map.containsKey("CurrentSampleTimeAnOutlier")) {
            string2 = "isCurrentSampleTimeAnOutlier";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CurrentSampleTimeAnOutlier", WLDFHarvesterRuntimeMBean.class, string2, string);
            map.put("CurrentSampleTimeAnOutlier", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Whether or not the sampling time for the most recent data sample differed significantly enough from the average to be considered a statistical outlier.</p> ");
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        String[] stringArray;
        MethodDescriptor methodDescriptor;
        Method method = WLDFHarvesterRuntimeMBean.class.getMethod("getHarvestableAttributes", String.class);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{HarvesterRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"the name of the type to get the attributes for ")};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"HarvesterException.HarvestableTypesNotFoundException if the type          name is valid but could not be located"), BeanInfoHelper.encodeEntities((String)"HarvesterException.AmbiguousTypeName if the          type name requires qualification to resolve"), BeanInfoHelper.encodeEntities((String)"HarvesterException.TypeNotHarvestableException if the          type could never be harvested")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>The set of attributes that are eligible for harvesting for the specified type. The specified type does not need to be currently configured for harvesting. For MBeans other than WebLogic Server MBeans, returns null until at least one instance has been created.</p>  <p>The returned array represents a list of pairs. The first element in each pair is the attribute name and the second element is the class name of the attribute's type.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = WLDFHarvesterRuntimeMBean.class.getMethod("preDeregister", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", " ");
            methodDescriptor.setValue("role", "operation");
        }
        method = WLDFHarvesterRuntimeMBean.class.getMethod("getHarvestableAttributesForInstance", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{HarvesterRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"instancePattern", (String)"the ObjectName or ObjectName pattern of the type to get the attributes for ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"HarvesterException.HarvestableTypesNotFoundException            if the type name is valid but could not be located"), BeanInfoHelper.encodeEntities((String)"HarvesterException.AmbiguousTypeName            if the type name requires qualification to resolve"), BeanInfoHelper.encodeEntities((String)"HarvesterException.TypeNotHarvestableException            if the type could never be harvested")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>The set of attributes that are eligible for harvesting for the specified instance name. The type of the specified instance does not need to be currently configured for harvesting. For MBeans other than WebLogic Server MBeans, returns null until at least one instance has been created.</p>  <p>Note that in the case where an ObjectName pattern is specified for a WebLogic Server MBean, the ObjectName's property list must contain the &quot;Type&quot; property (e.g., &quot;com.bea:Type=ServerRuntime,*&quot;). Otherwise, as is the case for any non-WebLogic Server MBean, an instance must exist in order for the set of harvestable attributes to be known.</p>  <p> The returned array represents a list of pairs. The first element in each pair is the attribute name and the second element is the class name of the attribute's type. </p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = WLDFHarvesterRuntimeMBean.class.getMethod("getCurrentlyHarvestedAttributes", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{HarvesterRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"the name of the type to get the attributes for ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"HarvesterException.MissingConfigurationType if the provided type          is not configured for harvesting"), BeanInfoHelper.encodeEntities((String)"HarvesterException.HarvestingNotEnabled if the Harvester is not deployed"), BeanInfoHelper.encodeEntities((String)"HarvesterException.HarvesterException.AmbiguousTypeName if the          type name requires qualification to resolve")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>The set of attributes that are currently being harvested for the specified type. The specified type must be explicitly configured for harvesting.</p>  <p>The returned set of attributes usually matches the corresponding set of attributes configured for harvesting; but if an error occurs when harvesting an attribute, that attribute will be omitted from the returned set.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = WLDFHarvesterRuntimeMBean.class.getMethod("getKnownHarvestableTypes", String.class))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p> The set of all known types within a particular MBean namespace, regardless of whether the types are currently configured for harvesting. An MBean namespace loosely corresponds to those MBeans that can be found within a particular MBeanServer, although there may be multiple Harvester delegates that service a particular MBean namespace. The returned set includes the WebLogic Server MBeans, which are always present, plus any other types that can be discovered. MBeans that are not WebLogic Server MBeans will require instances to exist in order to discover the type. </p> ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("unharvestable", Boolean.TRUE);
            methodDescriptor.setValue("role", "operation");
        }
        method = WLDFHarvesterRuntimeMBean.class.getMethod("getKnownHarvestableInstances", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{HarvesterRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"the name of the type to get the attributes for ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"HarvesterException.HarvestableTypesNotFoundException if the type          name is valid but could not be located"), BeanInfoHelper.encodeEntities((String)"HarvesterException.AmbiguousTypeName if the          type name requires qualification to resolve"), BeanInfoHelper.encodeEntities((String)"HarvesterException.TypeNotHarvestableException if the          type could never be harvested")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>The set of instances that are eligible for harvesting for the specified type at the time of the call.  The type does not need to be currently configured for harvesting.</p>  <p>The caller should be aware that instances come and go. This method returns only those instances that exist at the time of the call.</p>  <dl><dt>Note</dt><dd><p>For MBeans that are not WebLogic Server MBeans, returns null until at least one instance has been created.</p></dd></dl> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = WLDFHarvesterRuntimeMBean.class.getMethod("getKnownHarvestableInstances", String.class, String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{HarvesterRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"namespace", (String)"the MBean namespace to query "), HarvesterRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"the name of the type to get the attributes for ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"HarvesterException.HarvestableTypesNotFoundException if the type          name is valid but could not be located"), BeanInfoHelper.encodeEntities((String)"HarvesterException.AmbiguousTypeName if the          type name requires qualification to resolve"), BeanInfoHelper.encodeEntities((String)"HarvesterException.TypeNotHarvestableException if the          type could never be harvested")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>The set of instances that are eligible for harvesting for the specified type at the time of the call within a particular MBean namespace.  An MBean namespace loosely corresponds to those MBeans that can be found within a particular MBeanServer, although there may be multiple Harvester delegates that service a particular MBean namespace.  The type parameter provided to this call does not need to be currently configured for harvesting.</p>  <p>The caller should be aware that instances come and go. This method returns only those instances that exist at the time of the call.</p>  <dl><dt>Note</dt><dd><p>For MBeans that are not WebLogic Server MBeans, returns null until at least one instance has been created.</p></dd></dl> ");
            methodDescriptor.setValue("exclude", Boolean.TRUE);
            methodDescriptor.setValue("role", "operation");
        }
        method = WLDFHarvesterRuntimeMBean.class.getMethod("getCurrentlyHarvestedInstances", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{HarvesterRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"the name of the type to get the instances for ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"HarvesterException.MissingConfigurationType if the provided type          is not configured for harvesting"), BeanInfoHelper.encodeEntities((String)"HarvesterException.HarvestingNotEnabled if the Harvester is not          deployed"), BeanInfoHelper.encodeEntities((String)"HarvesterException.AmbiguousTypeName if the          type name requires qualification to resolve")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>The set of instances that are currently being harvested for the specified type. The type must be configured for harvesting.</p>  <p>The returned set of instances usually matches the corresponding set of instances configured for harvesting; but if an error occurs when harvesting an instance, that instance will be omitted from the returned set.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = WLDFHarvesterRuntimeMBean.class.getMethod("getHarvestableType", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{HarvesterRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"instanceName", (String)"the name of the instance to get the type for ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"HarvesterException.HarvestableInstancesNotFoundException if          the provided instance does not currently exist"), BeanInfoHelper.encodeEntities((String)"HarvesterException.AmbiguousInstanceName if the          instance name requires qualification to resolve")};
            methodDescriptor.setValue("throws", stringArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>The type associated with a particular harvestable instance.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

