/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import com.bea.adaptive.harvester.WatchedValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.harvester.HarvesterDataSample;
import weblogic.diagnostics.harvester.WLDFHarvesterUtils;
import weblogic.diagnostics.harvester.internal.DebugSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HarvesterSnapshot {
    private static final DebugLogger DBG_DATA = DebugSupport.getLowLevelDebugLogger();
    private Collection<HarvesterDataSample> harvestedSamples;
    private long snapshotTimeMillis;
    private long snapshotElapsedTimeNanos;

    private static Set<String> createSupportedTypeNameSet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Class clazz : SupportedTypesHolder.supportedClasses) {
            hashSet.add(clazz.getName());
        }
        return hashSet;
    }

    private static Set<Class> createSupportedTypesSet() {
        HashSet<Class> hashSet = new HashSet<Class>();
        for (Class clazz : SupportedTypesHolder.supportedClasses) {
            hashSet.add(clazz);
        }
        return hashSet;
    }

    HarvesterSnapshot(long l) {
        this.snapshotTimeMillis = l;
    }

    int getDataSampleCount() {
        return this.harvestedSamples.size();
    }

    long getSnapshotStartTimeMillis() {
        return this.snapshotTimeMillis;
    }

    long getSnapshotElapsedTimeNanos() {
        return this.snapshotElapsedTimeNanos;
    }

    void setSnapshotElapsedTimeNanos(long l) {
        this.snapshotElapsedTimeNanos = l;
    }

    Collection<HarvesterDataSample> getHarvesterDataSamples() {
        return this.harvestedSamples;
    }

    synchronized void setDataSamples(Collection<WatchedValues.Values> collection) {
        this.harvestedSamples = this.buildSamplesSet(collection);
    }

    private List<HarvesterDataSample> buildSamplesSet(Collection<WatchedValues.Values> collection) {
        ArrayList<HarvesterDataSample> arrayList = new ArrayList<HarvesterDataSample>();
        for (WatchedValues.Values values : collection) {
            List list = values.getValues().getRawValues();
            for (WatchedValues.Values.RawValueData rawValueData : list) {
                Object object = rawValueData.getValue();
                if (object == null) continue;
                Class<?> clazz = object.getClass();
                if (clazz.isArray()) {
                    this.addSamples(arrayList, rawValueData, (Object[])object);
                    continue;
                }
                this.addSample(arrayList, rawValueData, object);
            }
        }
        return arrayList;
    }

    private void addSamples(List<HarvesterDataSample> list, WatchedValues.Values.RawValueData rawValueData, Object[] objectArray) {
        for (Object object : objectArray) {
            if (object == null) continue;
            if (object.getClass().isArray()) {
                this.addSamples(list, rawValueData, (Object[])object);
                continue;
            }
            this.addSample(list, rawValueData, object);
        }
    }

    private void addSample(List<HarvesterDataSample> list, WatchedValues.Values.RawValueData rawValueData, Object object) {
        Class<?> clazz = object.getClass();
        if (HarvesterSnapshot.isSupportedValueType(clazz)) {
            list.add(new HarvesterDataSample(this.snapshotTimeMillis, rawValueData.getTypeName(), rawValueData.getInstanceName(), rawValueData.getAttributeName(), rawValueData.getValue()));
        } else if (object instanceof WatchedValues.AttributeTrackedDataItem) {
            WatchedValues.AttributeTrackedDataItem attributeTrackedDataItem = (WatchedValues.AttributeTrackedDataItem)object;
            String string = WLDFHarvesterUtils.buildDataContextString(attributeTrackedDataItem.getDataContext());
            Object object2 = attributeTrackedDataItem.getData();
            if (object2 != null && HarvesterSnapshot.isSupportedValueType(object2.getClass())) {
                list.add(new HarvesterDataSample(this.snapshotTimeMillis, rawValueData.getTypeName(), rawValueData.getInstanceName(), string, object2));
            } else if (DBG_DATA.isDebugEnabled()) {
                this.debugInvalidDataType(string, rawValueData.getInstanceName(), rawValueData.getTypeName());
            }
        } else if (DBG_DATA.isDebugEnabled()) {
            this.debugInvalidDataType(rawValueData.getAttributeName(), rawValueData.getInstanceName(), rawValueData.getTypeName());
        }
    }

    private void debugInvalidDataType(String string, String string2, String string3) {
        DBG_DATA.debug("Data value for attribute " + string + " of instance " + string2 + " is of type " + string3 + ", which is not supported for harvesting");
    }

    static boolean isSupportedValueType(String string) {
        if (DBG_DATA.isDebugEnabled()) {
            DBG_DATA.debug("checking if value of type " + string + " is supported");
        }
        return SupportedTypesHolder.SUPPORTED_TYPE_NAMES.contains(string);
    }

    static boolean isSupportedValueType(Class clazz) {
        if (DBG_DATA.isDebugEnabled()) {
            DBG_DATA.debug("checking if value of type " + clazz.getName() + " is supported");
        }
        return SupportedTypesHolder.SUPPORTED_TYPES.contains(clazz);
    }

    static /* synthetic */ Set access$000() {
        return HarvesterSnapshot.createSupportedTypesSet();
    }

    static /* synthetic */ Set access$100() {
        return HarvesterSnapshot.createSupportedTypeNameSet();
    }

    private static class SupportedTypesHolder {
        private static final Class[] supportedClasses = new Class[]{String.class, Integer.class, Integer.TYPE, Boolean.class, Boolean.TYPE, Long.class, Long.TYPE, Double.class, Double.TYPE, Character.class, Character.TYPE, Float.TYPE, Float.class, Byte.TYPE, Byte.class};
        private static final Set<Class> SUPPORTED_TYPES = HarvesterSnapshot.access$000();
        private static final Set<String> SUPPORTED_TYPE_NAMES = HarvesterSnapshot.access$100();

        private SupportedTypesHolder() {
        }
    }
}

