/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import weblogic.diagnostics.harvester.HarvesterException;
import weblogic.diagnostics.harvester.I18NConstants;

final class HarvesterSpec
implements I18NConstants {
    private String typeName = null;
    private boolean isEnabled = true;
    private StringArray requestedHarvestableAttributes = null;
    private StringArray requestedHarvestableInstances = null;

    HarvesterSpec(String string, String[] stringArray, String[] stringArray2, boolean bl) throws HarvesterException.NullName {
        if (string == null) {
            throw new HarvesterException.NullName(TYPE_I18N);
        }
        this.typeName = string;
        this.isEnabled = bl;
        this.requestedHarvestableAttributes = new StringArray(stringArray);
        this.requestedHarvestableAttributes.normalizeEntries();
        this.requestedHarvestableInstances = new StringArray(stringArray2);
        this.requestedHarvestableInstances.normalizeEntries();
    }

    String getTypeName() {
        return this.typeName;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    private class StringArray {
        private String[] array;

        private StringArray(String[] stringArray) {
            this.array = stringArray;
        }

        private String[] getStringArray() {
            return this.array;
        }

        private void normalizeEntries() {
            String[] stringArray = this.getStringArray();
            if (stringArray == null) {
                return;
            }
            int n = this.normalizeEntries(0, 0);
            if (n != 0) {
                String[] stringArray2 = new String[stringArray.length - n];
                int n2 = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (string == null) continue;
                    stringArray2[n2] = string;
                    ++n2;
                }
                this.array = stringArray2;
            }
        }

        private int normalizeEntries(int n, int n2) {
            String string;
            int n3;
            String[] stringArray = this.getStringArray();
            if (n + 1 > stringArray.length) {
                return 0;
            }
            if (n + 1 < stringArray.length) {
                n2 += this.normalizeEntries(n + 1, n2);
            }
            String string2 = stringArray[n];
            stringArray[n] = string2 = string2.trim();
            for (n3 = n + 1; n3 < stringArray.length && !string2.equals(string = stringArray[n3]); ++n3) {
            }
            if (n3 != stringArray.length) {
                ++n2;
                stringArray[n] = null;
            }
            return n2;
        }

        public String toString() {
            String[] stringArray = this.getStringArray();
            if (stringArray == null) {
                return "<ALL>";
            }
            String string = "[";
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (i != 0) {
                    string = string + ",";
                }
                string = string + string2;
            }
            string = string + "]";
            return string;
        }
    }
}

