/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import com.bea.adaptive.harvester.Harvester;
import com.bea.adaptive.harvester.jmx.MBeanHarvesterManager;
import weblogic.diagnostics.harvester.HarvesterRuntimeException;
import weblogic.diagnostics.harvester.internal.BaseHarvesterControlImpl;
import weblogic.diagnostics.harvester.internal.DelegateHarvesterControl;
import weblogic.diagnostics.harvester.internal.JMXHarvesterConfig;

class JMXHarvesterControlImpl
extends BaseHarvesterControlImpl {
    private static MBeanHarvesterManager harvesterLauncher;
    private JMXHarvesterConfig config;

    public JMXHarvesterControlImpl(JMXHarvesterConfig jMXHarvesterConfig, boolean bl) {
        super(jMXHarvesterConfig.getHarvesterName(), jMXHarvesterConfig.getNamespace(), DelegateHarvesterControl.ActivationPolicy.ON_METADATA_REQUEST, true, bl);
        this.config = jMXHarvesterConfig;
    }

    public JMXHarvesterControlImpl(JMXHarvesterConfig jMXHarvesterConfig, DelegateHarvesterControl.ActivationPolicy activationPolicy) {
        super(jMXHarvesterConfig.getHarvesterName(), jMXHarvesterConfig.getNamespace(), activationPolicy, true, false);
        this.config = jMXHarvesterConfig;
    }

    private void initHarvesterManager() {
        if (harvesterLauncher == null) {
            harvesterLauncher = new MBeanHarvesterManager();
            harvesterLauncher.prepareHarvesterManager();
            harvesterLauncher.activateHarvesterManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        JMXHarvesterControlImpl jMXHarvesterControlImpl = this;
        synchronized (jMXHarvesterControlImpl) {
            if (!this.isActive()) {
                this.initHarvesterManager();
                try {
                    Harvester harvester = harvesterLauncher.allocateHarvester(this.config.getHarvesterName(), this.config.getNamespace(), this.config.getMbeanServer(), this.config.getCategorizer(), null);
                    harvester.setAttributeNameTrackingEnabled(this.isAttributeNameTrackingEnabled());
                    harvester.setAttributeValidationEnabled(this.isAttributeValidationEnabled());
                    harvester.setRemoveAttributesWithProblems(true);
                    this.setDelegate(harvester);
                    this.setActive(true);
                }
                catch (Exception exception) {
                    throw new HarvesterRuntimeException(exception);
                }
            }
        }
    }
}

