/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import com.bea.adaptive.harvester.WatchedValues;
import com.bea.adaptive.harvester.WatchedValuesImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import weblogic.application.ApplicationContext;
import weblogic.descriptor.DescriptorDiff;
import weblogic.diagnostics.accessor.DiagnosticAccessRuntime;
import weblogic.diagnostics.accessor.DiagnosticDataAccessRuntime;
import weblogic.diagnostics.archive.DataWriter;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.descriptor.WLDFHarvestedTypeBean;
import weblogic.diagnostics.descriptor.WLDFHarvesterBean;
import weblogic.diagnostics.descriptor.WLDFResourceBean;
import weblogic.diagnostics.harvester.HarvesterDataSample;
import weblogic.diagnostics.harvester.HarvesterException;
import weblogic.diagnostics.harvester.I18NConstants;
import weblogic.diagnostics.harvester.I18NSupport;
import weblogic.diagnostics.harvester.InstanceNameNormalizer;
import weblogic.diagnostics.harvester.LogSupport;
import weblogic.diagnostics.harvester.WLDFHarvester;
import weblogic.diagnostics.harvester.WLDFHarvesterLauncher;
import weblogic.diagnostics.harvester.WLDFHarvesterManager;
import weblogic.diagnostics.harvester.WLDFHarvesterUtils;
import weblogic.diagnostics.harvester.WLDFToHarvester;
import weblogic.diagnostics.harvester.internal.DebugSupport;
import weblogic.diagnostics.harvester.internal.HarvesterImageSource;
import weblogic.diagnostics.harvester.internal.HarvesterRuntimeMBeanImpl;
import weblogic.diagnostics.harvester.internal.HarvesterSnapshot;
import weblogic.diagnostics.harvester.internal.HarvesterSpec;
import weblogic.diagnostics.i18n.DiagnosticsHarvesterLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.lifecycle.DiagnosticComponentLifecycleException;
import weblogic.diagnostics.module.WLDFModule;
import weblogic.diagnostics.module.WLDFModuleException;
import weblogic.diagnostics.utils.DateUtils;
import weblogic.diagnostics.watch.WatchManager;
import weblogic.kernel.Kernel;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.t3.srvr.T3Srvr;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.PlatformConstants;
import weblogic.utils.time.Timer;
import weblogic.work.WorkManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetricArchiver
implements TimerListener,
WLDFToHarvester,
I18NConstants {
    private static final String WATCHED_VALUES_NAME = "WLDFArchivedMetrics";
    private static final MetricArchiver archiver = new MetricArchiver();
    private ImageManager imageManager;
    private HarvesterRuntimeMBeanImpl harvesterRuntime;
    private boolean enabled = true;
    private static WLDFHarvester harvester;
    private static WLDFHarvesterLauncher launcher;
    private WatchedValues watchedValues = null;
    private int wvid = -1;
    private static boolean initializationComplete;
    private long samplePeriodNanos = 0L;
    private long samplePeriodFromConfigMillis = 0L;
    private boolean deployed = false;
    private boolean currentSnapshotAnOutlier = false;
    private long lastTotalTimeNanos = 0L;
    private long minimumSampleIntervalNanos;
    private int totalSamplingCycles = 0;
    private int currentDataSampleCount = 0;
    private long currentSnapshotStartTimeMillis = -1L;
    private long currentSnapshotElapsedTimeNanos = 0L;
    private long minimumSamplingTimeNanos = Long.MAX_VALUE;
    private long maximumSamplingTimeNanos = Long.MIN_VALUE;
    private long totalSamplingTimeNanos = 0L;
    private float averageSamplingTimeNanos = 0.0f;
    DataWriter archive = null;
    private HarvesterSnapshot inProgressSnapshot;
    private HarvesterSnapshot currentSnapshot;
    private Set<String> unharvestableTypes = null;
    private HashMap<String, HarvesterSpec> harvestSpecs = null;
    private long startTimeNanos = 0L;
    private long startTimeMillis = 0L;
    private long totalConfiguredDataSampleCount = 0L;
    private long totalImplicitDataSampleCount = 0L;
    private long outlierCount = 0L;
    private static final AuthenticatedSubject KERNEL_ID;
    private static final Timer CLOCK;
    private static final DebugLogger DBG;
    private static final DebugLogger DBG_DATA;
    private static final float STAT_OUTLIER_MULT_FACTOR = 3.0f;
    private static final boolean TEST_NO_ARCHIVE;
    long previousExpired = 0L;
    private static final boolean TEST_TRACE_INTERVALS;
    private static final boolean TEST_TRACE_STATS;
    private static final boolean TEST_REMOVE_OUTLIER_DETECTION;
    private static final Long TEST_HARVEST_DELAY_MILLIS;
    int cycleCount = 0;
    private static final Integer TEST_HARVEST_DELAY_AT_CYCLE;
    private static final boolean DBG_USE_LONG_DATA_FORM;
    public static final String HARV_IMAGE_SOURCE_NAME = "HarvesterImageSource";
    private static final long MINIMUM_SAMPLE_INTERVAL_AS_PERCENT_OF_SAMPLE_PERIOD = 50L;
    public static final String HVST_TIMER_MANAGER = "HarvesterTimerManager";
    private static final long NANOS_PER_MILLI = 1000000L;
    private static final long TIME_CONVERSION;
    WLDFResourceBean rootBean = null;
    private WatchManager watchManager;
    private TimerManagerFactory timerManagerFactory;
    private TimerManager timerManager;
    private weblogic.timers.Timer harvestTimer;
    private int enabledTypeCount;
    private static boolean adminServer;
    private static boolean checkedServerType;

    synchronized WLDFHarvester getHarvester() {
        if (initializationComplete) {
            this.initWLDFHarvester();
        }
        return harvester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeActivation() {
        TimerListener timerListener = this;
        synchronized (timerListener) {
            initializationComplete = true;
        }
        this.addWatchedValues();
        try {
            timerListener = WatchManager.getInstance();
            if (timerListener != null) {
                timerListener.activateConfiguration();
            }
        }
        catch (ManagementException managementException) {
            DiagnosticsHarvesterLogger.logErrorActivatingWatchConfiguration((Throwable)managementException);
        }
        this.initWLDFHarvester();
    }

    private synchronized void initWLDFHarvester() {
        if (initializationComplete) {
            if (harvester == null) {
                if (DBG.isDebugEnabled()) {
                    DBG.debug("WLDFHarvester singleton being lazily initialized...");
                }
                if (launcher == null) {
                    launcher = WLDFHarvesterManager.getInstance();
                    launcher.prepare();
                    launcher.activate();
                }
                harvester = launcher.getHarvesterSingleton();
            }
        } else if (DBG.isDebugEnabled()) {
            DBG.debug("Harvester service has not yet signaled that the activation is finalized");
        }
    }

    @Override
    public boolean isActivated() {
        return initializationComplete;
    }

    private MetricArchiver() {
    }

    static long getNanoWallClockTime() {
        return CLOCK.timestamp() + TIME_CONVERSION;
    }

    void init(ApplicationContext applicationContext, WLDFResourceBean wLDFResourceBean) {
        this.rootBean = wLDFResourceBean;
    }

    void prepare() {
    }

    synchronized void activate() {
        if (this.deployed) {
            return;
        }
        try {
            if (DBG.isDebugEnabled()) {
                DBG.debug("Harvester is being activated.");
            }
            this.watchManager = WatchManager.getInstance();
            this.imageManager = ImageManager.getInstance();
            this.imageManager.registerImageSource(HARV_IMAGE_SOURCE_NAME, new HarvesterImageSource());
            this.timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
            this.timerManager = this.timerManagerFactory.getTimerManager(HVST_TIMER_MANAGER, WorkManagerFactory.getInstance().getSystem());
            this.loadConfig(this.rootBean);
            this.deployed = true;
            if (DBG.isDebugEnabled()) {
                DBG.debug("Harvester activation is completed.");
            }
        }
        catch (Exception exception) {
            LogSupport.logUnexpectedException(I18NSupport.formatter().getConfigLoadingProblemMessage(), exception);
        }
    }

    private void addWatchedValues() {
        try {
            if (this.rootBean != null && this.rootBean.getHarvester().isEnabled()) {
                if (this.enabledTypeCount == 0) {
                    DiagnosticsLogger.logDisablingHarvesterDueToLackOfActiveConfig();
                    this.disableHarvester();
                } else {
                    this.wvid = this.addWatchedValues(this.watchedValues);
                    this.enableHarvester();
                }
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    synchronized void deactivate() {
        if (DBG.isDebugEnabled()) {
            DBG.debug("Harvester is being deactivated.");
        }
        this.disableHarvester();
        this.harvestSpecs = null;
        this.watchManager = null;
        if (launcher != null && harvester != null) {
            this.deleteArchiverWatchedValues();
        }
        try {
            this.imageManager.unregisterImageSource(HARV_IMAGE_SOURCE_NAME);
            this.imageManager = null;
        }
        catch (Exception exception) {
            LogSupport.logUnexpectedException("Problem unregistering Harvester image source.", exception);
        }
        this.inProgressSnapshot = null;
        this.currentSnapshot = null;
        this.deployed = false;
        this.unharvestableTypes = null;
        if (DBG.isDebugEnabled()) {
            DBG.debug("Harvester is now inactive.");
        }
    }

    private void deleteArchiverWatchedValues() {
        if (this.wvid > -1) {
            try {
                this.deleteWatchedValues(this.watchedValues);
            }
            catch (HarvesterException harvesterException) {
                DiagnosticsLogger.logErrorDeleteingWatchedValues((String)this.watchedValues.getName(), (Throwable)((Object)harvesterException));
            }
            this.watchedValues = null;
            this.wvid = -1;
        }
    }

    void unprepare() {
    }

    void destroy() {
    }

    void prepareUpdate(WLDFResourceBean wLDFResourceBean, DescriptorDiff descriptorDiff) throws WLDFModuleException {
    }

    synchronized void activateUpdate(WLDFResourceBean wLDFResourceBean, DescriptorDiff descriptorDiff) throws WLDFModuleException {
        try {
            this.reloadConfig(wLDFResourceBean);
        }
        catch (Exception exception) {
            LogSupport.logUnexpectedException("Problem consuming modified configuration.", exception);
        }
    }

    void rollbackUpdate(WLDFResourceBean wLDFResourceBean, DescriptorDiff descriptorDiff) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(weblogic.timers.Timer timer) {
        if (!this.deployed || !this.enabled) {
            if (DBG.isDebugEnabled()) {
                DBG.debug("A pending harvester cycle is being skipped because the harvester has been disabled.");
            }
            return;
        }
        if (DBG.isDebugEnabled()) {
            DBG.debug("Timer expired for harvester with period = " + timer.getPeriod() + " at " + DateUtils.nanoDateToString(System.currentTimeMillis() * 1000000L, true));
            DBG.debug("TIMER OBJECT  " + timer);
        }
        String string = WLDFModule.UPDATE_SYNC;
        synchronized (string) {
            long l;
            if (DBG.isDebugEnabled()) {
                DBG.debug("Entered sync block at " + DateUtils.nanoDateToString(System.currentTimeMillis() * 1000000L, true));
            }
            long l2 = 0L;
            long l3 = MetricArchiver.getNanoWallClockTime();
            long l4 = System.currentTimeMillis();
            if (TEST_TRACE_INTERVALS) {
                l2 = MetricArchiver.getNanoWallClockTime();
                System.out.print(" HTO: " + (l2 - this.previousExpired));
            }
            if ((l = l3 - this.startTimeNanos) < this.minimumSampleIntervalNanos) {
                DiagnosticsLogger.logInsufficientTimeBetweenHarvesterCycles((long)(l / 1000000L));
                if (TEST_TRACE_INTERVALS) {
                    System.out.print("*");
                }
                return;
            }
            this.startTimeNanos = l3;
            this.startTimeMillis = l4;
            this.execute(l3);
            if (this.watchManager != null) {
                this.watchManager.evaluateHarvesterRules();
            }
            if (this.harvesterRuntime != null) {
                long l5 = this.currentSnapshot != null ? this.currentSnapshot.getSnapshotStartTimeMillis() : this.startTimeMillis;
                this.harvesterRuntime.harvestCycleOccurred(l5);
            }
            this.previousExpired = l2;
        }
    }

    @Override
    public int addWatchedValues(WatchedValues watchedValues) {
        int n = -1;
        WLDFHarvester wLDFHarvester = this.getHarvester();
        if (wLDFHarvester == null) {
            if (DBG.isDebugEnabled()) {
                DBG.debug("addWatchedValues(): harvester not yet initialized, returning");
            }
            return n;
        }
        try {
            if (DBG.isDebugEnabled()) {
                DBG.debug("Harvester is being providing the list of watched data.");
            }
            n = wLDFHarvester.addWatchedValues(watchedValues.getName(), watchedValues, null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (watchedValues.getAllMetricValues().size() > 0) {
            if (DBG.isDebugEnabled()) {
                DBG.debug("Harvester watched data has been setup.");
            }
            if (!this.enabled) {
                if (DBG.isDebugEnabled()) {
                    DBG.debug("Harvester is being enabled implicitly with an internal of " + this.samplePeriodFromConfigMillis + " milliseconds.");
                }
                this.enableHarvester();
            } else if (DBG.isDebugEnabled()) {
                String string = this.dumpAsString("  ");
                DBG.debug(PlatformConstants.EOL + string);
            }
        }
        return n;
    }

    @Override
    public Collection<WatchedValues.Validation> validateWatchedValues(WatchedValues watchedValues) throws HarvesterException.HarvestingNotEnabled {
        if (harvester != null) {
            return harvester.validateWatchedValues(watchedValues);
        }
        throw new HarvesterException.HarvestingNotEnabled();
    }

    int getStatus() {
        if (!this.enabled || !this.deployed) {
            return 2;
        }
        return 1;
    }

    boolean isEnabled() {
        switch (this.getStatus()) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    void initialize() {
        if (Kernel.isServer()) {
            try {
                this.harvesterRuntime = HarvesterRuntimeMBeanImpl.getInstance(this);
            }
            catch (ManagementException managementException) {
                throw new RuntimeException(managementException);
            }
        }
    }

    void enable() throws DiagnosticComponentLifecycleException {
    }

    void disable() throws DiagnosticComponentLifecycleException {
        if (this.harvestTimer != null) {
            this.harvestTimer.cancel();
        }
        this.harvestTimer = null;
    }

    public static MetricArchiver getInstance() {
        return archiver;
    }

    HarvesterSnapshot getCurrentSnapshot() {
        return this.currentSnapshot;
    }

    long getSamplePeriod() throws HarvesterException.HarvestingNotEnabled {
        return this.samplePeriodFromConfigMillis;
    }

    int getTotalSamplingCycles() {
        return this.totalSamplingCycles;
    }

    long getTotalConfiguredDataSampleCount() {
        return this.totalConfiguredDataSampleCount;
    }

    int getCurrentConfiguredDataSampleCount() throws HarvesterException.HarvestingNotEnabled {
        return this.currentDataSampleCount;
    }

    long getTotalImplicitDataSampleCount() {
        return this.totalImplicitDataSampleCount;
    }

    long getCurrentImplicitDataSampleCount() throws HarvesterException.HarvestingNotEnabled {
        if (!this.enabled || !this.deployed) {
            throw new HarvesterException.HarvestingNotEnabled();
        }
        if (this.watchedValues == null) {
            return 0L;
        }
        return this.watchedValues.getMostRecentValuesCount();
    }

    public long getTotalSamplingTimeOutlierCount() {
        return this.outlierCount;
    }

    public boolean isCurrentSampleTimeAnOutlier() {
        return this.currentSnapshotAnOutlier;
    }

    public float getOutlierDetectionFactor() {
        return 3.0f;
    }

    long getCurrentSnapshotStartTime() throws HarvesterException.HarvestingNotEnabled {
        return this.currentSnapshotStartTimeMillis * 1000000L;
    }

    long getCurrentSnapshotElapsedTime() throws HarvesterException.HarvestingNotEnabled {
        return this.currentSnapshotElapsedTimeNanos;
    }

    long getMinimumSamplingTime() {
        return this.minimumSamplingTimeNanos;
    }

    long getMaximumSamplingTime() {
        return this.maximumSamplingTimeNanos;
    }

    long getTotalSamplingTime() {
        return this.totalSamplingTimeNanos;
    }

    long getAverageSamplingTime() {
        return Math.round(this.averageSamplingTimeNanos);
    }

    synchronized String[] getCurrentlyHarvestedAttributes(String string) throws HarvesterException.MissingConfigurationType {
        String[] stringArray = new String[]{};
        WLDFHarvester wLDFHarvester = this.getHarvester();
        if (wLDFHarvester != null) {
            this.checkConfiguredType(string);
            List list = wLDFHarvester.getHarvestedAttributes(this.wvid, string, null);
            if (list != null && list.size() > 0) {
                stringArray = list.toArray(new String[list.size()]);
            }
        }
        return stringArray;
    }

    public String[] getConfiguredNamespaces() {
        String[] stringArray = new String[]{};
        WLDFHarvester wLDFHarvester = this.getHarvester();
        if (wLDFHarvester != null) {
            stringArray = wLDFHarvester.getSupportedNamespaces();
        }
        return stringArray;
    }

    public String getDefaultNamespace() {
        String string = null;
        WLDFHarvester wLDFHarvester = this.getHarvester();
        if (wLDFHarvester != null) {
            string = wLDFHarvester.getDefaultNamespace();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfiguredType(String string) throws HarvesterException.MissingConfigurationType {
        HarvesterSpec harvesterSpec = null;
        if (this.harvestSpecs != null) {
            HashMap<String, HarvesterSpec> hashMap = this.harvestSpecs;
            synchronized (hashMap) {
                harvesterSpec = this.harvestSpecs.get(string);
            }
        }
        if (harvesterSpec == null) {
            throw new HarvesterException.MissingConfigurationType(string);
        }
    }

    String[] getKnownHarvestableTypes() {
        return this.getKnownHarvestableTypes(null);
    }

    String[] getKnownHarvestableTypes(String string) {
        String[] stringArray = new String[]{};
        WLDFHarvester wLDFHarvester = this.getHarvester();
        if (wLDFHarvester != null) {
            try {
                String[][] stringArray2 = wLDFHarvester.getKnownHarvestableTypes(string, null);
                if (stringArray2 != null) {
                    stringArray = new String[stringArray2.length];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        stringArray[i] = stringArray2[i][0];
                    }
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return stringArray;
    }

    String[] getKnownHarvestableInstances(String string) throws HarvesterException.AmbiguousTypeName, HarvesterException.HarvestableTypesNotFoundException, HarvesterException.TypeNotHarvestable {
        return this.getKnownHarvestableInstances(null, string);
    }

    synchronized String[] getKnownHarvestableInstances(String string, String string2) throws HarvesterException.AmbiguousTypeName, HarvesterException.HarvestableTypesNotFoundException, HarvesterException.TypeNotHarvestable {
        String[] stringArray = new String[]{};
        WLDFHarvester wLDFHarvester = this.getHarvester();
        if (wLDFHarvester != null) {
            try {
                List<String> list = wLDFHarvester.getKnownHarvestableInstances(string, string2, null);
                stringArray = list.toArray(new String[list.size()]);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            catch (RuntimeException runtimeException) {
                throw new HarvesterException.HarvestableTypesNotFoundException(new String[]{string2}, (Throwable)runtimeException);
            }
            if (stringArray == null) {
                throw new HarvesterException.HarvestableTypesNotFoundException(new String[]{string2});
            }
        }
        return stringArray;
    }

    synchronized String[] getCurrentlyHarvestedInstances(String string) throws HarvesterException.MissingConfigurationType {
        String[] stringArray = new String[]{};
        WLDFHarvester wLDFHarvester = this.getHarvester();
        if (wLDFHarvester != null) {
            this.checkConfiguredType(string);
            try {
                List list = wLDFHarvester.getHarvestedInstances(this.wvid, string, null);
                stringArray = new String[list.size()];
                list.toArray(stringArray);
            }
            catch (RuntimeException runtimeException) {
                throw new HarvesterException.MissingConfigurationType(string, runtimeException);
            }
        }
        return stringArray;
    }

    synchronized String[][] getHarvestableAttributes(String string) throws IOException, HarvesterException.AmbiguousTypeName, HarvesterException.HarvestableTypesNotFoundException, HarvesterException.TypeNotHarvestable {
        String[][] stringArray;
        String[][] stringArray2 = new String[][]{};
        WLDFHarvester wLDFHarvester = this.getHarvester();
        if (wLDFHarvester != null && (stringArray = wLDFHarvester.getHarvestableAttributes(string, null)) != null) {
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            for (String[] stringArray3 : stringArray) {
                String string2 = stringArray3[1];
                if (!HarvesterSnapshot.isSupportedValueType(string2)) continue;
                arrayList.add(stringArray3);
            }
            if (arrayList.size() > 0) {
                stringArray2 = (String[][])arrayList.toArray((T[])stringArray2);
            }
        }
        return stringArray2;
    }

    public synchronized String getHarvestableType(String string) throws HarvesterException.HarvestableInstancesNotFoundException, HarvesterException.AmbiguousInstanceName {
        String string2 = null;
        WLDFHarvester wLDFHarvester = this.getHarvester();
        if (wLDFHarvester != null) {
            String string3 = string;
            try {
                string3 = new ObjectName(string).getCanonicalName();
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            string2 = WLDFHarvesterUtils.getTypeForInstance(string);
            if (string2 == null) {
                string2 = wLDFHarvester.getTypeForInstance(string3);
            }
        }
        return string2;
    }

    private synchronized void execute(long l) {
        boolean bl;
        if (T3Srvr.getT3Srvr().getRunState() == 2) {
            if (DBG.isDebugEnabled()) {
                DBG.debug("Executing harvesting process.");
            }
        } else {
            if (DBG.isDebugEnabled()) {
                DBG.debug("Scheduled harvest cycle postponed util server is started.");
            }
            return;
        }
        if (harvester != null) {
            harvester.harvest(null);
        }
        long l2 = System.currentTimeMillis();
        this.inProgressSnapshot = new HarvesterSnapshot(l2);
        if (this.watchedValues == null) {
            if (DBG.isDebugEnabled()) {
                DBG.debug("Watched values for MetricArchiver not set, skipping harvest cycle");
            }
            DiagnosticsLogger.logHarvesterIsDisabled();
            return;
        }
        List list = this.watchedValues.getAllMetricValues();
        this.inProgressSnapshot.setDataSamples(list);
        long l3 = list != null ? (long)list.size() : 0L;
        long l4 = this.watchedValues != null ? this.watchedValues.getMostRecentValuesCount() : 0L;
        this.totalConfiguredDataSampleCount += l3;
        this.totalImplicitDataSampleCount += l4;
        long l5 = l4 + l3;
        if (l5 == 0L) {
            if (DBG.isDebugEnabled()) {
                DBG.debug("No data was harvested");
            }
            return;
        }
        if (l3 > 0L) {
            DBG.debug("Harvested " + l3 + " data samples from configured specifications.");
        }
        if (l4 > 0L) {
            DBG.debug("Harvested " + l4 + " implicit data samples.");
        }
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        if (TEST_HARVEST_DELAY_MILLIS != null) {
            boolean bl2 = true;
            if (TEST_HARVEST_DELAY_AT_CYCLE != null) {
                int n = TEST_HARVEST_DELAY_AT_CYCLE;
                ++this.cycleCount;
                if (this.cycleCount != n) {
                    bl2 = false;
                }
            }
            if (bl2) {
                long l9 = TEST_HARVEST_DELAY_MILLIS;
                try {
                    Thread.sleep(l9);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (DBG_DATA.isDebugEnabled()) {
            if (l3 > 0L) {
                String string = PlatformConstants.EOL + PlatformConstants.EOL + "*************************************************" + PlatformConstants.EOL + "CONFIGURED DATA SAMPLES (set in the last cycle):" + PlatformConstants.EOL + "*************************************************" + PlatformConstants.EOL + PlatformConstants.EOL;
                long l10 = this.inProgressSnapshot.getSnapshotStartTimeMillis();
                string = string + "Timestamp of the most recent collection: " + DateUtils.nanoDateToString(l10 * 1000000L, true) + PlatformConstants.EOL + PlatformConstants.EOL;
                for (HarvesterDataSample harvesterDataSample : this.inProgressSnapshot.getHarvesterDataSamples()) {
                    String string2 = DBG_USE_LONG_DATA_FORM ? harvesterDataSample.toStringLong() : harvesterDataSample.toStringShort();
                    string = string + string2 + PlatformConstants.EOL;
                }
                DBG_DATA.debug(string);
            }
            if (l4 > 0L) {
                String string = this.watchedValues.dump("", true, false, !DBG_USE_LONG_DATA_FORM);
                DBG_DATA.debug(string);
            }
        }
        if (DBG.isDebugEnabled()) {
            l6 = MetricArchiver.getNanoWallClockTime() - l;
        }
        if (!TEST_NO_ARCHIVE) {
            long l11 = 0L;
            if (DBG.isDebugEnabled()) {
                l11 = MetricArchiver.getNanoWallClockTime();
            }
            this.archive();
            if (DBG.isDebugEnabled()) {
                l7 = MetricArchiver.getNanoWallClockTime() - l11;
            }
        }
        l8 = MetricArchiver.getNanoWallClockTime() - l;
        if (DBG.isDebugEnabled()) {
            DBG.debug("Nanosecond timings for this harvest cycle:   1) harvest: " + l6 + "   2) archive: " + l7 + "   3) total: " + l8);
        }
        boolean bl3 = bl = (float)l8 > (float)this.lastTotalTimeNanos * 3.0f;
        if (TEST_REMOVE_OUTLIER_DETECTION) {
            bl = false;
        }
        if (TEST_TRACE_STATS) {
            System.out.print("HT: " + l8);
            System.out.println("" + (bl ? "*" : ""));
        }
        this.inProgressSnapshot.setSnapshotElapsedTimeNanos(l8);
        this.currentSnapshot = this.inProgressSnapshot;
        this.inProgressSnapshot = null;
        if (!bl) {
            if (!this.currentSnapshotAnOutlier) {
                this.updateHarvesterRuntime(l8, 0L);
            } else {
                if (DBG.isDebugEnabled()) {
                    DBG.debug("The last harvest cycle was removed from the Harvester statistics as an outlier.  To make up for this we are adding the current values twice.");
                }
                this.updateHarvesterRuntime(l8, l8);
            }
        } else {
            ++this.outlierCount;
            if (!this.currentSnapshotAnOutlier) {
                if (DBG.isDebugEnabled()) {
                    DBG.debug("This harvest cycle took significantly longer than expected.  It is being removed from the harvester statistics as an outlier");
                }
            } else {
                if (DBG.isDebugEnabled()) {
                    DBG.debug("This harvest cycle took significantly longer than expected.  It is being removed from the harvester statistics as an outlier.  In addition, the last cycle was removed for the same reasons.  Because this value is larger we are promoting it to outlier status and adding in the previous cycle values twice.");
                }
                this.updateHarvesterRuntime(this.lastTotalTimeNanos, this.lastTotalTimeNanos);
            }
        }
        this.lastTotalTimeNanos = l8;
        this.currentSnapshotAnOutlier = bl;
    }

    private DataWriter getArchive() {
        if (this.archive == null) {
            try {
                DiagnosticAccessRuntime diagnosticAccessRuntime = DiagnosticAccessRuntime.getInstance();
                DiagnosticDataAccessRuntime diagnosticDataAccessRuntime = (DiagnosticDataAccessRuntime)diagnosticAccessRuntime.lookupWLDFDataAccessRuntime("HarvestedDataArchive");
                this.archive = (DataWriter)diagnosticDataAccessRuntime.getDiagnosticDataAccessService();
            }
            catch (Exception exception) {
                LogSupport.logUnexpectedException("Could not find harvester archive", exception);
            }
        }
        return this.archive;
    }

    private void archive() {
        DataWriter dataWriter = this.getArchive();
        if (dataWriter != null) {
            Collection<HarvesterDataSample> collection = this.inProgressSnapshot.getHarvesterDataSamples();
            if (DBG.isDebugEnabled()) {
                DBG.debug("Archiving " + collection.size() + " samples...");
            }
            if (collection.size() == 0) {
                return;
            }
            try {
                dataWriter.writeData(collection);
            }
            catch (IOException iOException) {
                DiagnosticsLogger.logErrorHarvesting((Throwable)iOException);
            }
        }
    }

    private void updateHarvesterRuntime(long l, long l2) {
        ++this.totalSamplingCycles;
        this.currentSnapshotStartTimeMillis = this.currentSnapshot.getSnapshotStartTimeMillis();
        this.currentSnapshotElapsedTimeNanos = l;
        this.currentDataSampleCount = this.currentSnapshot.getDataSampleCount();
        this.totalSamplingTimeNanos += this.currentSnapshotElapsedTimeNanos;
        this.averageSamplingTimeNanos = (float)this.totalSamplingTimeNanos / (float)this.totalSamplingCycles;
        this.minimumSamplingTimeNanos = Math.min(this.minimumSamplingTimeNanos, this.currentSnapshotElapsedTimeNanos);
        this.maximumSamplingTimeNanos = Math.max(this.maximumSamplingTimeNanos, this.currentSnapshotElapsedTimeNanos);
        if (TEST_TRACE_STATS) {
            System.out.println("HS:              " + this.currentSnapshotElapsedTimeNanos + " " + this.totalSamplingTimeNanos + " " + this.averageSamplingTimeNanos);
        }
        if (l2 != 0L) {
            ++this.totalSamplingCycles;
            this.totalSamplingTimeNanos += l2;
            this.averageSamplingTimeNanos = (float)this.totalSamplingTimeNanos / (float)this.totalSamplingCycles;
            if (TEST_TRACE_STATS) {
                System.out.println("HS2:             " + l2 + " " + this.totalSamplingTimeNanos + " " + this.averageSamplingTimeNanos);
            }
        }
    }

    @Override
    public WatchedValues createWatchedValues(String string) {
        WatchedValuesImpl watchedValuesImpl = new WatchedValuesImpl(string, this.getSamplePeriodSeconds());
        watchedValuesImpl.setShared(true);
        watchedValuesImpl.setId(-1);
        return watchedValuesImpl;
    }

    @Override
    public void deleteWatchedValues(WatchedValues watchedValues) throws HarvesterException {
        if (harvester == null) {
            throw new HarvesterException.HarvestingNotEnabled();
        }
        try {
            if (watchedValues != null) {
                if (watchedValues.getId() >= 0) {
                    harvester.deleteWatchedValues(watchedValues);
                    watchedValues.setId(-1);
                } else if (DBG.isDebugEnabled()) {
                    DBG.debug("deleteWatchedValues(): nothing to do, watched values list id is invalid: " + watchedValues.getId());
                }
            } else if (DBG.isDebugEnabled()) {
                DBG.debug("deleteWatchedValues(): nothing to do, watched values list is null");
            }
        }
        catch (Exception exception) {
            String string = watchedValues == null ? "Unknown" : watchedValues.getName();
            DiagnosticsLogger.logErrorDeleteingWatchedValues((String)string, (Throwable)exception);
        }
    }

    private void addUnharvestableType(String string) {
        DiagnosticsLogger.logTypeRemoval((String)string);
    }

    private void loadConfigInternal(WLDFResourceBean wLDFResourceBean) {
        WLDFHarvesterBean wLDFHarvesterBean = wLDFResourceBean.getHarvester();
        this.resetState(wLDFHarvesterBean);
        if (!wLDFHarvesterBean.isEnabled()) {
            DiagnosticsLogger.logHarvesterIsDisabled();
            this.disableHarvester();
            return;
        }
        WLDFHarvestedTypeBean[] wLDFHarvestedTypeBeanArray = wLDFHarvesterBean.getHarvestedTypes();
        for (int i = 0; i < wLDFHarvestedTypeBeanArray.length; ++i) {
            String[] stringArray;
            String[] stringArray2;
            WLDFHarvestedTypeBean wLDFHarvestedTypeBean = wLDFHarvestedTypeBeanArray[i];
            String string = wLDFHarvestedTypeBean.getName();
            String string2 = wLDFHarvestedTypeBean.getNamespace();
            if (!MetricArchiver.isAdminServer() && string2.equals("DomainRuntime")) {
                DiagnosticsHarvesterLogger.logUnservicableHarvestedTypeNamespaceError((String)string, (String)string2);
                continue;
            }
            HarvesterSpec harvesterSpec = this.harvestSpecs.get(string);
            boolean bl = wLDFHarvestedTypeBean.isEnabled();
            if (DBG.isDebugEnabled()) {
                DBG.debug("Harvester configuration for type: " + string + " is currently " + (bl ? "enabled" : "disabled"));
            }
            if ((stringArray2 = wLDFHarvestedTypeBean.getHarvestedAttributes()) != null && stringArray2.length == 0) {
                stringArray2 = null;
            }
            if ((stringArray = wLDFHarvestedTypeBean.getHarvestedInstances()) != null && stringArray.length == 0) {
                stringArray = null;
            }
            if (harvesterSpec == null) {
                try {
                    stringArray2 = WLDFHarvesterUtils.normalizeAttributeSpecs(string, stringArray2);
                    harvesterSpec = new HarvesterSpec(string, stringArray2, stringArray, bl);
                    this.registerWatchedValues(string2, string, stringArray, stringArray2, bl);
                    this.harvestSpecs.put(string, harvesterSpec);
                }
                catch (HarvesterException.HarvestingNotEnabled harvestingNotEnabled) {
                    throw new RuntimeException((Throwable)((Object)harvestingNotEnabled));
                }
                catch (HarvesterException.NullName nullName) {
                    this.addUnharvestableType(string);
                }
            }
            if (!bl) {
                DiagnosticsLogger.logHarvesterTypeIsDisabled((String)string);
                continue;
            }
            ++this.enabledTypeCount;
        }
        this.addWatchedValues();
    }

    private void resetState(WLDFHarvesterBean wLDFHarvesterBean) {
        this.deleteArchiverWatchedValues();
        this.watchedValues = this.createWatchedValues(WATCHED_VALUES_NAME);
        this.harvestSpecs = new HashMap();
        this.unharvestableTypes = new HashSet<String>();
        this.samplePeriodFromConfigMillis = wLDFHarvesterBean.getSamplePeriod();
        this.enabledTypeCount = 0;
    }

    private void registerWatchedValues(String string, String string2, String[] stringArray, String[] stringArray2, boolean bl) throws HarvesterException.HarvestingNotEnabled {
        if (stringArray == null) {
            this.registerWatchedValues(string, string2, null, false, stringArray2, bl);
        } else {
            for (String string3 : stringArray) {
                InstanceNameNormalizer instanceNameNormalizer = new InstanceNameNormalizer(string3);
                try {
                    this.registerWatchedValues(string, string2, instanceNameNormalizer.translateHarvesterSpec(), instanceNameNormalizer.isRegexPattern(), stringArray2, bl);
                }
                catch (Exception exception) {
                    DiagnosticsHarvesterLogger.logInstanceNameInvalid((String)string3);
                }
            }
        }
    }

    private void registerWatchedValues(String string, String string2, String string3, boolean bl, String[] stringArray, boolean bl2) throws HarvesterException.HarvestingNotEnabled {
        if (stringArray == null) {
            this.watchedValues.addMetric(string, string2, string3, null, false, bl, false, bl2);
        } else {
            for (String string4 : stringArray) {
                this.watchedValues.addMetric(string, string2, string3, string4, false, false, false, bl2);
            }
        }
    }

    private int getSamplePeriodSeconds() {
        return (int)this.samplePeriodFromConfigMillis / 1000;
    }

    private void loadConfig(WLDFResourceBean wLDFResourceBean) {
        DiagnosticsLogger.logConfigLoading();
        this.loadConfigInternal(wLDFResourceBean);
    }

    private void reloadConfig(WLDFResourceBean wLDFResourceBean) {
        DiagnosticsLogger.logConfigReloading();
        if (!this.deployed) {
            throw new AssertionError((Object)LogSupport.getGenericHarvesterProblemText("Attempt to load a new configuration into an undeployed Harvester."));
        }
        this.loadConfigInternal(wLDFResourceBean);
    }

    private void enableHarvester() {
        long l = this.samplePeriodFromConfigMillis * 1000000L;
        if (!this.enabled || l != this.samplePeriodNanos) {
            if (this.harvestTimer != null) {
                this.harvestTimer.cancel();
            }
            this.samplePeriodNanos = l;
            this.minimumSampleIntervalNanos = Math.round((float)this.samplePeriodNanos / 100.0f * 50.0f);
            this.harvestTimer = this.scheduleTimer(this, this.samplePeriodFromConfigMillis);
            DiagnosticsLogger.logHarvestTimerInitiated((long)this.samplePeriodFromConfigMillis);
        }
        this.enabled = true;
        if (DBG.isDebugEnabled()) {
            String string = this.dumpAsString("  ");
            DBG.debug(PlatformConstants.EOL + string);
        }
        this.postEnabledStatusMessage();
    }

    private void disableHarvester() {
        if (this.harvestTimer != null) {
            this.harvestTimer.cancel();
        }
        this.harvestTimer = null;
        this.harvestSpecs = null;
        this.enabled = false;
        this.postEnabledStatusMessage();
    }

    private void postEnabledStatusMessage() {
        String string = this.enabled ? ACTIVE_I18N : INACTIVE_I18N;
        DiagnosticsLogger.logHarvestState((String)string);
    }

    private weblogic.timers.Timer scheduleTimer(final MetricArchiver metricArchiver, final long l) {
        weblogic.timers.Timer timer = null;
        try {
            timer = (weblogic.timers.Timer)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID), (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    MetricArchiver.this.harvestTimer = MetricArchiver.this.timerManager.scheduleAtFixedRate((TimerListener)metricArchiver, 0L, l);
                    return MetricArchiver.this.harvestTimer;
                }
            });
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException(privilegedActionException);
        }
        return timer;
    }

    String dumpAsString(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        this.dump(printStream, string);
        String string2 = byteArrayOutputStream.toString();
        return string2;
    }

    void dump(PrintStream printStream, String string) {
        printStream.println("");
        printStream.println(string + "Active Harvester Configuration:");
        printStream.println(string + "  enabled: " + this.enabled);
        printStream.println(string + "  samplePeriod: " + Math.round((float)this.samplePeriodNanos / 1000000.0f));
        printStream.println(string + "  unharvestableTypes: " + this.unharvestableTypes);
        printStream.println(string + "  Current Configured Harvester Specifications:");
        if (this.watchedValues != null) {
            this.watchedValues.dump("\t", true, true, false);
        }
    }

    public static boolean isAdminServer() {
        if (!checkedServerType) {
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
            adminServer = runtimeAccess.isAdminServer();
            checkedServerType = true;
            if (adminServer && DBG.isDebugEnabled()) {
                DBG.debug("adminServer is " + adminServer);
            }
        }
        return adminServer;
    }

    static {
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        CLOCK = Timer.createTimer();
        DBG = DebugSupport.getDebugLogger();
        DBG_DATA = DebugSupport.getLowLevelDebugLogger();
        TEST_NO_ARCHIVE = Boolean.getBoolean("weblogic.diagnostics.harvester.DBG_NoArchive");
        TEST_TRACE_INTERVALS = Boolean.getBoolean("weblogic.diagnostics.harvester.DBG_TraceHarvestIntervals");
        TEST_TRACE_STATS = Boolean.getBoolean("weblogic.diagnostics.harvester.DBG_TraceHarvesterStatistics");
        TEST_REMOVE_OUTLIER_DETECTION = Boolean.getBoolean("weblogic.diagnostics.harvester.DBG_RemoveOutlierDetection");
        TEST_HARVEST_DELAY_MILLIS = Long.getLong("weblogic.diagnostics.harvester.DBG_HarvesterDelay");
        TEST_HARVEST_DELAY_AT_CYCLE = Integer.getInteger("weblogic.diagnostics.harvester.DBG_HarvesterDelayAt");
        DBG_USE_LONG_DATA_FORM = Boolean.getBoolean("weblogic.diagnostics.harvester.DBG_UseLongDataForm");
        TIME_CONVERSION = System.currentTimeMillis() * 1000000L - CLOCK.timestamp();
    }
}

