/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import java.beans.BeanInfo;
import java.lang.reflect.Method;
import weblogic.diagnostics.harvester.HarvesterRuntimeException;
import weblogic.utils.AssertionError;

public final class TreeBeanHarvestableDataProviderHelper {
    static Object supportService = null;
    private static final String SUPPORT_SERVICE_CLASS = "weblogic.management.mbeanservers.runtime.internal.DiagnosticSupportService";
    private static final Class SupportServiceClass = TreeBeanHarvestableDataProviderHelper.getClass("weblogic.management.mbeanservers.runtime.internal.DiagnosticSupportService");
    private static Method getBeanInfo = TreeBeanHarvestableDataProviderHelper.getDeclaredMethod("getBeanInfo", new Class[]{String.class});
    private static Method getObjectIdentifier = TreeBeanHarvestableDataProviderHelper.getDeclaredMethod("getObjectIdentifier", new Class[]{Object.class});
    private static Method getRegisteredObjectIdentifier = TreeBeanHarvestableDataProviderHelper.getDeclaredMethod("getRegisteredObjectIdentifier", new Class[]{Object.class});
    private static Method unregisterInstance = TreeBeanHarvestableDataProviderHelper.getDeclaredMethod("unregisterInstance", new Class[]{Object.class});
    private static Method typeNameForInstance = TreeBeanHarvestableDataProviderHelper.getDeclaredMethod("getInterfaceClassForObjectIdentifier", new Class[]{String.class});
    private static Method instanceForObjectIdentifier = TreeBeanHarvestableDataProviderHelper.getDeclaredMethod("getInstanceForObjectIdentifier", new Class[]{String.class});

    public static void setSupportService(Object object) {
        if (supportService != null) {
            return;
        }
        supportService = object;
    }

    public static BeanInfo getBeanInfo(String string) {
        try {
            return (BeanInfo)getBeanInfo.invoke(supportService, string);
        }
        catch (Exception exception) {
            throw new HarvesterRuntimeException(exception);
        }
    }

    public static String getObjectNameForBean(Object object) {
        try {
            return (String)getObjectIdentifier.invoke(supportService, object);
        }
        catch (Exception exception) {
            throw new HarvesterRuntimeException(exception);
        }
    }

    public static String getRegisteredObjectNameForBean(Object object) {
        try {
            return (String)getRegisteredObjectIdentifier.invoke(supportService, object);
        }
        catch (Exception exception) {
            throw new HarvesterRuntimeException(exception);
        }
    }

    static void unregisterInstance(Object object) {
        try {
            unregisterInstance.invoke(supportService, object);
        }
        catch (Exception exception) {
            throw new HarvesterRuntimeException(exception);
        }
    }

    public static String getTypeNameForInstance(String string) {
        try {
            return (String)typeNameForInstance.invoke(supportService, string);
        }
        catch (Exception exception) {
            throw new HarvesterRuntimeException(exception);
        }
    }

    public static Object getInstanceForObjectIdentifier(String string) {
        try {
            return instanceForObjectIdentifier.invoke(supportService, string);
        }
        catch (Exception exception) {
            throw new HarvesterRuntimeException(exception);
        }
    }

    private static Method getDeclaredMethod(String string, Class[] classArray) {
        try {
            return SupportServiceClass.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Throwable)noSuchMethodException);
        }
    }

    private static Class getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Throwable)classNotFoundException);
        }
    }
}

