/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.DynamicMBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.descriptor.WLDFHarvestedTypeBean;
import weblogic.diagnostics.harvester.AttributeNameNormalizer;
import weblogic.diagnostics.harvester.HarvesterException;
import weblogic.diagnostics.harvester.I18NConstants;
import weblogic.diagnostics.harvester.InstanceNameNormalizer;
import weblogic.diagnostics.harvester.InvalidHarvesterInstanceNameException;
import weblogic.diagnostics.harvester.internal.BeanTreeHarvesterImpl;
import weblogic.diagnostics.harvester.internal.DebugSupport;
import weblogic.diagnostics.harvester.internal.HarvesterDefaultAttributeNormalizer;
import weblogic.diagnostics.harvester.internal.TreeBeanHarvestableDataProviderHelper;
import weblogic.management.jmx.modelmbean.WLSModelMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validators
implements I18NConstants {
    private static final DebugLogger DBG = DebugSupport.getDebugLogger();
    private static final DebugLogger DBG2 = DebugSupport.getLowLevelDebugLogger();
    private static final HarvesterDefaultAttributeNormalizer DEFAULT_NORMALIZER = new HarvesterDefaultAttributeNormalizer();

    public static void validateNamespace(String string) throws IllegalArgumentException {
        if (!string.equals("ServerRuntime") && !string.equals("DomainRuntime")) {
            throw new IllegalArgumentException(string);
        }
    }

    public static String getDefaultMetricNamespace() {
        return "ServerRuntime";
    }

    public static void validateHarvestedTypeBean(WLDFHarvestedTypeBean wLDFHarvestedTypeBean) throws IllegalArgumentException {
        String string = wLDFHarvestedTypeBean.getName();
        if (DBG.isDebugEnabled()) {
            DBG.debug("Doing bean-level velidation for configured type: " + string);
        }
        int n = Validators.isTypeHandled(string);
        if (wLDFHarvestedTypeBean.isKnownType() && n != 2) {
            throw new IllegalArgumentException((Throwable)((Object)new HarvesterException.TypeNotHarvestable(string)));
        }
    }

    public static void validateConfiguredType(String string) throws IllegalArgumentException {
        if (DBG.isDebugEnabled()) {
            DBG.debug("Validating configured type name: " + string);
        }
        if (Validators.isTypeHandled(string) == -1) {
            throw new IllegalArgumentException((Throwable)((Object)new HarvesterException.TypeNotHarvestable(string)));
        }
    }

    public static void validateConfiguredAttributes(String string, String[] stringArray) throws IllegalArgumentException {
        if (DBG.isDebugEnabled()) {
            DBG.debug("Validating configured attributes for type " + string + ":  " + Validators.stringArraytoString(stringArray));
        }
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BeanInfo beanInfo = TreeBeanHarvestableDataProviderHelper.getBeanInfo(string);
        if (beanInfo == null) {
            if (DBG.isDebugEnabled()) {
                DBG.debug("Unknown type, applying default normalizer");
            }
            for (String string2 : stringArray) {
                if (string2 == null || string2.length() <= 0) continue;
                try {
                    String string3 = DEFAULT_NORMALIZER.getNormalizedAttributeName(string2);
                    if (!DBG.isDebugEnabled()) continue;
                    DBG.debug("Normalizing " + string2 + ", result:  " + string3);
                }
                catch (Exception exception) {
                    arrayList.add(string2);
                }
            }
        } else {
            String string4;
            Object object;
            Object object2;
            Object object3;
            int n;
            if (DBG.isDebugEnabled()) {
                DBG.debug("Known type, looking up and applying any normalizers");
            }
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            HashSet<String> hashSet = new HashSet<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (n = 0; n < propertyDescriptorArray.length; ++n) {
                boolean bl;
                object3 = propertyDescriptorArray[n];
                object2 = (Boolean)((FeatureDescriptor)object3).getValue("unharvestable");
                boolean bl2 = object2 != null ? !((Boolean)object2).booleanValue() : (bl = true);
                if (!bl) continue;
                object = ((FeatureDescriptor)object3).getName();
                if (!Validators.typeIsComplex((PropertyDescriptor)object3)) {
                    hashSet.add((String)object);
                    continue;
                }
                string4 = (String)((FeatureDescriptor)object3).getValue("harvesterAttributeNormalizerClass");
                if (string4 == null) {
                    string4 = HarvesterDefaultAttributeNormalizer.class.getName();
                }
                hashMap.put((String)object, string4);
            }
            for (n = 0; n < stringArray.length; ++n) {
                object3 = stringArray[n];
                if (object3 == null || ((String)object3).length() == 0 || hashSet.contains(object3)) continue;
                object2 = DEFAULT_NORMALIZER.getAttributeName((String)object3);
                String string5 = (String)hashMap.get(object2);
                if (string5 == null) {
                    arrayList.add(object3);
                    continue;
                }
                try {
                    object = (AttributeNameNormalizer)Class.forName(string5).newInstance();
                    string4 = object.getNormalizedAttributeName((String)object3);
                    if (!DBG.isDebugEnabled()) continue;
                    DBG.debug("The normalized name is: " + (String)object3 + ":  " + string4);
                    continue;
                }
                catch (Exception exception) {
                    arrayList.add(object3);
                }
            }
        }
        if (arrayList.size() > 0) {
            if (DBG.isDebugEnabled()) {
                DBG.debug("The following attributes are invalid for type: " + string + ":  " + arrayList);
            }
            throw new HarvesterException.ValidationError(ATTRIBUTES_I18N, string, ((Object)arrayList).toString());
        }
        if (DBG2.isDebugEnabled()) {
            DBG2.debug("Attributes for type: " + string + " have been successfully validated.");
        }
    }

    private static boolean typeIsComplex(PropertyDescriptor propertyDescriptor) {
        Class<?> clazz = propertyDescriptor.getPropertyType();
        if (clazz.isPrimitive()) {
            return false;
        }
        if (clazz == String.class || clazz == Boolean.class || clazz == Character.class) {
            return false;
        }
        return !Number.class.isAssignableFrom(clazz);
    }

    public static void validateConfiguredInstances(String[] stringArray) throws IllegalArgumentException {
        if (DBG.isDebugEnabled()) {
            DBG.debug("Validating configured instances:  " + Validators.stringArraytoString(stringArray));
        }
        for (String string : stringArray) {
            InstanceNameNormalizer instanceNameNormalizer = new InstanceNameNormalizer(string);
            try {
                instanceNameNormalizer.translateHarvesterSpec();
            }
            catch (InvalidHarvesterInstanceNameException invalidHarvesterInstanceNameException) {
                throw new IllegalArgumentException(invalidHarvesterInstanceNameException);
            }
        }
        if (DBG2.isDebugEnabled()) {
            DBG2.debug("Instances have been successfully validated.");
        }
    }

    private static String stringArraytoString(String[] stringArray) {
        if (stringArray == null) {
            return "[]";
        }
        String string = "[";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (i != 0) {
                string = string + ",";
            }
            string = string + string2;
        }
        string = string + "]";
        return string;
    }

    private static int isTypeHandled(String string) {
        int n = 0;
        if (string == null || string.length() == 0) {
            throw new HarvesterException.NullName(TYPE_I18N);
        }
        BeanTreeHarvesterImpl beanTreeHarvesterImpl = BeanTreeHarvesterImpl.getInstance();
        n = beanTreeHarvesterImpl.isTypeHandled(string);
        if (n != 2) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                n = 1;
            }
            if (clazz != null) {
                boolean bl;
                boolean bl2 = WLSModelMBean.class.isAssignableFrom(clazz);
                n = bl2 ? 2 : ((bl = DynamicMBean.class.isAssignableFrom(clazz)) ? 1 : (Validators.isStandardMBean(clazz) || Validators.isMXBean(clazz) ? 1 : -1));
            }
        }
        if (DBG.isDebugEnabled()) {
            DBG.debug("Validator has has voted " + (n == 2 ? "yes" : (n == -1 ? "no" : "maybe")) + " for type " + string);
        }
        return n;
    }

    private static boolean isStandardMBean(Class<?> clazz) {
        String string = clazz.getName() + "MBean";
        try {
            clazz = Class.forName(string);
            if (clazz.isInterface()) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isMXBean(Class<?> clazz) {
        Class<?>[] classArray;
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (!clazz2.getCanonicalName().endsWith("MXBean")) continue;
            return true;
        }
        return false;
    }
}

