/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import com.bea.adaptive.harvester.HarvestCallback;
import com.bea.adaptive.harvester.Harvester;
import com.bea.adaptive.harvester.WatchedValues;
import com.bea.adaptive.harvester.WatchedValuesImpl;
import com.bea.adaptive.mbean.typing.MBeanCategorizer;
import com.bea.adaptive.mbean.typing.MBeanCategorizerPlugins;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.MBeanServer;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.harvester.HarvesterConstants;
import weblogic.diagnostics.harvester.HarvesterException;
import weblogic.diagnostics.harvester.HarvesterRuntimeException;
import weblogic.diagnostics.harvester.InvalidHarvesterNamespaceException;
import weblogic.diagnostics.harvester.LogSupport;
import weblogic.diagnostics.harvester.WLDFHarvester;
import weblogic.diagnostics.harvester.WLDFHarvesterUtils;
import weblogic.diagnostics.harvester.internal.BeanTreeHarvesterControlImpl;
import weblogic.diagnostics.harvester.internal.DebugSupport;
import weblogic.diagnostics.harvester.internal.DelegateHarvesterControl;
import weblogic.diagnostics.harvester.internal.DelegateHarvesterManager;
import weblogic.diagnostics.harvester.internal.DelegateHarvesterManagerImpl;
import weblogic.diagnostics.harvester.internal.JMXHarvesterConfig;
import weblogic.diagnostics.harvester.internal.JMXHarvesterControlImpl;
import weblogic.diagnostics.harvester.internal.MetricArchiver;
import weblogic.diagnostics.harvester.internal.ServerRuntimePlugin;
import weblogic.diagnostics.harvester.internal.WatchedValuesControl;
import weblogic.diagnostics.harvester.internal.WatchedValuesDelegateMap;
import weblogic.diagnostics.i18n.DiagnosticsHarvesterLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.i18n.DiagnosticsTextHarvesterTextFormatter;
import weblogic.diagnostics.utils.SecurityHelper;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WLDFHarvesterImpl
implements WLDFHarvester,
HarvesterConstants {
    public static final String WLDFHARVESTER_NAME = "WLDFHarvester";
    private final DebugLogger debugLogger = DebugSupport.getDebugLogger();
    private static final WLDFHarvesterImpl self = new WLDFHarvesterImpl("WLDFHarvester");
    private static final DebugLogger DBG = DebugLogger.getDebugLogger((String)"DebugDiagnosticsHarvester");
    private String name;
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private DelegateHarvesterManager harvesterManager = DelegateHarvesterManagerImpl.createDelegateHarvesterManager();
    private ConcurrentHashMap<Integer, WatchedValuesControl> wvidToDelegatesMap = new ConcurrentHashMap();
    private int nextWVID;
    private int defaultSamplePeriod = 300;
    private boolean attributeTrackingEnabled;
    private boolean adminServer;
    private boolean attributeValidationEnabled;

    public static WLDFHarvesterImpl getInstance() {
        SecurityHelper.checkForAdminRole();
        return self;
    }

    WLDFHarvesterImpl(String string) {
        this.name = string;
    }

    public int addWatchedValues(String string, WatchedValues watchedValues, HarvestCallback harvestCallback) throws IOException, JMException {
        SecurityHelper.checkForAdminRole();
        int n = -1;
        Collection<ValidationMap> collection = this.mapWatchedValues(watchedValues);
        if (collection == null) {
            return -1;
        }
        ArrayList<WatchedValuesDelegateMap> arrayList = null;
        Iterator<Harvester> iterator = this.harvesterManager.activeOnlyIterator();
        while (iterator.hasNext()) {
            Harvester harvester = iterator.next();
            ArrayList<Integer> arrayList2 = this.findVidsForHarvester(harvester, collection);
            if (arrayList2 == null) continue;
            if (n < 0) {
                n = this.computeNextWVID();
            }
            if (DBG.isDebugEnabled()) {
                DBG.debug("Found " + arrayList2.size() + " metrics claimed by harvester " + harvester.getName());
                DBG.debug("VIDS claimed: " + arrayList2.toString());
            }
            int n2 = harvester.addWatchedValues(string, watchedValues, harvestCallback);
            if (arrayList == null) {
                arrayList = new ArrayList<WatchedValuesDelegateMap>(this.harvesterManager.getConfiguredHarvestersCount());
            }
            WatchedValuesDelegateMap watchedValuesDelegateMap = new WatchedValuesDelegateMap(harvester, arrayList2, n2, watchedValues);
            arrayList.add(watchedValuesDelegateMap);
        }
        if (n > -1) {
            this.wvidToDelegatesMap.put(n, new WatchedValuesControl(watchedValues, harvestCallback, arrayList));
            watchedValues.setId(n);
        }
        if (collection.size() > 0) {
            WLDFHarvesterUtils.processValidationResults(watchedValues.getName(), this.extractValidations(collection));
        }
        if (this.debugLogger.isDebugEnabled()) {
            this.debugLogger.debug("addWatchedValues(): " + this.wvidToDelegatesMap.size() + " watched values are now active");
        }
        return n;
    }

    public Collection<WatchedValues.Validation> validateWatchedValues(WatchedValues watchedValues) {
        Collection<ValidationMap> collection = this.mapWatchedValues(watchedValues);
        ArrayList<WatchedValues.Validation> arrayList = new ArrayList<WatchedValues.Validation>(collection.size());
        Iterator<ValidationMap> iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().vote);
        }
        return arrayList;
    }

    public int deleteMetrics(int n, Collection<WatchedValues.Values> collection) {
        int n2 = 0;
        List<WatchedValuesDelegateMap> list = this.getMapListForParentWVID(n);
        for (WatchedValuesDelegateMap watchedValuesDelegateMap : list) {
            Collection<WatchedValues.Values> collection2 = watchedValuesDelegateMap.findMatchingValuesSlots(collection);
            n2 += watchedValuesDelegateMap.getDelegateHarvester().deleteMetrics(n, collection2);
        }
        return n2;
    }

    public int deleteWatchedValues(int[] nArray) {
        int n = 0;
        for (int n2 : nArray) {
            List<WatchedValuesDelegateMap> list = this.getMapListForParentWVID(n2);
            for (WatchedValuesDelegateMap watchedValuesDelegateMap : list) {
                if (watchedValuesDelegateMap.getDelegateHarvester().deleteWatchedValues(new int[]{watchedValuesDelegateMap.getDelegateWVID()}) <= 0) continue;
                ++n;
            }
            list.clear();
            this.wvidToDelegatesMap.remove(n2);
        }
        if (this.debugLogger.isDebugEnabled()) {
            this.debugLogger.debug("deleteWatchedValues(): " + this.wvidToDelegatesMap.size() + " watched values are now active");
        }
        return n;
    }

    public int disableMetrics(int n, Integer[] integerArray) {
        int n2 = 0;
        WatchedValuesControl watchedValuesControl = this.wvidToDelegatesMap.get(n);
        if (watchedValuesControl != null) {
            for (WatchedValuesDelegateMap watchedValuesDelegateMap : watchedValuesControl.getMapList()) {
                n2 += watchedValuesDelegateMap.disableMetrics(integerArray);
            }
        }
        return n2;
    }

    public int enableMetrics(int n, Integer[] integerArray) {
        int n2 = 0;
        WatchedValuesControl watchedValuesControl = this.wvidToDelegatesMap.get(n);
        if (watchedValuesControl != null) {
            for (WatchedValuesDelegateMap watchedValuesDelegateMap : watchedValuesControl.getMapList()) {
                n2 += watchedValuesDelegateMap.enableMetrics(integerArray);
            }
        }
        return n2;
    }

    public void extendWatchedValues(int n, WatchedValues watchedValues) {
        SecurityHelper.checkForAdminRole();
        WatchedValuesControl watchedValuesControl = this.wvidToDelegatesMap.get(n);
        if (watchedValuesControl == null) {
            throw new HarvesterRuntimeException(DiagnosticsTextHarvesterTextFormatter.getInstance().getWatchedValuesIdNotFoundText(n));
        }
        Collection<ValidationMap> collection = this.mapWatchedValues(watchedValues);
        if (collection != null) {
            Iterator<Harvester> iterator = this.harvesterManager.activeOnlyIterator();
            while (iterator.hasNext()) {
                Harvester harvester = iterator.next();
                ArrayList<Integer> arrayList = this.findVidsForHarvester(harvester, collection);
                if (arrayList == null) continue;
                WatchedValuesDelegateMap watchedValuesDelegateMap = watchedValuesControl.findDelegateMap(harvester);
                if (watchedValuesDelegateMap != null) {
                    watchedValuesDelegateMap.extendWatchedValues(watchedValues, arrayList);
                    continue;
                }
                ArrayList<Integer> arrayList2 = watchedValuesControl.extendDelegateMap(harvester, watchedValues, arrayList);
                if (!DBG.isDebugEnabled()) continue;
                DBG.debug("extendWatchedValues: Found " + arrayList2.size() + " metrics claimed by harvester " + harvester.getName());
                DBG.debug("extendWatchedValues: VIDS claimed: " + arrayList2.toString());
            }
        }
    }

    public String[][] getHarvestableAttributes(String string, String string2) throws IOException {
        String[][] stringArray;
        block3: {
            ArrayList<String[][]> arrayList = new ArrayList<String[][]>();
            Iterator<Harvester> iterator = this.harvesterManager.activatingIterator();
            while (iterator.hasNext()) {
                stringArray = iterator.next();
                int n = stringArray.isTypeHandled(string);
                if (n == 2) {
                    return stringArray.getHarvestableAttributes(string, string2);
                }
                if (n != 1) continue;
                arrayList.add(stringArray);
            }
            stringArray = null;
            if (arrayList.size() <= 0) break block3;
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext() && (stringArray = ((Harvester)iterator2.next()).getHarvestableAttributes(string, string2)) == null) {
            }
        }
        return stringArray;
    }

    public List<String> getHarvestedAttributes(int n, String string, String string2) {
        List list = null;
        WatchedValuesControl watchedValuesControl = this.wvidToDelegatesMap.get(n);
        if (watchedValuesControl != null) {
            List<WatchedValuesDelegateMap> list2 = watchedValuesControl.getMapList();
            for (WatchedValuesDelegateMap watchedValuesDelegateMap : list2) {
                List list3 = watchedValuesDelegateMap.getDelegateHarvester().getHarvestedAttributes(watchedValuesDelegateMap.getDelegateWVID(), string, string2);
                if (list3 == null || list3.size() <= 0) continue;
                list = list3;
                break;
            }
        }
        return list;
    }

    public List<String> getHarvestedInstances(int n, String string, String string2) {
        List list = null;
        WatchedValuesControl watchedValuesControl = this.wvidToDelegatesMap.get(n);
        if (watchedValuesControl != null) {
            List<WatchedValuesDelegateMap> list2 = watchedValuesControl.getMapList();
            for (WatchedValuesDelegateMap watchedValuesDelegateMap : list2) {
                List list3 = watchedValuesDelegateMap.getDelegateHarvester().getHarvestedInstances(watchedValuesDelegateMap.getDelegateWVID(), string, string2);
                if (list3 == null || list3.size() <= 0) continue;
                list = list3;
                break;
            }
        }
        return list;
    }

    public List<String> getHarvestedTypes(int n, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        WatchedValuesControl watchedValuesControl = this.wvidToDelegatesMap.get(n);
        if (watchedValuesControl != null) {
            for (WatchedValuesDelegateMap watchedValuesDelegateMap : watchedValuesControl.getMapList()) {
                List<String> list = watchedValuesDelegateMap.getHarvestedTypes(string);
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public List<String> getKnownHarvestableInstances(String string, String string2) throws IOException {
        return this.getKnownHarvestableInstances(null, string, string2);
    }

    @Override
    public List<String> getKnownHarvestableInstances(String string, String string2, String string3) throws IOException {
        Object object;
        block2: {
            Object object2;
            Pattern pattern = string == null ? null : Pattern.compile(string);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            object = this.harvesterManager.activatingIterator();
            while (object.hasNext()) {
                object2 = object.next();
                boolean bl = pattern == null || pattern.matcher(object2.getNamespace()).matches();
                if (!bl) continue;
                int n = object2.isTypeHandled(string2);
                if (n == 2) {
                    return object2.getKnownHarvestableInstances(string2, string3);
                }
                if (n != 1) continue;
                arrayList.add(object2);
            }
            object = null;
            object2 = arrayList.iterator();
            if (!object2.hasNext()) break block2;
            Harvester harvester = (Harvester)object2.next();
            object = harvester.getKnownHarvestableInstances(string2, string3);
        }
        return object;
    }

    public String[][] getKnownHarvestableTypes(String string) throws IOException {
        return this.getKnownHarvestableTypes(null, string);
    }

    @Override
    public String[][] getKnownHarvestableTypes(String string, String string2) throws IOException {
        String[][] stringArray = null;
        Map<String, String[]> map = this.getKnownTypesMap(string, string2);
        if (map.size() > 0) {
            stringArray = new String[map.size()][2];
            int n = 0;
            Iterator<String[]> iterator = map.values().iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = iterator.next();
            }
        }
        return stringArray;
    }

    public String getName() {
        return this.name;
    }

    public WatchedValues.Values[] getPendingMetrics(int n) {
        ArrayList<WatchedValues.Values> arrayList = new ArrayList<WatchedValues.Values>();
        WatchedValuesControl watchedValuesControl = this.wvidToDelegatesMap.get(n);
        if (watchedValuesControl != null) {
            for (WatchedValuesDelegateMap watchedValuesDelegateMap : watchedValuesControl.getMapList()) {
                List<WatchedValues.Values> list = watchedValuesDelegateMap.getPendingMetrics();
                arrayList.addAll(list);
            }
        }
        return arrayList.toArray(new WatchedValues.Values[0]);
    }

    public List<String> getUnharvestableAttributes(int n, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        WatchedValuesControl watchedValuesControl = this.wvidToDelegatesMap.get(n);
        if (watchedValuesControl != null) {
            for (WatchedValuesDelegateMap watchedValuesDelegateMap : watchedValuesControl.getMapList()) {
                List<String> list = watchedValuesDelegateMap.getUnharvestableAttributes(string, string2);
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public List<String> getDisabledAttributes(int n, String string, String string2) {
        HashSet<String> hashSet = new HashSet<String>();
        WatchedValuesControl watchedValuesControl = this.wvidToDelegatesMap.get(n);
        if (watchedValuesControl != null) {
            for (WatchedValuesDelegateMap watchedValuesDelegateMap : watchedValuesControl.getMapList()) {
                List<String> list = watchedValuesDelegateMap.getDisabledAttributes(string, string2);
                hashSet.addAll(list);
            }
        }
        ArrayList arrayList = new ArrayList(hashSet);
        return arrayList;
    }

    public void harvest(Map<Integer, Set<Integer>> map) {
        if (map == null) {
            for (WatchedValuesControl watchedValuesControl : this.wvidToDelegatesMap.values()) {
                watchedValuesControl.getWatchedValues().setTimeStamp(MetricArchiver.getNanoWallClockTime());
                List<WatchedValuesDelegateMap> list = watchedValuesControl.getMapList();
                for (WatchedValuesDelegateMap watchedValuesDelegateMap : list) {
                    watchedValuesDelegateMap.harvest(null);
                }
            }
        } else {
            for (Integer n : map.keySet()) {
                WatchedValuesControl watchedValuesControl = this.wvidToDelegatesMap.get(n);
                if (watchedValuesControl == null) continue;
                watchedValuesControl.getWatchedValues().setTimeStamp(MetricArchiver.getNanoWallClockTime());
                Set<Integer> set = map.get(n);
                List<WatchedValuesDelegateMap> list = watchedValuesControl.getMapList();
                for (WatchedValuesDelegateMap watchedValuesDelegateMap : list) {
                    watchedValuesDelegateMap.harvest(set);
                }
            }
        }
    }

    public int isTypeHandled(String string) {
        int n = 0;
        ArrayList<Harvester> arrayList = new ArrayList<Harvester>();
        Harvester harvester = null;
        Iterator<Harvester> iterator = this.harvesterManager.activatingIterator();
        block7: while (iterator.hasNext()) {
            Harvester harvester2 = iterator.next();
            try {
                int n2 = harvester2.isTypeHandled(string);
                switch (n2) {
                    case 2: {
                        n = n2;
                        if (harvester == null) {
                            arrayList = new ArrayList(1);
                            arrayList.add(harvester2);
                            harvester = harvester2;
                            break;
                        }
                        throw new HarvesterException.AmbiguousTypeName(string, harvester2.getName(), harvester.getName());
                    }
                    case 1: {
                        if (harvester != null) continue block7;
                        n = n2;
                        arrayList.add(harvester2);
                        break;
                    }
                    case -1: {
                        if (n != 0) continue block7;
                        n = n2;
                        break;
                    }
                    default: {
                        String string2 = harvester2.getName();
                        LogSupport.logUnexpectedProblem("Provider " + string2 + " returned an invalid value from method isTypeHandled (" + n2 + "). Value must be " + 2 + "(yes), " + -1 + "(no), or " + 1 + "(maybe). " + string2 + " is not eligible to handle type " + string + ".");
                        break;
                    }
                }
            }
            catch (Exception exception) {
                LogSupport.logUnexpectedException("Exception thrown in call to harvester plugIn " + harvester2.getName() + " for type " + string + ". This type will be removed from consideration by the plug-in", exception);
            }
        }
        return n;
    }

    public void deallocate() {
        this.deactivate();
    }

    public void prepare() {
        if (DBG.isDebugEnabled()) {
            DBG.debug("In WLDFHarvesterImpl.prepare");
        }
    }

    public void activate() {
        if (DBG.isDebugEnabled()) {
            DBG.debug("In WLDFHarvesterImpl.activate()");
        }
        try {
            this.initializeHarvesters();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void deactivate() {
        if (DBG.isDebugEnabled()) {
            DBG.debug("In WLDFHarvesterImpl.deactivate()");
        }
        this.harvesterManager.removeAll();
    }

    public void unprepare() {
        if (DBG.isDebugEnabled()) {
            DBG.debug("In WLDFHarvester.unprepare()");
        }
    }

    public WatchedValues createWatchedValues(String string) {
        WatchedValuesImpl watchedValuesImpl = new WatchedValuesImpl(string, this.defaultSamplePeriod);
        watchedValuesImpl.setShared(true);
        watchedValuesImpl.setId(-1);
        return watchedValuesImpl;
    }

    public void deleteWatchedValues(WatchedValues watchedValues) {
        if (watchedValues.getId() > -1) {
            int[] nArray = new int[]{watchedValues.getId()};
            this.deleteWatchedValues(nArray);
        }
    }

    public boolean isAttributeNameTrackingEnabled() {
        return this.attributeTrackingEnabled;
    }

    public void setAttributeNameTrackingEnabled(boolean bl) {
        this.attributeTrackingEnabled = bl;
        Iterator<DelegateHarvesterControl> iterator = this.harvesterManager.iterator();
        while (iterator.hasNext()) {
            iterator.next().setAttributeNameTrackingEnabled(this.attributeTrackingEnabled);
        }
    }

    public boolean isAttributeValidationEnabled() {
        return this.attributeValidationEnabled;
    }

    public void setAttributeValidationEnabled(boolean bl) {
        this.attributeValidationEnabled = bl;
        Iterator<DelegateHarvesterControl> iterator = this.harvesterManager.iterator();
        while (iterator.hasNext()) {
            iterator.next().setAttributeValidationEnabled(this.attributeTrackingEnabled);
        }
    }

    public String getTypeForInstance(String string) {
        String string2 = null;
        Iterator<Harvester> iterator = this.harvesterManager.activatingIterator();
        while (iterator.hasNext() && (string2 = iterator.next().getTypeForInstance(string)) == null) {
        }
        return string2;
    }

    @Override
    public void validateNamespace(String string) throws InvalidHarvesterNamespaceException {
        boolean bl = false;
        if (string != null) {
            for (String string2 : this.getSupportedNamespaces()) {
                if (!string2.equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new InvalidHarvesterNamespaceException(DiagnosticsTextHarvesterTextFormatter.getInstance().getInvalidHarvesterNamespaceText(string));
            }
            if (string.equals("DomainRuntime") && !this.adminServer) {
                throw new InvalidHarvesterNamespaceException(DiagnosticsTextHarvesterTextFormatter.getInstance().getDomainRuntimeNamespaceWarningText(string));
            }
        }
    }

    @Override
    public String[] getSupportedNamespaces() {
        HashSet<String> hashSet = new HashSet<String>(this.harvesterManager.getConfiguredHarvestersCount());
        Iterator<DelegateHarvesterControl> iterator = this.harvesterManager.iterator();
        while (iterator.hasNext()) {
            DelegateHarvesterControl delegateHarvesterControl = iterator.next();
            hashSet.add(delegateHarvesterControl.getNamespace());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public String getNamespace() {
        return "weblogic";
    }

    @Override
    public String getDefaultNamespace() {
        String string = "ServerRuntime";
        Iterator<DelegateHarvesterControl> iterator = this.harvesterManager.iterator();
        while (iterator.hasNext()) {
            DelegateHarvesterControl delegateHarvesterControl = iterator.next();
            if (!delegateHarvesterControl.isDefaultDelegate()) continue;
            string = delegateHarvesterControl.getNamespace();
        }
        return string;
    }

    public void resolveAllMetrics(int[] nArray) {
        for (int n : nArray) {
            this.resolveMetrics(n, null);
        }
    }

    public void resolveMetrics(int n, Set<Integer> set) {
        WatchedValuesControl watchedValuesControl = this.wvidToDelegatesMap.get(n);
        if (watchedValuesControl == null) {
            throw new HarvesterRuntimeException(DiagnosticsTextHarvesterTextFormatter.getInstance().getWatchedValuesIdNotFoundText(n));
        }
        watchedValuesControl.resolveMetrics(set);
    }

    public boolean removeAttributesWithProblems() {
        return true;
    }

    public void setRemoveAttributesWithProblems(boolean bl) {
    }

    private void initializeHarvesters() throws IOException, JMException {
        this.harvesterManager.addDelegateHarvester(new BeanTreeHarvesterControlImpl("BeanTreeHarvester", "ServerRuntime", DelegateHarvesterControl.ActivationPolicy.ON_METADATA_REQUEST, true));
        MBeanCategorizer.Impl impl = new MBeanCategorizer.Impl(new MBeanCategorizer.Plugin[]{new MBeanCategorizerPlugins.NonWLSPlugin(), new ServerRuntimePlugin()});
        MBeanServer mBeanServer = ManagementService.getRuntimeMBeanServer(KERNEL_ID);
        if (mBeanServer != null) {
            this.addHarvesterForMBeanServer(impl, "ServerRuntimeHarvester", "ServerRuntime", mBeanServer, DelegateHarvesterControl.ActivationPolicy.ON_METADATA_REQUEST);
        } else {
            DiagnosticsHarvesterLogger.logServerRuntimeMBeanServerNotAvailable();
        }
        MBeanServer mBeanServer2 = null;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID);
        this.adminServer = runtimeAccess.isAdminServer();
        if (this.adminServer) {
            mBeanServer2 = ManagementService.getDomainRuntimeMBeanServer(KERNEL_ID);
            if (mBeanServer2 == null) {
                DiagnosticsLogger.logDomainRuntimeHarvesterUnavailable();
            } else {
                MBeanCategorizer.Impl impl2 = new MBeanCategorizer.Impl(new MBeanCategorizer.Plugin[]{new ServerRuntimePlugin(), new MBeanCategorizerPlugins.NonWLSPlugin()});
                this.addHarvesterForMBeanServer(impl2, "DomainRuntimeHarvester", "DomainRuntime", mBeanServer2, DelegateHarvesterControl.ActivationPolicy.ON_METADATA_REQUEST);
            }
        }
    }

    private int computeNextWVID() {
        return this.nextWVID++;
    }

    private ArrayList<Integer> findVidsForHarvester(Harvester harvester, Collection<ValidationMap> collection) {
        ArrayList<Integer> arrayList = null;
        for (ValidationMap validationMap : collection) {
            if (validationMap.harvester != harvester) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
            }
            arrayList.add(validationMap.vote.getMetric().getVID());
        }
        return arrayList;
    }

    private Map<String, String[]> getKnownTypesMap(String string, String string2) throws IOException {
        Pattern pattern = string == null ? null : Pattern.compile(string);
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        Iterator<Harvester> iterator = this.harvesterManager.activatingIterator(DelegateHarvesterControl.ActivationPolicy.ON_METADATA_REQUEST);
        while (iterator.hasNext()) {
            Harvester harvester = iterator.next();
            if (pattern != null && !pattern.matcher(harvester.getNamespace()).matches()) continue;
            String[][] stringArray = harvester.getKnownHarvestableTypes(string2);
            for (int i = 0; i < stringArray.length; ++i) {
                hashMap.put(stringArray[i][0], stringArray[i]);
            }
        }
        return hashMap;
    }

    private Collection<WatchedValues.Validation> extractValidations(Collection<ValidationMap> collection) {
        ArrayList<WatchedValues.Validation> arrayList = null;
        if (collection != null) {
            arrayList = new ArrayList<WatchedValues.Validation>(collection.size());
            for (ValidationMap validationMap : collection) {
                arrayList.add(validationMap.vote);
            }
        }
        return arrayList;
    }

    private List<WatchedValuesDelegateMap> getMapListForParentWVID(int n) throws RuntimeException {
        WatchedValuesControl watchedValuesControl = this.wvidToDelegatesMap.get(n);
        if (watchedValuesControl == null) {
            throw new RuntimeException("Unable to map watched values identifier: " + n);
        }
        return watchedValuesControl.getMapList();
    }

    private void addHarvesterForMBeanServer(MBeanCategorizer.Impl impl, String string, String string2, MBeanServer mBeanServer, DelegateHarvesterControl.ActivationPolicy activationPolicy) throws IOException, JMException {
        this.harvesterManager.addDelegateHarvester(new JMXHarvesterControlImpl(new JMXHarvesterConfig(string, string2, (MBeanCategorizer)impl, true, mBeanServer), activationPolicy));
    }

    private Collection<ValidationMap> mapWatchedValues(WatchedValues watchedValues) {
        int n = 0;
        Iterator iterator = watchedValues.getAllMetricValues().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++n;
        }
        HashMap<Integer, ValidationMap> hashMap = new HashMap<Integer, ValidationMap>(n);
        if (n > 0) {
            int n2 = n;
            Iterator<Harvester> iterator2 = this.harvesterManager.activatingIterator(DelegateHarvesterControl.ActivationPolicy.EXPLICIT);
            while (iterator2.hasNext() && n2 > 0) {
                Harvester harvester = iterator2.next();
                Collection collection = harvester.validateWatchedValues(watchedValues);
                if (collection == null) continue;
                if (collection.size() != n) {
                    throw new RuntimeException("Child validation result length did number of metrics in WatchedValues!");
                }
                if (hashMap.size() == 0) {
                    hashMap = new HashMap(collection.size());
                    for (WatchedValues.Validation validation : collection) {
                        if (validation.getStatus() == 2) {
                            --n2;
                        }
                        hashMap.put(validation.getMetric().getVID(), new ValidationMap(harvester, validation));
                    }
                    continue;
                }
                for (WatchedValues.Validation validation : collection) {
                    int n3 = validation.getMetric().getVID();
                    ValidationMap validationMap = (ValidationMap)hashMap.get(n3);
                    WatchedValues.Validation validation2 = validationMap.vote;
                    if (validation.getStatus() <= validation2.getStatus()) continue;
                    if (validation.getStatus() == 2) {
                        --n2;
                    }
                    if (DBG.isDebugEnabled()) {
                        DBG.debug("Harvester " + harvester.getName() + " has outbid harvester " + validationMap.harvester.getName() + " for metric " + validationMap.vote.getMetric().toString());
                    }
                    hashMap.put(n3, new ValidationMap(harvester, validation));
                }
            }
        } else if (DBG.isDebugEnabled()) {
            DBG.debug("mapWatchedValues(): No values in watched values list");
        }
        return hashMap.values();
    }

    public void oneShotHarvest(WatchedValues watchedValues) {
        Iterator<Harvester> iterator = this.harvesterManager.activeOnlyIterator();
        while (iterator.hasNext()) {
            iterator.next().oneShotHarvest(watchedValues);
        }
    }

    private static class ValidationMap {
        WatchedValues.Validation vote;
        Harvester harvester;

        public ValidationMap(Harvester harvester, WatchedValues.Validation validation) {
            this.harvester = harvester;
            this.vote = validation;
        }
    }
}

