/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import com.bea.adaptive.harvester.HarvestCallback;
import com.bea.adaptive.harvester.Harvester;
import com.bea.adaptive.harvester.WatchedValues;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import weblogic.diagnostics.harvester.HarvesterRuntimeException;
import weblogic.diagnostics.harvester.internal.WatchedValuesDelegateMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchedValuesControl {
    private WatchedValues watchedValues;
    private List<WatchedValuesDelegateMap> mapList;
    private HarvestCallback harvestCallback;

    public WatchedValuesControl(WatchedValues watchedValues, HarvestCallback harvestCallback, List<WatchedValuesDelegateMap> list) {
        this.setMapList(list);
        this.setWatchedValues(watchedValues);
        this.harvestCallback = harvestCallback;
    }

    public HarvestCallback getHarvestCallback() {
        return this.harvestCallback;
    }

    public ArrayList<Integer> extendDelegateMap(Harvester harvester, WatchedValues watchedValues, ArrayList<Integer> arrayList) {
        List list = this.getWatchedValues().extendValues(watchedValues, arrayList);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(list.size());
        for (Object object : list) {
            arrayList2.add(object.getVID());
        }
        try {
            Object object;
            int n = harvester.addWatchedValues(this.getWatchedValues().getName(), this.getWatchedValues(), this.harvestCallback);
            object = new WatchedValuesDelegateMap(harvester, arrayList2, n, this.getWatchedValues());
            this.getMapList().add((WatchedValuesDelegateMap)object);
        }
        catch (Exception exception) {
            throw new HarvesterRuntimeException(exception);
        }
        return arrayList2;
    }

    public WatchedValuesDelegateMap findDelegateMap(Harvester harvester) {
        WatchedValuesDelegateMap watchedValuesDelegateMap = null;
        for (WatchedValuesDelegateMap watchedValuesDelegateMap2 : this.getMapList()) {
            if (watchedValuesDelegateMap2.getDelegateHarvester() != harvester) continue;
            watchedValuesDelegateMap = watchedValuesDelegateMap2;
            break;
        }
        return watchedValuesDelegateMap;
    }

    public void resolveMetrics(Set<Integer> set) {
        for (WatchedValuesDelegateMap watchedValuesDelegateMap : this.getMapList()) {
            watchedValuesDelegateMap.resolveMetrics(set);
        }
    }

    public void setWatchedValues(WatchedValues watchedValues) {
        this.watchedValues = watchedValues;
    }

    public WatchedValues getWatchedValues() {
        return this.watchedValues;
    }

    public void setMapList(List<WatchedValuesDelegateMap> list) {
        this.mapList = list;
    }

    public List<WatchedValuesDelegateMap> getMapList() {
        return this.mapList;
    }
}

