/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.harvester.internal;

import com.bea.adaptive.harvester.Harvester;
import com.bea.adaptive.harvester.WatchedValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.diagnostics.debug.DebugLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WatchedValuesDelegateMap {
    private WatchedValues parentList;
    private int delegateWVID;
    private HashSet<Integer> vids;
    private Harvester delegateHarvester;
    private HashMap<Integer, WatchedValues.Values> vidsToValuesMap;
    private HashMap<Integer, Set<Integer>> allSlotsMap;
    private static DebugLogger dbg = DebugLogger.getDebugLogger((String)"DebugDiagnosticsHarvester");

    public WatchedValuesDelegateMap(Harvester harvester, ArrayList<Integer> arrayList, int n, WatchedValues watchedValues) {
        this.delegateHarvester = harvester;
        this.vids = new HashSet<Integer>(arrayList);
        this.delegateWVID = n;
        this.parentList = watchedValues;
    }

    public WatchedValues.Values getValue(int n) {
        return this.parentList.getMetric(n);
    }

    public Collection<WatchedValues.Values> findMatchingValuesSlots(Collection<WatchedValues.Values> collection) {
        ArrayList<WatchedValues.Values> arrayList = new ArrayList<WatchedValues.Values>(this.vids.size());
        for (WatchedValues.Values values : collection) {
            WatchedValues.Values values2 = this.getVidsToValuesMap().get(values.getVID());
            if (values2 == null) continue;
            arrayList.add(values2);
        }
        return arrayList;
    }

    public Harvester getDelegateHarvester() {
        return this.delegateHarvester;
    }

    public void setDelegateHarvester(Harvester harvester) {
        this.delegateHarvester = harvester;
    }

    public int getDelegateWVID() {
        return this.delegateWVID;
    }

    public void setDelegateWVID(int n) {
        this.delegateWVID = n;
    }

    public Set<Integer> getVids() {
        return this.vids;
    }

    public void setVids(Set<Integer> set) {
        this.vids = new HashSet<Integer>(set);
    }

    public WatchedValues getParentList() {
        return this.parentList;
    }

    public void setParentList(WatchedValues watchedValues) {
        this.parentList = watchedValues;
    }

    public void harvest(Collection<Integer> collection) {
        if (collection == null) {
            if (dbg.isDebugEnabled()) {
                dbg.debug("Harvesting all slots for Harvester " + this.delegateHarvester.getName());
            }
            this.delegateHarvester.harvest(this.getAllSlotsMap());
        } else {
            Map<Integer, Set<Integer>> map = this.getSlotsSubSet(collection);
            if (dbg.isDebugEnabled()) {
                dbg.debug("Harvesting slots {" + map + "} of " + this.parentList.getName() + " for Harvester " + this.delegateHarvester.getName());
            }
            this.delegateHarvester.harvest(map);
        }
    }

    public Map<Integer, Set<Integer>> getSlotsSubSet(Collection<Integer> collection) {
        HashSet<Integer> hashSet = new HashSet<Integer>(collection.size());
        for (Integer n : collection) {
            if (!this.vids.contains(n)) continue;
            hashSet.add(n);
        }
        HashMap hashMap = new HashMap();
        hashMap.put(this.delegateWVID, hashSet);
        return hashMap;
    }

    public List<WatchedValues.Values> getPendingMetrics() {
        WatchedValues.Values[] valuesArray = this.delegateHarvester.getPendingMetrics(this.delegateWVID);
        ArrayList<WatchedValues.Values> arrayList = new ArrayList<WatchedValues.Values>(valuesArray.length);
        for (WatchedValues.Values values : valuesArray) {
            if (!this.vids.contains(values.getVID())) continue;
            arrayList.add(values);
        }
        return arrayList;
    }

    public List<String> getUnharvestableAttributes(String string, String string2) {
        return this.delegateHarvester.getUnharvestableAttributes(this.delegateWVID, string, string2);
    }

    public List<String> getDisabledAttributes(String string, String string2) {
        return this.delegateHarvester.getDisabledAttributes(this.delegateWVID, string, string2);
    }

    public List<String> getHarvestedTypes(String string) {
        return this.delegateHarvester.getHarvestedTypes(this.delegateWVID, string);
    }

    public int disableMetrics(Integer[] integerArray) {
        int n = 0;
        Set<Integer> set = this.findVidIntersection(integerArray);
        if (set.size() > 0) {
            n += this.delegateHarvester.disableMetrics(this.delegateWVID, set.toArray(new Integer[set.size()]));
        }
        return n;
    }

    public int enableMetrics(Integer[] integerArray) {
        int n = 0;
        Set<Integer> set = this.findVidIntersection(integerArray);
        if (set.size() > 0) {
            n += this.delegateHarvester.enableMetrics(this.delegateWVID, set.toArray(new Integer[set.size()]));
        }
        return n;
    }

    private Set<Integer> findVidIntersection(Integer[] integerArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>(integerArray.length);
        for (Integer n : integerArray) {
            if (!this.vids.contains(n)) continue;
            hashSet.add(n);
        }
        return hashSet;
    }

    private HashMap<Integer, WatchedValues.Values> getVidsToValuesMap() {
        if (this.vidsToValuesMap == null) {
            this.vidsToValuesMap = this.constructVidsToValuesMap();
        }
        return this.vidsToValuesMap;
    }

    private HashMap<Integer, WatchedValues.Values> constructVidsToValuesMap() {
        HashMap<Integer, WatchedValues.Values> hashMap = new HashMap<Integer, WatchedValues.Values>(this.vids.size());
        for (Integer n : this.vids) {
            hashMap.put(n, this.parentList.getMetric(n.intValue()));
        }
        return hashMap;
    }

    private synchronized HashMap<Integer, Set<Integer>> getAllSlotsMap() {
        if (this.allSlotsMap == null) {
            this.allSlotsMap = new HashMap();
        }
        this.allSlotsMap.put(this.delegateWVID, this.vids);
        return this.allSlotsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extendWatchedValues(WatchedValues watchedValues, ArrayList<Integer> arrayList) {
        List list = this.parentList.extendValues(watchedValues, arrayList);
        HashSet<Integer> hashSet = new HashSet<Integer>(list.size());
        for (WatchedValues.Values values : list) {
            hashSet.add(values.getVID());
        }
        this.delegateHarvester.resolveMetrics(this.delegateWVID, hashSet);
        WatchedValuesDelegateMap watchedValuesDelegateMap = this;
        synchronized (watchedValuesDelegateMap) {
            this.vids.addAll(hashSet);
            this.allSlotsMap = null;
        }
    }

    public void resolveMetrics(Set<Integer> set) {
        Set<Integer> set2 = null;
        set2 = set != null ? this.findVidIntersection(set.toArray(new Integer[0])) : this.vids;
        this.delegateHarvester.resolveMetrics(this.delegateWVID, set2);
    }
}

