/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.image;

import com.oracle.jrockit.jfr.client.EventSettingsBuilder;
import com.oracle.jrockit.jfr.client.FlightRecorderClient;
import com.oracle.jrockit.jfr.client.FlightRecordingClient;
import com.oracle.jrockit.jfr.management.FlightRecorderMBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.List;
import weblogic.diagnostics.context.DiagnosticContextManager;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.flightrecorder.FlightRecorderManager;
import weblogic.diagnostics.flightrecorder.event.GlobalInformationEventInfo;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.management.configuration.WLDFServerDiagnosticMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.io.StreamUtils;

public class FlightRecorderSource
implements ImageSource {
    private static final boolean DisableJVMEvents = Boolean.getBoolean("weblogic.diagnostics.image.DisableJVMEvents");
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticImage");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static WLDFServerDiagnosticMBean wldfConfig;
    private boolean timeoutRequested;
    private long count = 0L;
    private FlightRecorderClient flightRecorderClient;
    private FlightRecordingClient flightRecordingClient;
    private ImageManager imageManager;
    private File destinationTempFile = null;
    private GlobalInformation globalInfo = new GlobalInformation();
    private String recordingName = null;

    public FlightRecorderSource(ImageManager imageManager) {
        this.imageManager = imageManager;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        boolean bl = debugLogger.isDebugEnabled();
        this.timeoutRequested = false;
        if (bl) {
            debugLogger.debug("FlightRecorderSource.createDiagnosticImage()");
        }
        if (this.flightRecordingClient == null) {
            if (!bl) return;
            debugLogger.debug("FlightRecorderSource.createDiagnosticImage() no recording is active");
            return;
        }
        File file = null;
        FlightRecordingClient flightRecordingClient = null;
        try {
            block32: {
                try {
                    this.triggerGlobalInformationEvent();
                    DiagnosticContextManager.getDiagnosticContextManager().triggerThrottleInformationEvent();
                    file = File.createTempFile("__tmp", ".jfr", new File(this.imageManager.getDestinationDirectory()));
                    try {
                        flightRecordingClient = this.flightRecordingClient.cloneRecordingObject(this.recordingName + "_" + this.count++, true);
                    }
                    catch (Throwable throwable) {
                        block30: {
                            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
                            if (runtimeAccess != null) {
                                FileInputStream fileInputStream;
                                block28: {
                                    block29: {
                                        ServerRuntimeMBean serverRuntimeMBean = runtimeAccess.getServerRuntime();
                                        fileInputStream = null;
                                        if (serverRuntimeMBean == null || !serverRuntimeMBean.isShuttingDown() || this.destinationTempFile == null || !this.destinationTempFile.exists() || !this.destinationTempFile.canRead()) break block28;
                                        if (bl) {
                                            debugLogger.debug("Server is shutting down, trying to capture from temporary recording file");
                                        }
                                        fileInputStream = new FileInputStream(this.destinationTempFile);
                                        StreamUtils.writeTo((InputStream)fileInputStream, (OutputStream)outputStream);
                                        outputStream.flush();
                                        Object var11_12 = null;
                                        if (fileInputStream == null) break block29;
                                        fileInputStream.close();
                                    }
                                    Object var15_16 = null;
                                    if (file != null) {
                                        file.delete();
                                    }
                                    if (flightRecordingClient == null) return;
                                    flightRecordingClient.close();
                                    return;
                                }
                                try {
                                    Object var11_13 = null;
                                    if (fileInputStream != null) {
                                        fileInputStream.close();
                                    }
                                    break block30;
                                    catch (IOException iOException) {
                                        DiagnosticsLogger.logErrorCapturingFlightRecorderImage((Throwable)iOException);
                                        Object var11_14 = null;
                                        if (fileInputStream != null) {
                                            fileInputStream.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable2) {
                                    Object var11_15 = null;
                                    if (fileInputStream == null) throw throwable2;
                                    fileInputStream.close();
                                    throw throwable2;
                                }
                            }
                        }
                        DiagnosticsLogger.logErrorCapturingFlightRecorderImage((Throwable)throwable);
                    }
                    if (flightRecordingClient != null) {
                        flightRecordingClient.copyTo(file.getAbsolutePath());
                        if (bl) {
                            debugLogger.debug("FlightRecorderSource exists= " + file.exists());
                        }
                        FileInputStream fileInputStream = new FileInputStream(file);
                        try {
                            try {
                                if (bl) {
                                    debugLogger.debug("FlightRecorderSource writing from temp file " + file + " to stream");
                                }
                                StreamUtils.writeTo((InputStream)fileInputStream, (OutputStream)outputStream);
                                outputStream.flush();
                            }
                            catch (IOException iOException) {
                                DiagnosticsLogger.logErrorCapturingFlightRecorderImage((Throwable)iOException);
                                Object var13_23 = null;
                                if (fileInputStream != null) {
                                    fileInputStream.close();
                                }
                            }
                            Object var13_22 = null;
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var13_24 = null;
                            if (fileInputStream == null) throw throwable;
                            fileInputStream.close();
                            throw throwable;
                        }
                    }
                    Object var15_17 = null;
                    if (file == null) break block32;
                    file.delete();
                }
                catch (IOException iOException) {
                    DiagnosticsLogger.logErrorCapturingFlightRecorderImage((Throwable)iOException);
                    Object var15_18 = null;
                    if (file != null) {
                        file.delete();
                    }
                    if (flightRecordingClient == null) return;
                    flightRecordingClient.close();
                    return;
                }
            }
            if (flightRecordingClient == null) return;
            flightRecordingClient.close();
            return;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            if (file != null) {
                file.delete();
            }
            if (flightRecordingClient == null) throw throwable;
            flightRecordingClient.close();
            throw throwable;
        }
    }

    public void timeoutImageCreation() {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("FlightRecorderSource.timeoutImageCreation()");
        }
        this.timeoutRequested = true;
    }

    private void initialize() {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("FlightRecorderSource.initialize()");
        }
        this.flightRecorderClient = FlightRecorderManager.getFlightRecorderClient();
        if (this.flightRecorderClient == null) {
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("FlightRecorderSource.initialize() no FlightRecorderClient found");
            }
            this.determineRecordingName();
            this.triggerGlobalInformationEvent();
            return;
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("FlightRecorderSource.initialize() start recording");
        }
        this.determineRecordingName();
        this.startRecording();
        this.triggerGlobalInformationEvent();
    }

    private void startRecording() {
        try {
            this.flightRecordingClient = this.flightRecorderClient.createRecordingObject(this.recordingName);
            List list = this.flightRecorderClient.getEventSettings(this.flightRecordingClient.getObjectName());
            EventSettingsBuilder eventSettingsBuilder = new EventSettingsBuilder();
            eventSettingsBuilder.createSetting("http://www.oracle.com/jrockit/jvm/*", false, false, Long.MAX_VALUE, 0L);
            List list2 = eventSettingsBuilder.createSettings((FlightRecorderMBean)this.flightRecorderClient);
            if ("Off".equals(this.getDiagnosticVolume()) || "Low".equals(this.getDiagnosticVolume()) && FlightRecorderManager.areJVMEventsExpensive()) {
                this.flightRecorderClient.updateEventSettings(this.flightRecordingClient.getObjectName(), list2);
            }
            this.destinationTempFile = File.createTempFile("__tmp", ".jfr", new File(this.imageManager.getDestinationDirectory()));
            this.destinationTempFile.deleteOnExit();
            this.flightRecordingClient.setDestination(this.destinationTempFile.getAbsolutePath());
            FlightRecorderManager.setImageRecordingClient((FlightRecordingClient)this.flightRecordingClient, (String)"WLDF ", (List)(DisableJVMEvents ? list2 : list), (List)list2);
            this.flightRecordingClient.start();
            FlightRecorderManager.debugRecorderDetails();
        }
        catch (Exception exception) {
            DiagnosticsLogger.logErrorInitializingFlightRecording((Throwable)exception);
        }
    }

    private String getDiagnosticVolume() {
        return wldfConfig.getWLDFDiagnosticVolume();
    }

    private void determineRecordingName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WLDFDiagnosticImageRecording");
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        if (runtimeAccess != null) {
            this.globalInfo.setDomainName(runtimeAccess.getDomainName());
            this.globalInfo.setServerName(runtimeAccess.getServerName());
            ServerRuntimeMBean serverRuntimeMBean = runtimeAccess.getServerRuntime();
            if (serverRuntimeMBean != null) {
                this.globalInfo.setMachineName(serverRuntimeMBean.getCurrentMachine());
            }
            wldfConfig = runtimeAccess.getServer().getServerDiagnosticConfig();
        }
        stringBuffer.append("_");
        stringBuffer.append(this.globalInfo.getDomainName());
        stringBuffer.append("_");
        stringBuffer.append(this.globalInfo.getServerName());
        stringBuffer.append("_");
        stringBuffer.append(this.globalInfo.getMachineName());
        this.recordingName = stringBuffer.toString();
    }

    private GlobalInformation triggerGlobalInformationEvent() {
        this.globalInfo.setDiagnosticVolume(this.getDiagnosticVolume());
        return this.globalInfo;
    }

    private static class GlobalInformation
    implements GlobalInformationEventInfo {
        private String domainName;
        private String serverName;
        private String machineName;
        private String diagnosticVolume;

        private GlobalInformation() {
        }

        public String getDomainName() {
            return this.domainName;
        }

        public void setDomainName(String string) {
            this.domainName = string;
        }

        public String getServerName() {
            return this.serverName;
        }

        public void setServerName(String string) {
            this.serverName = string;
        }

        public String getMachineName() {
            return this.machineName;
        }

        public void setMachineName(String string) {
            this.machineName = string;
        }

        public String getDiagnosticVolume() {
            return this.diagnosticVolume;
        }

        public void setDiagnosticVolume(String string) {
            this.diagnosticVolume = string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("domainName=");
            stringBuffer.append(this.domainName);
            stringBuffer.append(", serverName=");
            stringBuffer.append(this.serverName);
            stringBuffer.append(", machineName=");
            stringBuffer.append(this.machineName);
            stringBuffer.append(", diagnosticVolume=");
            stringBuffer.append(this.diagnosticVolume);
            return stringBuffer.toString();
        }
    }
}

