/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.image;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.image.ImageFilenameFilter;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.image.ImageRequester;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.diagnostics.image.ImageSourceOutputStream;
import weblogic.diagnostics.image.ImageSourceWork;
import weblogic.diagnostics.image.ImageSummary;
import weblogic.diagnostics.image.TaskRuntimeMBeanImpl;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

class ImageBuilder {
    ImageManager imageManager = ImageManager.getInstance();
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticImage");
    private WorkManager workManager = WorkManagerFactory.getInstance().find("ImageWorkManager");
    private ZipOutputStream zipFile;
    private ImageRequester imageRequester;
    private ImageSummary imageSummary;
    private String imageDirectory;
    private String archiveName;
    private long imageCreationTime;
    private boolean cancelRequest = false;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    ImageBuilder(String string, long l, ImageRequester imageRequester) {
        this.imageDirectory = string;
        this.imageCreationTime = l;
        this.imageRequester = imageRequester;
    }

    void requestImageCaptureCancel() {
        this.cancelRequest = true;
    }

    String getArchiveName() {
        return this.archiveName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    synchronized void buildImage(TaskRuntimeMBeanImpl taskRuntimeMBeanImpl) {
        long l = System.currentTimeMillis();
        try {
            try {
                this.cancelRequest = false;
                Map map = this.imageManager.getInternalImageSources();
                this.createImageSourceArchive();
                Map map2 = map;
                // MONITORENTER : map2
                Set set = map.keySet();
                Iterator iterator = set.iterator();
                while (!this.cancelRequest && iterator.hasNext()) {
                    String string = (String)iterator.next();
                    ImageSource imageSource = (ImageSource)map.get(string);
                    long l2 = System.currentTimeMillis();
                    this.addImageSourceToArchive(string, imageSource);
                    long l3 = System.currentTimeMillis() - l2;
                    if (!debugLogger.isDebugEnabled()) continue;
                    debugLogger.debug("Added image source " + string + " to archive: " + this.archiveName + " in " + l3 + " ms.");
                }
                if (this.cancelRequest) {
                    this.imageSummary.captureCancelled();
                }
                // MONITOREXIT : map2
            }
            catch (IOException iOException) {
                this.logBuilderError(taskRuntimeMBeanImpl, iOException);
                Object var18_13 = null;
                try {}
                catch (Throwable throwable) {
                    Object var21_23 = null;
                    taskRuntimeMBeanImpl.setEndTime(System.currentTimeMillis());
                    throw throwable;
                }
                try {}
                catch (Exception exception) {
                    this.logBuilderError(taskRuntimeMBeanImpl, exception);
                    Object var21_22 = null;
                    taskRuntimeMBeanImpl.setEndTime(System.currentTimeMillis());
                    return;
                }
                long l4 = System.currentTimeMillis() - l;
                this.imageSummary.setImageCreationElapsedTime(l4);
                this.closeImageSourceArchive();
                if (debugLogger.isDebugEnabled()) {
                    debugLogger.debug("Successfully created archive: " + this.archiveName + " in " + l4 + " ms.");
                }
                Object var21_21 = null;
                taskRuntimeMBeanImpl.setEndTime(System.currentTimeMillis());
                return;
            }
            Object var18_12 = null;
            try {
                block18: {
                    try {
                        long l2 = System.currentTimeMillis() - l;
                        this.imageSummary.setImageCreationElapsedTime(l2);
                        this.closeImageSourceArchive();
                        if (!debugLogger.isDebugEnabled()) break block18;
                        debugLogger.debug("Successfully created archive: " + this.archiveName + " in " + l2 + " ms.");
                    }
                    catch (Exception exception) {
                        this.logBuilderError(taskRuntimeMBeanImpl, exception);
                        Object var21_19 = null;
                        taskRuntimeMBeanImpl.setEndTime(System.currentTimeMillis());
                        return;
                    }
                }
                Object var21_18 = null;
                taskRuntimeMBeanImpl.setEndTime(System.currentTimeMillis());
                return;
            }
            catch (Throwable throwable) {
                Object var21_20 = null;
                taskRuntimeMBeanImpl.setEndTime(System.currentTimeMillis());
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var18_14 = null;
            try {}
            catch (Throwable throwable2) {
                Object var21_26 = null;
                taskRuntimeMBeanImpl.setEndTime(System.currentTimeMillis());
                throw throwable2;
            }
            try {}
            catch (Exception exception) {
                this.logBuilderError(taskRuntimeMBeanImpl, exception);
                Object var21_25 = null;
                taskRuntimeMBeanImpl.setEndTime(System.currentTimeMillis());
                throw throwable;
            }
            long l5 = System.currentTimeMillis() - l;
            this.imageSummary.setImageCreationElapsedTime(l5);
            this.closeImageSourceArchive();
            if (debugLogger.isDebugEnabled()) {
                debugLogger.debug("Successfully created archive: " + this.archiveName + " in " + l5 + " ms.");
            }
            Object var21_24 = null;
            taskRuntimeMBeanImpl.setEndTime(System.currentTimeMillis());
            throw throwable;
        }
    }

    private String getUniqueDiagnosticImageName() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "_";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        stringBuffer.append("diagnostic_image_");
        stringBuffer.append(ManagementService.getRuntimeAccess(kernelId).getServer().getName() + string);
        stringBuffer.append(simpleDateFormat.format(new Date(this.imageCreationTime)));
        String string2 = stringBuffer.toString();
        File file = new File(this.imageDirectory, string2 + ".zip");
        if (file.exists()) {
            string2 = this.incrementName(string2);
        }
        return this.imageDirectory + File.separator + string2 + ".zip";
    }

    private void createImageSourceArchive() throws IOException {
        this.archiveName = this.getUniqueDiagnosticImageName();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.archiveName));
        this.zipFile = new ZipOutputStream(bufferedOutputStream);
        this.imageSummary = new ImageSummary(this.imageCreationTime, this.imageRequester, this.archiveName);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Creating image source archive: " + this.archiveName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeImageSourceArchive() throws IOException, ImageSourceCreationException {
        block11: {
            ZipOutputStream zipOutputStream;
            String string = "image.summary";
            ZipEntry zipEntry = new ZipEntry(string);
            try {
                try {
                    ZipOutputStream zipOutputStream2 = this.zipFile;
                    synchronized (zipOutputStream2) {
                        this.zipFile.putNextEntry(zipEntry);
                    }
                    this.imageSummary.createDiagnosticImage(this.zipFile);
                }
                catch (Exception exception) {
                    DiagnosticsLogger.logDiagnosticImageSourceCreationException((String)string, (Throwable)exception);
                    Object var6_6 = null;
                    ZipOutputStream zipOutputStream2 = this.zipFile;
                    synchronized (zipOutputStream2) {
                        this.zipFile.closeEntry();
                        this.zipFile.close();
                        break block11;
                    }
                }
                Object var6_5 = null;
                zipOutputStream = this.zipFile;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                ZipOutputStream zipOutputStream4 = this.zipFile;
                synchronized (zipOutputStream4) {
                    this.zipFile.closeEntry();
                    this.zipFile.close();
                    throw throwable;
                }
            }
            synchronized (zipOutputStream) {
                this.zipFile.closeEntry();
                this.zipFile.close();
            }
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Closing image source archive: " + this.archiveName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImageSourceToArchive(String string, ImageSource imageSource) throws IOException {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Adding image source to archive: " + string);
        }
        String string2 = string.equals("FlightRecorder") ? ".jfr" : ".img";
        String string3 = string + string2;
        ZipEntry zipEntry = new ZipEntry(string3);
        OutputStream outputStream = this.zipFile;
        synchronized (outputStream) {
            this.zipFile.putNextEntry(zipEntry);
        }
        outputStream = new ImageSourceOutputStream(this.zipFile);
        ImageSourceWork imageSourceWork = new ImageSourceWork(imageSource, outputStream);
        this.workManager.schedule((Runnable)imageSourceWork);
        this.handleImageSourceWork(imageSourceWork);
        ZipOutputStream zipOutputStream = this.zipFile;
        synchronized (zipOutputStream) {
            this.zipFile.closeEntry();
            this.zipFile.flush();
        }
        if (imageSourceWork.getFailureException() == null) {
            this.imageSummary.addSuccessfulImageSource(string, imageSourceWork.getImageSourceElapsedTime());
        } else {
            this.imageSummary.addFailedImageSource(string, imageSourceWork.getFailureException());
            DiagnosticsLogger.logDiagnosticImageSourceCreationException((String)string, (Throwable)imageSourceWork.getFailureException());
        }
    }

    private String incrementName(String string) {
        File file = new File(this.imageDirectory);
        String string2 = "_";
        int n = 0;
        ImageFilenameFilter imageFilenameFilter = new ImageFilenameFilter(string + string2);
        Object[] objectArray = file.list(imageFilenameFilter);
        if (objectArray.length > 0) {
            Arrays.sort(objectArray);
            Object object = objectArray[objectArray.length - 1];
            object = ((String)object).split("[.]")[0];
            String[] stringArray = ((String)object).split(string2);
            n = Integer.parseInt(stringArray[stringArray.length - 1]);
        }
        return string + string2 + ++n;
    }

    private void handleImageSourceWork(ImageSourceWork imageSourceWork) {
        boolean bl = false;
        for (long i = 60000L; !imageSourceWork.isFinished() && i > 0L; i -= 500L) {
            this.sleep(500L);
        }
        if (!imageSourceWork.isFinished()) {
            imageSourceWork.getImageSource().timeoutImageCreation();
            this.sleep(30000L);
            bl = true;
        }
        ImageSourceOutputStream imageSourceOutputStream = (ImageSourceOutputStream)imageSourceWork.getOutputStream();
        imageSourceOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(long l) {
        try {
            long l2 = System.currentTimeMillis() + l;
            ImageBuilder imageBuilder = this;
            synchronized (imageBuilder) {
                while (System.currentTimeMillis() < l2) {
                    this.wait(l);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            UnexpectedExceptionHandler.handle("ImageBuilder interrupted.", interruptedException);
        }
    }

    private void logBuilderError(TaskRuntimeMBeanImpl taskRuntimeMBeanImpl, Exception exception) {
        DiagnosticsLogger.logDiagnosticImageCreationError((Throwable)exception);
        taskRuntimeMBeanImpl.setError(exception);
    }
}

