/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.image;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.security.AccessController;
import java.text.Collator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.flightrecorder.FlightRecorderManager;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.image.FlightRecorderSource;
import weblogic.diagnostics.image.ImageAlreadyCapturedException;
import weblogic.diagnostics.image.ImageRequester;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceNotFoundException;
import weblogic.diagnostics.image.ImageWork;
import weblogic.diagnostics.image.InvalidDestinationDirectoryException;
import weblogic.diagnostics.image.InvalidLockoutTimeException;
import weblogic.diagnostics.image.JVMSource;
import weblogic.diagnostics.instrumentation.gathering.DataGatheringManager;
import weblogic.management.DomainDir;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.WLDFServerDiagnosticMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.WLDFImageCreationTaskRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class ImageManager
implements PropertyChangeListener {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticImage");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final ImageManager imageManager = new ImageManager();
    private String destinationDirectory = null;
    private String absoluteDestPath = null;
    private int imageTimeout = 0;
    private Map imageSources = new Hashtable();
    private long lockoutExpiration = -1L;
    private WorkManager workManager;
    private ServerMBean serverBean;
    private Set<WLDFImageCreationTaskRuntimeMBean> activeTasks = new HashSet<WLDFImageCreationTaskRuntimeMBean>();

    private ImageManager() {
        String string = "ImageWorkManager";
        int n = 2;
        int n2 = -1;
        this.workManager = WorkManagerFactory.getInstance().findOrCreate(string, n, n2);
        this.serverBean = ManagementService.getRuntimeAccess(kernelId).getServer();
        WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean = this.serverBean.getServerDiagnosticConfig();
        this.initFromConfiguration(wLDFServerDiagnosticMBean);
        this.isValidDestination(this.destinationDirectory);
        this.registerImageSource("JVM", new JVMSource());
        DataGatheringManager.initialize();
        if (FlightRecorderManager.isRecordingPossible()) {
            this.registerImageSource("FlightRecorder", new FlightRecorderSource(this));
        } else if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Flight recording is not possible, not registering the image source");
        }
    }

    public static ImageManager getInstance() {
        return imageManager;
    }

    public ImageSource registerImageSource(String string, ImageSource imageSource) {
        if (string == null || imageSource == null) {
            throw new IllegalArgumentException("Name or source null.");
        }
        ImageSource imageSource2 = this.imageSources.put(string, imageSource);
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Registered image source: " + string);
        }
        return imageSource2;
    }

    public ImageSource unregisterImageSource(String string) throws ImageSourceNotFoundException {
        if (string == null) {
            throw new IllegalArgumentException("ImageSource name null.");
        }
        ImageSource imageSource = (ImageSource)this.imageSources.remove(string);
        if (imageSource == null) {
            throw new ImageSourceNotFoundException("Image source not found: " + string);
        }
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Unregistered image source: " + string);
        }
        return imageSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getImageSources() {
        Map map = this.imageSources;
        synchronized (map) {
            Set set = this.imageSources.keySet();
            return set.toArray(new String[set.size()]);
        }
    }

    public WLDFImageCreationTaskRuntimeMBean captureImage() throws ImageAlreadyCapturedException, InvalidDestinationDirectoryException {
        return this.captureImage(this.getDestinationDirectory());
    }

    public WLDFImageCreationTaskRuntimeMBean captureImage(String string) throws ImageAlreadyCapturedException, InvalidDestinationDirectoryException {
        return this.createImageWork(string, this.imageTimeout);
    }

    public WLDFImageCreationTaskRuntimeMBean captureImage(int n) throws InvalidLockoutTimeException, ImageAlreadyCapturedException, InvalidDestinationDirectoryException {
        return this.captureImage(this.getDestinationDirectory(), n);
    }

    public WLDFImageCreationTaskRuntimeMBean captureImage(String string, int n) throws InvalidLockoutTimeException, ImageAlreadyCapturedException, InvalidDestinationDirectoryException {
        if (n < 0) {
            DiagnosticsLogger.logDiagnosticImageLockoutBelow((int)n);
            throw new InvalidLockoutTimeException("Specified lock time less than minimum.");
        }
        if (n > 1440) {
            DiagnosticsLogger.logDiagnosticImageLockoutAbove((int)n);
            throw new InvalidLockoutTimeException("Specified lock time greater than maximum.");
        }
        this.purgeCompletedTasks();
        WLDFImageCreationTaskRuntimeMBean wLDFImageCreationTaskRuntimeMBean = this.createImageWork(string, n);
        this.activeTasks.add(wLDFImageCreationTaskRuntimeMBean);
        return wLDFImageCreationTaskRuntimeMBean;
    }

    public boolean tasksInProgress() {
        this.purgeCompletedTasks();
        return !this.activeTasks.isEmpty();
    }

    public void setDestinationDirectory(String string) throws InvalidDestinationDirectoryException {
        if (!this.isValidDestination(string)) {
            DiagnosticsLogger.logDiagnosticImageDirectoryAccessError((String)string);
            throw new InvalidDestinationDirectoryException(string);
        }
        this.destinationDirectory = string;
    }

    public String getDestinationDirectory() {
        return this.destinationDirectory;
    }

    public void resetImageLockout() {
        this.lockoutExpiration = -1L;
    }

    Map getInternalImageSources() {
        return this.imageSources;
    }

    private void initFromConfiguration(WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean) {
        String string = wLDFServerDiagnosticMBean.getImageDir();
        this.imageTimeout = wLDFServerDiagnosticMBean.getImageTimeout();
        File file = new File(string);
        if (!file.isAbsolute()) {
            File file2 = new File(DomainDir.getPathRelativeServerDir((String)this.serverBean.getName(), (String)string));
            this.destinationDirectory = file2.getAbsolutePath();
        } else {
            this.destinationDirectory = string;
        }
    }

    private synchronized WLDFImageCreationTaskRuntimeMBean createImageWork(String string, int n) throws ImageAlreadyCapturedException, InvalidDestinationDirectoryException {
        if (this.isThrottled()) {
            DiagnosticsLogger.logDiagnosticImageAlreadyCaptured();
            long l = this.lockoutExpiration - System.currentTimeMillis();
            String string2 = new StringBuffer().append("Image captures are throttled for another ").append(l).append(" milliseconds due to lockout specification.").toString();
            throw new ImageAlreadyCapturedException(string2);
        }
        if (!this.isValidDestination(string)) {
            DiagnosticsLogger.logDiagnosticImageDirectoryAccessError((String)string);
            throw new InvalidDestinationDirectoryException(string);
        }
        DiagnosticsLogger.logDiagnosticImageCaptureRequest((String)this.absoluteDestPath, (int)n);
        ImageRequester imageRequester = new ImageRequester(new Exception());
        ImageWork imageWork = new ImageWork(this.absoluteDestPath, n, imageRequester);
        this.workManager.schedule((Runnable)imageWork);
        if (n != 0) {
            this.createLockout(n);
        }
        return imageWork.getImageWatcher();
    }

    private boolean isThrottled() {
        boolean bl = false;
        if (this.lockoutExpiration != -1L) {
            boolean bl2 = bl = System.currentTimeMillis() <= this.lockoutExpiration;
            if (!bl) {
                this.lockoutExpiration = -1L;
            }
        }
        return bl;
    }

    private void createLockout(int n) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("Creating lockout for image captures (minutes): " + n);
        }
        long l = n * 60 * 1000;
        this.lockoutExpiration = System.currentTimeMillis() + l;
    }

    private boolean isValidDestination(String string) {
        boolean bl;
        Object object;
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            object = ManagementService.getRuntimeAccess(kernelId).getServer();
            File file2 = new File(DomainDir.getPathRelativeServerDir((String)object.getName(), (String)string));
            this.absoluteDestPath = file2.getAbsolutePath();
        } else {
            this.absoluteDestPath = string;
        }
        object = new File(this.absoluteDestPath);
        if (!((File)object).exists() && !(bl = ((File)object).mkdirs())) {
            DiagnosticsLogger.logDiagnosticImageDirectoryCreationError((String)this.absoluteDestPath);
            return false;
        }
        return ((File)object).canWrite();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.attributesChanged(propertyChangeEvent.getSource());
    }

    private void attributesChanged(Object object) {
        if (object instanceof WLDFServerDiagnosticMBean) {
            WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean = (WLDFServerDiagnosticMBean)object;
            this.initFromConfiguration(wLDFServerDiagnosticMBean);
        }
    }

    public String[] getAvailableCapturedImages() {
        File file;
        File[] fileArray;
        String[] stringArray = new String[]{};
        if (this.isValidDestination(this.destinationDirectory) && (fileArray = (file = new File(this.absoluteDestPath)).listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".zip");
            }
        })) != null && fileArray.length > 0) {
            stringArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = fileArray[i].getName();
            }
            if (fileArray.length > 1) {
                Arrays.sort(stringArray, Collator.getInstance());
            }
        }
        return stringArray;
    }

    public File findImageFile(String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            throw new IllegalArgumentException("Invalid image file requested");
        }
        File file2 = new File(this.getDestinationDirectory() + File.separatorChar + file.getName());
        return file2;
    }

    private void purgeCompletedTasks() {
        Iterator<WLDFImageCreationTaskRuntimeMBean> iterator = this.activeTasks.iterator();
        while (iterator.hasNext()) {
            WLDFImageCreationTaskRuntimeMBean wLDFImageCreationTaskRuntimeMBean = iterator.next();
            if (!wLDFImageCreationTaskRuntimeMBean.isRunning()) {
                iterator.remove();
                if (!debugLogger.isDebugEnabled()) continue;
                debugLogger.debug("Purging completed image task " + wLDFImageCreationTaskRuntimeMBean.getName());
                continue;
            }
            if (!debugLogger.isDebugEnabled()) continue;
            debugLogger.debug("Image task " + wLDFImageCreationTaskRuntimeMBean.getName() + " still running");
        }
    }
}

