/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.image;

import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.image.ImageAlreadyCapturedException;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.image.InvalidDestinationDirectoryException;
import weblogic.diagnostics.image.InvalidLockoutTimeException;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.WLDFImageCreationTaskRuntimeMBean;
import weblogic.management.runtime.WLDFImageRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ImageRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements WLDFImageRuntimeMBean {
    private static DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugDiagnosticImage");
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static ImageRuntimeMBeanImpl singleton;
    private static ImageManager im;
    private Set tasks = Collections.synchronizedSet(new HashSet());

    public static synchronized ImageRuntimeMBeanImpl getInstance() throws ManagementException {
        if (singleton == null) {
            singleton = new ImageRuntimeMBeanImpl();
        }
        return singleton;
    }

    public ImageRuntimeMBeanImpl() throws ManagementException {
        super("Image", (RuntimeMBean)ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getWLDFRuntime());
        im = ImageManager.getInstance();
    }

    public WLDFImageCreationTaskRuntimeMBean captureImage() throws ManagementException {
        try {
            WLDFImageCreationTaskRuntimeMBean wLDFImageCreationTaskRuntimeMBean = im.captureImage();
            this.tasks.add(wLDFImageCreationTaskRuntimeMBean);
            return wLDFImageCreationTaskRuntimeMBean;
        }
        catch (ImageAlreadyCapturedException imageAlreadyCapturedException) {
            throw new ManagementException((Throwable)((Object)imageAlreadyCapturedException));
        }
        catch (InvalidDestinationDirectoryException invalidDestinationDirectoryException) {
            throw new ManagementException((Throwable)((Object)invalidDestinationDirectoryException));
        }
    }

    public WLDFImageCreationTaskRuntimeMBean captureImage(int n) throws ManagementException {
        try {
            WLDFImageCreationTaskRuntimeMBean wLDFImageCreationTaskRuntimeMBean = im.captureImage(n);
            this.tasks.add(wLDFImageCreationTaskRuntimeMBean);
            return wLDFImageCreationTaskRuntimeMBean;
        }
        catch (ImageAlreadyCapturedException imageAlreadyCapturedException) {
            throw new ManagementException((Throwable)((Object)imageAlreadyCapturedException));
        }
        catch (InvalidDestinationDirectoryException invalidDestinationDirectoryException) {
            throw new ManagementException((Throwable)((Object)invalidDestinationDirectoryException));
        }
        catch (InvalidLockoutTimeException invalidLockoutTimeException) {
            throw new ManagementException((Throwable)((Object)invalidLockoutTimeException));
        }
    }

    public WLDFImageCreationTaskRuntimeMBean captureImage(String string) throws ManagementException {
        try {
            WLDFImageCreationTaskRuntimeMBean wLDFImageCreationTaskRuntimeMBean = im.captureImage(string);
            this.tasks.add(wLDFImageCreationTaskRuntimeMBean);
            return wLDFImageCreationTaskRuntimeMBean;
        }
        catch (ImageAlreadyCapturedException imageAlreadyCapturedException) {
            throw new ManagementException((Throwable)((Object)imageAlreadyCapturedException));
        }
        catch (InvalidDestinationDirectoryException invalidDestinationDirectoryException) {
            throw new ManagementException((Throwable)((Object)invalidDestinationDirectoryException));
        }
    }

    public WLDFImageCreationTaskRuntimeMBean captureImage(String string, int n) throws ManagementException {
        try {
            WLDFImageCreationTaskRuntimeMBean wLDFImageCreationTaskRuntimeMBean = im.captureImage(string, n);
            this.tasks.add(wLDFImageCreationTaskRuntimeMBean);
            return wLDFImageCreationTaskRuntimeMBean;
        }
        catch (ImageAlreadyCapturedException imageAlreadyCapturedException) {
            throw new ManagementException((Throwable)((Object)imageAlreadyCapturedException));
        }
        catch (InvalidDestinationDirectoryException invalidDestinationDirectoryException) {
            throw new ManagementException((Throwable)((Object)invalidDestinationDirectoryException));
        }
        catch (InvalidLockoutTimeException invalidLockoutTimeException) {
            throw new ManagementException((Throwable)((Object)invalidLockoutTimeException));
        }
    }

    public WLDFImageCreationTaskRuntimeMBean[] listImageCaptureTasks() {
        return this.tasks.toArray(new WLDFImageCreationTaskRuntimeMBean[this.tasks.size()]);
    }

    public void clearCompletedImageCaptureTasks() {
        Iterator iterator = this.tasks.iterator();
        HashSet<WLDFImageCreationTaskRuntimeMBean> hashSet = new HashSet<WLDFImageCreationTaskRuntimeMBean>();
        while (iterator.hasNext()) {
            WLDFImageCreationTaskRuntimeMBean wLDFImageCreationTaskRuntimeMBean = (WLDFImageCreationTaskRuntimeMBean)iterator.next();
            if (!wLDFImageCreationTaskRuntimeMBean.getStatus().equalsIgnoreCase("Completed")) continue;
            hashSet.add(wLDFImageCreationTaskRuntimeMBean);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.tasks.remove((WLDFImageCreationTaskRuntimeMBean)iterator.next());
        }
    }

    public void resetImageLockout() {
        im.resetImageLockout();
    }
}

