/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.image;

import java.io.IOException;
import java.io.OutputStream;

class ImageSourceOutputStream
extends OutputStream {
    private OutputStream out;
    private boolean streamExpired = false;

    ImageSourceOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void close() {
        this.streamExpired = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        this.checkExpired();
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.out.flush();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkExpired();
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.out.write(byArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) throws IOException {
        this.checkExpired();
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.out.write(n);
        }
    }

    private void checkExpired() throws IOException {
        if (this.streamExpired) {
            throw new IOException("Stream no longer writable.");
        }
    }
}

