/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.image;

import java.io.OutputStream;
import weblogic.diagnostics.image.ImageSource;

class ImageSourceWork
implements Runnable {
    private ImageSource imageSource;
    private boolean finished;
    private long startTime;
    private long imageSourceElapsedTime;
    private OutputStream imageOutputStream;
    private Exception failureException;

    ImageSourceWork(ImageSource imageSource, OutputStream outputStream) {
        this.imageSource = imageSource;
        this.imageOutputStream = outputStream;
    }

    ImageSource getImageSource() {
        return this.imageSource;
    }

    OutputStream getOutputStream() {
        return this.imageOutputStream;
    }

    long getImageSourceElapsedTime() {
        return this.imageSourceElapsedTime;
    }

    boolean isFinished() {
        return this.finished;
    }

    Exception getFailureException() {
        return this.failureException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.startTime = System.currentTimeMillis();
                this.imageSource.createDiagnosticImage(this.imageOutputStream);
            }
            catch (Exception exception) {
                this.failureException = exception;
                Object var3_2 = null;
                this.imageSourceElapsedTime = System.currentTimeMillis() - this.startTime;
                this.finished = true;
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.imageSourceElapsedTime = System.currentTimeMillis() - this.startTime;
            this.finished = true;
            throw throwable;
        }
        this.imageSourceElapsedTime = System.currentTimeMillis() - this.startTime;
        this.finished = true;
    }
}

