/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.image;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.diagnostics.image.ImageRequester;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.diagnostics.image.descriptor.FailedImageSourceBean;
import weblogic.diagnostics.image.descriptor.ImageSummaryBean;
import weblogic.diagnostics.image.descriptor.SuccessfulImageSourceBean;
import weblogic.diagnostics.image.descriptor.SystemPropertyBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.StackTraceUtils;
import weblogic.version;

class ImageSummary
implements ImageSource {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private boolean captureCancelled;
    private String imageName;
    private Date imageCreationDate;
    private Long imageCreationElapsedTime;
    private Map successfulImageSources = new HashMap();
    private Map failedImageSources = new HashMap();
    private ImageRequester imageRequester;
    private ImageSummaryBean root;

    ImageSummary(long l, ImageRequester imageRequester, String string) {
        this.imageCreationDate = new Date(l);
        this.imageRequester = imageRequester;
        this.imageName = string;
        this.setImageCreationElapsedTime(0L);
    }

    void setImageCreationElapsedTime(long l) {
        this.imageCreationElapsedTime = new Long(l);
    }

    void addSuccessfulImageSource(String string, long l) {
        this.successfulImageSources.put(string, new Long(l));
    }

    void addFailedImageSource(String string, Exception exception) {
        this.failedImageSources.put(string, exception);
    }

    void captureCancelled() {
        this.captureCancelled = true;
    }

    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        DescriptorManager descriptorManager = new DescriptorManager();
        Descriptor descriptor = descriptorManager.createDescriptorRoot(ImageSummaryBean.class);
        this.root = (ImageSummaryBean)descriptor.getRootBean();
        this.writeHeader();
        this.writeImageSourceElapsedTimes();
        this.writeFailedImageSources();
        this.writeImageRequester();
        try {
            descriptorManager.writeDescriptorBeanAsXML((DescriptorBean)this.root, outputStream);
        }
        catch (IOException iOException) {
            throw new ImageSourceCreationException((Throwable)iOException);
        }
    }

    public void timeoutImageCreation() {
    }

    private void writeHeader() {
        this.root.setImageCaptureCancelled(this.captureCancelled);
        this.root.setImageCreationDate(this.imageCreationDate.toString());
        this.root.setImageCreationElapsedTime(this.imageCreationElapsedTime);
        this.root.setImageFileName(this.imageName);
        this.root.setMuxerClass(ManagementService.getRuntimeAccess(kernelId).getServer().getMuxerClass());
        this.root.setServerName(ManagementService.getRuntimeAccess(kernelId).getServer().getName());
        this.root.setServerReleaseInfo(version.getWebServerReleaseInfo());
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            SystemPropertyBean systemPropertyBean = this.root.createSystemProperty();
            systemPropertyBean.setName(entry.getKey().toString());
            systemPropertyBean.setValue(entry.getValue().toString());
        }
    }

    private void writeImageSourceElapsedTimes() {
        Set set = this.successfulImageSources.keySet();
        for (String string : set) {
            Long l = (Long)this.successfulImageSources.get(string);
            SuccessfulImageSourceBean successfulImageSourceBean = this.root.createSuccessfulImageSource();
            successfulImageSourceBean.setImageSource(string);
            successfulImageSourceBean.setImageCaptureElapsedTime(l);
        }
    }

    private void writeFailedImageSources() {
        Set set = this.failedImageSources.keySet();
        for (String string : set) {
            Throwable throwable = (Throwable)this.failedImageSources.get(string);
            if (throwable == null) continue;
            String string2 = StackTraceUtils.throwable2StackTrace((Throwable)throwable);
            FailedImageSourceBean failedImageSourceBean = this.root.createFailedImageSource();
            failedImageSourceBean.setImageSource(string);
            failedImageSourceBean.setFailureExceptionStackTrace(string2);
        }
    }

    private void writeImageRequester() {
        this.root.setRequesterThreadName(this.imageRequester.getRequesterThreadName());
        this.root.setRequesterUserId(this.imageRequester.getRequesterUserId());
        this.root.setRequestStackTrace(this.imageRequester.getRequester());
    }
}

