/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.image;

import weblogic.diagnostics.image.ImageBuilder;
import weblogic.diagnostics.image.ImageRequester;
import weblogic.diagnostics.image.TaskRuntimeMBeanImpl;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;
import weblogic.management.ManagementException;
import weblogic.management.runtime.WLDFImageCreationTaskRuntimeMBean;

class ImageWork
implements Runnable {
    private TaskRuntimeMBeanImpl imageWatcher;
    private String destination;
    private int lockoutMinutes;
    ImageRequester imageRequester;

    ImageWork(String string, int n, ImageRequester imageRequester) {
        this.destination = string;
        this.lockoutMinutes = n;
        this.imageRequester = imageRequester;
        try {
            this.imageWatcher = new TaskRuntimeMBeanImpl();
        }
        catch (ManagementException managementException) {
            UnexpectedExceptionHandler.handle("Problem registering TaskRuntimeMBean.", managementException);
        }
    }

    WLDFImageCreationTaskRuntimeMBean getImageWatcher() {
        return this.imageWatcher;
    }

    public void run() {
        long l = System.currentTimeMillis();
        ImageBuilder imageBuilder = new ImageBuilder(this.destination, l, this.imageRequester);
        this.imageWatcher.setImageBuilder(imageBuilder);
        this.imageWatcher.setBeginTime(l);
        imageBuilder.buildImage(this.imageWatcher);
    }
}

