/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.image;

import java.io.PrintWriter;
import weblogic.diagnostics.image.ImageBuilder;
import weblogic.diagnostics.image.ImageConstants;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.TaskRuntimeMBean;
import weblogic.management.runtime.WLDFImageCreationTaskRuntimeMBean;

public class TaskRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements WLDFImageCreationTaskRuntimeMBean {
    private int imageStatus = 0;
    private long imageCaptureStartTime;
    private long imageCaptureEndTime;
    private boolean systemTask;
    private Exception imageError;
    private static int count = 0;
    private ImageBuilder imageBuilder;

    public TaskRuntimeMBeanImpl() throws ManagementException {
        super("DiagnosticImageCaptureTaskRuntime_" + TaskRuntimeMBeanImpl.getCount());
    }

    synchronized void setError(Exception exception) {
        this.imageError = exception;
        this.imageStatus = 3;
    }

    synchronized void setBeginTime(long l) {
        this.imageCaptureStartTime = l;
        this.imageStatus = 1;
    }

    synchronized void setEndTime(long l) {
        this.imageCaptureEndTime = l;
        this.imageStatus = 2;
    }

    void setImageBuilder(ImageBuilder imageBuilder) {
        this.imageBuilder = imageBuilder;
    }

    public String getDescription() {
        String string;
        String string2 = string = this.imageBuilder != null ? this.imageBuilder.getArchiveName() : null;
        if (string == null) {
            return "Diagnostic image request pending execution.";
        }
        return string;
    }

    public synchronized String getStatus() {
        return ImageConstants.CAPTURE_STATES[this.imageStatus];
    }

    public synchronized boolean isRunning() {
        return this.imageStatus == 1;
    }

    public synchronized long getBeginTime() {
        return this.imageCaptureStartTime;
    }

    public synchronized long getEndTime() {
        return this.imageCaptureEndTime;
    }

    public TaskRuntimeMBean[] getSubTasks() {
        return null;
    }

    public TaskRuntimeMBean getParentTask() {
        return null;
    }

    public void cancel() {
        if (this.isRunning()) {
            this.imageBuilder.requestImageCaptureCancel();
        }
    }

    public synchronized Exception getError() {
        return this.imageError;
    }

    public boolean isSystemTask() {
        return this.systemTask;
    }

    public void setSystemTask(boolean bl) {
        this.systemTask = bl;
    }

    public void printLog(PrintWriter printWriter) {
    }

    private static synchronized int getCount() {
        return ++count;
    }
}

