/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.image.descriptor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.AbstractSchemaHelper2;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.diagnostics.image.descriptor.JVMRuntimeBean;
import weblogic.utils.collections.CombinedIterator;

public class JVMRuntimeBeanImpl
extends AbstractDescriptorBean
implements JVMRuntimeBean,
Serializable {
    private String _BootClassPath;
    private boolean _BootClassPathSupported;
    private String _ClassPath;
    private long _CurrentThreadCpuTime;
    private boolean _CurrentThreadCpuTimeSupported;
    private long _CurrentThreadUserTime;
    private int _DaemonThreadCount;
    private long _HeapMemoryCommittedBytes;
    private long _HeapMemoryInitBytes;
    private long _HeapMemoryMaxBytes;
    private long _HeapMemoryUsedBytes;
    private String _LibraryPath;
    private int _LoadedClassCount;
    private String _ManagementSpecVersion;
    private long _NonHeapMemoryCommittedBytes;
    private long _NonHeapMemoryInitBytes;
    private long _NonHeapMemoryMaxBytes;
    private long _NonHeapMemoryUsedBytes;
    private String _OSArch;
    private int _OSAvailableProcessors;
    private String _OSName;
    private String _OSVersion;
    private int _ObjectPendingFinalizationCount;
    private int _PeakThreadCount;
    private String _RunningJVMName;
    private String _SpecName;
    private String _SpecVendor;
    private String _SpecVersion;
    private long _StartTime;
    private boolean _ThreadContentionMonitoringEnabled;
    private boolean _ThreadContentionMonitoringSupported;
    private int _ThreadCount;
    private boolean _ThreadCpuTimeEnabled;
    private boolean _ThreadCpuTimeSupported;
    private String _ThreadDump;
    private String _ThreadRequestExecutionDetails;
    private long _TotalLoadedClassCount;
    private long _TotalStartedThreadCount;
    private long _UnloadedClassCount;
    private long _Uptime;
    private String _VmName;
    private String _VmVendor;
    private String _VmVersion;
    private static SchemaHelper2 _schemaHelper;

    public JVMRuntimeBeanImpl() {
        this._initializeRootBean(this.getDescriptor());
        this._initializeProperty(-1);
    }

    public JVMRuntimeBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeRootBean(this.getDescriptor());
        this._initializeProperty(-1);
    }

    public void setObjectPendingFinalizationCount(int n) {
        int n2 = this._ObjectPendingFinalizationCount;
        this._ObjectPendingFinalizationCount = n;
        this._postSet(0, n2, n);
    }

    public int getObjectPendingFinalizationCount() {
        return this._ObjectPendingFinalizationCount;
    }

    public boolean isObjectPendingFinalizationCountSet() {
        return this._isSet(0);
    }

    public void setHeapMemoryUsedBytes(long l) {
        long l2 = this._HeapMemoryUsedBytes;
        this._HeapMemoryUsedBytes = l;
        this._postSet(1, l2, l);
    }

    public long getHeapMemoryUsedBytes() {
        return this._HeapMemoryUsedBytes;
    }

    public boolean isHeapMemoryUsedBytesSet() {
        return this._isSet(1);
    }

    public void setHeapMemoryMaxBytes(long l) {
        long l2 = this._HeapMemoryMaxBytes;
        this._HeapMemoryMaxBytes = l;
        this._postSet(2, l2, l);
    }

    public long getHeapMemoryMaxBytes() {
        return this._HeapMemoryMaxBytes;
    }

    public boolean isHeapMemoryMaxBytesSet() {
        return this._isSet(2);
    }

    public void setHeapMemoryInitBytes(long l) {
        long l2 = this._HeapMemoryInitBytes;
        this._HeapMemoryInitBytes = l;
        this._postSet(3, l2, l);
    }

    public long getHeapMemoryInitBytes() {
        return this._HeapMemoryInitBytes;
    }

    public boolean isHeapMemoryInitBytesSet() {
        return this._isSet(3);
    }

    public void setHeapMemoryCommittedBytes(long l) {
        long l2 = this._HeapMemoryCommittedBytes;
        this._HeapMemoryCommittedBytes = l;
        this._postSet(4, l2, l);
    }

    public long getHeapMemoryCommittedBytes() {
        return this._HeapMemoryCommittedBytes;
    }

    public boolean isHeapMemoryCommittedBytesSet() {
        return this._isSet(4);
    }

    public void setNonHeapMemoryUsedBytes(long l) {
        long l2 = this._NonHeapMemoryUsedBytes;
        this._NonHeapMemoryUsedBytes = l;
        this._postSet(5, l2, l);
    }

    public long getNonHeapMemoryUsedBytes() {
        return this._NonHeapMemoryUsedBytes;
    }

    public boolean isNonHeapMemoryUsedBytesSet() {
        return this._isSet(5);
    }

    public void setNonHeapMemoryMaxBytes(long l) {
        long l2 = this._NonHeapMemoryMaxBytes;
        this._NonHeapMemoryMaxBytes = l;
        this._postSet(6, l2, l);
    }

    public long getNonHeapMemoryMaxBytes() {
        return this._NonHeapMemoryMaxBytes;
    }

    public boolean isNonHeapMemoryMaxBytesSet() {
        return this._isSet(6);
    }

    public void setNonHeapMemoryInitBytes(long l) {
        long l2 = this._NonHeapMemoryInitBytes;
        this._NonHeapMemoryInitBytes = l;
        this._postSet(7, l2, l);
    }

    public long getNonHeapMemoryInitBytes() {
        return this._NonHeapMemoryInitBytes;
    }

    public boolean isNonHeapMemoryInitBytesSet() {
        return this._isSet(7);
    }

    public void setNonHeapMemoryCommittedBytes(long l) {
        long l2 = this._NonHeapMemoryCommittedBytes;
        this._NonHeapMemoryCommittedBytes = l;
        this._postSet(8, l2, l);
    }

    public long getNonHeapMemoryCommittedBytes() {
        return this._NonHeapMemoryCommittedBytes;
    }

    public boolean isNonHeapMemoryCommittedBytesSet() {
        return this._isSet(8);
    }

    public void setThreadCount(int n) {
        int n2 = this._ThreadCount;
        this._ThreadCount = n;
        this._postSet(9, n2, n);
    }

    public int getThreadCount() {
        return this._ThreadCount;
    }

    public boolean isThreadCountSet() {
        return this._isSet(9);
    }

    public void setPeakThreadCount(int n) {
        int n2 = this._PeakThreadCount;
        this._PeakThreadCount = n;
        this._postSet(10, n2, n);
    }

    public int getPeakThreadCount() {
        return this._PeakThreadCount;
    }

    public boolean isPeakThreadCountSet() {
        return this._isSet(10);
    }

    public void setTotalStartedThreadCount(long l) {
        long l2 = this._TotalStartedThreadCount;
        this._TotalStartedThreadCount = l;
        this._postSet(11, l2, l);
    }

    public long getTotalStartedThreadCount() {
        return this._TotalStartedThreadCount;
    }

    public boolean isTotalStartedThreadCountSet() {
        return this._isSet(11);
    }

    public void setDaemonThreadCount(int n) {
        int n2 = this._DaemonThreadCount;
        this._DaemonThreadCount = n;
        this._postSet(12, n2, n);
    }

    public int getDaemonThreadCount() {
        return this._DaemonThreadCount;
    }

    public boolean isDaemonThreadCountSet() {
        return this._isSet(12);
    }

    public void setThreadContentionMonitoringSupported(boolean bl) {
        boolean bl2 = this._ThreadContentionMonitoringSupported;
        this._ThreadContentionMonitoringSupported = bl;
        this._postSet(13, bl2, bl);
    }

    public boolean isThreadContentionMonitoringSupported() {
        return this._ThreadContentionMonitoringSupported;
    }

    public boolean isThreadContentionMonitoringSupportedSet() {
        return this._isSet(13);
    }

    public void setThreadContentionMonitoringEnabled(boolean bl) {
        boolean bl2 = this._ThreadContentionMonitoringEnabled;
        this._ThreadContentionMonitoringEnabled = bl;
        this._postSet(14, bl2, bl);
    }

    public boolean isThreadContentionMonitoringEnabled() {
        return this._ThreadContentionMonitoringEnabled;
    }

    public boolean isThreadContentionMonitoringEnabledSet() {
        return this._isSet(14);
    }

    public void setCurrentThreadCpuTime(long l) {
        long l2 = this._CurrentThreadCpuTime;
        this._CurrentThreadCpuTime = l;
        this._postSet(15, l2, l);
    }

    public long getCurrentThreadCpuTime() {
        return this._CurrentThreadCpuTime;
    }

    public boolean isCurrentThreadCpuTimeSet() {
        return this._isSet(15);
    }

    public void setCurrentThreadUserTime(long l) {
        long l2 = this._CurrentThreadUserTime;
        this._CurrentThreadUserTime = l;
        this._postSet(16, l2, l);
    }

    public long getCurrentThreadUserTime() {
        return this._CurrentThreadUserTime;
    }

    public boolean isCurrentThreadUserTimeSet() {
        return this._isSet(16);
    }

    public void setThreadCpuTimeSupported(boolean bl) {
        boolean bl2 = this._ThreadCpuTimeSupported;
        this._ThreadCpuTimeSupported = bl;
        this._postSet(17, bl2, bl);
    }

    public boolean isThreadCpuTimeSupported() {
        return this._ThreadCpuTimeSupported;
    }

    public boolean isThreadCpuTimeSupportedSet() {
        return this._isSet(17);
    }

    public void setCurrentThreadCpuTimeSupported(boolean bl) {
        boolean bl2 = this._CurrentThreadCpuTimeSupported;
        this._CurrentThreadCpuTimeSupported = bl;
        this._postSet(18, bl2, bl);
    }

    public boolean isCurrentThreadCpuTimeSupported() {
        return this._CurrentThreadCpuTimeSupported;
    }

    public boolean isCurrentThreadCpuTimeSupportedSet() {
        return this._isSet(18);
    }

    public void setThreadCpuTimeEnabled(boolean bl) {
        boolean bl2 = this._ThreadCpuTimeEnabled;
        this._ThreadCpuTimeEnabled = bl;
        this._postSet(19, bl2, bl);
    }

    public boolean isThreadCpuTimeEnabled() {
        return this._ThreadCpuTimeEnabled;
    }

    public boolean isThreadCpuTimeEnabledSet() {
        return this._isSet(19);
    }

    public void setRunningJVMName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._RunningJVMName;
        this._RunningJVMName = string;
        this._postSet(20, string2, string);
    }

    public String getRunningJVMName() {
        return this._RunningJVMName;
    }

    public boolean isRunningJVMNameSet() {
        return this._isSet(20);
    }

    public void setManagementSpecVersion(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ManagementSpecVersion;
        this._ManagementSpecVersion = string;
        this._postSet(21, string2, string);
    }

    public String getManagementSpecVersion() {
        return this._ManagementSpecVersion;
    }

    public boolean isManagementSpecVersionSet() {
        return this._isSet(21);
    }

    public void setVmName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._VmName;
        this._VmName = string;
        this._postSet(22, string2, string);
    }

    public String getVmName() {
        return this._VmName;
    }

    public boolean isVmNameSet() {
        return this._isSet(22);
    }

    public void setVmVendor(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._VmVendor;
        this._VmVendor = string;
        this._postSet(23, string2, string);
    }

    public String getVmVendor() {
        return this._VmVendor;
    }

    public boolean isVmVendorSet() {
        return this._isSet(23);
    }

    public void setVmVersion(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._VmVersion;
        this._VmVersion = string;
        this._postSet(24, string2, string);
    }

    public String getVmVersion() {
        return this._VmVersion;
    }

    public boolean isVmVersionSet() {
        return this._isSet(24);
    }

    public void setSpecName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._SpecName;
        this._SpecName = string;
        this._postSet(25, string2, string);
    }

    public String getSpecName() {
        return this._SpecName;
    }

    public boolean isSpecNameSet() {
        return this._isSet(25);
    }

    public void setSpecVendor(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._SpecVendor;
        this._SpecVendor = string;
        this._postSet(26, string2, string);
    }

    public String getSpecVendor() {
        return this._SpecVendor;
    }

    public boolean isSpecVendorSet() {
        return this._isSet(26);
    }

    public void setSpecVersion(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._SpecVersion;
        this._SpecVersion = string;
        this._postSet(27, string2, string);
    }

    public String getSpecVersion() {
        return this._SpecVersion;
    }

    public boolean isSpecVersionSet() {
        return this._isSet(27);
    }

    public void setClassPath(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ClassPath;
        this._ClassPath = string;
        this._postSet(28, string2, string);
    }

    public String getClassPath() {
        return this._ClassPath;
    }

    public boolean isClassPathSet() {
        return this._isSet(28);
    }

    public void setLibraryPath(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._LibraryPath;
        this._LibraryPath = string;
        this._postSet(29, string2, string);
    }

    public String getLibraryPath() {
        return this._LibraryPath;
    }

    public boolean isLibraryPathSet() {
        return this._isSet(29);
    }

    public void setBootClassPath(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._BootClassPath;
        this._BootClassPath = string;
        this._postSet(30, string2, string);
    }

    public String getBootClassPath() {
        return this._BootClassPath;
    }

    public boolean isBootClassPathSet() {
        return this._isSet(30);
    }

    public void setUptime(long l) {
        long l2 = this._Uptime;
        this._Uptime = l;
        this._postSet(31, l2, l);
    }

    public long getUptime() {
        return this._Uptime;
    }

    public boolean isUptimeSet() {
        return this._isSet(31);
    }

    public void setStartTime(long l) {
        long l2 = this._StartTime;
        this._StartTime = l;
        this._postSet(32, l2, l);
    }

    public long getStartTime() {
        return this._StartTime;
    }

    public boolean isStartTimeSet() {
        return this._isSet(32);
    }

    public void setBootClassPathSupported(boolean bl) {
        boolean bl2 = this._BootClassPathSupported;
        this._BootClassPathSupported = bl;
        this._postSet(33, bl2, bl);
    }

    public boolean isBootClassPathSupported() {
        return this._BootClassPathSupported;
    }

    public boolean isBootClassPathSupportedSet() {
        return this._isSet(33);
    }

    public void setOSName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._OSName;
        this._OSName = string;
        this._postSet(34, string2, string);
    }

    public String getOSName() {
        return this._OSName;
    }

    public boolean isOSNameSet() {
        return this._isSet(34);
    }

    public void setOSVersion(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._OSVersion;
        this._OSVersion = string;
        this._postSet(35, string2, string);
    }

    public String getOSVersion() {
        return this._OSVersion;
    }

    public boolean isOSVersionSet() {
        return this._isSet(35);
    }

    public void setOSArch(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._OSArch;
        this._OSArch = string;
        this._postSet(36, string2, string);
    }

    public String getOSArch() {
        return this._OSArch;
    }

    public boolean isOSArchSet() {
        return this._isSet(36);
    }

    public void setOSAvailableProcessors(int n) {
        int n2 = this._OSAvailableProcessors;
        this._OSAvailableProcessors = n;
        this._postSet(37, n2, n);
    }

    public int getOSAvailableProcessors() {
        return this._OSAvailableProcessors;
    }

    public boolean isOSAvailableProcessorsSet() {
        return this._isSet(37);
    }

    public void setLoadedClassCount(int n) {
        int n2 = this._LoadedClassCount;
        this._LoadedClassCount = n;
        this._postSet(38, n2, n);
    }

    public int getLoadedClassCount() {
        return this._LoadedClassCount;
    }

    public boolean isLoadedClassCountSet() {
        return this._isSet(38);
    }

    public void setTotalLoadedClassCount(long l) {
        long l2 = this._TotalLoadedClassCount;
        this._TotalLoadedClassCount = l;
        this._postSet(39, l2, l);
    }

    public long getTotalLoadedClassCount() {
        return this._TotalLoadedClassCount;
    }

    public boolean isTotalLoadedClassCountSet() {
        return this._isSet(39);
    }

    public void setUnloadedClassCount(long l) {
        long l2 = this._UnloadedClassCount;
        this._UnloadedClassCount = l;
        this._postSet(40, l2, l);
    }

    public long getUnloadedClassCount() {
        return this._UnloadedClassCount;
    }

    public boolean isUnloadedClassCountSet() {
        return this._isSet(40);
    }

    public String getThreadDump() {
        return this._ThreadDump;
    }

    public boolean isThreadDumpSet() {
        return this._isSet(41);
    }

    public void setThreadDump(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ThreadDump;
        this._ThreadDump = string;
        this._postSet(41, string2, string);
    }

    public String getThreadRequestExecutionDetails() {
        return this._ThreadRequestExecutionDetails;
    }

    public boolean isThreadRequestExecutionDetailsSet() {
        return this._isSet(42);
    }

    public void setThreadRequestExecutionDetails(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ThreadRequestExecutionDetails;
        this._ThreadRequestExecutionDetails = string;
        this._postSet(42, string2, string);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 30;
        }
        try {
            switch (n) {
                case 30: {
                    this._BootClassPath = null;
                    if (bl) break;
                }
                case 28: {
                    this._ClassPath = null;
                    if (bl) break;
                }
                case 15: {
                    this._CurrentThreadCpuTime = 0L;
                    if (bl) break;
                }
                case 16: {
                    this._CurrentThreadUserTime = 0L;
                    if (bl) break;
                }
                case 12: {
                    this._DaemonThreadCount = 0;
                    if (bl) break;
                }
                case 4: {
                    this._HeapMemoryCommittedBytes = 0L;
                    if (bl) break;
                }
                case 3: {
                    this._HeapMemoryInitBytes = 0L;
                    if (bl) break;
                }
                case 2: {
                    this._HeapMemoryMaxBytes = 0L;
                    if (bl) break;
                }
                case 1: {
                    this._HeapMemoryUsedBytes = 0L;
                    if (bl) break;
                }
                case 29: {
                    this._LibraryPath = null;
                    if (bl) break;
                }
                case 38: {
                    this._LoadedClassCount = 0;
                    if (bl) break;
                }
                case 21: {
                    this._ManagementSpecVersion = null;
                    if (bl) break;
                }
                case 8: {
                    this._NonHeapMemoryCommittedBytes = 0L;
                    if (bl) break;
                }
                case 7: {
                    this._NonHeapMemoryInitBytes = 0L;
                    if (bl) break;
                }
                case 6: {
                    this._NonHeapMemoryMaxBytes = 0L;
                    if (bl) break;
                }
                case 5: {
                    this._NonHeapMemoryUsedBytes = 0L;
                    if (bl) break;
                }
                case 36: {
                    this._OSArch = null;
                    if (bl) break;
                }
                case 37: {
                    this._OSAvailableProcessors = 0;
                    if (bl) break;
                }
                case 34: {
                    this._OSName = null;
                    if (bl) break;
                }
                case 35: {
                    this._OSVersion = null;
                    if (bl) break;
                }
                case 0: {
                    this._ObjectPendingFinalizationCount = 0;
                    if (bl) break;
                }
                case 10: {
                    this._PeakThreadCount = 0;
                    if (bl) break;
                }
                case 20: {
                    this._RunningJVMName = null;
                    if (bl) break;
                }
                case 25: {
                    this._SpecName = null;
                    if (bl) break;
                }
                case 26: {
                    this._SpecVendor = null;
                    if (bl) break;
                }
                case 27: {
                    this._SpecVersion = null;
                    if (bl) break;
                }
                case 32: {
                    this._StartTime = 0L;
                    if (bl) break;
                }
                case 9: {
                    this._ThreadCount = 0;
                    if (bl) break;
                }
                case 41: {
                    this._ThreadDump = null;
                    if (bl) break;
                }
                case 42: {
                    this._ThreadRequestExecutionDetails = null;
                    if (bl) break;
                }
                case 39: {
                    this._TotalLoadedClassCount = 0L;
                    if (bl) break;
                }
                case 11: {
                    this._TotalStartedThreadCount = 0L;
                    if (bl) break;
                }
                case 40: {
                    this._UnloadedClassCount = 0L;
                    if (bl) break;
                }
                case 31: {
                    this._Uptime = 0L;
                    if (bl) break;
                }
                case 22: {
                    this._VmName = null;
                    if (bl) break;
                }
                case 23: {
                    this._VmVendor = null;
                    if (bl) break;
                }
                case 24: {
                    this._VmVersion = null;
                    if (bl) break;
                }
                case 33: {
                    this._BootClassPathSupported = false;
                    if (bl) break;
                }
                case 18: {
                    this._CurrentThreadCpuTimeSupported = false;
                    if (bl) break;
                }
                case 14: {
                    this._ThreadContentionMonitoringEnabled = false;
                    if (bl) break;
                }
                case 13: {
                    this._ThreadContentionMonitoringSupported = false;
                    if (bl) break;
                }
                case 19: {
                    this._ThreadCpuTimeEnabled = false;
                    if (bl) break;
                }
                case 17: {
                    this._ThreadCpuTimeSupported = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/weblogic-diagnostics-image/1.0/weblogic-diagnostics-image.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/weblogic-diagnostics-image";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public static class SchemaHelper2
    extends AbstractSchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 15: {
                    if (!string.equals("boot-class-path")) break;
                    return 30;
                }
                case 10: {
                    if (string.equals("class-path")) {
                        return 28;
                    }
                    if (string.equals("os-version")) {
                        return 35;
                    }
                    if (string.equals("start-time")) {
                        return 32;
                    }
                    if (!string.equals("vm-version")) break;
                    return 24;
                }
                case 23: {
                    if (string.equals("current-thread-cpu-time")) {
                        return 15;
                    }
                    if (string.equals("management-spec-version")) {
                        return 21;
                    }
                    if (string.equals("os-available-processors")) {
                        return 37;
                    }
                    if (!string.equals("thread-cpu-time-enabled")) break;
                    return 19;
                }
                case 24: {
                    if (string.equals("current-thread-user-time")) {
                        return 16;
                    }
                    if (!string.equals("total-loaded-class-count")) break;
                    return 39;
                }
                case 19: {
                    if (!string.equals("daemon-thread-count")) break;
                    return 12;
                }
                case 27: {
                    if (!string.equals("heap-memory-committed-bytes")) break;
                    return 4;
                }
                case 22: {
                    if (string.equals("heap-memory-init-bytes")) {
                        return 3;
                    }
                    if (!string.equals("heap-memory-used-bytes")) break;
                    return 1;
                }
                case 21: {
                    if (!string.equals("heap-memory-max-bytes")) break;
                    return 2;
                }
                case 12: {
                    if (string.equals("library-path")) {
                        return 29;
                    }
                    if (string.equals("spec-version")) {
                        return 27;
                    }
                    if (!string.equals("thread-count")) break;
                    return 9;
                }
                case 18: {
                    if (!string.equals("loaded-class-count")) break;
                    return 38;
                }
                case 31: {
                    if (!string.equals("non-heap-memory-committed-bytes")) break;
                    return 8;
                }
                case 26: {
                    if (string.equals("non-heap-memory-init-bytes")) {
                        return 7;
                    }
                    if (string.equals("non-heap-memory-used-bytes")) {
                        return 5;
                    }
                    if (!string.equals("total-started-thread-count")) break;
                    return 11;
                }
                case 25: {
                    if (string.equals("non-heap-memory-max-bytes")) {
                        return 6;
                    }
                    if (string.equals("boot-class-path-supported")) {
                        return 33;
                    }
                    if (!string.equals("thread-cpu-time-supported")) break;
                    return 17;
                }
                case 7: {
                    if (string.equals("os-arch")) {
                        return 36;
                    }
                    if (string.equals("os-name")) {
                        return 34;
                    }
                    if (!string.equals("vm-name")) break;
                    return 22;
                }
                case 33: {
                    if (string.equals("object-pending-finalization-count")) {
                        return 0;
                    }
                    if (!string.equals("current-thread-cpu-time-supported")) break;
                    return 18;
                }
                case 17: {
                    if (!string.equals("peak-thread-count")) break;
                    return 10;
                }
                case 16: {
                    if (!string.equals("running-jvm-name")) break;
                    return 20;
                }
                case 9: {
                    if (string.equals("spec-name")) {
                        return 25;
                    }
                    if (!string.equals("vm-vendor")) break;
                    return 23;
                }
                case 11: {
                    if (string.equals("spec-vendor")) {
                        return 26;
                    }
                    if (!string.equals("thread-dump")) break;
                    return 41;
                }
                case 32: {
                    if (!string.equals("thread-request-execution-details")) break;
                    return 42;
                }
                case 20: {
                    if (!string.equals("unloaded-class-count")) break;
                    return 40;
                }
                case 6: {
                    if (!string.equals("uptime")) break;
                    return 31;
                }
                case 36: {
                    if (!string.equals("thread-contention-monitoring-enabled")) break;
                    return 14;
                }
                case 38: {
                    if (!string.equals("thread-contention-monitoring-supported")) break;
                    return 13;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getRootElementName() {
            return "jvm-runtime";
        }

        public String getElementName(int n) {
            switch (n) {
                case 30: {
                    return "boot-class-path";
                }
                case 28: {
                    return "class-path";
                }
                case 15: {
                    return "current-thread-cpu-time";
                }
                case 16: {
                    return "current-thread-user-time";
                }
                case 12: {
                    return "daemon-thread-count";
                }
                case 4: {
                    return "heap-memory-committed-bytes";
                }
                case 3: {
                    return "heap-memory-init-bytes";
                }
                case 2: {
                    return "heap-memory-max-bytes";
                }
                case 1: {
                    return "heap-memory-used-bytes";
                }
                case 29: {
                    return "library-path";
                }
                case 38: {
                    return "loaded-class-count";
                }
                case 21: {
                    return "management-spec-version";
                }
                case 8: {
                    return "non-heap-memory-committed-bytes";
                }
                case 7: {
                    return "non-heap-memory-init-bytes";
                }
                case 6: {
                    return "non-heap-memory-max-bytes";
                }
                case 5: {
                    return "non-heap-memory-used-bytes";
                }
                case 36: {
                    return "os-arch";
                }
                case 37: {
                    return "os-available-processors";
                }
                case 34: {
                    return "os-name";
                }
                case 35: {
                    return "os-version";
                }
                case 0: {
                    return "object-pending-finalization-count";
                }
                case 10: {
                    return "peak-thread-count";
                }
                case 20: {
                    return "running-jvm-name";
                }
                case 25: {
                    return "spec-name";
                }
                case 26: {
                    return "spec-vendor";
                }
                case 27: {
                    return "spec-version";
                }
                case 32: {
                    return "start-time";
                }
                case 9: {
                    return "thread-count";
                }
                case 41: {
                    return "thread-dump";
                }
                case 42: {
                    return "thread-request-execution-details";
                }
                case 39: {
                    return "total-loaded-class-count";
                }
                case 11: {
                    return "total-started-thread-count";
                }
                case 40: {
                    return "unloaded-class-count";
                }
                case 31: {
                    return "uptime";
                }
                case 22: {
                    return "vm-name";
                }
                case 23: {
                    return "vm-vendor";
                }
                case 24: {
                    return "vm-version";
                }
                case 33: {
                    return "boot-class-path-supported";
                }
                case 18: {
                    return "current-thread-cpu-time-supported";
                }
                case 14: {
                    return "thread-contention-monitoring-enabled";
                }
                case 13: {
                    return "thread-contention-monitoring-supported";
                }
                case 19: {
                    return "thread-cpu-time-enabled";
                }
                case 17: {
                    return "thread-cpu-time-supported";
                }
            }
            return super.getElementName(n);
        }
    }

    protected static class Helper
    extends AbstractDescriptorBeanHelper {
        private JVMRuntimeBeanImpl bean;

        protected Helper(JVMRuntimeBeanImpl jVMRuntimeBeanImpl) {
            super((AbstractDescriptorBean)jVMRuntimeBeanImpl);
            this.bean = jVMRuntimeBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 30: {
                    return "BootClassPath";
                }
                case 28: {
                    return "ClassPath";
                }
                case 15: {
                    return "CurrentThreadCpuTime";
                }
                case 16: {
                    return "CurrentThreadUserTime";
                }
                case 12: {
                    return "DaemonThreadCount";
                }
                case 4: {
                    return "HeapMemoryCommittedBytes";
                }
                case 3: {
                    return "HeapMemoryInitBytes";
                }
                case 2: {
                    return "HeapMemoryMaxBytes";
                }
                case 1: {
                    return "HeapMemoryUsedBytes";
                }
                case 29: {
                    return "LibraryPath";
                }
                case 38: {
                    return "LoadedClassCount";
                }
                case 21: {
                    return "ManagementSpecVersion";
                }
                case 8: {
                    return "NonHeapMemoryCommittedBytes";
                }
                case 7: {
                    return "NonHeapMemoryInitBytes";
                }
                case 6: {
                    return "NonHeapMemoryMaxBytes";
                }
                case 5: {
                    return "NonHeapMemoryUsedBytes";
                }
                case 36: {
                    return "OSArch";
                }
                case 37: {
                    return "OSAvailableProcessors";
                }
                case 34: {
                    return "OSName";
                }
                case 35: {
                    return "OSVersion";
                }
                case 0: {
                    return "ObjectPendingFinalizationCount";
                }
                case 10: {
                    return "PeakThreadCount";
                }
                case 20: {
                    return "RunningJVMName";
                }
                case 25: {
                    return "SpecName";
                }
                case 26: {
                    return "SpecVendor";
                }
                case 27: {
                    return "SpecVersion";
                }
                case 32: {
                    return "StartTime";
                }
                case 9: {
                    return "ThreadCount";
                }
                case 41: {
                    return "ThreadDump";
                }
                case 42: {
                    return "ThreadRequestExecutionDetails";
                }
                case 39: {
                    return "TotalLoadedClassCount";
                }
                case 11: {
                    return "TotalStartedThreadCount";
                }
                case 40: {
                    return "UnloadedClassCount";
                }
                case 31: {
                    return "Uptime";
                }
                case 22: {
                    return "VmName";
                }
                case 23: {
                    return "VmVendor";
                }
                case 24: {
                    return "VmVersion";
                }
                case 33: {
                    return "BootClassPathSupported";
                }
                case 18: {
                    return "CurrentThreadCpuTimeSupported";
                }
                case 14: {
                    return "ThreadContentionMonitoringEnabled";
                }
                case 13: {
                    return "ThreadContentionMonitoringSupported";
                }
                case 19: {
                    return "ThreadCpuTimeEnabled";
                }
                case 17: {
                    return "ThreadCpuTimeSupported";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("BootClassPath")) {
                return 30;
            }
            if (string.equals("ClassPath")) {
                return 28;
            }
            if (string.equals("CurrentThreadCpuTime")) {
                return 15;
            }
            if (string.equals("CurrentThreadUserTime")) {
                return 16;
            }
            if (string.equals("DaemonThreadCount")) {
                return 12;
            }
            if (string.equals("HeapMemoryCommittedBytes")) {
                return 4;
            }
            if (string.equals("HeapMemoryInitBytes")) {
                return 3;
            }
            if (string.equals("HeapMemoryMaxBytes")) {
                return 2;
            }
            if (string.equals("HeapMemoryUsedBytes")) {
                return 1;
            }
            if (string.equals("LibraryPath")) {
                return 29;
            }
            if (string.equals("LoadedClassCount")) {
                return 38;
            }
            if (string.equals("ManagementSpecVersion")) {
                return 21;
            }
            if (string.equals("NonHeapMemoryCommittedBytes")) {
                return 8;
            }
            if (string.equals("NonHeapMemoryInitBytes")) {
                return 7;
            }
            if (string.equals("NonHeapMemoryMaxBytes")) {
                return 6;
            }
            if (string.equals("NonHeapMemoryUsedBytes")) {
                return 5;
            }
            if (string.equals("OSArch")) {
                return 36;
            }
            if (string.equals("OSAvailableProcessors")) {
                return 37;
            }
            if (string.equals("OSName")) {
                return 34;
            }
            if (string.equals("OSVersion")) {
                return 35;
            }
            if (string.equals("ObjectPendingFinalizationCount")) {
                return 0;
            }
            if (string.equals("PeakThreadCount")) {
                return 10;
            }
            if (string.equals("RunningJVMName")) {
                return 20;
            }
            if (string.equals("SpecName")) {
                return 25;
            }
            if (string.equals("SpecVendor")) {
                return 26;
            }
            if (string.equals("SpecVersion")) {
                return 27;
            }
            if (string.equals("StartTime")) {
                return 32;
            }
            if (string.equals("ThreadCount")) {
                return 9;
            }
            if (string.equals("ThreadDump")) {
                return 41;
            }
            if (string.equals("ThreadRequestExecutionDetails")) {
                return 42;
            }
            if (string.equals("TotalLoadedClassCount")) {
                return 39;
            }
            if (string.equals("TotalStartedThreadCount")) {
                return 11;
            }
            if (string.equals("UnloadedClassCount")) {
                return 40;
            }
            if (string.equals("Uptime")) {
                return 31;
            }
            if (string.equals("VmName")) {
                return 22;
            }
            if (string.equals("VmVendor")) {
                return 23;
            }
            if (string.equals("VmVersion")) {
                return 24;
            }
            if (string.equals("BootClassPathSupported")) {
                return 33;
            }
            if (string.equals("CurrentThreadCpuTimeSupported")) {
                return 18;
            }
            if (string.equals("ThreadContentionMonitoringEnabled")) {
                return 14;
            }
            if (string.equals("ThreadContentionMonitoringSupported")) {
                return 13;
            }
            if (string.equals("ThreadCpuTimeEnabled")) {
                return 19;
            }
            if (string.equals("ThreadCpuTimeSupported")) {
                return 17;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isBootClassPathSet()) {
                    stringBuffer.append("BootClassPath");
                    stringBuffer.append(String.valueOf(this.bean.getBootClassPath()));
                }
                if (this.bean.isClassPathSet()) {
                    stringBuffer.append("ClassPath");
                    stringBuffer.append(String.valueOf(this.bean.getClassPath()));
                }
                if (this.bean.isCurrentThreadCpuTimeSet()) {
                    stringBuffer.append("CurrentThreadCpuTime");
                    stringBuffer.append(String.valueOf(this.bean.getCurrentThreadCpuTime()));
                }
                if (this.bean.isCurrentThreadUserTimeSet()) {
                    stringBuffer.append("CurrentThreadUserTime");
                    stringBuffer.append(String.valueOf(this.bean.getCurrentThreadUserTime()));
                }
                if (this.bean.isDaemonThreadCountSet()) {
                    stringBuffer.append("DaemonThreadCount");
                    stringBuffer.append(String.valueOf(this.bean.getDaemonThreadCount()));
                }
                if (this.bean.isHeapMemoryCommittedBytesSet()) {
                    stringBuffer.append("HeapMemoryCommittedBytes");
                    stringBuffer.append(String.valueOf(this.bean.getHeapMemoryCommittedBytes()));
                }
                if (this.bean.isHeapMemoryInitBytesSet()) {
                    stringBuffer.append("HeapMemoryInitBytes");
                    stringBuffer.append(String.valueOf(this.bean.getHeapMemoryInitBytes()));
                }
                if (this.bean.isHeapMemoryMaxBytesSet()) {
                    stringBuffer.append("HeapMemoryMaxBytes");
                    stringBuffer.append(String.valueOf(this.bean.getHeapMemoryMaxBytes()));
                }
                if (this.bean.isHeapMemoryUsedBytesSet()) {
                    stringBuffer.append("HeapMemoryUsedBytes");
                    stringBuffer.append(String.valueOf(this.bean.getHeapMemoryUsedBytes()));
                }
                if (this.bean.isLibraryPathSet()) {
                    stringBuffer.append("LibraryPath");
                    stringBuffer.append(String.valueOf(this.bean.getLibraryPath()));
                }
                if (this.bean.isLoadedClassCountSet()) {
                    stringBuffer.append("LoadedClassCount");
                    stringBuffer.append(String.valueOf(this.bean.getLoadedClassCount()));
                }
                if (this.bean.isManagementSpecVersionSet()) {
                    stringBuffer.append("ManagementSpecVersion");
                    stringBuffer.append(String.valueOf(this.bean.getManagementSpecVersion()));
                }
                if (this.bean.isNonHeapMemoryCommittedBytesSet()) {
                    stringBuffer.append("NonHeapMemoryCommittedBytes");
                    stringBuffer.append(String.valueOf(this.bean.getNonHeapMemoryCommittedBytes()));
                }
                if (this.bean.isNonHeapMemoryInitBytesSet()) {
                    stringBuffer.append("NonHeapMemoryInitBytes");
                    stringBuffer.append(String.valueOf(this.bean.getNonHeapMemoryInitBytes()));
                }
                if (this.bean.isNonHeapMemoryMaxBytesSet()) {
                    stringBuffer.append("NonHeapMemoryMaxBytes");
                    stringBuffer.append(String.valueOf(this.bean.getNonHeapMemoryMaxBytes()));
                }
                if (this.bean.isNonHeapMemoryUsedBytesSet()) {
                    stringBuffer.append("NonHeapMemoryUsedBytes");
                    stringBuffer.append(String.valueOf(this.bean.getNonHeapMemoryUsedBytes()));
                }
                if (this.bean.isOSArchSet()) {
                    stringBuffer.append("OSArch");
                    stringBuffer.append(String.valueOf(this.bean.getOSArch()));
                }
                if (this.bean.isOSAvailableProcessorsSet()) {
                    stringBuffer.append("OSAvailableProcessors");
                    stringBuffer.append(String.valueOf(this.bean.getOSAvailableProcessors()));
                }
                if (this.bean.isOSNameSet()) {
                    stringBuffer.append("OSName");
                    stringBuffer.append(String.valueOf(this.bean.getOSName()));
                }
                if (this.bean.isOSVersionSet()) {
                    stringBuffer.append("OSVersion");
                    stringBuffer.append(String.valueOf(this.bean.getOSVersion()));
                }
                if (this.bean.isObjectPendingFinalizationCountSet()) {
                    stringBuffer.append("ObjectPendingFinalizationCount");
                    stringBuffer.append(String.valueOf(this.bean.getObjectPendingFinalizationCount()));
                }
                if (this.bean.isPeakThreadCountSet()) {
                    stringBuffer.append("PeakThreadCount");
                    stringBuffer.append(String.valueOf(this.bean.getPeakThreadCount()));
                }
                if (this.bean.isRunningJVMNameSet()) {
                    stringBuffer.append("RunningJVMName");
                    stringBuffer.append(String.valueOf(this.bean.getRunningJVMName()));
                }
                if (this.bean.isSpecNameSet()) {
                    stringBuffer.append("SpecName");
                    stringBuffer.append(String.valueOf(this.bean.getSpecName()));
                }
                if (this.bean.isSpecVendorSet()) {
                    stringBuffer.append("SpecVendor");
                    stringBuffer.append(String.valueOf(this.bean.getSpecVendor()));
                }
                if (this.bean.isSpecVersionSet()) {
                    stringBuffer.append("SpecVersion");
                    stringBuffer.append(String.valueOf(this.bean.getSpecVersion()));
                }
                if (this.bean.isStartTimeSet()) {
                    stringBuffer.append("StartTime");
                    stringBuffer.append(String.valueOf(this.bean.getStartTime()));
                }
                if (this.bean.isThreadCountSet()) {
                    stringBuffer.append("ThreadCount");
                    stringBuffer.append(String.valueOf(this.bean.getThreadCount()));
                }
                if (this.bean.isThreadDumpSet()) {
                    stringBuffer.append("ThreadDump");
                    stringBuffer.append(String.valueOf(this.bean.getThreadDump()));
                }
                if (this.bean.isThreadRequestExecutionDetailsSet()) {
                    stringBuffer.append("ThreadRequestExecutionDetails");
                    stringBuffer.append(String.valueOf(this.bean.getThreadRequestExecutionDetails()));
                }
                if (this.bean.isTotalLoadedClassCountSet()) {
                    stringBuffer.append("TotalLoadedClassCount");
                    stringBuffer.append(String.valueOf(this.bean.getTotalLoadedClassCount()));
                }
                if (this.bean.isTotalStartedThreadCountSet()) {
                    stringBuffer.append("TotalStartedThreadCount");
                    stringBuffer.append(String.valueOf(this.bean.getTotalStartedThreadCount()));
                }
                if (this.bean.isUnloadedClassCountSet()) {
                    stringBuffer.append("UnloadedClassCount");
                    stringBuffer.append(String.valueOf(this.bean.getUnloadedClassCount()));
                }
                if (this.bean.isUptimeSet()) {
                    stringBuffer.append("Uptime");
                    stringBuffer.append(String.valueOf(this.bean.getUptime()));
                }
                if (this.bean.isVmNameSet()) {
                    stringBuffer.append("VmName");
                    stringBuffer.append(String.valueOf(this.bean.getVmName()));
                }
                if (this.bean.isVmVendorSet()) {
                    stringBuffer.append("VmVendor");
                    stringBuffer.append(String.valueOf(this.bean.getVmVendor()));
                }
                if (this.bean.isVmVersionSet()) {
                    stringBuffer.append("VmVersion");
                    stringBuffer.append(String.valueOf(this.bean.getVmVersion()));
                }
                if (this.bean.isBootClassPathSupportedSet()) {
                    stringBuffer.append("BootClassPathSupported");
                    stringBuffer.append(String.valueOf(this.bean.isBootClassPathSupported()));
                }
                if (this.bean.isCurrentThreadCpuTimeSupportedSet()) {
                    stringBuffer.append("CurrentThreadCpuTimeSupported");
                    stringBuffer.append(String.valueOf(this.bean.isCurrentThreadCpuTimeSupported()));
                }
                if (this.bean.isThreadContentionMonitoringEnabledSet()) {
                    stringBuffer.append("ThreadContentionMonitoringEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isThreadContentionMonitoringEnabled()));
                }
                if (this.bean.isThreadContentionMonitoringSupportedSet()) {
                    stringBuffer.append("ThreadContentionMonitoringSupported");
                    stringBuffer.append(String.valueOf(this.bean.isThreadContentionMonitoringSupported()));
                }
                if (this.bean.isThreadCpuTimeEnabledSet()) {
                    stringBuffer.append("ThreadCpuTimeEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isThreadCpuTimeEnabled()));
                }
                if (this.bean.isThreadCpuTimeSupportedSet()) {
                    stringBuffer.append("ThreadCpuTimeSupported");
                    stringBuffer.append(String.valueOf(this.bean.isThreadCpuTimeSupported()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                JVMRuntimeBeanImpl jVMRuntimeBeanImpl = (JVMRuntimeBeanImpl)abstractDescriptorBean;
                this.computeDiff("BootClassPath", this.bean.getBootClassPath(), jVMRuntimeBeanImpl.getBootClassPath(), false);
                this.computeDiff("ClassPath", this.bean.getClassPath(), jVMRuntimeBeanImpl.getClassPath(), false);
                this.computeDiff("CurrentThreadCpuTime", this.bean.getCurrentThreadCpuTime(), jVMRuntimeBeanImpl.getCurrentThreadCpuTime(), false);
                this.computeDiff("CurrentThreadUserTime", this.bean.getCurrentThreadUserTime(), jVMRuntimeBeanImpl.getCurrentThreadUserTime(), false);
                this.computeDiff("DaemonThreadCount", this.bean.getDaemonThreadCount(), jVMRuntimeBeanImpl.getDaemonThreadCount(), false);
                this.computeDiff("HeapMemoryCommittedBytes", this.bean.getHeapMemoryCommittedBytes(), jVMRuntimeBeanImpl.getHeapMemoryCommittedBytes(), false);
                this.computeDiff("HeapMemoryInitBytes", this.bean.getHeapMemoryInitBytes(), jVMRuntimeBeanImpl.getHeapMemoryInitBytes(), false);
                this.computeDiff("HeapMemoryMaxBytes", this.bean.getHeapMemoryMaxBytes(), jVMRuntimeBeanImpl.getHeapMemoryMaxBytes(), false);
                this.computeDiff("HeapMemoryUsedBytes", this.bean.getHeapMemoryUsedBytes(), jVMRuntimeBeanImpl.getHeapMemoryUsedBytes(), false);
                this.computeDiff("LibraryPath", this.bean.getLibraryPath(), jVMRuntimeBeanImpl.getLibraryPath(), false);
                this.computeDiff("LoadedClassCount", this.bean.getLoadedClassCount(), jVMRuntimeBeanImpl.getLoadedClassCount(), false);
                this.computeDiff("ManagementSpecVersion", this.bean.getManagementSpecVersion(), jVMRuntimeBeanImpl.getManagementSpecVersion(), false);
                this.computeDiff("NonHeapMemoryCommittedBytes", this.bean.getNonHeapMemoryCommittedBytes(), jVMRuntimeBeanImpl.getNonHeapMemoryCommittedBytes(), false);
                this.computeDiff("NonHeapMemoryInitBytes", this.bean.getNonHeapMemoryInitBytes(), jVMRuntimeBeanImpl.getNonHeapMemoryInitBytes(), false);
                this.computeDiff("NonHeapMemoryMaxBytes", this.bean.getNonHeapMemoryMaxBytes(), jVMRuntimeBeanImpl.getNonHeapMemoryMaxBytes(), false);
                this.computeDiff("NonHeapMemoryUsedBytes", this.bean.getNonHeapMemoryUsedBytes(), jVMRuntimeBeanImpl.getNonHeapMemoryUsedBytes(), false);
                this.computeDiff("OSArch", this.bean.getOSArch(), jVMRuntimeBeanImpl.getOSArch(), false);
                this.computeDiff("OSAvailableProcessors", this.bean.getOSAvailableProcessors(), jVMRuntimeBeanImpl.getOSAvailableProcessors(), false);
                this.computeDiff("OSName", this.bean.getOSName(), jVMRuntimeBeanImpl.getOSName(), false);
                this.computeDiff("OSVersion", this.bean.getOSVersion(), jVMRuntimeBeanImpl.getOSVersion(), false);
                this.computeDiff("ObjectPendingFinalizationCount", this.bean.getObjectPendingFinalizationCount(), jVMRuntimeBeanImpl.getObjectPendingFinalizationCount(), false);
                this.computeDiff("PeakThreadCount", this.bean.getPeakThreadCount(), jVMRuntimeBeanImpl.getPeakThreadCount(), false);
                this.computeDiff("RunningJVMName", this.bean.getRunningJVMName(), jVMRuntimeBeanImpl.getRunningJVMName(), false);
                this.computeDiff("SpecName", this.bean.getSpecName(), jVMRuntimeBeanImpl.getSpecName(), false);
                this.computeDiff("SpecVendor", this.bean.getSpecVendor(), jVMRuntimeBeanImpl.getSpecVendor(), false);
                this.computeDiff("SpecVersion", this.bean.getSpecVersion(), jVMRuntimeBeanImpl.getSpecVersion(), false);
                this.computeDiff("StartTime", this.bean.getStartTime(), jVMRuntimeBeanImpl.getStartTime(), false);
                this.computeDiff("ThreadCount", this.bean.getThreadCount(), jVMRuntimeBeanImpl.getThreadCount(), false);
                this.computeDiff("ThreadDump", this.bean.getThreadDump(), jVMRuntimeBeanImpl.getThreadDump(), false);
                this.computeDiff("ThreadRequestExecutionDetails", this.bean.getThreadRequestExecutionDetails(), jVMRuntimeBeanImpl.getThreadRequestExecutionDetails(), false);
                this.computeDiff("TotalLoadedClassCount", this.bean.getTotalLoadedClassCount(), jVMRuntimeBeanImpl.getTotalLoadedClassCount(), false);
                this.computeDiff("TotalStartedThreadCount", this.bean.getTotalStartedThreadCount(), jVMRuntimeBeanImpl.getTotalStartedThreadCount(), false);
                this.computeDiff("UnloadedClassCount", this.bean.getUnloadedClassCount(), jVMRuntimeBeanImpl.getUnloadedClassCount(), false);
                this.computeDiff("Uptime", this.bean.getUptime(), jVMRuntimeBeanImpl.getUptime(), false);
                this.computeDiff("VmName", this.bean.getVmName(), jVMRuntimeBeanImpl.getVmName(), false);
                this.computeDiff("VmVendor", this.bean.getVmVendor(), jVMRuntimeBeanImpl.getVmVendor(), false);
                this.computeDiff("VmVersion", this.bean.getVmVersion(), jVMRuntimeBeanImpl.getVmVersion(), false);
                this.computeDiff("BootClassPathSupported", this.bean.isBootClassPathSupported(), jVMRuntimeBeanImpl.isBootClassPathSupported(), false);
                this.computeDiff("CurrentThreadCpuTimeSupported", this.bean.isCurrentThreadCpuTimeSupported(), jVMRuntimeBeanImpl.isCurrentThreadCpuTimeSupported(), false);
                this.computeDiff("ThreadContentionMonitoringEnabled", this.bean.isThreadContentionMonitoringEnabled(), jVMRuntimeBeanImpl.isThreadContentionMonitoringEnabled(), false);
                this.computeDiff("ThreadContentionMonitoringSupported", this.bean.isThreadContentionMonitoringSupported(), jVMRuntimeBeanImpl.isThreadContentionMonitoringSupported(), false);
                this.computeDiff("ThreadCpuTimeEnabled", this.bean.isThreadCpuTimeEnabled(), jVMRuntimeBeanImpl.isThreadCpuTimeEnabled(), false);
                this.computeDiff("ThreadCpuTimeSupported", this.bean.isThreadCpuTimeSupported(), jVMRuntimeBeanImpl.isThreadCpuTimeSupported(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                JVMRuntimeBeanImpl jVMRuntimeBeanImpl = (JVMRuntimeBeanImpl)beanUpdateEvent.getSourceBean();
                JVMRuntimeBeanImpl jVMRuntimeBeanImpl2 = (JVMRuntimeBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("BootClassPath")) {
                    jVMRuntimeBeanImpl.setBootClassPath(jVMRuntimeBeanImpl2.getBootClassPath());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                } else if (string.equals("ClassPath")) {
                    jVMRuntimeBeanImpl.setClassPath(jVMRuntimeBeanImpl2.getClassPath());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                } else if (string.equals("CurrentThreadCpuTime")) {
                    jVMRuntimeBeanImpl.setCurrentThreadCpuTime(jVMRuntimeBeanImpl2.getCurrentThreadCpuTime());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("CurrentThreadUserTime")) {
                    jVMRuntimeBeanImpl.setCurrentThreadUserTime(jVMRuntimeBeanImpl2.getCurrentThreadUserTime());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("DaemonThreadCount")) {
                    jVMRuntimeBeanImpl.setDaemonThreadCount(jVMRuntimeBeanImpl2.getDaemonThreadCount());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("HeapMemoryCommittedBytes")) {
                    jVMRuntimeBeanImpl.setHeapMemoryCommittedBytes(jVMRuntimeBeanImpl2.getHeapMemoryCommittedBytes());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 4);
                } else if (string.equals("HeapMemoryInitBytes")) {
                    jVMRuntimeBeanImpl.setHeapMemoryInitBytes(jVMRuntimeBeanImpl2.getHeapMemoryInitBytes());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 3);
                } else if (string.equals("HeapMemoryMaxBytes")) {
                    jVMRuntimeBeanImpl.setHeapMemoryMaxBytes(jVMRuntimeBeanImpl2.getHeapMemoryMaxBytes());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("HeapMemoryUsedBytes")) {
                    jVMRuntimeBeanImpl.setHeapMemoryUsedBytes(jVMRuntimeBeanImpl2.getHeapMemoryUsedBytes());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 1);
                } else if (string.equals("LibraryPath")) {
                    jVMRuntimeBeanImpl.setLibraryPath(jVMRuntimeBeanImpl2.getLibraryPath());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                } else if (string.equals("LoadedClassCount")) {
                    jVMRuntimeBeanImpl.setLoadedClassCount(jVMRuntimeBeanImpl2.getLoadedClassCount());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 38);
                } else if (string.equals("ManagementSpecVersion")) {
                    jVMRuntimeBeanImpl.setManagementSpecVersion(jVMRuntimeBeanImpl2.getManagementSpecVersion());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("NonHeapMemoryCommittedBytes")) {
                    jVMRuntimeBeanImpl.setNonHeapMemoryCommittedBytes(jVMRuntimeBeanImpl2.getNonHeapMemoryCommittedBytes());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("NonHeapMemoryInitBytes")) {
                    jVMRuntimeBeanImpl.setNonHeapMemoryInitBytes(jVMRuntimeBeanImpl2.getNonHeapMemoryInitBytes());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("NonHeapMemoryMaxBytes")) {
                    jVMRuntimeBeanImpl.setNonHeapMemoryMaxBytes(jVMRuntimeBeanImpl2.getNonHeapMemoryMaxBytes());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 6);
                } else if (string.equals("NonHeapMemoryUsedBytes")) {
                    jVMRuntimeBeanImpl.setNonHeapMemoryUsedBytes(jVMRuntimeBeanImpl2.getNonHeapMemoryUsedBytes());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 5);
                } else if (string.equals("OSArch")) {
                    jVMRuntimeBeanImpl.setOSArch(jVMRuntimeBeanImpl2.getOSArch());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 36);
                } else if (string.equals("OSAvailableProcessors")) {
                    jVMRuntimeBeanImpl.setOSAvailableProcessors(jVMRuntimeBeanImpl2.getOSAvailableProcessors());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 37);
                } else if (string.equals("OSName")) {
                    jVMRuntimeBeanImpl.setOSName(jVMRuntimeBeanImpl2.getOSName());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 34);
                } else if (string.equals("OSVersion")) {
                    jVMRuntimeBeanImpl.setOSVersion(jVMRuntimeBeanImpl2.getOSVersion());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 35);
                } else if (string.equals("ObjectPendingFinalizationCount")) {
                    jVMRuntimeBeanImpl.setObjectPendingFinalizationCount(jVMRuntimeBeanImpl2.getObjectPendingFinalizationCount());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 0);
                } else if (string.equals("PeakThreadCount")) {
                    jVMRuntimeBeanImpl.setPeakThreadCount(jVMRuntimeBeanImpl2.getPeakThreadCount());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("RunningJVMName")) {
                    jVMRuntimeBeanImpl.setRunningJVMName(jVMRuntimeBeanImpl2.getRunningJVMName());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("SpecName")) {
                    jVMRuntimeBeanImpl.setSpecName(jVMRuntimeBeanImpl2.getSpecName());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("SpecVendor")) {
                    jVMRuntimeBeanImpl.setSpecVendor(jVMRuntimeBeanImpl2.getSpecVendor());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                } else if (string.equals("SpecVersion")) {
                    jVMRuntimeBeanImpl.setSpecVersion(jVMRuntimeBeanImpl2.getSpecVersion());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                } else if (string.equals("StartTime")) {
                    jVMRuntimeBeanImpl.setStartTime(jVMRuntimeBeanImpl2.getStartTime());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                } else if (string.equals("ThreadCount")) {
                    jVMRuntimeBeanImpl.setThreadCount(jVMRuntimeBeanImpl2.getThreadCount());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("ThreadDump")) {
                    jVMRuntimeBeanImpl.setThreadDump(jVMRuntimeBeanImpl2.getThreadDump());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 41);
                } else if (string.equals("ThreadRequestExecutionDetails")) {
                    jVMRuntimeBeanImpl.setThreadRequestExecutionDetails(jVMRuntimeBeanImpl2.getThreadRequestExecutionDetails());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 42);
                } else if (string.equals("TotalLoadedClassCount")) {
                    jVMRuntimeBeanImpl.setTotalLoadedClassCount(jVMRuntimeBeanImpl2.getTotalLoadedClassCount());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 39);
                } else if (string.equals("TotalStartedThreadCount")) {
                    jVMRuntimeBeanImpl.setTotalStartedThreadCount(jVMRuntimeBeanImpl2.getTotalStartedThreadCount());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("UnloadedClassCount")) {
                    jVMRuntimeBeanImpl.setUnloadedClassCount(jVMRuntimeBeanImpl2.getUnloadedClassCount());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 40);
                } else if (string.equals("Uptime")) {
                    jVMRuntimeBeanImpl.setUptime(jVMRuntimeBeanImpl2.getUptime());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                } else if (string.equals("VmName")) {
                    jVMRuntimeBeanImpl.setVmName(jVMRuntimeBeanImpl2.getVmName());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("VmVendor")) {
                    jVMRuntimeBeanImpl.setVmVendor(jVMRuntimeBeanImpl2.getVmVendor());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("VmVersion")) {
                    jVMRuntimeBeanImpl.setVmVersion(jVMRuntimeBeanImpl2.getVmVersion());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("BootClassPathSupported")) {
                    jVMRuntimeBeanImpl.setBootClassPathSupported(jVMRuntimeBeanImpl2.isBootClassPathSupported());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                } else if (string.equals("CurrentThreadCpuTimeSupported")) {
                    jVMRuntimeBeanImpl.setCurrentThreadCpuTimeSupported(jVMRuntimeBeanImpl2.isCurrentThreadCpuTimeSupported());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("ThreadContentionMonitoringEnabled")) {
                    jVMRuntimeBeanImpl.setThreadContentionMonitoringEnabled(jVMRuntimeBeanImpl2.isThreadContentionMonitoringEnabled());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("ThreadContentionMonitoringSupported")) {
                    jVMRuntimeBeanImpl.setThreadContentionMonitoringSupported(jVMRuntimeBeanImpl2.isThreadContentionMonitoringSupported());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("ThreadCpuTimeEnabled")) {
                    jVMRuntimeBeanImpl.setThreadCpuTimeEnabled(jVMRuntimeBeanImpl2.isThreadCpuTimeEnabled());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("ThreadCpuTimeSupported")) {
                    jVMRuntimeBeanImpl.setThreadCpuTimeSupported(jVMRuntimeBeanImpl2.isThreadCpuTimeSupported());
                    jVMRuntimeBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                JVMRuntimeBeanImpl jVMRuntimeBeanImpl = (JVMRuntimeBeanImpl)abstractDescriptorBean;
                super.finishCopy((AbstractDescriptorBean)jVMRuntimeBeanImpl, bl, list);
                if ((list == null || !list.contains("BootClassPath")) && this.bean.isBootClassPathSet()) {
                    jVMRuntimeBeanImpl.setBootClassPath(this.bean.getBootClassPath());
                }
                if ((list == null || !list.contains("ClassPath")) && this.bean.isClassPathSet()) {
                    jVMRuntimeBeanImpl.setClassPath(this.bean.getClassPath());
                }
                if ((list == null || !list.contains("CurrentThreadCpuTime")) && this.bean.isCurrentThreadCpuTimeSet()) {
                    jVMRuntimeBeanImpl.setCurrentThreadCpuTime(this.bean.getCurrentThreadCpuTime());
                }
                if ((list == null || !list.contains("CurrentThreadUserTime")) && this.bean.isCurrentThreadUserTimeSet()) {
                    jVMRuntimeBeanImpl.setCurrentThreadUserTime(this.bean.getCurrentThreadUserTime());
                }
                if ((list == null || !list.contains("DaemonThreadCount")) && this.bean.isDaemonThreadCountSet()) {
                    jVMRuntimeBeanImpl.setDaemonThreadCount(this.bean.getDaemonThreadCount());
                }
                if ((list == null || !list.contains("HeapMemoryCommittedBytes")) && this.bean.isHeapMemoryCommittedBytesSet()) {
                    jVMRuntimeBeanImpl.setHeapMemoryCommittedBytes(this.bean.getHeapMemoryCommittedBytes());
                }
                if ((list == null || !list.contains("HeapMemoryInitBytes")) && this.bean.isHeapMemoryInitBytesSet()) {
                    jVMRuntimeBeanImpl.setHeapMemoryInitBytes(this.bean.getHeapMemoryInitBytes());
                }
                if ((list == null || !list.contains("HeapMemoryMaxBytes")) && this.bean.isHeapMemoryMaxBytesSet()) {
                    jVMRuntimeBeanImpl.setHeapMemoryMaxBytes(this.bean.getHeapMemoryMaxBytes());
                }
                if ((list == null || !list.contains("HeapMemoryUsedBytes")) && this.bean.isHeapMemoryUsedBytesSet()) {
                    jVMRuntimeBeanImpl.setHeapMemoryUsedBytes(this.bean.getHeapMemoryUsedBytes());
                }
                if ((list == null || !list.contains("LibraryPath")) && this.bean.isLibraryPathSet()) {
                    jVMRuntimeBeanImpl.setLibraryPath(this.bean.getLibraryPath());
                }
                if ((list == null || !list.contains("LoadedClassCount")) && this.bean.isLoadedClassCountSet()) {
                    jVMRuntimeBeanImpl.setLoadedClassCount(this.bean.getLoadedClassCount());
                }
                if ((list == null || !list.contains("ManagementSpecVersion")) && this.bean.isManagementSpecVersionSet()) {
                    jVMRuntimeBeanImpl.setManagementSpecVersion(this.bean.getManagementSpecVersion());
                }
                if ((list == null || !list.contains("NonHeapMemoryCommittedBytes")) && this.bean.isNonHeapMemoryCommittedBytesSet()) {
                    jVMRuntimeBeanImpl.setNonHeapMemoryCommittedBytes(this.bean.getNonHeapMemoryCommittedBytes());
                }
                if ((list == null || !list.contains("NonHeapMemoryInitBytes")) && this.bean.isNonHeapMemoryInitBytesSet()) {
                    jVMRuntimeBeanImpl.setNonHeapMemoryInitBytes(this.bean.getNonHeapMemoryInitBytes());
                }
                if ((list == null || !list.contains("NonHeapMemoryMaxBytes")) && this.bean.isNonHeapMemoryMaxBytesSet()) {
                    jVMRuntimeBeanImpl.setNonHeapMemoryMaxBytes(this.bean.getNonHeapMemoryMaxBytes());
                }
                if ((list == null || !list.contains("NonHeapMemoryUsedBytes")) && this.bean.isNonHeapMemoryUsedBytesSet()) {
                    jVMRuntimeBeanImpl.setNonHeapMemoryUsedBytes(this.bean.getNonHeapMemoryUsedBytes());
                }
                if ((list == null || !list.contains("OSArch")) && this.bean.isOSArchSet()) {
                    jVMRuntimeBeanImpl.setOSArch(this.bean.getOSArch());
                }
                if ((list == null || !list.contains("OSAvailableProcessors")) && this.bean.isOSAvailableProcessorsSet()) {
                    jVMRuntimeBeanImpl.setOSAvailableProcessors(this.bean.getOSAvailableProcessors());
                }
                if ((list == null || !list.contains("OSName")) && this.bean.isOSNameSet()) {
                    jVMRuntimeBeanImpl.setOSName(this.bean.getOSName());
                }
                if ((list == null || !list.contains("OSVersion")) && this.bean.isOSVersionSet()) {
                    jVMRuntimeBeanImpl.setOSVersion(this.bean.getOSVersion());
                }
                if ((list == null || !list.contains("ObjectPendingFinalizationCount")) && this.bean.isObjectPendingFinalizationCountSet()) {
                    jVMRuntimeBeanImpl.setObjectPendingFinalizationCount(this.bean.getObjectPendingFinalizationCount());
                }
                if ((list == null || !list.contains("PeakThreadCount")) && this.bean.isPeakThreadCountSet()) {
                    jVMRuntimeBeanImpl.setPeakThreadCount(this.bean.getPeakThreadCount());
                }
                if ((list == null || !list.contains("RunningJVMName")) && this.bean.isRunningJVMNameSet()) {
                    jVMRuntimeBeanImpl.setRunningJVMName(this.bean.getRunningJVMName());
                }
                if ((list == null || !list.contains("SpecName")) && this.bean.isSpecNameSet()) {
                    jVMRuntimeBeanImpl.setSpecName(this.bean.getSpecName());
                }
                if ((list == null || !list.contains("SpecVendor")) && this.bean.isSpecVendorSet()) {
                    jVMRuntimeBeanImpl.setSpecVendor(this.bean.getSpecVendor());
                }
                if ((list == null || !list.contains("SpecVersion")) && this.bean.isSpecVersionSet()) {
                    jVMRuntimeBeanImpl.setSpecVersion(this.bean.getSpecVersion());
                }
                if ((list == null || !list.contains("StartTime")) && this.bean.isStartTimeSet()) {
                    jVMRuntimeBeanImpl.setStartTime(this.bean.getStartTime());
                }
                if ((list == null || !list.contains("ThreadCount")) && this.bean.isThreadCountSet()) {
                    jVMRuntimeBeanImpl.setThreadCount(this.bean.getThreadCount());
                }
                if ((list == null || !list.contains("ThreadDump")) && this.bean.isThreadDumpSet()) {
                    jVMRuntimeBeanImpl.setThreadDump(this.bean.getThreadDump());
                }
                if ((list == null || !list.contains("ThreadRequestExecutionDetails")) && this.bean.isThreadRequestExecutionDetailsSet()) {
                    jVMRuntimeBeanImpl.setThreadRequestExecutionDetails(this.bean.getThreadRequestExecutionDetails());
                }
                if ((list == null || !list.contains("TotalLoadedClassCount")) && this.bean.isTotalLoadedClassCountSet()) {
                    jVMRuntimeBeanImpl.setTotalLoadedClassCount(this.bean.getTotalLoadedClassCount());
                }
                if ((list == null || !list.contains("TotalStartedThreadCount")) && this.bean.isTotalStartedThreadCountSet()) {
                    jVMRuntimeBeanImpl.setTotalStartedThreadCount(this.bean.getTotalStartedThreadCount());
                }
                if ((list == null || !list.contains("UnloadedClassCount")) && this.bean.isUnloadedClassCountSet()) {
                    jVMRuntimeBeanImpl.setUnloadedClassCount(this.bean.getUnloadedClassCount());
                }
                if ((list == null || !list.contains("Uptime")) && this.bean.isUptimeSet()) {
                    jVMRuntimeBeanImpl.setUptime(this.bean.getUptime());
                }
                if ((list == null || !list.contains("VmName")) && this.bean.isVmNameSet()) {
                    jVMRuntimeBeanImpl.setVmName(this.bean.getVmName());
                }
                if ((list == null || !list.contains("VmVendor")) && this.bean.isVmVendorSet()) {
                    jVMRuntimeBeanImpl.setVmVendor(this.bean.getVmVendor());
                }
                if ((list == null || !list.contains("VmVersion")) && this.bean.isVmVersionSet()) {
                    jVMRuntimeBeanImpl.setVmVersion(this.bean.getVmVersion());
                }
                if ((list == null || !list.contains("BootClassPathSupported")) && this.bean.isBootClassPathSupportedSet()) {
                    jVMRuntimeBeanImpl.setBootClassPathSupported(this.bean.isBootClassPathSupported());
                }
                if ((list == null || !list.contains("CurrentThreadCpuTimeSupported")) && this.bean.isCurrentThreadCpuTimeSupportedSet()) {
                    jVMRuntimeBeanImpl.setCurrentThreadCpuTimeSupported(this.bean.isCurrentThreadCpuTimeSupported());
                }
                if ((list == null || !list.contains("ThreadContentionMonitoringEnabled")) && this.bean.isThreadContentionMonitoringEnabledSet()) {
                    jVMRuntimeBeanImpl.setThreadContentionMonitoringEnabled(this.bean.isThreadContentionMonitoringEnabled());
                }
                if ((list == null || !list.contains("ThreadContentionMonitoringSupported")) && this.bean.isThreadContentionMonitoringSupportedSet()) {
                    jVMRuntimeBeanImpl.setThreadContentionMonitoringSupported(this.bean.isThreadContentionMonitoringSupported());
                }
                if ((list == null || !list.contains("ThreadCpuTimeEnabled")) && this.bean.isThreadCpuTimeEnabledSet()) {
                    jVMRuntimeBeanImpl.setThreadCpuTimeEnabled(this.bean.isThreadCpuTimeEnabled());
                }
                if ((list == null || !list.contains("ThreadCpuTimeSupported")) && this.bean.isThreadCpuTimeSupportedSet()) {
                    jVMRuntimeBeanImpl.setThreadCpuTimeSupported(this.bean.isThreadCpuTimeSupported());
                }
                return jVMRuntimeBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

