/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.InstrumentationEvent;
import weblogic.diagnostics.instrumentation.JoinPoint;

public abstract class AbstractDiagnosticAction
implements DiagnosticAction {
    static final long serialVersionUID = 4064514881509087899L;
    private static final boolean noEventGen = Boolean.getBoolean("weblogic.diagnostics.internal.noEventGen");
    private DiagnosticMonitor monitor;
    private String type;

    public final String getType() {
        return this.type;
    }

    public final void setType(String string) {
        this.type = string;
    }

    public boolean requiresArgumentsCapture() {
        return false;
    }

    public void setDiagnosticMonitor(DiagnosticMonitor diagnosticMonitor) {
        this.monitor = diagnosticMonitor;
    }

    public DiagnosticMonitor getDiagnosticMonitor() {
        return this.monitor;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DiagnosticAction) {
            String string = ((DiagnosticAction)object).getType();
            return this.getType().equals(string);
        }
        return false;
    }

    protected InstrumentationEvent createInstrumentationEvent(JoinPoint joinPoint, boolean bl) {
        if (noEventGen) {
            return null;
        }
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        InstrumentationEvent instrumentationEvent = new InstrumentationEvent(this, joinPoint, bl);
        if (diagnosticContext != null) {
            instrumentationEvent.setContextId(diagnosticContext.getContextId());
        }
        return instrumentationEvent;
    }
}

