/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import weblogic.diagnostics.instrumentation.CustomMonitor;
import weblogic.diagnostics.instrumentation.DelegatingMonitorControl;
import weblogic.diagnostics.instrumentation.DiagnosticMonitorControl;
import weblogic.diagnostics.instrumentation.InstrumentationLibrary;
import weblogic.diagnostics.instrumentation.InvalidPointcutException;
import weblogic.diagnostics.instrumentation.engine.MonitorSpecification;

public class CustomMonitorControl
extends DelegatingMonitorControl
implements CustomMonitor {
    static final long serialVersionUID = -851465013676026651L;
    private String pointcutExpr;
    private MonitorSpecification monitorSpecification;

    public CustomMonitorControl(CustomMonitorControl customMonitorControl) {
        super(customMonitorControl);
        this.pointcutExpr = customMonitorControl.pointcutExpr;
        this.monitorSpecification = customMonitorControl.monitorSpecification;
    }

    public CustomMonitorControl(String string) {
        this("", string);
    }

    public CustomMonitorControl(String string, String string2) {
        super(string, string2);
    }

    public String[] getCompatibleActionTypes() {
        String[] stringArray = new String[]{};
        InstrumentationLibrary instrumentationLibrary = InstrumentationLibrary.getInstrumentationLibrary();
        switch (this.getLocationType()) {
            case 1: 
            case 2: {
                return instrumentationLibrary.getStatelessDiagnosticActionTypes();
            }
            case 3: {
                return instrumentationLibrary.getAroundDiagnosticActionTypes();
            }
        }
        return stringArray;
    }

    public String getPointcut() {
        return this.pointcutExpr;
    }

    public void setPointcut(String string) throws InvalidPointcutException {
        this.pointcutExpr = string;
    }

    void setMonitorSpecification(MonitorSpecification monitorSpecification) {
        this.monitorSpecification = monitorSpecification;
    }

    MonitorSpecification getMonitorSpecification() {
        return this.monitorSpecification;
    }

    public synchronized boolean merge(DiagnosticMonitorControl diagnosticMonitorControl) {
        boolean bl = false;
        if (super.merge(diagnosticMonitorControl) && diagnosticMonitorControl instanceof CustomMonitorControl) {
            CustomMonitorControl customMonitorControl = (CustomMonitorControl)diagnosticMonitorControl;
            this.pointcutExpr = customMonitorControl.pointcutExpr;
            this.monitorSpecification = customMonitorControl.monitorSpecification;
            bl = true;
        }
        return bl;
    }

    boolean isStructurallyDifferent(CustomMonitorControl customMonitorControl) {
        int n;
        if (this.pointcutExpr != null && !this.pointcutExpr.equals(customMonitorControl.pointcutExpr)) {
            return true;
        }
        if (customMonitorControl.pointcutExpr != null && !customMonitorControl.pointcutExpr.equals(this.pointcutExpr)) {
            return true;
        }
        int n2 = this.monitorSpecification != null ? this.monitorSpecification.getLocation() : -1;
        int n3 = n = customMonitorControl.monitorSpecification != null ? customMonitorControl.monitorSpecification.getLocation() : -1;
        return n2 != n;
    }
}

