/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.diagnostics.instrumentation.ActionNotFoundException;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticMonitorControl;
import weblogic.diagnostics.instrumentation.DuplicateActionException;
import weblogic.diagnostics.instrumentation.IncompatibleActionException;
import weblogic.diagnostics.instrumentation.InstrumentationDebug;
import weblogic.diagnostics.instrumentation.StandardMonitorControl;

public class DelegatingMonitorControl
extends StandardMonitorControl
implements DelegatingMonitor {
    static final long serialVersionUID = -3716624702862137600L;
    private List actionList;
    private int locationType;
    private String[] compatibleActionTypes;
    private static final DiagnosticAction[] EMPTY_ACTIONS_ARR = new DiagnosticAction[0];
    private volatile DiagnosticAction[] cachedActions;

    public DelegatingMonitorControl(DelegatingMonitorControl delegatingMonitorControl) {
        super(delegatingMonitorControl);
        this.setLocationType(delegatingMonitorControl.getLocationType());
        this.setCompatibleActionTypes(delegatingMonitorControl.getCompatibleActionTypes());
    }

    public DelegatingMonitorControl(String string) {
        this("", string);
    }

    public DelegatingMonitorControl(String string, String string2) {
        super(string, string2);
        this.actionList = null;
        this.cachedActions = EMPTY_ACTIONS_ARR;
    }

    public DiagnosticAction[] getActions() {
        return this.cachedActions;
    }

    private synchronized void computeCachedActions() {
        int n;
        DiagnosticAction[] diagnosticActionArray = EMPTY_ACTIONS_ARR;
        int n2 = n = this.actionList != null ? this.actionList.size() : 0;
        if (n > 0) {
            diagnosticActionArray = new DiagnosticAction[n];
            diagnosticActionArray = this.actionList.toArray(diagnosticActionArray);
        }
        this.cachedActions = diagnosticActionArray;
    }

    public String[] getCompatibleActionTypes() {
        return this.compatibleActionTypes;
    }

    public void setCompatibleActionTypes(String[] stringArray) {
        this.compatibleActionTypes = stringArray;
    }

    public int getLocationType() {
        return this.locationType;
    }

    public void setLocationType(int n) {
        this.locationType = n;
    }

    public synchronized void addAction(DiagnosticAction diagnosticAction) throws DuplicateActionException, IncompatibleActionException {
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("Adding action of type " + diagnosticAction.getType() + " to " + this.getName());
        }
        if (this.actionList == null) {
            this.actionList = new ArrayList();
        }
        if (this.actionList.contains(diagnosticAction)) {
            throw new DuplicateActionException("Action " + diagnosticAction + " already attached to " + this.getType());
        }
        String[] stringArray = this.getCompatibleActionTypes();
        int n = stringArray != null ? stringArray.length : 0;
        boolean bl = false;
        String string = diagnosticAction.getType();
        for (int i = 0; !bl && i < n; ++i) {
            if (!string.equals(stringArray[i])) continue;
            bl = true;
        }
        if (!bl) {
            throw new IncompatibleActionException("Attempt to use incompatible action type " + string + " with delegating monitor type " + this.getType());
        }
        this.actionList.add(diagnosticAction);
        if (diagnosticAction.requiresArgumentsCapture()) {
            if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
                InstrumentationDebug.DEBUG_CONFIG.debug("setting arguments capture flag to true");
            }
            this.argumentsCaptureNeeded = true;
        }
        diagnosticAction.setDiagnosticMonitor((DiagnosticMonitor)this);
        this.computeCachedActions();
    }

    public synchronized void removeAllActions() {
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("Removing all actions from " + this.getName());
        }
        if (this.actionList != null) {
            this.actionList.clear();
            this.actionList = null;
        }
        this.argumentsCaptureNeeded = false;
        this.computeCachedActions();
    }

    public synchronized void removeAction(DiagnosticAction diagnosticAction) throws ActionNotFoundException {
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("Removing action of type " + diagnosticAction.getType() + " from " + this.getName());
        }
        if (this.actionList == null || !this.actionList.contains(diagnosticAction)) {
            throw new ActionNotFoundException("Attempt to remove non-existent action " + diagnosticAction + " from " + this.getType());
        }
        this.actionList.remove(diagnosticAction);
        if (this.argumentsCaptureNeeded) {
            this.checkArgsCaptureNeeded();
        }
        this.computeCachedActions();
    }

    public synchronized boolean merge(DiagnosticMonitorControl diagnosticMonitorControl) {
        boolean bl = false;
        if (super.merge(diagnosticMonitorControl) && diagnosticMonitorControl instanceof DelegatingMonitorControl) {
            DelegatingMonitorControl delegatingMonitorControl = (DelegatingMonitorControl)diagnosticMonitorControl;
            this.actionList = delegatingMonitorControl.actionList;
            if (this.actionList != null) {
                for (DiagnosticAction diagnosticAction : this.actionList) {
                    diagnosticAction.setDiagnosticMonitor((DiagnosticMonitor)this);
                }
            }
            this.locationType = delegatingMonitorControl.locationType;
            this.checkArgsCaptureNeeded();
            bl = true;
            this.computeCachedActions();
        }
        return bl;
    }

    private void checkArgsCaptureNeeded() {
        if (this.actionList != null) {
            Iterator iterator = this.actionList.iterator();
            while (iterator.hasNext()) {
                if (!((DiagnosticAction)iterator.next()).requiresArgumentsCapture()) continue;
                this.argumentsCaptureNeeded = true;
                return;
            }
        }
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("setting arguments capture flag to false");
        }
        this.argumentsCaptureNeeded = false;
    }

    void subvertArgumentsCaptureNeededCheck() {
        this.argumentsCaptureNeeded = true;
    }
}

