/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import weblogic.diagnostics.instrumentation.InstrumentationManager;
import weblogic.diagnostics.instrumentation.InstrumentationScope;
import weblogic.diagnostics.instrumentation.engine.InstrumentationEngineConfiguration;
import weblogic.diagnostics.instrumentation.rtsupport.InstrumentationSupportImpl;
import weblogic.utils.classloaders.ClassPreProcessor;
import weblogic.utils.classloaders.GenericClassLoader;

public class DiagnosticClassPreProcessor
implements ClassPreProcessor {
    private Map classLoaderMap = new WeakHashMap();
    private InstrumentationManager manager = InstrumentationManager.getInstrumentationManager();
    private static final InstrumentationScopeBundle VOID_BUNDLE = new InstrumentationScopeBundle();
    private static final boolean DEBUG = false;

    public void initialize(Hashtable hashtable) {
    }

    public byte[] preProcess(String string, byte[] byArray) {
        byte[] byArray2;
        GenericClassLoader genericClassLoader;
        InstrumentationScope instrumentationScope;
        ClassLoader classLoader;
        ClassLoader classLoader2;
        if (!this.isEligibleClass(string)) {
            return byArray;
        }
        for (classLoader2 = classLoader = Thread.currentThread().getContextClassLoader(); classLoader2 != null && !(classLoader2 instanceof GenericClassLoader); classLoader2 = classLoader2.getParent()) {
        }
        if (classLoader2 == null) {
            return byArray;
        }
        if (classLoader2 instanceof GenericClassLoader && (instrumentationScope = this.getInstrumentationScope(genericClassLoader = (GenericClassLoader)classLoader2)) != null && (byArray2 = instrumentationScope.instrumentClass(classLoader, string, byArray)) != null) {
            byArray = byArray2;
        }
        return byArray;
    }

    public byte[] preProcess(GenericClassLoader genericClassLoader, String string, byte[] byArray) {
        byte[] byArray2;
        if (!this.isEligibleClass(string)) {
            return byArray;
        }
        InstrumentationScope instrumentationScope = this.getInstrumentationScope(genericClassLoader);
        if (instrumentationScope != null && (byArray2 = instrumentationScope.instrumentClass((ClassLoader)genericClassLoader, string, byArray)) != null) {
            byArray = byArray2;
        }
        return byArray;
    }

    private boolean isEligibleClass(String string) {
        if (!this.manager.isEnabled()) {
            return false;
        }
        if (string.startsWith("$Proxy")) {
            return false;
        }
        if (string.indexOf("_WLDF$INST_AUX_CLASS_") >= 0) {
            return false;
        }
        for (String string2 : ExcludedPackages.EXCLUDES.keySet()) {
            if (!string.startsWith(string2)) continue;
            boolean bl = false;
            Set set = ExcludedPackages.EXCLUDES.get(string2);
            for (String string3 : set) {
                if (!string.startsWith(string3)) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        InstrumentationEngineConfiguration instrumentationEngineConfiguration = InstrumentationEngineConfiguration.getInstrumentationEngineConfiguration();
        return instrumentationEngineConfiguration.isEligibleClass(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentationScope getInstrumentationScope(GenericClassLoader genericClassLoader) {
        Object object = null;
        Object object2 = this.classLoaderMap;
        synchronized (object2) {
            object = (InstrumentationScopeBundle)this.classLoaderMap.get(genericClassLoader);
        }
        if (object == null) {
            object2 = this.createBundle(genericClassLoader);
            Map map = this.classLoaderMap;
            synchronized (map) {
                object = (InstrumentationScopeBundle)this.classLoaderMap.get(genericClassLoader);
                if (object == null) {
                    object = object2;
                    this.classLoaderMap.put(genericClassLoader, object);
                }
            }
        }
        if (object == null) {
            return null;
        }
        return ((InstrumentationScopeBundle)object).scope;
    }

    private InstrumentationScopeBundle createBundle(GenericClassLoader genericClassLoader) {
        String string = InstrumentationSupportImpl.getInstrumentationScopeName((ClassLoader)genericClassLoader);
        if (string == null) {
            return VOID_BUNDLE;
        }
        InstrumentationScope instrumentationScope = this.manager.findInstrumentationScope(string);
        if (instrumentationScope == null) {
            return null;
        }
        this.manager.associateClassloaderWithScope((ClassLoader)genericClassLoader, instrumentationScope);
        InstrumentationScopeBundle instrumentationScopeBundle = new InstrumentationScopeBundle();
        instrumentationScopeBundle.scope = instrumentationScope;
        return instrumentationScopeBundle;
    }

    private static final class ExcludedPackages {
        static final Map<String, Set> EXCLUDES = new HashMap<String, Set>(){
            {
                this.put("java.", new HashSet());
                this.put("javax.", new HashSet<String>(){
                    {
                        this.add("javax.faces.");
                    }
                });
                this.put("schema.", new HashSet());
                this.put("com.bea.xbean.", new HashSet());
                this.put("com.bea.xml.", new HashSet());
                this.put("weblogic.xml.", new HashSet());
            }
        };

        private ExcludedPackages() {
        }
    }

    private static class InstrumentationScopeBundle {
        InstrumentationScope scope;

        private InstrumentationScopeBundle() {
        }
    }
}

