/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.io.Serializable;
import java.util.Properties;
import weblogic.diagnostics.context.DiagnosticContextManager;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.InstrumentationDebug;
import weblogic.diagnostics.instrumentation.InstrumentationScope;
import weblogic.diagnostics.instrumentation.rtsupport.InstrumentationSupportImpl;

public abstract class DiagnosticMonitorControl
implements DiagnosticMonitor,
Serializable,
Comparable {
    private InstrumentationScope instrumentationScope;
    private String name;
    private String description;
    private String type;
    private boolean allowServerScope;
    private boolean allowComponentScope;
    public boolean enabled;
    private boolean enableDyeFiltering;
    private long dye_mask;
    private String[] attributeNames;
    private Properties properties = new Properties();
    private String[] includes;
    private String[] excludes;
    public boolean argumentsCaptureNeeded = false;
    private boolean serverManaged = false;
    private String diagnosticVolume = null;
    private String eventClassName = null;
    private Class eventClass = null;

    public DiagnosticMonitorControl(DiagnosticMonitorControl diagnosticMonitorControl) {
        this(diagnosticMonitorControl.getType());
        this.allowServerScope = diagnosticMonitorControl.allowServerScope;
        this.allowComponentScope = diagnosticMonitorControl.allowComponentScope;
        this.attributeNames = diagnosticMonitorControl.attributeNames;
        this.serverManaged = diagnosticMonitorControl.serverManaged;
        this.diagnosticVolume = diagnosticMonitorControl.diagnosticVolume;
        this.eventClassName = diagnosticMonitorControl.eventClassName;
        this.resolveEventClass();
    }

    public DiagnosticMonitorControl(String string) {
        this("", string);
    }

    public DiagnosticMonitorControl(String string, String string2) {
        this.name = string;
        this.type = string2;
    }

    void setInstrumentationScope(InstrumentationScope instrumentationScope) {
        this.instrumentationScope = instrumentationScope;
    }

    public InstrumentationScope getInstrumentationScope() {
        return this.instrumentationScope;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getType() {
        return this.type;
    }

    public boolean isServerScopeAllowed() {
        return this.allowServerScope;
    }

    void setServerScopeAllowed(boolean bl) {
        this.allowServerScope = bl;
    }

    public boolean isComponentScopeAllowed() {
        return this.allowComponentScope;
    }

    void setComponentScopeAllowed(boolean bl) {
        this.allowComponentScope = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("DiagnosticMonitorControl.setEnabled " + this.getType() + " to " + bl);
        }
        this.enabled = bl;
    }

    public boolean isEnabledAndNotDyeFiltered() {
        if (!this.enabled) {
            return false;
        }
        if (!this.enableDyeFiltering) {
            return !this.serverManaged || DiagnosticContextManager.isJFRThrottled();
        }
        return InstrumentationSupportImpl.dyeMatches(this);
    }

    public boolean isArgumentsCaptureNeeded() {
        return this.argumentsCaptureNeeded;
    }

    public boolean isServerManaged() {
        return this.serverManaged;
    }

    public void setServerManaged(boolean bl) {
        this.serverManaged = bl;
    }

    public String getEventClassName() {
        return this.eventClassName;
    }

    public void setEventClassName(String string) {
        this.eventClassName = string;
    }

    public Class getEventClass() {
        return this.eventClass;
    }

    private void resolveEventClass() {
        block4: {
            if (this.eventClassName == null || this.eventClassName.length() == 0) {
                return;
            }
            try {
                this.eventClass = Class.forName(this.eventClassName);
                if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
                    InstrumentationDebug.DEBUG_CONFIG.debug("DiagnosticMonitorControl.resolveEventClass " + this.eventClassName + " resolved and is not pooled");
                }
            }
            catch (Exception exception) {
                if (!InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) break block4;
                InstrumentationDebug.DEBUG_CONFIG.debug("DiagnosticMonitorControl.resolveEventClass exception resolving " + this.eventClassName, (Throwable)exception);
            }
        }
    }

    public String getDiagnosticVolume() {
        return this.diagnosticVolume;
    }

    public void setDiagnosticVolume(String string) {
        this.diagnosticVolume = string;
    }

    public String[] getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(String[] stringArray) {
        this.attributeNames = stringArray;
    }

    public String getAttribute(String string) {
        String string2 = null;
        if (this.isValidAttributeName(string)) {
            string2 = this.properties.getProperty(string);
        }
        return string2;
    }

    public void setAttribute(String string, String string2) {
        if (this.isValidAttributeName(string)) {
            if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
                InstrumentationDebug.DEBUG_CONFIG.debug("DiagnosticMonitorControl.setAttribute " + this.getType() + " " + string + "=" + string2);
            }
            if (string2 == null) {
                this.properties.remove(string);
            } else {
                this.properties.setProperty(string, string2);
            }
        }
    }

    private boolean isValidAttributeName(String string) {
        int n = this.attributeNames != null ? this.attributeNames.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.attributeNames[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isDyeFilteringEnabled() {
        return this.enableDyeFiltering;
    }

    public void setDyeFilteringEnabled(boolean bl) {
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("DiagnosticMonitorControl.setDyeFilteringEnabled " + this.getType() + " to " + bl);
        }
        this.enableDyeFiltering = bl;
    }

    public long getDyeMask() {
        return this.dye_mask;
    }

    public void setDyeMask(long l) {
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("DiagnosticMonitorControl.setDyeMask " + this.getType() + " to " + l);
        }
        this.dye_mask = l;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] stringArray) {
        this.includes = stringArray;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] stringArray) {
        this.excludes = stringArray;
    }

    protected synchronized boolean merge(DiagnosticMonitorControl diagnosticMonitorControl) {
        boolean bl = false;
        if (diagnosticMonitorControl != null && this.type.equals(diagnosticMonitorControl.type)) {
            this.name = diagnosticMonitorControl.name;
            this.description = diagnosticMonitorControl.description;
            this.allowServerScope = diagnosticMonitorControl.allowServerScope;
            this.allowComponentScope = diagnosticMonitorControl.allowComponentScope;
            this.enabled = diagnosticMonitorControl.enabled;
            this.enableDyeFiltering = diagnosticMonitorControl.enableDyeFiltering;
            this.dye_mask = diagnosticMonitorControl.dye_mask;
            this.attributeNames = diagnosticMonitorControl.attributeNames;
            this.properties = diagnosticMonitorControl.properties;
            this.includes = diagnosticMonitorControl.includes;
            this.excludes = diagnosticMonitorControl.excludes;
            this.argumentsCaptureNeeded = diagnosticMonitorControl.argumentsCaptureNeeded;
            this.serverManaged = diagnosticMonitorControl.serverManaged;
            this.diagnosticVolume = diagnosticMonitorControl.diagnosticVolume;
            bl = true;
        }
        return bl;
    }

    public int compareTo(Object object) {
        DiagnosticMonitorControl diagnosticMonitorControl = (DiagnosticMonitorControl)object;
        return this.type.compareTo(diagnosticMonitorControl.type);
    }
}

