/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import weblogic.diagnostics.instrumentation.AbstractDiagnosticAction;
import weblogic.diagnostics.instrumentation.AroundDiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.EventQueue;
import weblogic.diagnostics.instrumentation.InstrumentationEvent;
import weblogic.diagnostics.instrumentation.JoinPoint;

public final class DisplayArgsReturnsActions
extends AbstractDiagnosticAction
implements AroundDiagnosticAction {
    public DisplayArgsReturnsActions() {
        this.setType("DisplayArgsReturnsActions");
    }

    public String[] getAttributeNames() {
        return null;
    }

    public DiagnosticActionState createState() {
        return new ArgsState();
    }

    public boolean requiresArgumentsCapture() {
        return true;
    }

    public void preProcess(JoinPoint joinPoint, DiagnosticActionState diagnosticActionState) {
        ArgsState argsState = (ArgsState)diagnosticActionState;
        argsState.setArguments(((DynamicJoinPoint)joinPoint).getArguments());
    }

    public void postProcess(JoinPoint joinPoint, DiagnosticActionState diagnosticActionState) {
        ArgsState argsState = (ArgsState)diagnosticActionState;
        InstrumentationEvent instrumentationEvent = this.createInstrumentationEvent(joinPoint, true);
        if (instrumentationEvent == null) {
            return;
        }
        EventQueue.getInstance().enqueue(instrumentationEvent);
    }

    class ArgsState
    implements DiagnosticActionState {
        private Object[] args;

        ArgsState() {
        }

        void setArguments(Object[] objectArray) {
            this.args = objectArray;
        }

        Object[] getArguments() {
            return this.args;
        }
    }
}

