/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.util.Map;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.GatheredArgument;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueRenderingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicJoinPointImpl
implements DynamicJoinPoint {
    private static DebugLogger debugLog = DebugLogger.getDebugLogger((String)"DebugDiagnosticDataGathering");
    private JoinPoint delegateJp;
    private String monitorType = null;
    private Object[] unrenderedArgs;
    private Object unrenderedRetVal;
    private boolean argumentsSensitive = false;

    public DynamicJoinPointImpl(JoinPoint joinPoint, Object[] objectArray, Object object) {
        this.delegateJp = joinPoint;
        this.argumentsSensitive = InstrumentationSupport.isSensitiveArray((Object[])objectArray);
        if (joinPoint.getPointcutHandlingInfoMap() == null) {
            String string;
            if (!this.argumentsSensitive) {
                this.unrenderedArgs = InstrumentationSupport.toSensitive((Object[])objectArray);
                this.argumentsSensitive = true;
            }
            this.unrenderedRetVal = (string = joinPoint.getMethodDescriptor()) != null && string.endsWith(")V") ? null : "*****";
        } else {
            this.unrenderedArgs = objectArray;
            this.unrenderedRetVal = object;
        }
    }

    public String getModuleName() {
        return this.delegateJp.getModuleName();
    }

    public String getSourceFile() {
        return this.delegateJp.getSourceFile();
    }

    public String getClassName() {
        return this.delegateJp.getClassName();
    }

    public String getMethodName() {
        return this.delegateJp.getMethodName();
    }

    public String getMethodDescriptor() {
        return this.delegateJp.getMethodDescriptor();
    }

    public int getLineNumber() {
        return this.delegateJp.getLineNumber();
    }

    public Object[] getArguments() {
        if (this.unrenderedArgs == null) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("DynamicJoinPointImpl.getArguments() for " + this.monitorType + " unrenderedArgs is null, return null");
            }
            return null;
        }
        if (this.argumentsSensitive) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("DynamicJoinPointImpl.getArguments() for " + this.monitorType + " handling info map is null, return pre-processed sensitive args");
            }
            return this.unrenderedArgs;
        }
        if (debugLog.isDebugEnabled()) {
            debugLog.debug("DynamicJoinPointImpl.getArguments() for " + this.monitorType + " render args for return using info map");
        }
        Map map = this.delegateJp.getPointcutHandlingInfoMap();
        return ValueRenderingManager.renderArgumentValues(this.monitorType, !this.delegateJp.isStatic(), this.unrenderedArgs, map);
    }

    public void setArguments(Object[] objectArray) {
        this.argumentsSensitive = InstrumentationSupport.isSensitiveArray((Object[])objectArray);
        if (!this.argumentsSensitive && this.delegateJp.getPointcutHandlingInfoMap() == null) {
            this.unrenderedArgs = InstrumentationSupport.toSensitive((Object[])objectArray);
            this.argumentsSensitive = true;
        } else {
            this.unrenderedArgs = objectArray;
        }
    }

    public Object getReturnValue() {
        if (this.unrenderedRetVal == null) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("DynamicJoinPointImpl.getReturnValue() for " + this.monitorType + " unrenderedRetVal is null, return null");
            }
            return null;
        }
        Map map = this.delegateJp.getPointcutHandlingInfoMap();
        if (map == null) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("DynamicJoinPointImpl.getReturnValue() for " + this.monitorType + " handling info map is null, return null");
            }
            return this.unrenderedRetVal;
        }
        if (debugLog.isDebugEnabled()) {
            debugLog.debug("DynamicJoinPointImpl.getReturnValue() for " + this.monitorType + " render return value and return");
        }
        return ValueRenderingManager.renderReturnValue(this.monitorType, this.unrenderedRetVal, map);
    }

    public void setReturnValue(Object object) {
        this.unrenderedRetVal = this.delegateJp.getPointcutHandlingInfoMap() == null ? "*****" : object;
    }

    public JoinPoint getDelegate() {
        return this.delegateJp;
    }

    public String toString() {
        return this.delegateJp.toString();
    }

    public GatheredArgument[] getGatheredArguments() {
        return this.delegateJp.getGatheredArguments(this.monitorType);
    }

    public boolean isReturnGathered() {
        return this.delegateJp.isReturnGathered(this.monitorType);
    }

    public GatheredArgument[] getGatheredArguments(String string) {
        return this.delegateJp.getGatheredArguments(string);
    }

    public boolean isReturnGathered(String string) {
        return this.delegateJp.isReturnGathered(string);
    }

    public Map<String, PointcutHandlingInfo> getPointcutHandlingInfoMap() {
        return this.delegateJp.getPointcutHandlingInfoMap();
    }

    public boolean isStatic() {
        return this.delegateJp.isStatic();
    }

    public void setMonitorType(String string) {
        if (debugLog.isDebugEnabled()) {
            debugLog.debug("DynamicJoinPointImpl.setMonitorType(" + string + ")");
        }
        this.monitorType = string;
    }
}

