/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import weblogic.diagnostics.accessor.DiagnosticAccessRuntime;
import weblogic.diagnostics.accessor.DiagnosticDataAccessRuntime;
import weblogic.diagnostics.archive.DataWriter;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.context.DiagnosticContextHelper;
import weblogic.diagnostics.context.InvalidDyeException;
import weblogic.diagnostics.instrumentation.EventDispatcher;
import weblogic.diagnostics.instrumentation.EventPayload;
import weblogic.diagnostics.instrumentation.InstrumentationConstants;
import weblogic.diagnostics.instrumentation.InstrumentationDebug;
import weblogic.diagnostics.instrumentation.InstrumentationEvent;
import weblogic.diagnostics.instrumentation.InstrumentationManager;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManager;
import weblogic.timers.TimerManagerFactory;

public final class EventQueue
implements TimerListener,
InstrumentationConstants,
EventDispatcher {
    private static EventQueue singleton;
    private static final String WORK_MANAGER_NAME = "InstrumentationEvents";
    private static final String INST_TIMER_MANAGER = "InstrumentationTimer";
    private static final int MAX_THREADS = 1;
    private static final boolean noEventArchive;
    private static final boolean noQueueEvent;
    private static final boolean noEventPropagation;
    private int eventThreadPool = -1;
    private Boolean mutext = new Boolean(true);
    private List savedEventsList = new ArrayList();
    private TimerManagerFactory timerManagerFactory;
    private TimerManager timerManager;
    private Timer eventsTimer;
    private long timerInterval;
    private long timerPeriod = 5000L;
    private boolean isInProgress;
    private static final AuthenticatedSubject KERNEL_ID;

    private EventQueue() {
        TimerManagerFactory timerManagerFactory = TimerManagerFactory.getTimerManagerFactory();
        this.timerManager = timerManagerFactory.getTimerManager(INST_TIMER_MANAGER);
    }

    public static synchronized EventQueue getInstance() {
        if (singleton == null) {
            singleton = new EventQueue();
        }
        return singleton;
    }

    public void dispatch(String string, EventPayload eventPayload) {
        InstrumentationEvent instrumentationEvent = new InstrumentationEvent(string, eventPayload);
        this.enqueue(instrumentationEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(InstrumentationEvent instrumentationEvent) {
        if (noQueueEvent) {
            return;
        }
        if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_ACTIONS.debug("EventQueue:enqueue " + instrumentationEvent);
        }
        try {
            if (DiagnosticContextHelper.isDyedWith((byte)31)) {
                return;
            }
        }
        catch (InvalidDyeException invalidDyeException) {
            // empty catch block
        }
        boolean bl = InstrumentationManager.getInstrumentationManager().isSynchronousEventPersistenceEnabled();
        if (bl) {
            this.handleSynchronously(instrumentationEvent);
        } else {
            Boolean bl2 = this.mutext;
            synchronized (bl2) {
                this.savedEventsList.add(instrumentationEvent);
            }
        }
    }

    public synchronized void setTimerInterval(long l) {
        if (l < 1000L) {
            l = 1000L;
        }
        if (this.eventsTimer == null) {
            this.eventsTimer = this.timerManager.scheduleAtFixedRate((TimerListener)this, 0L, l);
        } else {
            this.eventsTimer.cancel();
            this.eventsTimer = this.timerManager.scheduleAtFixedRate((TimerListener)this, 0L, l);
        }
        this.timerInterval = l;
    }

    public long getTimerInterval() {
        return this.timerInterval;
    }

    private void handleSynchronously(InstrumentationEvent instrumentationEvent) {
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext(true);
        boolean bl = false;
        try {
            bl = diagnosticContext.isDyedWith((byte)31);
            diagnosticContext.setDye((byte)31, true);
        }
        catch (InvalidDyeException invalidDyeException) {
            // empty catch block
        }
        ArrayList<InstrumentationEvent> arrayList = new ArrayList<InstrumentationEvent>();
        arrayList.add(instrumentationEvent);
        SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedAction)new ArchiveEventsAction(arrayList));
        try {
            diagnosticContext.setDye((byte)31, bl);
        }
        catch (InvalidDyeException invalidDyeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timerExpired(Timer timer) {
        int n;
        if (this.isInProgress) {
            if (InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) {
                InstrumentationDebug.DEBUG_ACTIONS.debug("Previous archival session is in progress");
            }
            return;
        }
        this.isInProgress = true;
        List list = this.savedEventsList;
        Boolean bl = this.mutext;
        synchronized (bl) {
            if (this.savedEventsList.size() == 0) {
                this.isInProgress = false;
                return;
            }
            this.savedEventsList = new ArrayList();
        }
        if (InstrumentationDebug.DEBUG_EVENTS.isDebugEnabled()) {
            int n2 = list.size();
            for (n = 0; n < n2; ++n) {
                InstrumentationDebug.DEBUG_EVENTS.debug("EventsWork-EVENT " + n + ": " + list.get(n));
            }
        }
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext(true);
        n = 0;
        try {
            n = diagnosticContext.isDyedWith((byte)31) ? 1 : 0;
            diagnosticContext.setDye((byte)31, true);
        }
        catch (InvalidDyeException invalidDyeException) {
            // empty catch block
        }
        SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedAction)new ArchiveEventsAction(list));
        try {
            diagnosticContext.setDye((byte)31, n != 0);
        }
        catch (InvalidDyeException invalidDyeException) {
            // empty catch block
        }
        this.isInProgress = false;
    }

    private static DataWriter getArchive() {
        DataWriter dataWriter;
        block2: {
            dataWriter = null;
            try {
                DiagnosticAccessRuntime diagnosticAccessRuntime = DiagnosticAccessRuntime.getInstance();
                DiagnosticDataAccessRuntime diagnosticDataAccessRuntime = (DiagnosticDataAccessRuntime)diagnosticAccessRuntime.lookupWLDFDataAccessRuntime("EventsDataArchive");
                dataWriter = (DataWriter)diagnosticDataAccessRuntime.getDiagnosticDataAccessService();
            }
            catch (Exception exception) {
                if (!InstrumentationDebug.DEBUG_ACTIONS.isDebugEnabled()) break block2;
                InstrumentationDebug.DEBUG_ACTIONS.debug("Could not find events archive", (Throwable)exception);
            }
        }
        return dataWriter;
    }

    static {
        noEventArchive = Boolean.getBoolean("weblogic.diagnostics.internal.noEventArchive");
        noQueueEvent = Boolean.getBoolean("weblogic.diagnostics.internal.noQueueEvent");
        noEventPropagation = Boolean.getBoolean("weblogic.diagnostics.internal.noEventPropagation");
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    final class ArchiveEventsAction
    implements PrivilegedAction {
        private List eventsList;

        ArchiveEventsAction(List list) {
            this.eventsList = list;
        }

        public Object run() {
            try {
                DataWriter dataWriter;
                int n = this.eventsList.size();
                for (int i = 0; i < n; ++i) {
                    InstrumentationEvent instrumentationEvent = (InstrumentationEvent)this.eventsList.get(i);
                    this.eventsList.set(i, instrumentationEvent.getDataRecord());
                }
                if (!noEventPropagation) {
                    InstrumentationManager.getInstrumentationManager().propagateInstrumentationEvents(this.eventsList);
                }
                if (!noEventArchive && (dataWriter = EventQueue.getArchive()) != null) {
                    dataWriter.writeData((Collection)this.eventsList);
                }
            }
            catch (Exception exception) {
                UnexpectedExceptionHandler.handle("Error writing data to archive", exception);
            }
            return null;
        }
    }
}

