/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import weblogic.diagnostics.harvester.AttributeNameNormalizer;
import weblogic.diagnostics.instrumentation.HarvesterAttributeNormalizerLexer;
import weblogic.diagnostics.instrumentation.HarvesterAttributeNormalizerParser;

public class HarvesterAttributeNormalizer
implements AttributeNameNormalizer {
    private static final String METHOD_INVOCATION_STATS_ATTR = "MethodInvocationStatistics";
    private static final String METHOD_ALLOCATION_STATS_ATTR = "MethodMemoryAllocationStatistics";
    private static final String REGEX_PATTERN = "(\\((.)*?\\))";
    private static final int KEY_COUNT = 4;

    public String getNormalizedAttributeName(String string) {
        String string2;
        boolean bl = false;
        if (string.startsWith(METHOD_INVOCATION_STATS_ATTR)) {
            string = string.substring(METHOD_INVOCATION_STATS_ATTR.length());
        } else if (string.startsWith(METHOD_ALLOCATION_STATS_ATTR)) {
            bl = true;
            string = string.substring(METHOD_ALLOCATION_STATS_ATTR.length());
        }
        string = HarvesterAttributeNormalizer.ensureRegexGroups(string);
        HarvesterAttributeNormalizerLexer harvesterAttributeNormalizerLexer = new HarvesterAttributeNormalizerLexer(new StringReader(string));
        HarvesterAttributeNormalizerParser harvesterAttributeNormalizerParser = new HarvesterAttributeNormalizerParser(harvesterAttributeNormalizerLexer);
        try {
            string2 = harvesterAttributeNormalizerParser.normalizeAttributeSpec();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid attribute spec " + exception.getMessage(), exception);
        }
        if (bl) {
            return METHOD_ALLOCATION_STATS_ATTR + string2;
        }
        return METHOD_INVOCATION_STATS_ATTR + string2;
    }

    private static String ensureRegexGroups(String string) {
        if (string == null) {
            string = "";
        }
        Pattern pattern = Pattern.compile(REGEX_PATTERN);
        Matcher matcher = pattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if (matcher.find()) {
                stringBuilder.append(matcher.group());
                continue;
            }
            stringBuilder.append("(*)");
        }
        return stringBuilder.toString();
    }

    public String getPartiallyNormalizedAllocationAttributeName(String string) {
        return this.getPartiallyNormalizedAttributeName(METHOD_ALLOCATION_STATS_ATTR, string);
    }

    public String getPartiallyNormalizedInvocationAttributeName(String string) {
        return this.getPartiallyNormalizedAttributeName(METHOD_INVOCATION_STATS_ATTR, string);
    }

    private String getPartiallyNormalizedAttributeName(String string, String string2) {
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        if (string3.startsWith(string)) {
            string3 = string3.substring(string.length());
        }
        Pattern pattern = Pattern.compile(REGEX_PATTERN);
        Matcher matcher = pattern.matcher(string3);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 4 && matcher.find(); ++i) {
            String string4 = matcher.group();
            switch (i) {
                case 0: {
                    string4 = this.normalizeClassName(string4);
                    break;
                }
                case 1: {
                    string4 = this.normalizeMethodName(string4);
                    break;
                }
                case 2: {
                    string4 = this.normalizeMethodParams(string4);
                    break;
                }
                case 3: {
                    string4 = this.normalizeMethodStats(string4);
                }
            }
            stringBuilder.append(string4);
        }
        return string + stringBuilder.toString();
    }

    private String normalizeClassName(String string) {
        String string2;
        HarvesterAttributeNormalizerLexer harvesterAttributeNormalizerLexer = new HarvesterAttributeNormalizerLexer(new StringReader(string));
        HarvesterAttributeNormalizerParser harvesterAttributeNormalizerParser = new HarvesterAttributeNormalizerParser(harvesterAttributeNormalizerLexer);
        try {
            string2 = harvesterAttributeNormalizerParser.classNameKey();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid attribute spec " + exception.getMessage(), exception);
        }
        return string2;
    }

    private String normalizeMethodName(String string) {
        String string2;
        HarvesterAttributeNormalizerLexer harvesterAttributeNormalizerLexer = new HarvesterAttributeNormalizerLexer(new StringReader(string));
        HarvesterAttributeNormalizerParser harvesterAttributeNormalizerParser = new HarvesterAttributeNormalizerParser(harvesterAttributeNormalizerLexer);
        try {
            string2 = harvesterAttributeNormalizerParser.methodNameKey();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid attribute spec " + exception.getMessage(), exception);
        }
        return string2;
    }

    private String normalizeMethodParams(String string) {
        String string2;
        HarvesterAttributeNormalizerLexer harvesterAttributeNormalizerLexer = new HarvesterAttributeNormalizerLexer(new StringReader(string));
        HarvesterAttributeNormalizerParser harvesterAttributeNormalizerParser = new HarvesterAttributeNormalizerParser(harvesterAttributeNormalizerLexer);
        try {
            string2 = harvesterAttributeNormalizerParser.methodParamsKey();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid attribute spec " + exception.getMessage(), exception);
        }
        return string2;
    }

    private String normalizeMethodStats(String string) {
        String string2;
        HarvesterAttributeNormalizerLexer harvesterAttributeNormalizerLexer = new HarvesterAttributeNormalizerLexer(new StringReader(string));
        HarvesterAttributeNormalizerParser harvesterAttributeNormalizerParser = new HarvesterAttributeNormalizerParser(harvesterAttributeNormalizerLexer);
        try {
            string2 = harvesterAttributeNormalizerParser.methodStatsKey();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid attribute spec " + exception.getMessage(), exception);
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        HarvesterAttributeNormalizer harvesterAttributeNormalizer = new HarvesterAttributeNormalizer();
        String string = harvesterAttributeNormalizer.getPartiallyNormalizedInvocationAttributeName(stringArray[0]);
        System.out.println(string);
    }
}

