/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import weblogic.diagnostics.instrumentation.HarvesterAttributeNormalizerLexer;
import weblogic.diagnostics.instrumentation.HarvesterAttributeNormalizerParserTokenTypes;

public class HarvesterAttributeNormalizerParser
extends LLkParser
implements HarvesterAttributeNormalizerParserTokenTypes {
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "WS", "LPAREN", "RPAREN", "COMMA", "TYPE_NAME", "STAR_WILDCARD", "POSITIONAL_WILDCARD"};

    private static Set createValidStatsKeySet() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("min");
        hashSet.add("max");
        hashSet.add("avg");
        hashSet.add("count");
        hashSet.add("sum");
        hashSet.add("sum_of_squares");
        hashSet.add("std_deviation");
        return hashSet;
    }

    private static String normalizeKey(String string) {
        boolean bl = HarvesterAttributeNormalizerParser.isRegex(string);
        int n = string.length();
        String string2 = !bl ? "(" + string + ")" : "{" + HarvesterAttributeNormalizerParser.escapeRegexMetaChars(string) + "}";
        return string2;
    }

    private static boolean isRegex(String string) {
        if (string.equals("*")) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        boolean bl = string.indexOf("*") >= 0;
        bl = bl || string.indexOf("?") >= 0;
        bl = bl || string.indexOf("%") >= 0;
        return bl;
    }

    private static String escapeRegexMetaChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '$': {
                    stringBuilder.append("\\$");
                    continue block6;
                }
                case '.': {
                    stringBuilder.append("\\.");
                    continue block6;
                }
                case '?': {
                    stringBuilder.append("[^,]*?");
                    continue block6;
                }
                case '%': 
                case '*': {
                    stringBuilder.append(".*?");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static void validateStatsKey(String string) {
        if (!ValidStatsKeySetInitializer.VALID_STATS_KEYS.contains(string)) {
            throw new IllegalArgumentException("Invalid statistics key " + string);
        }
    }

    private static String getFullyQualifiedTypeName(String string) {
        int n = string.indexOf(".");
        if (n == -1) {
            try {
                return Class.forName("java.lang." + string).getName();
            }
            catch (Exception exception) {
                return string;
            }
        }
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Invalid number of arguments");
            System.exit(1);
        }
        HarvesterAttributeNormalizerLexer harvesterAttributeNormalizerLexer = new HarvesterAttributeNormalizerLexer(new StringReader(stringArray[0]));
        HarvesterAttributeNormalizerParser harvesterAttributeNormalizerParser = new HarvesterAttributeNormalizerParser(harvesterAttributeNormalizerLexer);
        String string = harvesterAttributeNormalizerParser.normalizeAttributeSpec();
        System.out.println("Normalized attribute spec: " + string);
    }

    protected HarvesterAttributeNormalizerParser(TokenBuffer tokenBuffer, int n) {
        super(tokenBuffer, n);
        this.tokenNames = _tokenNames;
    }

    public HarvesterAttributeNormalizerParser(TokenBuffer tokenBuffer) {
        this(tokenBuffer, 1);
    }

    protected HarvesterAttributeNormalizerParser(TokenStream tokenStream, int n) {
        super(tokenStream, n);
        this.tokenNames = _tokenNames;
    }

    public HarvesterAttributeNormalizerParser(TokenStream tokenStream) {
        this(tokenStream, 1);
    }

    public HarvesterAttributeNormalizerParser(ParserSharedInputState parserSharedInputState) {
        super(parserSharedInputState, 1);
        this.tokenNames = _tokenNames;
    }

    public final String normalizeAttributeSpec() throws RecognitionException, TokenStreamException {
        String string = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        string2 = this.classNameKey();
        string3 = this.methodNameKey();
        string4 = this.methodParamsKey();
        string5 = this.methodStatsKey();
        string = string2 + string3 + string4 + string5;
        return string;
    }

    public final String classNameKey() throws RecognitionException, TokenStreamException {
        String string;
        String string2 = null;
        Token token = null;
        Token token2 = null;
        this.match(5);
        switch (this.LA(1)) {
            case 8: {
                token = this.LT(1);
                this.match(8);
                string = token.getText();
                break;
            }
            case 9: {
                token2 = this.LT(1);
                this.match(9);
                string = token2.getText();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(6);
        string2 = HarvesterAttributeNormalizerParser.normalizeKey(string);
        return string2;
    }

    public final String methodNameKey() throws RecognitionException, TokenStreamException {
        String string;
        String string2 = null;
        Token token = null;
        Token token2 = null;
        this.match(5);
        switch (this.LA(1)) {
            case 8: {
                token = this.LT(1);
                this.match(8);
                string = token.getText();
                break;
            }
            case 9: {
                token2 = this.LT(1);
                this.match(9);
                string = token2.getText();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(6);
        string2 = HarvesterAttributeNormalizerParser.normalizeKey(string);
        return string2;
    }

    public final String methodParamsKey() throws RecognitionException, TokenStreamException {
        String string = "";
        Token token = null;
        Token token2 = null;
        this.match(5);
        switch (this.LA(1)) {
            case 8: 
            case 9: 
            case 10: {
                switch (this.LA(1)) {
                    case 8: {
                        token = this.LT(1);
                        this.match(8);
                        string = HarvesterAttributeNormalizerParser.getFullyQualifiedTypeName(token.getText());
                        break;
                    }
                    case 10: {
                        this.match(10);
                        string = "?";
                        break;
                    }
                    case 9: {
                        this.match(9);
                        string = "*";
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                block14: while (this.LA(1) == 7) {
                    this.match(7);
                    switch (this.LA(1)) {
                        case 8: {
                            token2 = this.LT(1);
                            this.match(8);
                            string = string + "," + HarvesterAttributeNormalizerParser.getFullyQualifiedTypeName(token2.getText());
                            continue block14;
                        }
                        case 10: {
                            this.match(10);
                            string = string + ",?";
                            continue block14;
                        }
                        case 9: {
                            this.match(9);
                            string = string + ",*";
                            continue block14;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(6);
        if (!HarvesterAttributeNormalizerParser.isRegex(string)) {
            string = string.replace(",", "\\,");
        }
        string = HarvesterAttributeNormalizerParser.normalizeKey(string);
        return string;
    }

    public final String methodStatsKey() throws RecognitionException, TokenStreamException {
        String string = "";
        Token token = null;
        Token token2 = null;
        Token token3 = null;
        this.match(5);
        switch (this.LA(1)) {
            case 8: {
                token = this.LT(1);
                this.match(8);
                string = token.getText();
                HarvesterAttributeNormalizerParser.validateStatsKey(string);
                while (this.LA(1) == 7) {
                    this.match(7);
                    token2 = this.LT(1);
                    this.match(8);
                    String string2 = token2.getText();
                    HarvesterAttributeNormalizerParser.validateStatsKey(string2);
                    string = string + "," + string2;
                }
                break;
            }
            case 9: {
                token3 = this.LT(1);
                this.match(9);
                string = token3.getText();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(6);
        string = HarvesterAttributeNormalizerParser.normalizeKey(string);
        return string;
    }

    static /* synthetic */ Set access$000() {
        return HarvesterAttributeNormalizerParser.createValidStatsKeySet();
    }

    private static class ValidStatsKeySetInitializer {
        private static final Set VALID_STATS_KEYS = HarvesterAttributeNormalizerParser.access$000();

        private ValidStatsKeySetInitializer() {
        }
    }
}

