/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.security.AccessController;
import java.security.Principal;
import javax.security.auth.Subject;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.archive.ArchiveConstants;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticMonitorControl;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationScope;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.kernel.Kernel;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.Security;
import weblogic.security.SubjectUtils;
import weblogic.security.WLSPrincipals;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.spi.WLSUser;
import weblogic.transaction.TxHelper;

public final class InstrumentationEvent {
    private String retValString = "";
    private String argsString = "";
    private DiagnosticMonitorControl monitor;
    private DiagnosticAction action;
    private String eventType;
    private JoinPoint jp;
    private long timestamp;
    private String contextId = "";
    private String threadName = "";
    private String contextPayload;
    private String txId = "";
    private String userId = "";
    private Object payload;
    private long dyeVector;
    private static String serverName;
    private static String domainName;
    private static final AuthenticatedSubject kernelId;

    public InstrumentationEvent(DiagnosticAction diagnosticAction, JoinPoint joinPoint, boolean bl) {
        this();
        this.action = diagnosticAction;
        this.jp = joinPoint;
        if (bl) {
            this.captureArgReturnValues();
        }
    }

    public InstrumentationEvent(DiagnosticMonitorControl diagnosticMonitorControl, JoinPoint joinPoint) {
        this();
        this.monitor = diagnosticMonitorControl;
        this.jp = joinPoint;
    }

    public InstrumentationEvent(String string) {
        this();
        this.eventType = string;
    }

    public InstrumentationEvent(String string, Object object) {
        this();
        this.eventType = string;
        this.payload = object;
    }

    private InstrumentationEvent() {
        this.doInit();
    }

    private void doInit() {
        this.timestamp = System.currentTimeMillis();
        this.threadName = Thread.currentThread().getName();
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        if (diagnosticContext != null) {
            this.contextId = diagnosticContext.getContextId();
            this.contextPayload = diagnosticContext.getPayload();
            this.dyeVector = diagnosticContext.getDyeVector();
        }
        if (Kernel.isInitialized()) {
            RuntimeAccess runtimeAccess;
            this.txId = TxHelper.getTransactionId();
            Subject subject = Security.getCurrentSubject();
            this.userId = this.extractCurrentWLSSubject(subject);
            if (this.userId == null) {
                this.userId = SubjectUtils.getUsername((Subject)subject);
            }
            if (this.txId == null) {
                this.txId = "";
            }
            if (this.userId == null) {
                this.userId = "";
            }
            if (serverName == null && (runtimeAccess = ManagementService.getRuntimeAccess(kernelId)) != null) {
                serverName = runtimeAccess.getServerName();
                domainName = runtimeAccess.getDomainName();
            }
        }
    }

    private String extractCurrentWLSSubject(Subject subject) {
        String string = null;
        int n = subject.getPrincipals().size();
        if (n > 0) {
            for (Principal principal : subject.getPrincipals()) {
                if (!(principal instanceof WLSUser)) continue;
                string = principal.getName();
                break;
            }
        } else {
            string = WLSPrincipals.getAnonymousUsername();
        }
        return string;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String string) {
        this.eventType = string;
    }

    public void setContextId(String string) {
        this.contextId = string;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setPayload(Object object) {
        this.payload = object;
    }

    public Object getPayload() {
        return this.payload;
    }

    public DataRecord getDataRecord() {
        Object object;
        String string = "";
        String string2 = "";
        String string3 = "";
        if (this.action != null) {
            object = this.action.getDiagnosticMonitor();
            if (object instanceof DiagnosticMonitorControl) {
                this.monitor = (DiagnosticMonitorControl)object;
            }
            string = this.action.getType();
        }
        if (this.monitor != null) {
            string2 = this.monitor.getType();
            object = this.monitor.getInstrumentationScope();
            if (object != null) {
                string3 = ((InstrumentationScope)object).getName();
            }
        }
        int n = 0;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        if (this.jp != null) {
            string4 = this.jp.getModuleName();
            n = this.jp.getLineNumber();
            string5 = this.jp.getSourceFile();
            string6 = this.jp.getClassName();
            string7 = this.jp.getMethodName();
            string8 = this.jp.getMethodDescriptor();
        }
        String string9 = serverName != null ? serverName : "";
        String string10 = domainName != null ? domainName : "";
        String string11 = this.eventType != null ? this.eventType : string;
        this.contextPayload = this.contextPayload != null ? this.contextPayload : "";
        Object[] objectArray = new Object[ArchiveConstants.EVENTS_ARCHIVE_COLUMNS_COUNT];
        int n2 = 0;
        objectArray[n2++] = null;
        objectArray[n2++] = new Long(this.timestamp);
        objectArray[n2++] = this.contextId;
        objectArray[n2++] = this.txId;
        objectArray[n2++] = this.userId;
        objectArray[n2++] = string11;
        objectArray[n2++] = string10;
        objectArray[n2++] = string9;
        objectArray[n2++] = string3;
        objectArray[n2++] = string4;
        objectArray[n2++] = string2;
        objectArray[n2++] = string5;
        objectArray[n2++] = new Integer(n);
        objectArray[n2++] = string6;
        objectArray[n2++] = string7;
        objectArray[n2++] = string8;
        objectArray[n2++] = this.argsString;
        objectArray[n2++] = this.retValString;
        objectArray[n2++] = this.payload;
        objectArray[n2++] = this.contextPayload;
        objectArray[n2++] = new Long(this.dyeVector);
        objectArray[n2++] = this.threadName;
        return new DataRecord(objectArray);
    }

    private void captureArgReturnValues() {
        if (this.jp instanceof DynamicJoinPoint) {
            Object[] objectArray;
            DynamicJoinPoint dynamicJoinPoint = (DynamicJoinPoint)this.jp;
            Object object = dynamicJoinPoint.getReturnValue();
            if (object != null) {
                this.retValString = this.getArgValue(object);
            }
            if ((objectArray = dynamicJoinPoint.getArguments()) != null) {
                int n = objectArray != null ? objectArray.length : 0;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.getArgValue(objectArray[i]));
                }
                this.argsString = stringBuffer.toString();
            }
        }
    }

    private String getArgValue(Object object) {
        if (object == null) {
            return "null";
        }
        String string = null;
        try {
            string = object.toString();
        }
        catch (Throwable throwable) {
            string = "??" + object.getClass().getName() + "??";
        }
        return string;
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

