/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.io.OutputStream;
import java.security.AccessController;
import java.util.Iterator;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.diagnostics.accessor.ColumnInfo;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.accessor.DiagnosticAccessRuntime;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.diagnostics.image.descriptor.ColumnDataBean;
import weblogic.diagnostics.image.descriptor.InstrumentationEventBean;
import weblogic.diagnostics.image.descriptor.InstrumentationImageSourceBean;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.WLDFServerDiagnosticMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.WLDFDataAccessRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

class InstrumentationImageSource
implements ImageSource {
    private boolean timeoutRequested;
    private String[] columnNames;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    InstrumentationImageSource() {
    }

    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        DescriptorManager descriptorManager = new DescriptorManager();
        Descriptor descriptor = descriptorManager.createDescriptorRoot(InstrumentationImageSourceBean.class);
        InstrumentationImageSourceBean instrumentationImageSourceBean = (InstrumentationImageSourceBean)descriptor.getRootBean();
        this.writeRecentEvents(instrumentationImageSourceBean);
        try {
            descriptorManager.writeDescriptorBeanAsXML((DescriptorBean)instrumentationImageSourceBean, outputStream);
        }
        catch (Exception exception) {
            throw new ImageSourceCreationException((Throwable)exception);
        }
    }

    public void timeoutImageCreation() {
        this.timeoutRequested = true;
    }

    private String[] getColumnNames(WLDFDataAccessRuntimeMBean wLDFDataAccessRuntimeMBean) throws Exception {
        if (this.columnNames == null) {
            ColumnInfo[] columnInfoArray = wLDFDataAccessRuntimeMBean.getColumns();
            this.columnNames = new String[columnInfoArray.length];
            for (int i = 0; i < columnInfoArray.length; ++i) {
                this.columnNames[i] = columnInfoArray[i].getColumnName();
            }
        }
        return this.columnNames;
    }

    private void writeRecentEvents(InstrumentationImageSourceBean instrumentationImageSourceBean) {
        try {
            this.timeoutRequested = false;
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
            WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean = serverMBean.getServerDiagnosticConfig();
            long l = wLDFServerDiagnosticMBean.getEventsImageCaptureInterval();
            if (l > 0L) {
                DiagnosticAccessRuntime diagnosticAccessRuntime = DiagnosticAccessRuntime.getInstance();
                WLDFDataAccessRuntimeMBean wLDFDataAccessRuntimeMBean = diagnosticAccessRuntime.lookupWLDFDataAccessRuntime("EventsDataArchive");
                long l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                String[] stringArray = this.getColumnNames(wLDFDataAccessRuntimeMBean);
                Iterator iterator = wLDFDataAccessRuntimeMBean.retrieveDataRecords(l3, l2, null);
                while (iterator.hasNext() && !this.timeoutRequested) {
                    DataRecord dataRecord = (DataRecord)iterator.next();
                    InstrumentationEventBean instrumentationEventBean = instrumentationImageSourceBean.createInstrumentationEvent();
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        ColumnDataBean columnDataBean = instrumentationEventBean.createColumnData();
                        columnDataBean.setName(string);
                        Object object = dataRecord.get(i);
                        if (object == null) continue;
                        columnDataBean.setValue(object.toString());
                    }
                }
            }
        }
        catch (Exception exception) {
            UnexpectedExceptionHandler.handle("Error in InstrumentationImageSource.", exception);
        }
    }
}

