/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.diagnostics.context.DiagnosticContextHelper;
import weblogic.diagnostics.context.InvalidDyeException;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.instrumentation.AroundDiagnosticAction;
import weblogic.diagnostics.instrumentation.CustomMonitorControl;
import weblogic.diagnostics.instrumentation.DelegatingMonitorControl;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticMonitorControl;
import weblogic.diagnostics.instrumentation.InstrumentationDebug;
import weblogic.diagnostics.instrumentation.StandardMonitorControl;
import weblogic.diagnostics.instrumentation.StatelessDiagnosticAction;
import weblogic.diagnostics.instrumentation.engine.InstrumentationEngineConfiguration;
import weblogic.diagnostics.instrumentation.engine.MonitorSpecification;
import weblogic.diagnostics.instrumentation.engine.base.InstrumentationEngineConstants;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;
import weblogic.kernel.Kernel;
import weblogic.management.DomainDir;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.jars.ManifestManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstrumentationLibrary
implements InstrumentationEngineConstants {
    private static InstrumentationLibrary singleton;
    private HashMap monitorMap;
    private HashMap serverManagedMonitorMap;
    private HashMap actionMap;
    private ClassLoader actionsClassLoader;
    private List statelessActionTypes = new ArrayList();
    private List aroundActionTypes = new ArrayList();
    private List<String> eventClassNamesInUse = new ArrayList<String>();
    private Collection pointcutList;
    private InstrumentationEngineConfiguration engineConf;
    private boolean valid;
    private static final AuthenticatedSubject kernelID;

    private InstrumentationLibrary() {
        this.monitorMap = new HashMap();
        this.actionMap = new HashMap();
        this.pointcutList = new ArrayList();
        this.serverManagedMonitorMap = new HashMap();
    }

    public static synchronized InstrumentationLibrary getInstrumentationLibrary() {
        if (singleton == null) {
            InstrumentationLibrary instrumentationLibrary = new InstrumentationLibrary();
            instrumentationLibrary.loadInstrumentationEngineConfiguration();
            singleton = instrumentationLibrary;
        }
        return singleton;
    }

    public boolean isValid() {
        return this.valid;
    }

    public InstrumentationEngineConfiguration getInstrumentationEngineConfiguration() {
        return this.engineConf;
    }

    private void loadInstrumentationEngineConfiguration() {
        Object object;
        String string;
        String string2;
        Object object22;
        Object object3;
        Object object4;
        this.actionsClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.actionsClassLoader == null) {
            this.actionsClassLoader = this.getClass().getClassLoader();
        }
        String string3 = null;
        if (Kernel.isServer()) {
            object4 = null;
            object3 = ManagementService.getRuntimeAccess(kernelID);
            if (object3 != null) {
                object4 = object3.getServerName();
            }
            if (object4 == null || ((String)object4).equals("")) {
                object4 = System.getProperty("weblogic.Name", "myserver");
            }
            if ("".equals(object4)) {
                object4 = null;
            }
            if (object4 != null) {
                object22 = new File(DomainDir.getPathRelativeServersCacheDir((String)object4, (String)"diagnostics"));
                object22 = new File((File)object22, "InstrumentationEngineConfig.ser");
                string3 = ((File)object22).getAbsolutePath();
            }
        }
        this.engineConf = InstrumentationEngineConfiguration.getInstrumentationEngineConfiguration(string3);
        if (!this.engineConf.isValid()) {
            return;
        }
        object4 = this.engineConf.getDyeFlagsMap();
        for (Object object22 : object4.keySet()) {
            int n = (Integer)object4.get(object22);
            try {
                DiagnosticContextHelper.registerDye((String)object22, n);
            }
            catch (InvalidDyeException invalidDyeException) {
                if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
                    InstrumentationDebug.DEBUG_CONFIG.debug("Failed to register dye: ", (Throwable)((Object)invalidDyeException));
                }
                DiagnosticsLogger.logDyeRegistrationFailureError((String)object22, (int)n);
            }
        }
        object3 = this.engineConf.getActionTypes();
        object22 = this.engineConf.getGroupActionTypes("StatelessActions");
        String[] stringArray = this.engineConf.getGroupActionTypes("AroundActions");
        int n = object3 != null ? ((String[])object3).length : 0;
        for (int i = 0; i < n; ++i) {
            string2 = object3[i];
            string = this.engineConf.getActionClassName(string2);
            try {
                object = (DiagnosticAction)Class.forName(string).newInstance();
                this.actionMap.put(string2, string);
                if (this.isInList(string2, (String[])object22)) {
                    this.statelessActionTypes.add(string2);
                    continue;
                }
                if (!this.isInList(string2, stringArray)) continue;
                this.aroundActionTypes.add(string2);
                continue;
            }
            catch (Exception exception) {
                UnexpectedExceptionHandler.handle("Unknown diagnostic action " + string, exception);
            }
        }
        Iterator iterator = this.engineConf.getAllMonitorSpecifications();
        while (iterator.hasNext()) {
            Object object5;
            string2 = (MonitorSpecification)iterator.next();
            string = string2.getType();
            object = null;
            if (string2.isStandardMonitor()) {
                object = new StandardMonitorControl(string);
            } else {
                object5 = new DelegatingMonitorControl(string);
                String[] stringArray2 = string2.getActionTypes();
                int n2 = stringArray2 != null ? stringArray2.length : 0;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < n2; ++i) {
                    if (this.actionMap.get(stringArray2[i]) == null) continue;
                    arrayList.add(stringArray2[i]);
                }
                stringArray2 = arrayList.toArray(new String[0]);
                ((DelegatingMonitorControl)object5).setCompatibleActionTypes(stringArray2);
                ((DelegatingMonitorControl)object5).setLocationType(string2.getLocation());
                object = object5;
            }
            ((DiagnosticMonitorControl)object).setAttributeNames(string2.getAttributeNames());
            ((DiagnosticMonitorControl)object).setServerScopeAllowed(string2.isServerScoped());
            ((DiagnosticMonitorControl)object).setComponentScopeAllowed(string2.isApplicationScoped());
            ((DiagnosticMonitorControl)object).setServerManaged(string2.isServerManaged());
            ((DiagnosticMonitorControl)object).setDiagnosticVolume(string2.getDiagnosticVolume());
            ((DiagnosticMonitorControl)object).setEventClassName(string2.getEventClassName());
            if (string2.isServerManaged()) {
                object5 = string2.getEventClassName();
                if (object5 != null && !this.eventClassNamesInUse.contains(object5)) {
                    this.eventClassNamesInUse.add((String)object5);
                }
                this.serverManagedMonitorMap.put(string, object);
                continue;
            }
            this.monitorMap.put(string, object);
        }
        this.readCustomActions();
        this.valid = true;
    }

    private boolean isInList(String string, String[] stringArray) {
        int n = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public DiagnosticMonitorControl[] getAvailableMonitors() {
        int n = this.monitorMap.size();
        DiagnosticMonitorControl[] diagnosticMonitorControlArray = new DiagnosticMonitorControl[n];
        int n2 = 0;
        for (String string : this.monitorMap.keySet()) {
            diagnosticMonitorControlArray[n2++] = this.getDiagnosticMonitorControl(string);
        }
        return diagnosticMonitorControlArray;
    }

    public DiagnosticMonitorControl[] getAllAvailableMonitors() {
        int n = this.monitorMap.size() + this.serverManagedMonitorMap.size();
        DiagnosticMonitorControl[] diagnosticMonitorControlArray = new DiagnosticMonitorControl[n];
        int n2 = 0;
        for (String string : this.monitorMap.keySet()) {
            diagnosticMonitorControlArray[n2++] = this.getDiagnosticMonitorControl(string);
        }
        for (String string : this.serverManagedMonitorMap.keySet()) {
            diagnosticMonitorControlArray[n2++] = this.getDiagnosticMonitorControl(string);
        }
        return diagnosticMonitorControlArray;
    }

    public DiagnosticMonitorControl getDiagnosticMonitorControl(String string) {
        DiagnosticMonitorControl diagnosticMonitorControl = (DiagnosticMonitorControl)this.monitorMap.get(string);
        if (diagnosticMonitorControl == null && (diagnosticMonitorControl = (DiagnosticMonitorControl)this.serverManagedMonitorMap.get(string)) == null) {
            return null;
        }
        StandardMonitorControl standardMonitorControl = null;
        if (diagnosticMonitorControl instanceof CustomMonitorControl) {
            standardMonitorControl = new CustomMonitorControl((CustomMonitorControl)diagnosticMonitorControl);
        } else if (diagnosticMonitorControl instanceof DelegatingMonitorControl) {
            standardMonitorControl = new DelegatingMonitorControl((DelegatingMonitorControl)diagnosticMonitorControl);
        } else if (diagnosticMonitorControl instanceof StandardMonitorControl) {
            standardMonitorControl = new StandardMonitorControl((StandardMonitorControl)diagnosticMonitorControl);
        }
        return standardMonitorControl;
    }

    public DiagnosticAction[] getAvailableActions() {
        int n = this.actionMap.size();
        DiagnosticAction[] diagnosticActionArray = new DiagnosticAction[n];
        int n2 = 0;
        for (String string : this.actionMap.keySet()) {
            diagnosticActionArray[n2++] = this.getDiagnosticAction(string);
        }
        return diagnosticActionArray;
    }

    public DiagnosticAction getDiagnosticAction(String string) {
        String string2 = (String)this.actionMap.get(string);
        if (string2 == null) {
            return null;
        }
        DiagnosticAction diagnosticAction = null;
        try {
            diagnosticAction = (DiagnosticAction)this.actionsClassLoader.loadClass(string2).newInstance();
        }
        catch (Exception exception) {
            UnexpectedExceptionHandler.handle("Unknown diagnostic action type " + string, exception);
        }
        diagnosticAction.setType(string);
        return diagnosticAction;
    }

    public String[] getActionTypes() {
        ArrayList arrayList = new ArrayList(this.statelessActionTypes);
        arrayList.addAll(this.aroundActionTypes);
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public String[] getStatelessDiagnosticActionTypes() {
        String[] stringArray = new String[this.statelessActionTypes.size()];
        return this.statelessActionTypes.toArray(stringArray);
    }

    public String[] getAroundDiagnosticActionTypes() {
        String[] stringArray = new String[this.aroundActionTypes.size()];
        return this.aroundActionTypes.toArray(stringArray);
    }

    public String getActionClassname(String string) {
        return (String)this.actionMap.get(string);
    }

    private void readCustomActions() {
        ArrayList arrayList = ManifestManager.getServices(DiagnosticAction.class);
        for (DiagnosticAction diagnosticAction : arrayList) {
            String string;
            String string2 = diagnosticAction.getType();
            if (this.isAlreadyRegistered(string2, string = diagnosticAction.getClass().getName())) continue;
            if (diagnosticAction instanceof StatelessDiagnosticAction) {
                this.statelessActionTypes.add(string2);
            } else {
                if (!(diagnosticAction instanceof AroundDiagnosticAction)) continue;
                this.aroundActionTypes.add(string2);
            }
            this.actionMap.put(string2, string);
            if (!InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) continue;
            InstrumentationDebug.DEBUG_CONFIG.debug("Found custom action class: " + string);
        }
    }

    private boolean isAlreadyRegistered(String string, String string2) {
        for (String string3 : this.actionMap.keySet()) {
            String string4 = (String)this.actionMap.get(string3);
            if (!string3.equals(string) && !string4.equals(string2)) continue;
            if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
                InstrumentationDebug.DEBUG_CONFIG.debug("Action type " + string + " or action class " + string2 + " is already in use");
            }
            return true;
        }
        return false;
    }

    public boolean isGatheringExtended() {
        String[] stringArray;
        String[] stringArray2 = this.engineConf.getGroupActionTypes("DataGatheringStatelessActions");
        int n = stringArray2.length + (stringArray = this.engineConf.getGroupActionTypes("DataGatheringAroundActions")).length;
        return n > 2;
    }

    public Map<String, String> getValueRenderersByType() {
        return this.engineConf.getValueRenderersByType();
    }

    public List<String> getEventClassNamesInUse() {
        return this.eventClassNamesInUse;
    }

    static {
        kernelID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

