/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import weblogic.Server;
import weblogic.diagnostics.accessor.DataRecord;
import weblogic.diagnostics.descriptor.WLDFInstrumentationBean;
import weblogic.diagnostics.descriptor.WLDFResourceBean;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.image.ImageManager;
import weblogic.diagnostics.instrumentation.ActionNotFoundException;
import weblogic.diagnostics.instrumentation.DelegatingMonitorControl;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticMonitorControl;
import weblogic.diagnostics.instrumentation.DuplicateActionException;
import weblogic.diagnostics.instrumentation.DuplicateMonitorException;
import weblogic.diagnostics.instrumentation.EventQueue;
import weblogic.diagnostics.instrumentation.IncompatibleActionException;
import weblogic.diagnostics.instrumentation.InstrumentationDebug;
import weblogic.diagnostics.instrumentation.InstrumentationEventListener;
import weblogic.diagnostics.instrumentation.InstrumentationException;
import weblogic.diagnostics.instrumentation.InstrumentationImageSource;
import weblogic.diagnostics.instrumentation.InstrumentationLibrary;
import weblogic.diagnostics.instrumentation.InstrumentationScope;
import weblogic.diagnostics.instrumentation.InstrumentationStatistics;
import weblogic.diagnostics.instrumentation.ScopeAlreadyExistsException;
import weblogic.diagnostics.instrumentation.StandardMonitorControl;
import weblogic.diagnostics.instrumentation.ValueRenderingManager;
import weblogic.diagnostics.instrumentation.engine.InstrumentationEngineConfiguration;
import weblogic.diagnostics.instrumentation.gathering.DataGatheringManager;
import weblogic.diagnostics.instrumentation.support.DyeInjectionMonitorSupport;
import weblogic.diagnostics.type.FeatureNotAvailableException;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.WLDFServerDiagnosticMBean;
import weblogic.management.configuration.WLDFSystemResourceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstrumentationManager
implements PropertyChangeListener {
    private static InstrumentationManager singleton;
    private boolean valid;
    private List instrumentationScopes;
    private InstrumentationScope serverInstrumentationScope;
    private boolean synchronousEventPersistence;
    private long eventsPersistenceInterval;
    private InstrumentationEventListener[] eventsListeners;
    private Map classLoaderMap = Collections.synchronizedMap(new WeakHashMap());
    private Map serverMonitors = new HashMap();
    private Map<String, DiagnosticMonitorControl> serverManagedMonitors = new HashMap<String, DiagnosticMonitorControl>();
    private static final String WEBLOGIC_INSTRUMENTATION_SERVER_MANAGED_SCOPE = "_WL_INTERNAL_SERVER_MANAGED_SCOPE";
    private InstrumentationScope serverManagedScope;
    private InstrumentationStatistics statsForDeletedScopes = new InstrumentationStatistics();
    private static final AuthenticatedSubject kernelId;

    private InstrumentationManager() {
        DiagnosticMonitor diagnosticMonitor;
        this.instrumentationScopes = new ArrayList();
        this.createServerManagedScope();
        this.eventsListeners = new InstrumentationEventListener[0];
        DiagnosticMonitor[] diagnosticMonitorArray = this.getAvailableMonitors();
        for (int i = 0; i < diagnosticMonitorArray.length; ++i) {
            diagnosticMonitor = diagnosticMonitorArray[i];
            if (!diagnosticMonitor.isServerScopeAllowed()) continue;
            if (diagnosticMonitor.isServerManaged()) {
                if (!(diagnosticMonitor instanceof DiagnosticMonitorControl)) continue;
                try {
                    if (diagnosticMonitor instanceof DelegatingMonitorControl) {
                        this.setupActionList((DelegatingMonitorControl)diagnosticMonitor);
                    }
                    this.serverManagedScope.addMonitorControl((DiagnosticMonitorControl)diagnosticMonitor);
                    this.serverManagedMonitors.put(diagnosticMonitor.getType(), (DiagnosticMonitorControl)diagnosticMonitor);
                }
                catch (DuplicateMonitorException duplicateMonitorException) {}
                continue;
            }
            this.serverMonitors.put(diagnosticMonitor.getType(), diagnosticMonitor);
        }
        InstrumentationLibrary instrumentationLibrary = InstrumentationLibrary.getInstrumentationLibrary();
        if (!instrumentationLibrary.isValid()) {
            DiagnosticsLogger.logInvalidInstrumentationLibraryError();
            return;
        }
        DataGatheringManager.setEventClassNamesInUse(instrumentationLibrary.getEventClassNamesInUse());
        ValueRenderingManager.initialize(instrumentationLibrary.getValueRenderersByType());
        diagnosticMonitor = (DiagnosticMonitorControl)this.serverMonitors.get("DyeInjection");
        if (diagnosticMonitor != null) {
            InstrumentationEngineConfiguration instrumentationEngineConfiguration = instrumentationLibrary.getInstrumentationEngineConfiguration();
            Map map = instrumentationEngineConfiguration.getDyeFlagsMap();
            HashSet<String> hashSet = new HashSet<String>();
            String[] stringArray = diagnosticMonitor.getAttributeNames();
            int n = stringArray != null ? stringArray.length : 0;
            for (int i = 0; i < n; ++i) {
                hashSet.add(stringArray[i]);
            }
            hashSet.addAll(map.keySet());
            stringArray = hashSet.toArray(new String[0]);
            diagnosticMonitor.setAttributeNames(stringArray);
            this.valid = true;
        } else {
            DiagnosticsLogger.logMissingDiagnosticMonitor((String)"DyeInjection");
        }
    }

    public static synchronized InstrumentationManager getInstrumentationManager() {
        if (singleton == null) {
            singleton = new InstrumentationManager();
        }
        return singleton;
    }

    public void initialize() {
        try {
            InstrumentationScope instrumentationScope = this.getServerInstrumentationScope();
            if (Boolean.getBoolean("weblogic.diagnostics.instrumentation.VerifyEventClasses")) {
                this.verifyEnabledServerManagedMonitorEventClassesLoadable();
            }
            this.updateServerManagedMonitors(DataGatheringManager.getDiagnosticVolume());
        }
        catch (Exception exception) {
            DiagnosticsLogger.logServerInstrumentationScopeInitializationError((Throwable)exception);
        }
    }

    public void initializeInstrumentationParameters() {
        WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        ServerMBean serverMBean = runtimeAccess.getServer();
        WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean2 = wLDFServerDiagnosticMBean = serverMBean != null ? serverMBean.getServerDiagnosticConfig() : null;
        if (wLDFServerDiagnosticMBean == null) {
            return;
        }
        this.eventsPersistenceInterval = wLDFServerDiagnosticMBean.getEventPersistenceInterval();
        this.synchronousEventPersistence = wLDFServerDiagnosticMBean.isSynchronousEventPersistenceEnabled();
        EventQueue.getInstance().setTimerInterval(this.eventsPersistenceInterval);
        ImageManager imageManager = ImageManager.getInstance();
        imageManager.registerImageSource("InstrumentationImageSource", new InstrumentationImageSource());
        wLDFServerDiagnosticMBean.addPropertyChangeListener(this);
    }

    InstrumentationScope getServerInstrumentationScope() throws Exception {
        InstrumentationScope instrumentationScope = null;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        String string = runtimeAccess.getServerName();
        DomainMBean domainMBean = runtimeAccess.getDomain();
        if (domainMBean == null) {
            return null;
        }
        WLDFSystemResourceMBean[] wLDFSystemResourceMBeanArray = domainMBean.getWLDFSystemResources();
        int n = wLDFSystemResourceMBeanArray != null ? wLDFSystemResourceMBeanArray.length : 0;
        for (int i = 0; instrumentationScope == null && i < n; ++i) {
            WLDFSystemResourceMBean wLDFSystemResourceMBean = wLDFSystemResourceMBeanArray[i];
            TargetMBean[] targetMBeanArray = wLDFSystemResourceMBean.getTargets();
            int n2 = targetMBeanArray != null ? targetMBeanArray.length : 0;
            for (int j = 0; instrumentationScope == null && j < n2; ++j) {
                if (!targetMBeanArray[j].getServerNames().contains(string)) continue;
                WLDFResourceBean wLDFResourceBean = wLDFSystemResourceMBean.getWLDFResource();
                if (wLDFResourceBean == null) {
                    throw new IllegalArgumentException(DiagnosticsLogger.logWLDFResourceBeanNotFoundLoggable((String)wLDFSystemResourceMBean.getName()).getMessage());
                }
                WLDFInstrumentationBean wLDFInstrumentationBean = wLDFResourceBean.getInstrumentation();
                if (wLDFInstrumentationBean == null) continue;
                instrumentationScope = this.createInstrumentationScope("_WL_INTERNAL_SERVER_SCOPE", wLDFInstrumentationBean);
            }
        }
        this.serverInstrumentationScope = instrumentationScope;
        return instrumentationScope;
    }

    public DiagnosticMonitorControl getServerMonitor(String string) {
        return (DiagnosticMonitorControl)this.serverMonitors.get(string);
    }

    public static void initializeServerScope(ClassLoader classLoader, byte[] byArray) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        InstrumentationScope instrumentationScope = (InstrumentationScope)objectInputStream.readObject();
        objectInputStream.close();
        InstrumentationManager instrumentationManager = InstrumentationManager.getInstrumentationManager();
        instrumentationManager.addInstrumentationScope("_WL_INTERNAL_SERVER_SCOPE", instrumentationScope, false);
        instrumentationManager.associateClassloaderWithScope(classLoader, instrumentationScope);
    }

    public boolean isHotswapAvailable() {
        return Server.isRedefineClassesSupported();
    }

    public DiagnosticMonitor[] getAvailableMonitors() {
        DiagnosticMonitor[] diagnosticMonitorArray = InstrumentationLibrary.getInstrumentationLibrary().getAllAvailableMonitors();
        return diagnosticMonitorArray;
    }

    public DiagnosticAction[] getAvailableActions() {
        DiagnosticAction[] diagnosticActionArray = InstrumentationLibrary.getInstrumentationLibrary().getAvailableActions();
        return diagnosticActionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstrumentationScope[] getInstrumentationScopes() {
        List list = this.instrumentationScopes;
        synchronized (list) {
            InstrumentationScope[] instrumentationScopeArray = new InstrumentationScope[this.instrumentationScopes.size()];
            return this.instrumentationScopes.toArray(instrumentationScopeArray);
        }
    }

    public InstrumentationScope createInstrumentationScope(String string) throws ScopeAlreadyExistsException {
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("Creating instrumentation scope: " + string);
        }
        InstrumentationScope instrumentationScope = new InstrumentationScope(string);
        this.addInstrumentationScope(string, instrumentationScope);
        return instrumentationScope;
    }

    public InstrumentationScope createInstrumentationScope(String string, WLDFInstrumentationBean wLDFInstrumentationBean) throws ScopeAlreadyExistsException {
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("Creating instrumentation scope: " + string);
        }
        InstrumentationScope instrumentationScope = InstrumentationScope.createInstrumentationScope(string, wLDFInstrumentationBean);
        this.addInstrumentationScope(string, instrumentationScope);
        if ("_WL_INTERNAL_SERVER_SCOPE".equals(string)) {
            this.serverInstrumentationScope = instrumentationScope;
        }
        return instrumentationScope;
    }

    private void addInstrumentationScope(String string, InstrumentationScope instrumentationScope) throws ScopeAlreadyExistsException {
        this.addInstrumentationScope(string, instrumentationScope, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addInstrumentationScope(String string, InstrumentationScope instrumentationScope, boolean bl) throws ScopeAlreadyExistsException {
        if (!this.isValid()) {
            instrumentationScope.setEnabled(false);
        }
        List list = this.instrumentationScopes;
        synchronized (list) {
            if (this.findInstrumentationScope(string) != null) {
                throw new ScopeAlreadyExistsException("Instrumentation scope already exists for " + string);
            }
            if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
                InstrumentationDebug.DEBUG_CONFIG.debug("Adding instrumentation scope: " + string);
            }
            instrumentationScope.initialize();
            this.instrumentationScopes.add(instrumentationScope);
            if (bl) {
                this.installDyeInjectionMonitor(instrumentationScope);
            }
        }
    }

    private boolean hasEnabledScope() {
        for (InstrumentationScope instrumentationScope : this.instrumentationScopes) {
            if (!instrumentationScope.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public void installDyeInjectionMonitor(InstrumentationScope instrumentationScope) {
        boolean bl;
        InstrumentationScope instrumentationScope2 = this.findInstrumentationScope("_WL_INTERNAL_SERVER_SCOPE");
        DiagnosticMonitorControl diagnosticMonitorControl = null;
        if (instrumentationScope2 != null) {
            diagnosticMonitorControl = instrumentationScope2.findDiagnosticMonitorControl("DyeInjection");
        }
        boolean bl2 = bl = diagnosticMonitorControl != null ? diagnosticMonitorControl.isEnabled() : false;
        if (this.hasEnabledScope()) {
            if (diagnosticMonitorControl == null || !bl) {
                diagnosticMonitorControl = new StandardMonitorControl("DyeInjection");
            }
        } else {
            diagnosticMonitorControl = null;
        }
        DyeInjectionMonitorSupport.setDyeInjectionMonitor(diagnosticMonitorControl);
    }

    public void installDyeInjectionMonitor_OLD(InstrumentationScope instrumentationScope) {
        if (instrumentationScope.getName().equals("_WL_INTERNAL_SERVER_SCOPE")) {
            DiagnosticMonitorControl diagnosticMonitorControl = instrumentationScope.findDiagnosticMonitorControl("DyeInjection");
            if (diagnosticMonitorControl != null && !diagnosticMonitorControl.isEnabled()) {
                diagnosticMonitorControl = null;
            }
            DyeInjectionMonitorSupport.setDyeInjectionMonitor(diagnosticMonitorControl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstrumentationScope findInstrumentationScope(String string) {
        List list = this.instrumentationScopes;
        synchronized (list) {
            for (InstrumentationScope instrumentationScope : this.instrumentationScopes) {
                if (!string.equals(instrumentationScope.getName())) continue;
                return instrumentationScope;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInstrumentationScope(InstrumentationScope instrumentationScope) {
        String string = instrumentationScope.getName();
        List list = this.instrumentationScopes;
        synchronized (list) {
            if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
                InstrumentationDebug.DEBUG_CONFIG.debug("Deleting instrumentation scope: " + string);
            }
            this.statsForDeletedScopes.add(instrumentationScope.getInstrumentationStatistics());
            DiagnosticMonitorControl[] diagnosticMonitorControlArray = instrumentationScope.getMonitorControlsInScope();
            int n = diagnosticMonitorControlArray != null ? diagnosticMonitorControlArray.length : 0;
            for (int i = 0; i < n; ++i) {
                diagnosticMonitorControlArray[i].setEnabled(false);
            }
            this.instrumentationScopes.remove(instrumentationScope);
        }
        if ("_WL_INTERNAL_SERVER_SCOPE".equals(string)) {
            this.serverInstrumentationScope = null;
            DyeInjectionMonitorSupport.setDyeInjectionMonitor(null);
        }
    }

    public void setDyeMask(InstrumentationScope instrumentationScope, long l) {
        DiagnosticMonitorControl[] diagnosticMonitorControlArray = instrumentationScope.getMonitorControlsInScope();
        int n = diagnosticMonitorControlArray != null ? diagnosticMonitorControlArray.length : 0;
        for (int i = 0; i < n; ++i) {
            this.setDyeMask(diagnosticMonitorControlArray[i], l);
        }
    }

    public void setDyeMask(DiagnosticMonitor diagnosticMonitor, long l) {
        diagnosticMonitor.setDyeMask(l);
    }

    public void setDyeMask(InstrumentationScope instrumentationScope, String string, long l) {
        DiagnosticMonitorControl[] diagnosticMonitorControlArray = instrumentationScope.getMonitorControlsInScope();
        int n = diagnosticMonitorControlArray != null ? diagnosticMonitorControlArray.length : 0;
        for (int i = 0; i < n; ++i) {
            DiagnosticMonitorControl diagnosticMonitorControl = diagnosticMonitorControlArray[i];
            this.setDyeMask(diagnosticMonitorControl, l);
        }
    }

    public void weaveClass(InstrumentationScope instrumentationScope, String string) throws FeatureNotAvailableException, ClassNotFoundException, InstrumentationException {
    }

    public void associateClassloaderWithScope(ClassLoader classLoader, InstrumentationScope instrumentationScope) {
        this.classLoaderMap.put(classLoader, instrumentationScope);
    }

    public InstrumentationScope getAssociatedScope(ClassLoader classLoader) {
        return (InstrumentationScope)this.classLoaderMap.get(classLoader);
    }

    private List array2list(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = objectArray != null ? objectArray.length : 0;
        for (int i = 0; i < n; ++i) {
            arrayList.add(objectArray[i]);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstrumentationEventListener(InstrumentationEventListener instrumentationEventListener) {
        InstrumentationManager instrumentationManager = this;
        synchronized (instrumentationManager) {
            List list = this.array2list(this.eventsListeners);
            if (!list.contains(instrumentationEventListener)) {
                list.add(instrumentationEventListener);
                InstrumentationEventListener[] instrumentationEventListenerArray = new InstrumentationEventListener[list.size()];
                this.eventsListeners = list.toArray(instrumentationEventListenerArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstrumentationEventListener(InstrumentationEventListener instrumentationEventListener) {
        InstrumentationManager instrumentationManager = this;
        synchronized (instrumentationManager) {
            List list = this.array2list(this.eventsListeners);
            if (list.contains(instrumentationEventListener)) {
                list.remove(instrumentationEventListener);
                InstrumentationEventListener[] instrumentationEventListenerArray = new InstrumentationEventListener[list.size()];
                this.eventsListeners = list.toArray(instrumentationEventListenerArray);
            }
        }
    }

    public InstrumentationStatistics getInstrumentationStatistics() {
        InstrumentationStatistics instrumentationStatistics = new InstrumentationStatistics();
        instrumentationStatistics.add(this.statsForDeletedScopes);
        for (InstrumentationScope instrumentationScope : this.instrumentationScopes) {
            instrumentationStatistics.add(instrumentationScope.getInstrumentationStatistics());
        }
        return instrumentationStatistics;
    }

    void propagateInstrumentationEvents(List list) {
        InstrumentationEventListener[] instrumentationEventListenerArray = this.eventsListeners;
        int n = instrumentationEventListenerArray != null ? instrumentationEventListenerArray.length : 0;
        for (int i = 0; i < n; ++i) {
            InstrumentationEventListener instrumentationEventListener = instrumentationEventListenerArray[i];
            try {
                for (DataRecord dataRecord : list) {
                    instrumentationEventListener.handleInstrumentationEvent(dataRecord);
                }
                continue;
            }
            catch (Exception exception) {
                UnexpectedExceptionHandler.handle("Could not propagate events to listener " + instrumentationEventListener, exception);
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isEnabled() {
        return this.valid && this.serverInstrumentationScope != null ? this.serverInstrumentationScope.isEnabled() : false;
    }

    public boolean isSynchronousEventPersistenceEnabled() {
        return this.synchronousEventPersistence;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.attributesChanged(propertyChangeEvent.getSource());
    }

    private void attributesChanged(Object object) {
        if (object instanceof WLDFServerDiagnosticMBean) {
            WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean = (WLDFServerDiagnosticMBean)object;
            long l = wLDFServerDiagnosticMBean.getEventPersistenceInterval();
            if (l != this.eventsPersistenceInterval) {
                EventQueue.getInstance().setTimerInterval(l);
                this.eventsPersistenceInterval = l;
            }
            this.synchronousEventPersistence = wLDFServerDiagnosticMBean.isSynchronousEventPersistenceEnabled();
        }
    }

    Map findAttachedActionTypes() {
        HashMap hashMap = new HashMap();
        if (this.serverInstrumentationScope != null) {
            this.serverInstrumentationScope.findAttachedActionTypes(hashMap);
        }
        if (this.instrumentationScopes != null) {
            for (InstrumentationScope instrumentationScope : this.instrumentationScopes) {
                instrumentationScope.findAttachedActionTypes(hashMap);
            }
        }
        return hashMap;
    }

    static boolean isKernelIdentity() {
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        return SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject);
    }

    public void updateServerManagedMonitors(int n) {
        if (this.serverManagedMonitors == null || this.serverManagedMonitors.isEmpty()) {
            return;
        }
        boolean bl = DataGatheringManager.isGatheringEnabled();
        boolean bl2 = DataGatheringManager.jfrActionsDisabled();
        block2: for (DiagnosticMonitorControl diagnosticMonitorControl : this.serverManagedMonitors.values()) {
            if (!bl || DataGatheringManager.convertVolume(diagnosticMonitorControl.getDiagnosticVolume()) > n) {
                if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
                    InstrumentationDebug.DEBUG_CONFIG.debug("monitor disabled: " + diagnosticMonitorControl.getType());
                }
                diagnosticMonitorControl.setEnabled(false);
                continue;
            }
            if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
                InstrumentationDebug.DEBUG_CONFIG.debug("monitor enabled: " + diagnosticMonitorControl.getType());
            }
            diagnosticMonitorControl.setEnabled(true);
            if (!bl2 || !(diagnosticMonitorControl instanceof DelegatingMonitorControl)) continue;
            DelegatingMonitorControl delegatingMonitorControl = (DelegatingMonitorControl)diagnosticMonitorControl;
            for (DiagnosticAction diagnosticAction : delegatingMonitorControl.getActions()) {
                if (!diagnosticAction.getType().equals("FlightRecorderAroundAction") && !diagnosticAction.getType().equals("FlightRecorderStatelessAction")) continue;
                try {
                    if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
                        InstrumentationDebug.DEBUG_CONFIG.debug("Removing " + diagnosticAction.getType() + " from monitor: " + diagnosticMonitorControl.getType());
                    }
                    delegatingMonitorControl.removeAction(diagnosticAction);
                    if (!diagnosticAction.requiresArgumentsCapture()) continue block2;
                    delegatingMonitorControl.subvertArgumentsCaptureNeededCheck();
                }
                catch (ActionNotFoundException actionNotFoundException) {}
                continue block2;
            }
        }
    }

    private void createServerManagedScope() {
        if (this.serverManagedScope != null) {
            return;
        }
        this.serverManagedScope = InstrumentationScope.createInstrumentationScope(WEBLOGIC_INSTRUMENTATION_SERVER_MANAGED_SCOPE, null);
    }

    private void setupActionList(DelegatingMonitorControl delegatingMonitorControl) {
        InstrumentationLibrary instrumentationLibrary = InstrumentationLibrary.getInstrumentationLibrary();
        for (String string : delegatingMonitorControl.getCompatibleActionTypes()) {
            try {
                DiagnosticAction diagnosticAction = instrumentationLibrary.getDiagnosticAction(string);
                if (diagnosticAction == null) {
                    DiagnosticsLogger.logNonExistentActionType((String)this.serverManagedScope.getName(), (String)delegatingMonitorControl.getType(), (String)string);
                    continue;
                }
                delegatingMonitorControl.addAction(diagnosticAction);
            }
            catch (DuplicateActionException duplicateActionException) {
                DiagnosticsLogger.logDuplicateActionInMonitor((String)this.serverManagedScope.getName(), (String)delegatingMonitorControl.getType(), (String)string);
            }
            catch (IncompatibleActionException incompatibleActionException) {
                DiagnosticsLogger.logIncompatibleAction((String)this.serverManagedScope.getName(), (String)delegatingMonitorControl.getType(), (String)string);
            }
        }
    }

    public DiagnosticMonitorControl getServerManagedMonitorControl(String string) {
        if (string != null) {
            return this.serverManagedMonitors.get(string);
        }
        return null;
    }

    private boolean verifyEnabledServerManagedMonitorEventClassesLoadable() {
        boolean bl = true;
        if (this.serverManagedMonitors == null || this.serverManagedMonitors.isEmpty()) {
            return bl;
        }
        for (DiagnosticMonitorControl diagnosticMonitorControl : this.serverManagedMonitors.values()) {
            String string = diagnosticMonitorControl.getEventClassName();
            if (string == null) {
                if (!InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) continue;
                InstrumentationDebug.DEBUG_CONFIG.debug("Monitor has null event class name: " + diagnosticMonitorControl.getType());
                continue;
            }
            try {
                Class<?> clazz = Class.forName(string);
                if (!InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) continue;
                InstrumentationDebug.DEBUG_CONFIG.debug("Loaded event class for Monitor : " + diagnosticMonitorControl.getType());
            }
            catch (Throwable throwable) {
                bl = false;
                if (!InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) continue;
                InstrumentationDebug.DEBUG_CONFIG.debug("Unable to load event class: " + string + ", specified by Monitor: " + diagnosticMonitorControl.getType(), throwable);
            }
        }
        return bl;
    }

    public boolean isGatheringExtended() {
        InstrumentationLibrary instrumentationLibrary = InstrumentationLibrary.getInstrumentationLibrary();
        return instrumentationLibrary.isGatheringExtended();
    }

    public Map<String, String> getValueRenderersByType() {
        InstrumentationLibrary instrumentationLibrary = InstrumentationLibrary.getInstrumentationLibrary();
        return instrumentationLibrary.getValueRenderersByType();
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }
}

