/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import com.bea.adaptive.harvester.WatchedValues;
import java.util.HashMap;
import java.util.Map;
import weblogic.diagnostics.harvester.WLDFHarvesterUtils;
import weblogic.diagnostics.harvester.internal.TreeBeanHarvestableDataProviderHelper;
import weblogic.diagnostics.instrumentation.HarvesterAttributeNormalizer;
import weblogic.diagnostics.instrumentation.InstrumentationScope;
import weblogic.diagnostics.instrumentation.InstrumentationStatistics;
import weblogic.management.ManagementException;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.WLDFInstrumentationRuntimeMBean;

public class InstrumentationRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements WLDFInstrumentationRuntimeMBean {
    private static final long NANOS_PER_MILLI = 1000000L;
    private InstrumentationScope scope;
    private HarvesterAttributeNormalizer attrNormalizer = new HarvesterAttributeNormalizer();

    public InstrumentationRuntimeMBeanImpl(InstrumentationScope instrumentationScope, RuntimeMBean runtimeMBean) throws ManagementException {
        super(instrumentationScope.getName(), runtimeMBean);
        this.scope = instrumentationScope;
    }

    private InstrumentationStatistics getInstrumentationStatistics() {
        return this.scope != null ? this.scope.getInstrumentationStatistics() : null;
    }

    public int getInspectedClassesCount() {
        InstrumentationStatistics instrumentationStatistics = this.getInstrumentationStatistics();
        return instrumentationStatistics != null ? instrumentationStatistics.getInspectedClassesCount() : 0;
    }

    public int getModifiedClassesCount() {
        InstrumentationStatistics instrumentationStatistics = this.getInstrumentationStatistics();
        return instrumentationStatistics != null ? instrumentationStatistics.getModifiedClassesCount() : 0;
    }

    public long getMinWeavingTime() {
        InstrumentationStatistics instrumentationStatistics = this.getInstrumentationStatistics();
        return instrumentationStatistics != null ? instrumentationStatistics.getMinWeavingTime() / 1000000L : 0L;
    }

    public long getMaxWeavingTime() {
        InstrumentationStatistics instrumentationStatistics = this.getInstrumentationStatistics();
        return instrumentationStatistics != null ? instrumentationStatistics.getMaxWeavingTime() / 1000000L : 0L;
    }

    public long getTotalWeavingTime() {
        InstrumentationStatistics instrumentationStatistics = this.getInstrumentationStatistics();
        return instrumentationStatistics != null ? instrumentationStatistics.getTotalWeavingTime() / 1000000L : 0L;
    }

    public int getExecutionJoinpointCount() {
        InstrumentationStatistics instrumentationStatistics = this.getInstrumentationStatistics();
        return instrumentationStatistics != null ? instrumentationStatistics.getExecutionJoinpointCount() : 0;
    }

    public int getCallJoinpointCount() {
        InstrumentationStatistics instrumentationStatistics = this.getInstrumentationStatistics();
        return instrumentationStatistics != null ? instrumentationStatistics.getCallJoinpointCount() : 0;
    }

    public int getClassweaveAbortCount() {
        InstrumentationStatistics instrumentationStatistics = this.getInstrumentationStatistics();
        return instrumentationStatistics != null ? instrumentationStatistics.getClassweaveAbortCount() : 0;
    }

    public Map getMethodInvocationStatistics() {
        InstrumentationStatistics instrumentationStatistics = this.getInstrumentationStatistics();
        return instrumentationStatistics != null ? instrumentationStatistics.getMethodInvocationStatistics() : new HashMap();
    }

    public Object getMethodInvocationStatisticsData(String string) throws ManagementException {
        string = this.attrNormalizer.getPartiallyNormalizedInvocationAttributeName(string);
        try {
            String string2 = TreeBeanHarvestableDataProviderHelper.getObjectNameForBean(this);
            Object[] objectArray = WLDFHarvesterUtils.getValue("ServerRuntime", WLDFInstrumentationRuntimeMBean.class.getName(), string2, string);
            if (objectArray != null && objectArray instanceof WatchedValues.AttributeTrackedDataItem) {
                objectArray = ((WatchedValues.AttributeTrackedDataItem)objectArray).getData();
            }
            if (objectArray != null && objectArray.getClass().isArray()) {
                objectArray = WLDFHarvesterUtils.getLeafValues(objectArray);
            }
            return objectArray;
        }
        catch (Exception exception) {
            ManagementException managementException = new ManagementException(exception.getMessage());
            managementException.setStackTrace(exception.getStackTrace());
            throw managementException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMethodInvocationStatisticsData(String string) throws ManagementException {
        Object object = this.getMethodInvocationStatisticsData(string);
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            Object object2 = object;
            synchronized (object2) {
                Map map = (Map)object;
                map.clear();
            }
        }
    }

    public Map getMethodMemoryAllocationStatistics() {
        InstrumentationStatistics instrumentationStatistics = this.getInstrumentationStatistics();
        return instrumentationStatistics != null ? instrumentationStatistics.getMethodMemoryAllocationStatistics() : new HashMap();
    }

    public Object getMethodMemoryAllocationStatisticsData(String string) throws ManagementException {
        string = this.attrNormalizer.getPartiallyNormalizedAllocationAttributeName(string);
        try {
            String string2 = TreeBeanHarvestableDataProviderHelper.getObjectNameForBean(this);
            Object[] objectArray = WLDFHarvesterUtils.getValue("ServerRuntime", WLDFInstrumentationRuntimeMBean.class.getName(), string2, string);
            if (objectArray != null && objectArray instanceof WatchedValues.AttributeTrackedDataItem) {
                objectArray = ((WatchedValues.AttributeTrackedDataItem)objectArray).getData();
            }
            if (objectArray != null && objectArray.getClass().isArray()) {
                objectArray = WLDFHarvesterUtils.getLeafValues(objectArray);
            }
            return objectArray;
        }
        catch (Exception exception) {
            ManagementException managementException = new ManagementException(exception.getMessage());
            managementException.setStackTrace(exception.getStackTrace());
            throw managementException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMethodMemoryAllocationStatisticsData(String string) throws ManagementException {
        Object object = this.getMethodMemoryAllocationStatisticsData(string);
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            Object object2 = object;
            synchronized (object2) {
                Map map = (Map)object;
                map.clear();
            }
        }
    }
}

