/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import weblogic.diagnostics.instrumentation.InstrumentationRuntimeMBeanImpl;
import weblogic.management.WebLogicMBeanImplBeanInfo;
import weblogic.management.internal.mbean.BeanInfoHelper;
import weblogic.management.runtime.WLDFInstrumentationRuntimeMBean;

public class InstrumentationRuntimeMBeanImplBeanInfo
extends WebLogicMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = WLDFInstrumentationRuntimeMBean.class;

    public InstrumentationRuntimeMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public InstrumentationRuntimeMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = InstrumentationRuntimeMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("since", "9.0.0.0");
        beanDescriptor.setValue("package", "weblogic.diagnostics.instrumentation");
        String string = new String("<p>This interface defines various methods for accessing runtime information about the diagnostic instrumentation system.</p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.runtime.WLDFInstrumentationRuntimeMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("CallJoinpointCount")) {
            string2 = "getCallJoinpointCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("CallJoinpointCount", WLDFInstrumentationRuntimeMBean.class, string2, string);
            map.put("CallJoinpointCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of affected CALL joinpoints for all classes that were inspected. (CALL joinpoints are on the caller side.)</p> ");
        }
        if (!map.containsKey("ClassweaveAbortCount")) {
            string2 = "getClassweaveAbortCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ClassweaveAbortCount", WLDFInstrumentationRuntimeMBean.class, string2, string);
            map.put("ClassweaveAbortCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Number of classes for which the class weaving aborted with some exceptional situation</p> ");
        }
        if (!map.containsKey("ExecutionJoinpointCount")) {
            string2 = "getExecutionJoinpointCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ExecutionJoinpointCount", WLDFInstrumentationRuntimeMBean.class, string2, string);
            map.put("ExecutionJoinpointCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of affected EXECUTION joinpoints for all classes that were inspected. (EXECUTION joinpoints are on the callee side.)</p> ");
        }
        if (!map.containsKey("InspectedClassesCount")) {
            string2 = "getInspectedClassesCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("InspectedClassesCount", WLDFInstrumentationRuntimeMBean.class, string2, string);
            map.put("InspectedClassesCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of classes inspected for weaving (weaving is the insertion of diagnostic code).</p> ");
        }
        if (!map.containsKey("MaxWeavingTime")) {
            string2 = "getMaxWeavingTime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MaxWeavingTime", WLDFInstrumentationRuntimeMBean.class, string2, string);
            map.put("MaxWeavingTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>For all classes, the weaving time in nanoseconds for the class that required the most time to process (includes the time spent both for inspection and for modification).</p> ");
        }
        if (!map.containsKey("MethodInvocationStatistics")) {
            string2 = "getMethodInvocationStatistics";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MethodInvocationStatistics", WLDFInstrumentationRuntimeMBean.class, string2, string);
            map.put("MethodInvocationStatistics", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Map containing the method invocation statistics for this scope. It is a nested Map structure. The first level Map is keyed by the fully qualified class names within the instrumentation scope. It yields another Map containing the method data within an instrumented class. The method data Map is keyed by the method name and it yields another Map structure that is keyed by the method signatures. Method signature key is represented by a comma separated list of the input parameters. Each method signature key's value is the ultimate statistics Map object that contains entries with predefined keys: count, min, max, avg, sum, sum_of_squares, and std_deviation. The value for these keys indicate the associated metric.</p>  <p>When specifying this attribute as part of a variable within a WLDF Watch rule expression, you must explicitly declare the WLDFInstrumentationRuntime type. Otherwise, the system can't determine the type when validating the attribute expression, and the expression won't work.</p> ");
            propertyDescriptor.setValue("harvesterAttributeNormalizerClass", "weblogic.diagnostics.instrumentation.HarvesterAttributeNormalizer");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.3", null, (String)this.targetVersion) && !map.containsKey("MethodMemoryAllocationStatistics")) {
            string2 = "getMethodMemoryAllocationStatistics";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MethodMemoryAllocationStatistics", WLDFInstrumentationRuntimeMBean.class, string2, string);
            map.put("MethodMemoryAllocationStatistics", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Map containing the method memory allocation statistics for this scope. It is a nested Map structure. The first level Map is keyed by the fully qualified class names within the instrumentation scope. It yields another Map containing the method data within an instrumented class. The method data Map is keyed by the method name and it yields another Map structure that is keyed by the method signatures. Method signature key is represented by a comma separated list of the input parameters. Each method signature key's value is the ultimate statistics Map object that contains entries with predefined keys: count, min, max, avg, sum, sum_of_squares, and std_deviation. The value for these keys indicate the associated metric.</p>  <p>When specifying this attribute as part of a variable within a WLDF Watch rule expression, you must explicitly declare the WLDFInstrumentationRuntime type. Otherwise, the system can't determine the type when validating the attribute expression, and the expression won't work.</p> ");
            propertyDescriptor.setValue("since", "10.3.3");
            propertyDescriptor.setValue("harvesterAttributeNormalizerClass", "weblogic.diagnostics.instrumentation.HarvesterAttributeNormalizer");
        }
        if (!map.containsKey("MinWeavingTime")) {
            string2 = "getMinWeavingTime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("MinWeavingTime", WLDFInstrumentationRuntimeMBean.class, string2, string);
            map.put("MinWeavingTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>For all classes, the weaving time in nanoseconds for the class that required the least time to process (includes the time spent both for inspection and for modification).</p> ");
        }
        if (!map.containsKey("ModifiedClassesCount")) {
            string2 = "getModifiedClassesCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ModifiedClassesCount", WLDFInstrumentationRuntimeMBean.class, string2, string);
            map.put("ModifiedClassesCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of modified classes (classes where diagnostic code has been inserted).</p> ");
        }
        if (!map.containsKey("TotalWeavingTime")) {
            string2 = "getTotalWeavingTime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("TotalWeavingTime", WLDFInstrumentationRuntimeMBean.class, string2, string);
            map.put("TotalWeavingTime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>For all classes, the total weaving time in nanoseconds for processing (includes the time spent both for inspection and for modification).</p> ");
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = WLDFInstrumentationRuntimeMBean.class.getMethod("preDeregister", new Class[0]);
        ParameterDescriptor[] parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(parameterDescriptorArray)) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", " ");
            methodDescriptor.setValue("role", "operation");
        }
        method = WLDFInstrumentationRuntimeMBean.class.getMethod("getMethodInvocationStatisticsData", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{InstrumentationRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"expr", (String)"Expression conforming to the harvester syntax for the MethodInvocationStatistics property without the attribute name prefix. ")};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "Drills down into the nested MethodInvocationStatistics Map structure and returns the object at the specified level. ");
            methodDescriptor.setValue("role", "operation");
        }
        method = WLDFInstrumentationRuntimeMBean.class.getMethod("resetMethodInvocationStatisticsData", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{InstrumentationRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"expr", (String)"Expression conforming to the harvester syntax for the MethodInvocationStatistics property without the attribute name prefix. ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "Resets the nested MethodInvocationStatistics structure and reinitializes the underlying metrics. ");
            methodDescriptor.setValue("role", "operation");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.3", null, (String)this.targetVersion)) {
            method = WLDFInstrumentationRuntimeMBean.class.getMethod("getMethodMemoryAllocationStatisticsData", String.class);
            parameterDescriptorArray = new ParameterDescriptor[]{InstrumentationRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"expr", (String)"Expression conforming to the harvester syntax for the MethodMemoryAllocationStatistics property without the attribute name prefix. ")};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("since", "10.3.3");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "Drills down into the nested MethodMemoryAllocationStatistics Map structure and returns the object at the specified level. ");
                methodDescriptor.setValue("role", "operation");
                methodDescriptor.setValue("since", "10.3.3");
            }
        }
        if (BeanInfoHelper.isVersionCompliant((String)"10.3.3", null, (String)this.targetVersion)) {
            method = WLDFInstrumentationRuntimeMBean.class.getMethod("resetMethodMemoryAllocationStatisticsData", String.class);
            parameterDescriptorArray = new ParameterDescriptor[]{InstrumentationRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"expr", (String)"Expression conforming to the harvester syntax for the MethodMemoryAllocationStatistics property without the attribute name prefix. ")};
            string = BeanInfoHelper.buildMethodKey((Method)method);
            if (!map.containsKey(string)) {
                methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
                methodDescriptor.setValue("since", "10.3.3");
                map.put(string, methodDescriptor);
                methodDescriptor.setValue("description", "Resets the nested MethodMemoryAllocationStatistics structure and reinitializes the underlying metrics. ");
                methodDescriptor.setValue("role", "operation");
                methodDescriptor.setValue("since", "10.3.3");
            }
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

