/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import weblogic.diagnostics.context.DiagnosticContextHelper;
import weblogic.diagnostics.descriptor.WLDFInstrumentationBean;
import weblogic.diagnostics.descriptor.WLDFInstrumentationMonitorBean;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.instrumentation.CustomMonitorControl;
import weblogic.diagnostics.instrumentation.DelegatingMonitorControl;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticMonitorControl;
import weblogic.diagnostics.instrumentation.DuplicateActionException;
import weblogic.diagnostics.instrumentation.DuplicateMonitorException;
import weblogic.diagnostics.instrumentation.IncompatibleActionException;
import weblogic.diagnostics.instrumentation.InstrumentationDebug;
import weblogic.diagnostics.instrumentation.InstrumentationLibrary;
import weblogic.diagnostics.instrumentation.InstrumentationManager;
import weblogic.diagnostics.instrumentation.InstrumentationRuntimeMBeanImpl;
import weblogic.diagnostics.instrumentation.InstrumentationStatistics;
import weblogic.diagnostics.instrumentation.MonitorNotFoundException;
import weblogic.diagnostics.instrumentation.engine.InstrumentationEngineConfiguration;
import weblogic.diagnostics.instrumentation.engine.InstrumentorEngine;
import weblogic.diagnostics.instrumentation.engine.MonitorSpecification;
import weblogic.diagnostics.instrumentation.engine.base.PointcutExpression;
import weblogic.diagnostics.type.UnexpectedExceptionHandler;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.runtime.WLDFRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class InstrumentationScope
implements Serializable {
    private String name;
    private String description;
    private List diagnosticMonitorControls;
    private boolean enabled;
    private String[] includes;
    private String[] excludes;
    private transient InstrumentorEngine instrumentorEngine;
    private transient InstrumentationRuntimeMBeanImpl runtimeMbean;
    private WeakHashMap classLoadersMap = new WeakHashMap();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public InstrumentationScope(String string) {
        this.name = string;
        this.description = "";
        this.diagnosticMonitorControls = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagnosticMonitorControl findDiagnosticMonitorControl(String string) {
        List list = this.diagnosticMonitorControls;
        synchronized (list) {
            for (DiagnosticMonitorControl diagnosticMonitorControl : this.diagnosticMonitorControls) {
                if (!string.equals(diagnosticMonitorControl.getType())) continue;
                return diagnosticMonitorControl;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagnosticMonitorControl[] getMonitorControlsInScope() {
        List list = this.diagnosticMonitorControls;
        synchronized (list) {
            DiagnosticMonitorControl[] diagnosticMonitorControlArray = new DiagnosticMonitorControl[this.diagnosticMonitorControls.size()];
            return this.diagnosticMonitorControls.toArray(diagnosticMonitorControlArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitorControl(DiagnosticMonitorControl diagnosticMonitorControl) throws DuplicateMonitorException {
        List list = this.diagnosticMonitorControls;
        synchronized (list) {
            String string = diagnosticMonitorControl.getType();
            InstrumentationDebug.DEBUG_CONFIG.debug("Addmin monitor " + string + " to scope " + this.getName());
            if (this.findDiagnosticMonitorControl(string) != null) {
                throw new DuplicateMonitorException("Diagnostic monitor of type " + string + " already exists in instrumentation scope " + this.getName());
            }
            this.diagnosticMonitorControls.add(diagnosticMonitorControl);
            if (diagnosticMonitorControl.getInstrumentationScope() == null || !"_WL_INTERNAL_SERVER_SCOPE".equals(this.getName())) {
                diagnosticMonitorControl.setInstrumentationScope(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitorControl(DiagnosticMonitorControl diagnosticMonitorControl) throws MonitorNotFoundException {
        List list = this.diagnosticMonitorControls;
        synchronized (list) {
            String string = diagnosticMonitorControl.getType();
            InstrumentationDebug.DEBUG_CONFIG.debug("Removing monitor " + string + " from scope " + this.getName());
            diagnosticMonitorControl = this.findDiagnosticMonitorControl(string);
            if (diagnosticMonitorControl == null) {
                throw new MonitorNotFoundException("Diagnostic monitor of type " + string + " does not exist in instrumentation scope " + this.getName());
            }
            diagnosticMonitorControl.setEnabled(false);
            diagnosticMonitorControl.setInstrumentationScope(null);
            this.diagnosticMonitorControls.remove(diagnosticMonitorControl);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!this.enabled) {
            this.disableAllMonitors();
        }
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] stringArray) {
        this.includes = stringArray;
    }

    private void validateRegexPatterns(String[] stringArray) throws PatternSyntaxException {
        int n = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n; ++i) {
            Pattern.compile(stringArray[i]);
        }
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] stringArray) {
        this.excludes = stringArray;
    }

    public InstrumentationStatistics getInstrumentationStatistics() {
        return this.instrumentorEngine.getInstrumentationStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] instrumentClass(ClassLoader classLoader, String string, byte[] byArray) {
        Object object;
        Object object2 = byArray;
        if (this.isEnabled() && this.instrumentorEngine != null && (object = (Object)this.instrumentorEngine.instrumentClass(classLoader, string, byArray)) != null) {
            object2 = object;
        }
        object = this.classLoadersMap;
        synchronized (object) {
            this.classLoadersMap.put(classLoader, new WeakReference<ClassLoader>(classLoader));
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redefineClasses() {
        Class[] classArray;
        DiagnosticsLogger.logDiagnosticsClassRedefinition((String)this.getName());
        this.initialize();
        ArrayList arrayList = new ArrayList();
        Object object = this.classLoadersMap;
        synchronized (object) {
            classArray = this.classLoadersMap.keySet().iterator();
            while (classArray.hasNext()) {
                arrayList.add(classArray.next());
            }
        }
        if (arrayList.size() > 0) {
            try {
                object = Class.forName("weblogic.diagnostics.instrumentation.agent.WLDFInstrumentationAgent");
                classArray = new Class[]{List.class};
                Method method = ((Class)object).getMethod("redefineClasses", classArray);
                Object[] objectArray = new Object[]{arrayList};
                Object object2 = method.invoke(null, objectArray);
            }
            catch (Throwable throwable) {
                DiagnosticsLogger.logDiagnosticsClassRedefinitionFailed((String)this.getName(), (Throwable)throwable);
            }
        }
    }

    private static boolean isParent(ClassLoader classLoader, ClassLoader classLoader2) {
        while (classLoader2 != null) {
            if (classLoader2 == classLoader) {
                return true;
            }
            classLoader2 = classLoader2.getParent();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findAttachedActionTypes(Map map) {
        for (Object e : this.diagnosticMonitorControls) {
            if (!(e instanceof DelegatingMonitorControl)) continue;
            DelegatingMonitorControl delegatingMonitorControl = (DelegatingMonitorControl)e;
            DiagnosticAction[] diagnosticActionArray = delegatingMonitorControl.getActions();
            int n = diagnosticActionArray != null ? diagnosticActionArray.length : 0;
            for (int i = 0; i < n; ++i) {
                String string = diagnosticActionArray[i].getType();
                Map map2 = map;
                synchronized (map2) {
                    String string2 = (String)map.get(string);
                    string2 = string2 == null ? this.getName() : string2 + "," + this.getName();
                    map.put(string, string2);
                    continue;
                }
            }
        }
    }

    void initialize() {
        InstrumentationEngineConfiguration instrumentationEngineConfiguration = InstrumentationEngineConfiguration.getInstrumentationEngineConfiguration();
        ArrayList<MonitorSpecification> arrayList = new ArrayList<MonitorSpecification>();
        for (DiagnosticMonitorControl diagnosticMonitorControl : this.diagnosticMonitorControls) {
            MonitorSpecification monitorSpecification = null;
            monitorSpecification = diagnosticMonitorControl instanceof CustomMonitorControl ? ((CustomMonitorControl)diagnosticMonitorControl).getMonitorSpecification() : instrumentationEngineConfiguration.getMonitorSpecification(diagnosticMonitorControl.getType());
            if (monitorSpecification == null) continue;
            arrayList.add(monitorSpecification);
        }
        MonitorSpecification[] monitorSpecificationArray = new MonitorSpecification[arrayList.size()];
        monitorSpecificationArray = arrayList.toArray(monitorSpecificationArray);
        boolean bl = InstrumentationManager.getInstrumentationManager().isHotswapAvailable();
        this.instrumentorEngine = new InstrumentorEngine(this.name, monitorSpecificationArray, bl);
        this.instrumentorEngine.setDiagnosticMonitors(this.diagnosticMonitorControls);
        try {
            if (this.includes != null) {
                this.instrumentorEngine.setIncludePatterns(this.includes);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            DiagnosticsLogger.logInvalidInclusionPatternError((String)this.name);
        }
        try {
            if (this.excludes != null) {
                this.instrumentorEngine.setExcludePatterns(this.excludes);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            DiagnosticsLogger.logInvalidExclusionPatternError((String)this.name);
        }
    }

    void registerRuntime(RuntimeMBean runtimeMBean) {
        try {
            if (this.runtimeMbean == null && ManagementService.getRuntimeAccess(kernelId) != null) {
                ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
                WLDFRuntimeMBean wLDFRuntimeMBean = null;
                if (serverRuntimeMBean != null) {
                    wLDFRuntimeMBean = serverRuntimeMBean.getWLDFRuntime();
                }
                if (runtimeMBean == null) {
                    runtimeMBean = wLDFRuntimeMBean;
                }
                this.runtimeMbean = new InstrumentationRuntimeMBeanImpl(this, runtimeMBean);
                if (wLDFRuntimeMBean != null) {
                    wLDFRuntimeMBean.addWLDFInstrumentationRuntime(this.runtimeMbean);
                }
            }
        }
        catch (ManagementException managementException) {
            UnexpectedExceptionHandler.handle("Internal error: failed to create runtime mbean for instrumentation scope " + this.getName(), managementException);
        }
    }

    void unregisterRuntime() {
        try {
            if (this.runtimeMbean != null) {
                ServerRuntimeMBean serverRuntimeMBean;
                if (ManagementService.getRuntimeAccess(kernelId) != null && (serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime()) != null) {
                    WLDFRuntimeMBean wLDFRuntimeMBean = serverRuntimeMBean.getWLDFRuntime();
                    wLDFRuntimeMBean.removeWLDFInstrumentationRuntime(this.runtimeMbean);
                }
                this.runtimeMbean.unregister();
                this.runtimeMbean = null;
            }
        }
        catch (ManagementException managementException) {
            UnexpectedExceptionHandler.handle("Internal error: failed to unregister runtime mbean for instrumentation scope " + this.getName(), managementException);
        }
    }

    public synchronized void merge(InstrumentationScope instrumentationScope) {
        int n;
        DiagnosticMonitorControl[] diagnosticMonitorControlArray;
        if (!this.name.equals(instrumentationScope.getName())) {
            return;
        }
        boolean bl = false;
        if (this.enabled != instrumentationScope.enabled) {
            bl = true;
        }
        if (!this.isIdenticalList(this.includes, instrumentationScope.includes)) {
            bl = true;
        }
        if (!this.isIdenticalList(this.excludes, instrumentationScope.excludes)) {
            bl = true;
        }
        int n2 = (diagnosticMonitorControlArray = this.getMonitorControlsInScope()) != null ? diagnosticMonitorControlArray.length : 0;
        for (n = 0; n < n2; ++n) {
            if (instrumentationScope.findDiagnosticMonitorControl(diagnosticMonitorControlArray[n].getType()) != null) continue;
            try {
                this.removeMonitorControl(diagnosticMonitorControlArray[n]);
                bl = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        diagnosticMonitorControlArray = instrumentationScope.getMonitorControlsInScope();
        n2 = diagnosticMonitorControlArray != null ? diagnosticMonitorControlArray.length : 0;
        for (n = 0; n < n2; ++n) {
            DiagnosticMonitorControl diagnosticMonitorControl = diagnosticMonitorControlArray[n];
            DiagnosticMonitorControl diagnosticMonitorControl2 = this.findDiagnosticMonitorControl(diagnosticMonitorControl.getType());
            if (diagnosticMonitorControl2 != null) {
                CustomMonitorControl customMonitorControl;
                if (diagnosticMonitorControl2 instanceof CustomMonitorControl && diagnosticMonitorControl instanceof CustomMonitorControl && (customMonitorControl = (CustomMonitorControl)diagnosticMonitorControl2).isStructurallyDifferent((CustomMonitorControl)diagnosticMonitorControl)) {
                    bl = true;
                }
                if (!this.isIdenticalList(diagnosticMonitorControl2.getIncludes(), diagnosticMonitorControl.getIncludes())) {
                    bl = true;
                }
                if (!this.isIdenticalList(diagnosticMonitorControl2.getExcludes(), diagnosticMonitorControl.getExcludes())) {
                    bl = true;
                }
                diagnosticMonitorControl2.merge(diagnosticMonitorControl);
                continue;
            }
            try {
                this.addMonitorControl(diagnosticMonitorControlArray[n]);
                bl = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        InstrumentationManager instrumentationManager = InstrumentationManager.getInstrumentationManager();
        if ("_WL_INTERNAL_SERVER_SCOPE".equals(this.getName())) {
            this.enabled = instrumentationScope.isEnabled();
            if (!this.enabled) {
                this.disableAllMonitors();
            }
            instrumentationManager.installDyeInjectionMonitor(this);
        } else if (bl) {
            if (InstrumentationManager.getInstrumentationManager().isHotswapAvailable()) {
                this.enabled = instrumentationScope.isEnabled();
                this.includes = instrumentationScope.includes;
                this.excludes = instrumentationScope.excludes;
                instrumentationManager.installDyeInjectionMonitor(this);
                this.redefineClasses();
            } else {
                DiagnosticsLogger.logWarnHotswapUnavailable((String)this.getName());
            }
        }
    }

    private void disableAllMonitors() {
        if (this.diagnosticMonitorControls != null) {
            for (DiagnosticMonitorControl diagnosticMonitorControl : this.diagnosticMonitorControls) {
                diagnosticMonitorControl.setEnabled(false);
            }
        }
    }

    private boolean isIdenticalList(String[] stringArray, String[] stringArray2) {
        int n;
        int n2 = stringArray != null ? stringArray.length : 0;
        int n3 = n = stringArray2 != null ? stringArray2.length : 0;
        if (n2 != n) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            String string = stringArray[i];
            boolean bl = false;
            for (int j = 0; !bl && j < n; ++j) {
                if (!string.equals(stringArray2[j])) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static InstrumentationScope createInstrumentationScope(String string, WLDFInstrumentationBean wLDFInstrumentationBean) {
        InstrumentationScope instrumentationScope = new InstrumentationScope(string);
        if (wLDFInstrumentationBean != null) {
            instrumentationScope.setEnabled(wLDFInstrumentationBean.isEnabled());
            instrumentationScope.setExcludes(wLDFInstrumentationBean.getExcludes());
            instrumentationScope.setIncludes(wLDFInstrumentationBean.getIncludes());
            InstrumentationScope.readMonitors(instrumentationScope, wLDFInstrumentationBean.getWLDFInstrumentationMonitors());
        }
        if (!instrumentationScope.isEnabled()) {
            instrumentationScope.disableAllMonitors();
        }
        return instrumentationScope;
    }

    private static void readMonitors(InstrumentationScope instrumentationScope, WLDFInstrumentationMonitorBean[] wLDFInstrumentationMonitorBeanArray) {
        int n = wLDFInstrumentationMonitorBeanArray != null ? wLDFInstrumentationMonitorBeanArray.length : 0;
        InstrumentationEngineConfiguration instrumentationEngineConfiguration = InstrumentationEngineConfiguration.getInstrumentationEngineConfiguration();
        for (int i = 0; i < n; ++i) {
            WLDFInstrumentationMonitorBean wLDFInstrumentationMonitorBean = wLDFInstrumentationMonitorBeanArray[i];
            String string = wLDFInstrumentationMonitorBean.getName();
            DiagnosticMonitorControl diagnosticMonitorControl = null;
            MonitorSpecification monitorSpecification = instrumentationEngineConfiguration.getMonitorSpecification(string);
            diagnosticMonitorControl = monitorSpecification != null ? InstrumentationScope.createMonitorControl(instrumentationScope, wLDFInstrumentationMonitorBean) : InstrumentationScope.readCustomMonitor(instrumentationScope, wLDFInstrumentationMonitorBean);
            if (diagnosticMonitorControl == null) continue;
            diagnosticMonitorControl.setEnabled(wLDFInstrumentationMonitorBean.isEnabled());
            diagnosticMonitorControl.setDyeFilteringEnabled(wLDFInstrumentationMonitorBean.isDyeFilteringEnabled());
            diagnosticMonitorControl.setDyeMask(DiagnosticContextHelper.parseDyeMask(wLDFInstrumentationMonitorBean.getDyeMask()));
            diagnosticMonitorControl.setIncludes(wLDFInstrumentationMonitorBean.getIncludes());
            diagnosticMonitorControl.setExcludes(wLDFInstrumentationMonitorBean.getExcludes());
            if ("HttpSessionDebug".equals(string)) {
                diagnosticMonitorControl.argumentsCaptureNeeded = true;
            }
            InstrumentationScope.readProperties(diagnosticMonitorControl, wLDFInstrumentationMonitorBean.getProperties());
            if (diagnosticMonitorControl instanceof DelegatingMonitorControl) {
                InstrumentationScope.readMonitorActions(instrumentationScope, wLDFInstrumentationMonitorBean, (DelegatingMonitorControl)diagnosticMonitorControl);
            }
            try {
                instrumentationScope.addMonitorControl(diagnosticMonitorControl);
                continue;
            }
            catch (DuplicateMonitorException duplicateMonitorException) {
                DiagnosticsLogger.logDuplicateMonitorInScope((String)instrumentationScope.getName(), (String)diagnosticMonitorControl.getType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readProperties(DiagnosticMonitorControl diagnosticMonitorControl, String string) {
        if (string == null) {
            return;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            Properties properties = new Properties();
            properties.load(byteArrayInputStream);
            String[] stringArray = diagnosticMonitorControl.getAttributeNames();
            int n = stringArray != null ? stringArray.length : 0;
            for (int i = 0; i < n; ++i) {
                diagnosticMonitorControl.setAttribute(stringArray[i], null);
            }
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                diagnosticMonitorControl.setAttribute(string2, string3);
            }
        }
        catch (IOException iOException) {
            DiagnosticsLogger.logMonitorAttributeError((String)diagnosticMonitorControl.getName(), (String)string, (Throwable)iOException);
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void readMonitorActions(InstrumentationScope instrumentationScope, WLDFInstrumentationMonitorBean wLDFInstrumentationMonitorBean, DelegatingMonitorControl delegatingMonitorControl) {
        InstrumentationLibrary instrumentationLibrary = InstrumentationLibrary.getInstrumentationLibrary();
        String[] stringArray = wLDFInstrumentationMonitorBean.getActions();
        delegatingMonitorControl.removeAllActions();
        int n = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            try {
                DiagnosticAction diagnosticAction = instrumentationLibrary.getDiagnosticAction(string);
                if (diagnosticAction == null) {
                    DiagnosticsLogger.logNonExistentActionType((String)instrumentationScope.getName(), (String)delegatingMonitorControl.getType(), (String)string);
                    continue;
                }
                delegatingMonitorControl.addAction(diagnosticAction);
                continue;
            }
            catch (DuplicateActionException duplicateActionException) {
                DiagnosticsLogger.logDuplicateActionInMonitor((String)instrumentationScope.getName(), (String)delegatingMonitorControl.getType(), (String)string);
                continue;
            }
            catch (IncompatibleActionException incompatibleActionException) {
                DiagnosticsLogger.logIncompatibleAction((String)instrumentationScope.getName(), (String)delegatingMonitorControl.getType(), (String)string);
            }
        }
    }

    private static CustomMonitorControl readCustomMonitor(InstrumentationScope instrumentationScope, WLDFInstrumentationMonitorBean wLDFInstrumentationMonitorBean) {
        InstrumentationLibrary instrumentationLibrary = InstrumentationLibrary.getInstrumentationLibrary();
        CustomMonitorControl customMonitorControl = null;
        String string = wLDFInstrumentationMonitorBean.getName();
        if ("_WL_INTERNAL_SERVER_SCOPE".equals(instrumentationScope.getName())) {
            DiagnosticsLogger.logCustomMonitorInServerScopeError((String)string);
            return null;
        }
        if (!MonitorSpecification.isValidType((String)string)) {
            DiagnosticsLogger.logInvalidCharactersInMonitorType((String)instrumentationScope.getName(), (String)string);
            return null;
        }
        try {
            int n = MonitorSpecification.getLocationType((String)wLDFInstrumentationMonitorBean.getLocationType());
            if (n == 0) {
                DiagnosticsLogger.logMissingLocationForCustomMonitor((String)string, (String)instrumentationScope.getName());
                return null;
            }
            String string2 = wLDFInstrumentationMonitorBean.getPointcut();
            PointcutExpression pointcutExpression = PointcutExpression.Factory.parse((String)string2);
            MonitorSpecification monitorSpecification = new MonitorSpecification(string, n, pointcutExpression, true, true);
            customMonitorControl = new CustomMonitorControl(string);
            customMonitorControl.setLocationType(n);
            customMonitorControl.setMonitorSpecification(monitorSpecification);
            customMonitorControl.setPointcut(string2);
        }
        catch (Exception exception) {
            DiagnosticsLogger.logMonitorConfigurationError((String)string, (String)instrumentationScope.getName(), (Throwable)exception);
        }
        return customMonitorControl;
    }

    private static DiagnosticMonitorControl createMonitorControl(InstrumentationScope instrumentationScope, WLDFInstrumentationMonitorBean wLDFInstrumentationMonitorBean) {
        String string = wLDFInstrumentationMonitorBean.getName();
        DiagnosticMonitorControl diagnosticMonitorControl = null;
        if ("_WL_INTERNAL_SERVER_SCOPE".equals(instrumentationScope.getName())) {
            InstrumentationManager instrumentationManager = InstrumentationManager.getInstrumentationManager();
            diagnosticMonitorControl = instrumentationManager.getServerMonitor(string);
        } else {
            InstrumentationLibrary instrumentationLibrary = InstrumentationLibrary.getInstrumentationLibrary();
            diagnosticMonitorControl = instrumentationLibrary.getDiagnosticMonitorControl(string);
        }
        if (diagnosticMonitorControl == null) {
            DiagnosticsLogger.logUnknownMonitorTypeInScope((String)instrumentationScope.getName(), (String)string);
            return null;
        }
        if ("_WL_INTERNAL_SERVER_SCOPE".equals(instrumentationScope.getName())) {
            if (!diagnosticMonitorControl.isServerScopeAllowed()) {
                DiagnosticsLogger.logInvalidMonitorInServerScope((String)string);
                diagnosticMonitorControl = null;
            }
        } else if (!diagnosticMonitorControl.isComponentScopeAllowed()) {
            DiagnosticsLogger.logInvalidMonitorInApplicationScope((String)string, (String)instrumentationScope.getName());
            diagnosticMonitorControl = null;
        }
        return diagnosticMonitorControl;
    }
}

