/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.descriptor.DescriptorDiff;
import weblogic.diagnostics.descriptor.WLDFInstrumentationBean;
import weblogic.diagnostics.descriptor.WLDFInstrumentationMonitorBean;
import weblogic.diagnostics.descriptor.WLDFResourceBean;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.instrumentation.InstrumentationDebug;
import weblogic.diagnostics.instrumentation.InstrumentationManager;
import weblogic.diagnostics.instrumentation.InstrumentationScope;
import weblogic.diagnostics.module.WLDFModuleException;
import weblogic.diagnostics.module.WLDFSubModule;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;

public final class InstrumentationSubmodule
implements WLDFSubModule {
    private ApplicationContextInternal appCtx;
    private WLDFResourceBean wldfResource;
    private boolean isSystemResource;

    public static final WLDFSubModule createInstance() {
        return new InstrumentationSubmodule();
    }

    private InstrumentationSubmodule() {
    }

    private String getName() {
        return this.isSystemResource ? "_WL_INTERNAL_SERVER_SCOPE" : this.appCtx.getApplicationId();
    }

    public void init(ApplicationContext applicationContext, WLDFResourceBean wLDFResourceBean) throws WLDFModuleException {
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("InstrumentationSubmodule initialized for " + applicationContext);
        }
        try {
            this.appCtx = (ApplicationContextInternal)applicationContext;
            this.wldfResource = wLDFResourceBean;
            this.isSystemResource = this.appCtx.getSystemResourceMBean() != null;
        }
        catch (ClassCastException classCastException) {
            throw new WLDFModuleException("Unexpected application context type", classCastException);
        }
    }

    public void prepare() throws WLDFModuleException {
        String string = this.getName();
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("InstrumentationSubmodule prepare for " + string);
        }
        J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl = this.appCtx.getRuntime();
        InstrumentationManager instrumentationManager = InstrumentationManager.getInstrumentationManager();
        InstrumentationScope instrumentationScope = null;
        if (this.isSystemResource) {
            instrumentationScope = instrumentationManager.findInstrumentationScope(string);
            if (instrumentationScope == null) {
                this.createInstrumentationScope(string, null);
            } else {
                instrumentationScope.registerRuntime(null);
            }
            return;
        }
        if (!instrumentationManager.isEnabled()) {
            if (!this.isEmptyInstrumentationDescriptor()) {
                DiagnosticsLogger.logWarnInstrumentationManagerDisabled((String)string);
            }
            return;
        }
        instrumentationScope = instrumentationManager.findInstrumentationScope(string);
        if (instrumentationScope != null) {
            throw new WLDFModuleException("Instrumentation scope " + string + " already exists");
        }
        this.createInstrumentationScope(string, j2EEApplicationRuntimeMBeanImpl);
    }

    private boolean isEmptyInstrumentationDescriptor() {
        WLDFInstrumentationBean wLDFInstrumentationBean;
        WLDFInstrumentationBean wLDFInstrumentationBean2 = wLDFInstrumentationBean = this.wldfResource != null ? this.wldfResource.getInstrumentation() : null;
        if (wLDFInstrumentationBean != null) {
            if (wLDFInstrumentationBean.isEnabled()) {
                return false;
            }
            WLDFInstrumentationMonitorBean[] wLDFInstrumentationMonitorBeanArray = wLDFInstrumentationBean.getWLDFInstrumentationMonitors();
            if (wLDFInstrumentationMonitorBeanArray != null && wLDFInstrumentationMonitorBeanArray.length > 0) {
                return false;
            }
        }
        return true;
    }

    private void createInstrumentationScope(String string, J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl) throws WLDFModuleException {
        try {
            InstrumentationManager instrumentationManager = InstrumentationManager.getInstrumentationManager();
            WLDFInstrumentationBean wLDFInstrumentationBean = this.wldfResource != null ? this.wldfResource.getInstrumentation() : null;
            InstrumentationScope instrumentationScope = instrumentationManager.createInstrumentationScope(string, wLDFInstrumentationBean);
            if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
                InstrumentationDebug.DEBUG_CONFIG.debug("InstrumentationSubmodule createInstrumentationScope for " + string + " created scope=" + instrumentationScope);
            }
            if (instrumentationScope != null) {
                DiagnosticsLogger.logInformInstrumentationScopeCreation((String)string);
                if (!instrumentationScope.isEnabled()) {
                    DiagnosticsLogger.logWarnInstrumentationScopeDisabled((String)string);
                }
                instrumentationScope.registerRuntime(j2EEApplicationRuntimeMBeanImpl);
            }
        }
        catch (Exception exception) {
            throw new WLDFModuleException("Failed to create instrumentation module for application " + string, exception);
        }
    }

    public void activate() throws WLDFModuleException {
    }

    public void deactivate() throws WLDFModuleException {
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("InstrumentationSubmodule deactivate for " + this.appCtx);
        }
        String string = this.getName();
        InstrumentationManager instrumentationManager = InstrumentationManager.getInstrumentationManager();
        InstrumentationScope instrumentationScope = instrumentationManager.findInstrumentationScope(string);
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("InstrumentationSubmodule deactivate for " + string + " found scope=" + instrumentationScope);
        }
        if (instrumentationScope != null) {
            instrumentationScope.setEnabled(false);
            instrumentationScope.unregisterRuntime();
            instrumentationManager.deleteInstrumentationScope(instrumentationScope);
        }
    }

    public void unprepare() throws WLDFModuleException {
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("InstrumentationSubmodule unprepare for " + this.appCtx);
        }
        String string = this.getName();
        InstrumentationManager instrumentationManager = InstrumentationManager.getInstrumentationManager();
        InstrumentationScope instrumentationScope = instrumentationManager.findInstrumentationScope(string);
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("InstrumentationSubmodule unprepare for " + string + " found scope=" + instrumentationScope);
        }
        if (instrumentationScope != null) {
            instrumentationScope.setEnabled(false);
            instrumentationScope.unregisterRuntime();
            instrumentationManager.deleteInstrumentationScope(instrumentationScope);
        }
    }

    public void destroy() throws WLDFModuleException {
    }

    public void prepareUpdate(WLDFResourceBean wLDFResourceBean, DescriptorDiff descriptorDiff) throws WLDFModuleException {
    }

    public void activateUpdate(WLDFResourceBean wLDFResourceBean, DescriptorDiff descriptorDiff) throws WLDFModuleException {
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("InstrumentationSubmodule activateUpdate for " + this.appCtx);
        }
        String string = this.getName();
        InstrumentationManager instrumentationManager = InstrumentationManager.getInstrumentationManager();
        InstrumentationScope instrumentationScope = instrumentationManager.findInstrumentationScope(string);
        if (InstrumentationDebug.DEBUG_CONFIG.isDebugEnabled()) {
            InstrumentationDebug.DEBUG_CONFIG.debug("InstrumentationSubmodule activateUpdate for " + string + " found scope=" + instrumentationScope);
        }
        if (instrumentationScope != null) {
            WLDFInstrumentationBean wLDFInstrumentationBean = wLDFResourceBean.getInstrumentation();
            InstrumentationScope instrumentationScope2 = InstrumentationScope.createInstrumentationScope(string, wLDFInstrumentationBean);
            instrumentationScope.merge(instrumentationScope2);
        }
    }

    public void rollbackUpdate(WLDFResourceBean wLDFResourceBean, DescriptorDiff descriptorDiff) {
    }
}

