/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfoImpl;
import weblogic.diagnostics.instrumentation.ValueRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueRenderingManager {
    private static boolean initialized = false;
    private static DebugLogger debugLog = DebugLogger.getDebugLogger((String)"DebugDiagnosticDataGathering");
    public static final ValueRenderer defaultValueRenderer = new DefaultValueRenderer();
    private static Map<Class, ValueRenderer> typeBasedValueRendererMap = new HashMap<Class, ValueRenderer>();
    private static Map<String, ValueRenderer> rendererMap = new HashMap<String, ValueRenderer>();

    public static Object renderReturnValue(String string, Object object, Map<String, PointcutHandlingInfo> map) {
        if (string == null || map == null) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug(" renderReturnValue sensitive, monitorType = " + string + " infoMap = " + map);
            }
            return "*****";
        }
        if (object == null) {
            return null;
        }
        PointcutHandlingInfo pointcutHandlingInfo = map.get(string);
        if (pointcutHandlingInfo == null) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug(" phInfo null, make args sensitive");
            }
            return "*****";
        }
        return ValueRenderingManager.renderValue(object, pointcutHandlingInfo.getReturnValueHandlingInfo());
    }

    public static Object[] renderArgumentValues(String string, boolean bl, Object[] objectArray, Map<String, PointcutHandlingInfo> map) {
        if (objectArray == null || objectArray.length == 0) {
            return objectArray;
        }
        if (string == null || map == null) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug(" sensitive 1 monType = " + string + " infoMap = " + map);
            }
            return InstrumentationSupport.toSensitive((Object[])objectArray);
        }
        PointcutHandlingInfo pointcutHandlingInfo = map.get(string);
        if (pointcutHandlingInfo == null) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug(" phInfo null, make args sensitive");
            }
            return InstrumentationSupport.toSensitive((Object[])objectArray);
        }
        ValueHandlingInfo valueHandlingInfo = pointcutHandlingInfo.getClassValueHandlingInfo();
        ValueHandlingInfo[] valueHandlingInfoArray = pointcutHandlingInfo.getArgumentValueHandlingInfo();
        if (valueHandlingInfoArray == null && (!bl || bl && valueHandlingInfo == null)) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug(" sensitive 2 argInfos = " + valueHandlingInfoArray + " renderClass = " + bl + " classInfo = " + valueHandlingInfo);
            }
            return InstrumentationSupport.toSensitive((Object[])objectArray);
        }
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        if (bl) {
            objectArray2[n++] = ValueRenderingManager.renderValue(objectArray[0], valueHandlingInfo);
            if (debugLog.isDebugEnabled()) {
                debugLog.debug(" renderClass in = " + objectArray[0] + " out = " + objectArray2[0]);
            }
        }
        int n2 = 0;
        while (n < objectArray.length) {
            if (valueHandlingInfoArray == null) {
                if (debugLog.isDebugEnabled()) {
                    debugLog.debug(" argInfos null sensitive " + n);
                }
                objectArray2[n] = "*****";
            } else {
                objectArray2[n] = ValueRenderingManager.renderValue(objectArray[n], valueHandlingInfoArray[n2++]);
                if (debugLog.isDebugEnabled()) {
                    debugLog.debug(" renderClass in = " + objectArray[n] + " out = " + objectArray2[n]);
                }
            }
            ++n;
        }
        return objectArray2;
    }

    public static Object renderValue(Object object, ValueHandlingInfo valueHandlingInfo) {
        if (debugLog.isDebugEnabled()) {
            debugLog.debug("renderValue(), value = " + object + " valInfo = " + valueHandlingInfo);
        }
        if (valueHandlingInfo == null || valueHandlingInfo.isSensitive()) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug(" renderValue sensitive, valInfo = " + valueHandlingInfo);
            }
            return "*****";
        }
        if (object == null) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug(" renderValue null value");
            }
            return null;
        }
        String string = valueHandlingInfo.getRendererClassName();
        ValueRenderer valueRenderer = null;
        if (string != null) {
            valueRenderer = ((ValueHandlingInfoImpl)valueHandlingInfo).getValueRenderer();
            if (valueRenderer == null) {
                if (debugLog.isDebugEnabled()) {
                    debugLog.debug(" renderValue find renderer by class");
                }
                valueRenderer = ValueRenderingManager.findRendererByClassName(string, object.getClass());
                ((ValueHandlingInfoImpl)valueHandlingInfo).setValueRenderer(valueRenderer);
            }
        } else {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug(" renderValue find renderer by type or default");
            }
            valueRenderer = ValueRenderingManager.findRendererByTypeClass(object.getClass());
        }
        return valueRenderer.render(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ValueRenderer findRendererByClassName(String string, Class clazz) {
        if (string == null || string.length() == 0) {
            return defaultValueRenderer;
        }
        ValueRenderer valueRenderer = rendererMap.get(string);
        if (valueRenderer != null) return valueRenderer;
        Class<ValueRenderingManager> clazz2 = ValueRenderingManager.class;
        synchronized (ValueRenderingManager.class) {
            valueRenderer = rendererMap.get(string);
            if (valueRenderer != null) return valueRenderer;
            try {
                Class<?> clazz3 = Class.forName(string);
                valueRenderer = (ValueRenderer)clazz3.newInstance();
            }
            catch (Exception exception) {
                valueRenderer = ValueRenderingManager.findRendererByTypeClass(clazz);
                DiagnosticsLogger.logCannotLoadRenderer((String)string, (Throwable)exception, (String)valueRenderer.getClass().getName());
            }
            rendererMap.put(string, valueRenderer);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return valueRenderer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ValueRenderer findRendererByTypeClass(Class clazz) {
        if (clazz == null || typeBasedValueRendererMap.size() == 0) {
            return defaultValueRenderer;
        }
        ValueRenderer valueRenderer = typeBasedValueRendererMap.get(clazz);
        if (valueRenderer != null) return valueRenderer;
        Class<ValueRenderingManager> clazz2 = ValueRenderingManager.class;
        synchronized (ValueRenderingManager.class) {
            valueRenderer = typeBasedValueRendererMap.get(clazz);
            if (valueRenderer != null) return valueRenderer;
            for (Class clazz3 : ValueRenderingManager.getCandidateClasses(clazz)) {
                valueRenderer = typeBasedValueRendererMap.get(clazz);
                if (valueRenderer == null) continue;
                break;
            }
            if (valueRenderer == null) {
                valueRenderer = defaultValueRenderer;
            }
            typeBasedValueRendererMap.put(clazz, valueRenderer);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return valueRenderer;
        }
    }

    private static List<Class> getCandidateClasses(Class clazz) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        if (clazz == null) {
            return arrayList;
        }
        if (clazz.isPrimitive()) {
            arrayList.add(clazz);
            return arrayList;
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            Class<?> clazz3;
            if (clazz2 == null || (clazz3 = clazz2.getClass()).equals(Class.class) || arrayList.contains(clazz3)) continue;
            arrayList.add(clazz3);
            arrayList.addAll(ValueRenderingManager.getCandidateClasses(clazz3));
        }
        Class clazz4 = clazz.getSuperclass();
        if (clazz4 != null) {
            arrayList.addAll(ValueRenderingManager.getCandidateClasses(clazz4));
        }
        return arrayList;
    }

    public static synchronized void initialize(Map<String, String> map) {
        if (initialized) {
            return;
        }
        initialized = true;
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            try {
                Class<?> clazz = Class.forName(entry.getKey());
                Class<?> clazz2 = Class.forName(entry.getValue());
                Object obj = clazz2.newInstance();
                typeBasedValueRendererMap.put(clazz, (ValueRenderer)obj);
            }
            catch (Exception exception) {
                DiagnosticsLogger.logCannotLoadTypeBasedRenderer((String)entry.getValue(), (String)entry.getKey(), (Throwable)exception);
            }
        }
    }

    private static class DefaultValueRenderer
    implements ValueRenderer {
        public Object render(Object object) {
            if (debugLog.isDebugEnabled()) {
                debugLog.debug("DefaultValueRenderer.render() input = " + object);
            }
            if (object == null) {
                return null;
            }
            return object;
        }
    }
}

