/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation.action;

import com.oracle.jrockit.jfr.TimedEvent;
import weblogic.diagnostics.flightrecorder.FlightRecorderManager;
import weblogic.diagnostics.instrumentation.AroundDiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.gathering.DataGatheringManager;
import weblogic.diagnostics.instrumentation.gathering.FlightRecorderEventHelper;

public class FlightRecorderAroundAction
implements AroundDiagnosticAction {
    private static final long serialVersionUID = 1L;
    private DiagnosticMonitor monitor;
    private String type;
    private static final FlightRecorderAroundActionState disabledActionState = new FlightRecorderAroundActionState(false);

    public FlightRecorderAroundAction() {
        this.setType("FlightRecorderAroundAction");
    }

    public boolean requiresArgumentsCapture() {
        return true;
    }

    public void setDiagnosticMonitor(DiagnosticMonitor diagnosticMonitor) {
        this.monitor = diagnosticMonitor;
    }

    public DiagnosticMonitor getDiagnosticMonitor() {
        return this.monitor;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public DiagnosticActionState createState() {
        if (DataGatheringManager.getDiagnosticVolume() == 0 || !FlightRecorderManager.isRecordingPossible()) {
            return disabledActionState;
        }
        return new FlightRecorderAroundActionState(true);
    }

    public void preProcess(JoinPoint joinPoint, DiagnosticActionState diagnosticActionState) {
        if (diagnosticActionState == null) {
            return;
        }
        FlightRecorderAroundActionState flightRecorderAroundActionState = (FlightRecorderAroundActionState)diagnosticActionState;
        flightRecorderAroundActionState.begin(this.monitor, joinPoint);
    }

    public void postProcess(JoinPoint joinPoint, DiagnosticActionState diagnosticActionState) {
        if (diagnosticActionState == null) {
            return;
        }
        FlightRecorderAroundActionState flightRecorderAroundActionState = (FlightRecorderAroundActionState)diagnosticActionState;
        flightRecorderAroundActionState.finishAndRecord(this.monitor, joinPoint);
    }

    private static class FlightRecorderAroundActionState
    implements DiagnosticActionState {
        private boolean enabled = false;
        private TimedEvent aroundEvent = null;

        private FlightRecorderAroundActionState(boolean bl) {
            this.enabled = bl;
        }

        private void begin(DiagnosticMonitor diagnosticMonitor, JoinPoint joinPoint) {
            if (!this.enabled) {
                return;
            }
            this.aroundEvent = FlightRecorderEventHelper.getInstance().getTimedEvent(diagnosticMonitor, joinPoint);
            if (this.aroundEvent != null) {
                this.aroundEvent.begin();
            }
        }

        private void finishAndRecord(DiagnosticMonitor diagnosticMonitor, JoinPoint joinPoint) {
            if (!this.enabled || this.aroundEvent == null) {
                return;
            }
            this.aroundEvent.end();
            FlightRecorderEventHelper.getInstance().recordTimedEvent(diagnosticMonitor, joinPoint, this.aroundEvent);
        }
    }
}

